#! /usr/bin/perl -w

#BEGIN { unshift(@INC,"/home/hong_man/lib/perl/");   }
BEGIN { unshift(@INC,"/home/hqin/lib/perl/");   }

# This script calls 'dk' multiple time sequentially. 
# The indepedent output of shortest-path can be used for statistic
# analysis and evaluations. 

# v0.0 Dec 12, 2005 Hong Qin

use strict; use warnings; 
use Getopt::Long;   
use lib '/shar/lib/perl/'; use Util;  use BeginPerlBioinfo; 

my $in_pair_fl = undef; 	# input network in pairwise format, required
my $in_node_fl = undef; 	# input node file, required
my $out_path_fl = undef;	
my $num_iterations = 10;	# default is 10
my $debug = 0;

# temporary variables
 my ($num, $i, $flag, $line, $cds, @lines, @buffers) = ();

 if ( ! $ARGV[0]) { _help(); exit(1); }

 GetOptions('in_network_pair_fl|i=s' => \$in_pair_fl,   # required
	    'in_node_list_fl|n=s' => \$in_node_fl,      # required
            'out_path_fl|o=s' => \$out_path_fl,
            'iteration_num|itr=i' => \$num_iterations, # default 10
            'debug|d=i' => \$debug);

 if ( ! $in_pair_fl  ) { _help(); exit(1); }    
 if ( ! $in_node_fl  ) { _help(); exit(1); }    
 my $short_time_stamp =  get_short_time_stamp_US();

 my $alias1 =  get_shortened_name ( $in_pair_fl  );  
 my $alias2 =  get_shortened_name ( $in_node_fl  );  

# if ( !(defined $out_path_fl ) ) {  
#   $out_path_fl =  "dk_path_".$alias1."_".$alias2.".txt";  
# }

# key variables
 my $prefix    = "/tmp/_dk_".$alias1."_".$alias2.".".$short_time_stamp; 

 if ( defined $out_path_fl  ) {  
  $prefix = $out_path_fl;
 }

 my @tmp_out_files = ();   # output dk-path file for each 'dk' run 

 foreach my $k ( 1 .. $num_iterations ) {
   $tmp_out_files[ $k-1 ] = "$prefix.$k.txt";
   my $cmd = "dk -i $in_pair_fl -n $in_node_fl -o $tmp_out_files[$k-1]" ;
   sleep 1;  # this makes sure that srand(&tp) gives different results.
   system ( $cmd );
 }

 # now merge file ???
 exit;
 # end of main

sub _help  {
print "
 GetOptions('in_network_pair_fl|if=s' => \$in_pair_fl,   # required
	    'in_node_list_fl|in=s' => \$in_node_fl,      # required
            'out_path_fl|of=s' => \$out_path_fl,
            'num_of_iterations|num=i' => \$num_iterations, # default 10
            'debug|d=i' => \$debug);
\n";
}
