#include "node_parser.h"
#include <fstream>
#include <iostream>
#include <cstdlib>
#include "WSLsplit.h"
#include "util.h"
#include "algostuff.hpp"
#include <algorithm>

///////////////////////////////////////
CNode_Parser::CNode_Parser(){}

CNode_Parser::~CNode_Parser(){}

///////////////////////////////////////

/*
Format of the input data
>header
element1	skipped_ele
element1	skipped_ele
... ...
# comment line
>header 2 for the second record
... ...
*/

int CNode_Parser::set_vsIds_frm_fl(const string& flname) {
 const char delims1('\t');
 const string comment_syms(">#");
 string sLine;
 char  buff[1024];  //note, line is shorter than 1024 characters
 vector<string> vs;
 int debug=0;

 ifstream file(flname.c_str());
 if ( ! file ) {
    cerr << "can not open input file \"" << flname << "\"" << endl;
    exit(EXIT_FAILURE);
 }

 while( file.getline( buff, 1024 ) ) {;
  if ((buff[0]!='>') and (buff[0]!='#')) {
     sLine = (string) buff;
     split(vs, sLine,  delims1);
     if (vs.size() > 0) {
  	vsIds.push_back( vs[0] );
        if(debug) { cout << vs.size() << " tokens:\t";
          for( unsigned i = 0; i<vs.size(); ++i) {
            cout << vs[i] << "\t";
          }
          cout << endl;
	}
     }//if
  }//if
 }//while

 file.close();
 return 0;
}

