#include "pairs_parser.h"
#include <fstream>
#include <iostream>
//#include <cstdlib>
#include <stdlib.h>
#include "WSLsplit.h"
#include "util.h"
#include "graph.h"
#include "algostuff.hpp"
#include <algorithm>

using namespace std;

///////////////////////////////////////
int _get_NodeNum_by_id( string & s, std::vector<Node> & vNodes ) {
 for (unsigned i=0; i<vNodes.size(); ++i ) {
   if ( (string) vNodes[i].pId == s ) {
       return i;
   }
 }
 return -1;
}

///////////////////////////////////////
CPairs_Parser::CPairs_Parser() {}

CPairs_Parser::~CPairs_Parser() {}

///////////////////////////////////////
int CPairs_Parser::generate_weighted_undirected_graph_without_self_pairing
		   (const string& flname,  Graph& g ) {
 int debug=0;
 pairs_in.clear();
 set_ids.clear();
 ordered_ids.clear();
 m_id2pos.clear();
 ml_pos2pos_edges.clear();
 mliiEdges.clear();

 set_pairs_frm_one_fasta_fl_wo_self_pairs(flname);

 set_uniq_elements();
 set_ordered_ids();
 set_as_undirected_pairs();
 rm_self_pairings();
 set_map_id2pos();
 set_mlmap_pos2pos_edges();
 set_mliiEdges();

 generate_nodes_without_neighbours( g.vNodes );

 set_neighboursAndWeights_in_nodes( flname, g.vNodes ); //add weight here 013006

 g.set_pairs_in( pairs_in );
 g.set_nr_ids( set_ids );
 g.set_ordered_ids(  ordered_ids );
 g.set_id2pos( m_id2pos );
 g.set_mliiEdge( mliiEdges );

 if (debug) {  g.print_graph_in_adj_list( );  }

 return 0;
}

/**  temproary funcitons    **/
int _is_there( Node & node1, std::vector<Node*> & vpNodes ) {
 for( unsigned i=0; i<vpNodes.size(); ++i ) {
     if ( (string) node1.pId == (string) vpNodes[i]->pId ) {
         return 1;  //yes
     }
 }
 return 0; // node1 is not in vNode
}


/***    ***/
int CPairs_Parser:: set_neighboursAndWeights_in_nodes( const string& flname, vector<Node>& vNodes ) {
 const char delims1('\t');
 const string comment_syms(">#");
 string sLine;
 char  buff[1024];  //note, line is shorter than 1024 characters
 vector<string> vs;
 int debug=0;

 ifstream file2(flname.c_str());
 if ( ! file2 ) {
    cerr << "can not open input file \"" << flname << "\"" << endl;
    exit(EXIT_FAILURE);
 }

 //cout << "in set_neighboursAndWeights() flname="<<flname <<endl;
 while( file2.getline( buff, 1024 ) ) {;
  if ((buff[0]!='>') && (buff[0]!='#')) {
    sLine = (string) buff;
    split(vs, sLine,  delims1);
    if (debug) {
         for (unsigned j=0; j<vs.size(); ++j ) {
             cout<< "("<< vs[j] <<")";
         }
         cout << endl;
    }

    if ( (vs.size() >= 3 ) && ( vs[0] != vs[1] ) ){
         unsigned one = _get_NodeNum_by_id( vs[0], vNodes );
         unsigned two = _get_NodeNum_by_id( vs[1], vNodes );
         float w = (float) std::atof( vs[2].c_str() );
         if(debug) {
            cout << vNodes[one].pId << " " << vNodes[two].pId << " " << w << endl;
         }
         if ( _is_there( vNodes[two], vNodes[one].vpNeighbors) == 0) {
            vNodes[one].vpNeighbors.push_back( & vNodes[two] );
            vNodes[one].vnWeights.push_back( w );
         }
         if ( _is_there( vNodes[one], vNodes[two].vpNeighbors) ==0 ) {
            vNodes[two].vpNeighbors.push_back( & vNodes[one] );
            vNodes[two].vnWeights.push_back( w );
         }
    }//if
  }//if
}//while

 file2.close();
 return 0;
}


///////////////////////////////////////
int CPairs_Parser::generate_undirected_graph_without_self_pairing
		   (const string& flname,  Graph& g ) {

 int debug=0;
 pairs_in.clear();
 set_ids.clear();
 ordered_ids.clear();
 m_id2pos.clear();
 ml_pos2pos_edges.clear();
 mliiEdges.clear();

 set_pairs_frm_one_fasta_fl_wo_self_pairs(flname);

 set_uniq_elements();
 set_ordered_ids();
 set_as_undirected_pairs();
 rm_self_pairings();
 set_map_id2pos();
 set_mlmap_pos2pos_edges();
 set_mliiEdges();

 generate_nodes_without_neighbours( g.vNodes );
 set_neighbours_in_nodes( g.vNodes );    //add weight here 013006

 //i am here 102703Mon
 g.set_pairs_in( pairs_in );
 g.set_nr_ids( set_ids );
 g.set_ordered_ids(  ordered_ids );
 g.set_id2pos( m_id2pos );
 g.set_mliiEdge( mliiEdges );

 if (debug) {  g.print_graph_in_adj_list( );  }

 return 0;
}

///////////////////////////////////////
/*
Format of the input pairwise interaction data:
>header
element1	element2	skipped_ele
element1	element3	skipped_ele
... ...
# comment line
>header 2 for the second record
... ...
*/

int CPairs_Parser::set_pairs_frm_one_fasta_fl(const string& flname) {
 const char delims1('\t');
 const string comment_syms(">#");
 string sLine;
 char  buff[1024];  //note, line is shorter than 1024 characters
 vector<string> vs;
 int debug =0;

 if (debug) { cout<<"set_pairs() flname="<<flname << endl; }

 ifstream file(flname.c_str());
 if ( ! file ) {
    cerr << "can not open input file \"" << flname << "\"" << endl;
    exit(EXIT_FAILURE);
 }

 while( file.getline( buff, 1024 ) ) {
  if ((buff[0]!='>') and (buff[0]!='#')) {
     sLine = (string) buff;
     split(vs, sLine,  delims1);
     if (vs.size() > 0) {
  	    pairs_in.push_back(make_pair(vs[0], vs[1]));
        if(debug) { cout << vs.size() << " tokens:\t";
          for( unsigned i = 0; i<vs.size(); ++i) {
            cout << vs[i] << "\t";
          }
          cout << endl;
	}
     }//if
  }//if
 }//while

 file.close();
 return 0;
}




int CPairs_Parser::set_pairs_frm_one_fasta_fl_wo_self_pairs(const string& flname) {
 const char delims1('\t');
 const string comment_syms(">#");
 string sLine;
 char  buff[1024];  //note, line is shorter than 1024 characters
 vector<string> vs;
 int debug=0;

 ifstream file(flname.c_str());
 if ( ! file ) {
    cerr << "can not open input file \"" << flname << "\"" << endl;
    exit(EXIT_FAILURE);
 }

 while( file.getline( buff, 1024 ) ) {;
  if ((buff[0]!='>') and (buff[0]!='#')) {
     sLine = (string) buff;
     split(vs, sLine,  delims1);
     if (vs.size() > 0) {
	if ( vs[0] != vs[1] ) {
  	  pairs_in.push_back(make_pair(vs[0], vs[1]));
   	}
        if(debug) { cout << vs.size() << " tokens:\t";
          for( unsigned i = 0; i<vs.size(); ++i) {
            cout << vs[i] << "\t";
          }
          cout << endl;
	}
     }//if
  }//if
 }//while

 file.close();
 return 0;
}


////////////////////////////////////////////
int CPairs_Parser::set_uniq_elements(){
 int debug=0;
 for( unsigned i = 0; i<pairs_in.size(); ++i) {
  set_ids.insert( pairs_in[i].first  );
  set_ids.insert( pairs_in[i].second  );
 }

 if (debug) {
  cout<<"CPairs_Parser::set_uniq_elements()::set_ids.size()=" << set_ids.size();
  PRINT_ELEMENTS( set_ids, "set_ids:  ");
 }
 return 0;
};

///////////////////////////////////////////
int CPairs_Parser::set_ordered_ids(){
 int debug=0;
 SET_str_t::iterator itr;
 for (itr=set_ids.begin(); itr!=set_ids.end(); ++itr) {
  ordered_ids.push_back( *itr );
 }
 if (debug) {
  cout<<"CPairs_Parser::set_ordered_ids()::ordered_ids.size()="<< ordered_ids.size();
  PRINT_ELEMENTS( ordered_ids, "ordered_ids:  ");
 }
 return 0;
}

////////////////////////////////////////////
int CPairs_Parser::set_map_id2pos() {
 int debug = 0;
 for( unsigned i=0; i<ordered_ids.size(); ++i ) {
    m_id2pos[ ordered_ids[i] ] = i;
 }
 if (debug) {
   std::map<string, int>::iterator itr;
   for (itr=m_id2pos.begin(); itr!= m_id2pos.end(); ++itr) {
       cout<< itr->first << " : " << itr->second << endl;
   }
 }
 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::set_as_undirected_pairs() {
 //int debug=0;
 std::set<PAIR_str_t> 	 set_pairs;

 isDirected = 0;

 for (unsigned i=0; i<pairs_in.size(); ++i ) {
   set_pairs.insert ( small2big_pair( pairs_in[i].first, pairs_in[i].second ) );
 }

 pairs_in.clear();  // clear the old data
 std::set<PAIR_str_t>::iterator itr;
 for (itr=set_pairs.begin(); itr!= set_pairs.end(); ++itr) {
   pairs_in.push_back( *itr );
 }

 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::rm_self_pairings() {
 // int debug=0;
 vector<PAIR_str_t> new_pairs;

 for (unsigned i=0; i<pairs_in.size(); ++i ) {
   if ( pairs_in[i].first !=  pairs_in[i].second ) {
      new_pairs.push_back( pairs_in[i] );
   }
 }

 pairs_in = new_pairs;

 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::set_mliiEdges() {
 int debug=0;
 mliiEdges.clear();
 for (unsigned i=0; i<pairs_in.size(); i+=1 ) {
   int pos1 = m_id2pos[ pairs_in[i].first  ];
   int pos2 = m_id2pos[ pairs_in[i].second ];
   int big = max( pos1, pos2 );
   int small = min( pos1, pos2);
   mliiEdges.insert( make_pair(small, big)  );  //102803 change! small to big order
   if (debug) {
     cout << "CPairs_Parser::set_mliiEdges() pos1="<<pos1<<" pos2="<<pos2<<endl;
     cout << "CPairs_Parser::set_mliiEdges() big=" <<big <<" small=" << small<<endl;
   }
 }

 if (debug) {
   cout <<"CPairs_Parser::set_mliiEdges()::mliiEdges.size()=" << mliiEdges.size()
	<< " pairs_in.size()="<<pairs_in.size()<<endl;
   std::multimap<int, int>::iterator itr;
   for (itr=mliiEdges.begin(); itr!= mliiEdges.end(); ++itr) {
       cout<< itr->first << ":" << itr->second << "\t";
   }
   cout << endl;
 }

 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::set_mlmap_pos2pos_edges() {
 int debug=0;
 ml_pos2pos_edges.clear();
 for (unsigned i=0; i<pairs_in.size(); ++i ) {
   int pos1 = m_id2pos[ pairs_in[i].first  ];
   int pos2 = m_id2pos[ pairs_in[i].second ];

   //mliiEdges.insert( make_pair(pos1, pos2)  ); // this is bug removed 102803

   ml_pos2pos_edges.insert( make_pair(pos1, pos2)  );
   if ( ! isDirected ) { ml_pos2pos_edges.insert( make_pair(pos2, pos1) ); }
 }

 if (debug) {
   std::multimap<int, int>::iterator itr;
   for (itr=ml_pos2pos_edges.begin(); itr!= ml_pos2pos_edges.end(); ++itr) {
       cout<< itr->first << " : " << itr->second << endl;
   }
 }
 return 0;
}


/////////////////////////////////////////////
/*
 vector<PAIR_str_t>             pairs_in;
 SET_str_t                      set_ids;
 VECTOR_str_t                   ordered_ids;
 std::map<string, int>          m_id2pos;
 std::multimap<int, int>        ml_pos2pos_edges; */
/////////////////////////////////////////////
int CPairs_Parser::generate_nodes_without_neighbours( Graph& g ) { //to do here!!!
 generate_nodes_without_neighbours( g.vNodes );
 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::generate_nodes_without_neighbours( vector<Node>& vNodes ) {
 int debug=0;

 vNodes.clear();

 for( unsigned i=0; i<ordered_ids.size(); ++i ) {
  //  Node* p_node= new Node( (char *) ordered_ids[i].c_str(), i ); //memory allocation
  //  vNodes.push_back( * p_node );   122005
    Node node = Node( (char *) ordered_ids[i].c_str(), i ); //122005 HQ
    vNodes.push_back( node );  //122005 This should call Node copy constructor
 }

 if (debug) {
   cout <<"CPairs_Parser::generate_nodes_without_neighbours( vector<Node>& vNodes ))\n";
   for ( unsigned i=0; i<vNodes.size(); ++i ) {
     cout << vNodes[i].pId << " : " <<  vNodes[i].iRank << endl;
   }
 }

 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::_set_int2NodePtr_lookup_table( vector<Node>& vNodes ) {
 //int debug=0;

 v_int2NodePtr.reserve( vNodes.size() );

 for ( unsigned i=0; i<vNodes.size(); ++i ) {
     int idx = vNodes[i].iRank;
     Node * ptr = & vNodes[i];
     v_int2NodePtr[ idx ]  = ptr;
 }
 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser:: set_neighbours_in_nodes( vector<Node>& vNodes ) {
 int debug=0;
 std::multimap<int, int>::iterator itr;

 _set_int2NodePtr_lookup_table( vNodes );
 set_mlmap_pos2pos_edges();
 if (debug) { cout << "CPairs_Parser:: set_neighbours_in_nodes( vector<Node>& vNodes )\n"; }

 for ( unsigned i=0; i<vNodes.size(); ++i ) {
    int iKey_from = vNodes[i].iRank;
    if (debug) { cout << "iKey_from =" << iKey_from << " " ;}
    for ( itr  = ml_pos2pos_edges.lower_bound(iKey_from);
	  itr != ml_pos2pos_edges.upper_bound(iKey_from); ++itr ) {
        if (debug) {
           cout <<  vNodes[itr->first].pId << " : " <<  vNodes[itr->second].pId << endl;
        }
        vNodes[itr->first].vpNeighbors.push_back( v_int2NodePtr[itr->second] );
        vNodes[itr->first].vnWeights.push_back( 1 ); // 013006 default weight
    }
    if (debug) { cout << endl; }
 }
 //i am here #1
 return 0;
}

/////////////////////////////////////////////
int CPairs_Parser::generate_nodes_with_neighbours( vector<Node>& vNodes ) {
 //int debug=0;
 cout << "You have called un unfinished constructor." <<endl;
 exit(1);
//to do 999

 return 0;
}

