/*
   Had I do a spelling check, I would name this permutor.cpp
*/

#include "permutator.h"
#include <iostream>
#include "algostuff.hpp"
#include "util.h"
#include "mytypes.h"

using namespace std;

int CPermutator::generate_MS02_null_pairs_without_self_pairs_1( 
		 MLMAP_ii_t&  mliiEdgesIn, MLMAP_ii_t&  mliiEdgesOut ) {
 // Note: cannot call random_shuffle for list. 
 int debug=1;
 if (debug) {
  cout << "\tCPermutator::generate_MS02_null_pairs_without_self_pairs_1" <<endl;
  cout << "\tvector<int> implementation"<<endl;
  cout << "\tCall srand() before using this routine!"<<endl;
 }

 long tp; time (&tp); srand (tp);  // seed srand()

 VI viIn;
 MyRandom rd;

 mlmapii_to_vector( mliiEdgesIn, viIn );         
 maxIterations = viIn.size();

 random_shuffle( viIn.begin(), viIn.end(), rd );
 if (debug) { PRINT_ELEMENTS( viIn, "CPermutator, shuffled viIn : "); cout<<endl; }

 // reshuffle self_pairings
 int iterations=0;
 VI  viSelfPairsFirstPositions, viNewPositions;

 find_SelfPairsFirstPositions_vector( viIn, viSelfPairsFirstPositions );
 while ( ( iterations < maxIterations ) and ( viSelfPairsFirstPositions.size() !=0 ) ) {
   find_new_positions( viIn, viSelfPairsFirstPositions, viNewPositions );
   swap_positions_in_vector( viIn, viSelfPairsFirstPositions, viNewPositions ); 
   find_SelfPairsFirstPositions_vector( viIn, viSelfPairsFirstPositions ); 
   iterations++;
 }

 if ( viSelfPairsFirstPositions.size() != 0 ) { // self pairing is unavoidable
    return iterations; 
 }

 //reshuffle redundant pairs
 VI viRedundantPairPositions, viNewPositions2;
 iterations=0;

 find_positions_of_first_redundant_pairs( viIn, viRedundantPairPositions );
 while ( ( iterations < maxIterations ) and ( viRedundantPairPositions.size() !=0 ) ) {    
   find_a_new_position_for_the_first_redundant_pair_position( viIn,
   	 viRedundantPairPositions, viNewPositions2 );
   swap_positions_in_vector( viIn, viRedundantPairPositions, viNewPositions2 ); 
   find_positions_of_first_redundant_pairs( viIn, viRedundantPairPositions ); 
   iterations++;
 }

//i am here 102903Wed AM

 vector_to_mlmapii( viIn, mliiEdgesOut );

 return 0;
}

