#include "util.h"
#include <iostream>
#include "algostuff.hpp"
//#include "stringtok.h"

using namespace std;

//////////////////////////////////////////////////////////////// 
void find_a_new_position_for_the_first_redundant_pair_position( VI& viIn, 
	VI& viRedundantPairPositions, VI& viNewPositions) {
 int debug=1;
 MyRandom rd;
 int count = 0;
 int nmax = viIn.size();
 int countmax = max( nmax, 20 );

 viNewPositions.clear();
 int iNewPos = rd( nmax );

 while ( ( count++ < countmax ) and 
	 ( ( exists_vi(viRedundantPairPositions, iNewPos ) )
           or ( viIn[ even_num(iNewPos) ] == viIn[ viRedundantPairPositions[1] ] ) 
           or ( viIn[ even_num(iNewPos) ] == viIn[ viRedundantPairPositions[2] ] ) 
           or ( viIn[ even_num(iNewPos)+1 ] == viIn[ viRedundantPairPositions[1] ] ) 
           or ( viIn[ even_num(iNewPos)+1 ] == viIn[ viRedundantPairPositions[2] ] ) 
	 )
       ) {
   if(debug) {
        cout<<"find_a_new_position_for_the_first_redundant_pair_position()::count="<<
	count<<" iNewPos="<<iNewPos<<endl;
   }
   iNewPos = rd ( nmax );
 }

 if (count == countmax) {
  cout<<"Warning::find_a_new_position_for_the_first_redundant_pair_position()::count=countmax"<<endl;
 }

 viNewPositions.push_back(iNewPos);

 if (debug) {
  cout<<"find_a_new_position_for_the_first_redundant_pair_position()::iNewPos="<<iNewPos<<endl;
 }
 // i am here 102903Wed find_a_new_position_for_the_first_redundant_pair_position()
}



//////////////////////////////////////////////////////////////// 
void find_positions_of_first_redundant_pairs( VI& viIn, VI& viRedundantPairPositions ) {
 int debug=1;
 MLMAP_pii_i_t mlpiiiPairPositions;
 MLMAP_pii_i_t::iterator pos;

 viRedundantPairPositions.clear();

 for ( unsigned i=0; i<viIn.size(); i+=2 ) {
   int imax = max( viIn[i],  viIn[i+1] );
   int imin = min( viIn[i],  viIn[i+1] );

   std::pair<int,int> current_pair = make_pair(imin, imax);
   pos =  mlpiiiPairPositions.find( current_pair );

   if ( pos == mlpiiiPairPositions.end() ) {
      mlpiiiPairPositions.insert( make_pair(current_pair, i) );
   } else { // current_pair exists in mlpiiiPairPositions
      viRedundantPairPositions.push_back( pos->second );
      viRedundantPairPositions.push_back( pos->second + 1 );
      viRedundantPairPositions.push_back( i );
      viRedundantPairPositions.push_back( i+1 );
   } 
 }

 if (debug) {
    cout <<"\nfind_positions_of_first_redundant_pairs()::viIn:";
    PRINT_ELEMENTS( viIn, " ");
    cout <<"find_positions_of_first_redundant_pairs()::viRedundantPairPositions:";
    PRINT_ELEMENTS( viRedundantPairPositions, " " ); 
    cout << "\n";
 }
 // i am here 102803Wed find_positions_of_first_redundant_pairs()
}


////////////////////////////////////////////////////////////////
void find_new_positions( VI& viIn, VI& viSelfPairsFirstPositions, VI& viNewPositions ) {
 find_new_positions( viIn, viSelfPairsFirstPositions, viNewPositions, 2 );
}


////////////////////////////////////////////////////////////////
// 'distance' is measured as abs( viOldPositions[i] - viNewPositions[i] )
// 'distance'=2  will reject new positions that are adjacnt to old positions
// viIn is not used in choosing the positions in this implementation.

void find_new_positions( VI& viIn, VI& viOldPositions, VI& viNewPositions, int distance ) {
 int debug=1;
 MyRandom rd;
 if (debug) { cout << "Assuming a small fraction of self-pairing."; }

 viNewPositions.clear();
 int nmax = viIn.size();

 for ( unsigned i=0; i<viOldPositions.size(); ++i ) {
    int iNew = rd( nmax ); 
    if (debug) { cout << "For " << viOldPositions[i] << ":" << iNew << "|"; }
    int count =0;
    while ( ( ( exists_vi(viOldPositions, iNew) ) 
		or ( abs(viOldPositions[i] - iNew) < distance )
		or ( exists_vi(viNewPositions, iNew) ) 
  	    ) and ( count < 5 * nmax ) 
	  ) {
       iNew = rd ( nmax ); cout << iNew << "|";
       count ++;
    }
    viNewPositions.push_back( iNew );
 }
 if (debug) { PRINT_ELEMENTS( viNewPositions, " viNewPositions "); }
}

////////////////////////////////////////////////////////////////
void swap_positions_in_vector( VI& viIn, VI& viOldPositions, VI& viNewPositions ) {
 int debug=1;

 if (debug) {  PRINT_ELEMENTS(viIn, "swap_positions_in_vector()::viIn Before: "); }

 for ( unsigned i=0; i<viNewPositions.size(); i+=1 ) {
   int iTmp = viIn[ viOldPositions[i] ];
   viIn[ viOldPositions[i] ] = viIn[ viNewPositions[ i] ];
   viIn[ viNewPositions[i] ] = iTmp;
 }

 if (debug) {  PRINT_ELEMENTS(viIn, "swap_positions_in_vector()::viIn After : "); }

}


////////////////////////////////////////////////////////////////
bool exists_vi( VI& viIn, int value ) {
 for ( unsigned i=0; i<viIn.size(); ++i ) {
   if ( viIn[i] == value ) { return 1; }
 }
 return 0;
}	

////////////////////////////////////////////////////////////////
bool ajacent_vi( VI& viIn, int value ) {
 for ( unsigned i=0; i<viIn.size(); ++i ) {
   if ( viIn[i] == value ) { return 1; }
   if ( abs( viIn[i] - value )== 1) { return 1; }
 }
 return 0;
}	

////////////////////////////////////////////////////////////////
void array_to_vector_int( int in[], VI& out, int iSize ) {
 for ( int i=0; i< iSize; ++i ) {
  out.push_back( in[i] );
 }
}

////////////////////////////////////////////////////////////////
void find_SelfPairsFirstPositions_vector( VI& viIn, VI& viSelfPairsFirstPositions ) {
 int debug=1;
 if (debug) { PRINT_ELEMENTS( viIn, "viIn  "); }
 viSelfPairsFirstPositions.clear();
 for ( unsigned i=0; i<viIn.size(); i+=2 ) {
    if ( viIn[i] == viIn[i+1] ) {
      viSelfPairsFirstPositions.push_back( i );
    }
 }
 if (debug) { PRINT_ELEMENTS(viSelfPairsFirstPositions, "viSelfPairsFirstPositions "); }
}


////////////////////////////////////////////////////////////////
void  vector_to_mlmapii( VI& viIn, MLMAP_ii_t& mliiOut ) {
 int debug=1;
 VI::iterator itr, itrNext;
 //int iCurrent, iNext;

 mliiOut.clear();

 for ( unsigned i=0; i<viIn.size(); i+=2) {
   mliiOut.insert(make_pair( viIn[i], viIn[i+1] ));
 }

 if (debug) {
  MLMAP_ii_t::iterator pos;
  for ( pos=mliiOut.begin(); pos!=mliiOut.end(); ++pos ) {
     cout << pos->first << ":" << pos->second << "\t";
  }
  cout << endl;
 }
}


////////////////////////////////////////////////////////////////
void list_to_mlmapii( LI& liIn, MLMAP_ii_t&  mliiOut ) {
 int debug=1;
 LI::iterator itr, itrNext;
 int iCurrent, iNext; 

 mliiOut.clear();
 
 itr= liIn.begin();
 while ( itr != liIn.end() ) {
   iCurrent  = * itr;
   ++itr;
   iNext     = * itr;
   mliiOut.insert(make_pair( iCurrent, iNext ));
   if ( itr!= liIn.end() ) { ++itr; }
 }

 if (debug) {
  MLMAP_ii_t::iterator pos;
  for ( pos=mliiOut.begin(); pos!=mliiOut.end(); ++pos ) {
     cout << pos->first << ":" << pos->second << "\t" ;
  }
  cout << endl;
 }
}

////////////////////////////////////////////////////////////////
void  mlmapii_to_vector( MLMAP_ii_t& mliiIn, VI& viOut ) {
 int debug=1;
 MLMAP_ii_t::iterator itr;
 
 viOut.clear();
 
 for ( itr=mliiIn.begin(); itr!=mliiIn.end(); ++itr ) {
   viOut.push_back( itr->first  );
   viOut.push_back( itr->second );
 }
 
 if (debug) { PRINT_ELEMENTS (viOut, "util::mlmapii_to_vector() viOut: ") ; }

}


////////////////////////////////////////////////////////////////
void mlmapii_to_list( MLMAP_ii_t&  mliiIn, LI& liOut ) {
 int debug=1;
 MLMAP_ii_t::iterator itr;

 liOut.clear();

 for ( itr=mliiIn.begin(); itr!=mliiIn.end(); ++itr ) {
   liOut.push_back( itr->first  );
   liOut.push_back( itr->second );
 }

 if (debug) { PRINT_ELEMENTS (liOut, "util::mlmapii_to_list() liOut: ") ; }
}


////////////////////////////////////////////////////////////////
PAIR_str_t  small2big_pair( string s1, string s2) {
 if ( s1.compare(s2) > 0 ) {  return PAIR_str_t (s2,s1) ; }
 return PAIR_str_t (s1, s2);
}
 
////////////////////////////////////////////////////////////////
void small2big_swap( string & s1, string & s2) {
 cout << "before: " << s1 << "\t" << s2 << endl;
 if ( s1.compare(s2) > 0 ) {   s1.swap( s2 ) ; }
 cout << "after:  " << s1 << "\t" << s2 << endl;
}

////////////////////////////////////////////////////////////////    
/* From KR white book */
void reverse( char s[] ) {
 int c, i, j;
 for ( i=0, j= strlen(s)-1; i<j; i++, j--) {
     c = s[i];
     s[i] = s[j];
     s[j] = c;
 }
}

void itoa( int n, char s[] ) {
 int i, sign;
 if ( (sign=n) < 0 ) n = -n;
 i = 0;
 do {
   s[i++] = n % 10 + '0';
 } while ( (n/=10) > 0 );
 if ( sign < 0 ) s[i++] = '-';
 s[i] = '\0';
 reverse(s);
}

/* trim: remove trailing blanks, tabs, newlines. From KR white book */
int trim(char s[]) {
 int n;
 for ( n=strlen(s)-1; n>=0; n--)
     if ( s[n] != ' ' && s[n] != '\t' && s[n] != '\n' )
	break;
 s[n+1] = '\0';
 return n;
}


////////////////////////////////////////////////////////////////    

void Tokenize(const std::string& str,  //122005 This is problematic. 
                      std::vector<string> & tokens,
                      const std::string& delimiters = "/")
{
    // Skip delimiters at beginning.
    std::string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    std::string::size_type pos     = str.find_first_of(delimiters, lastPos);

    cout << "lastPos="<<lastPos << " pos=" <<pos;
    cout << " npos=" << std::string::npos << "str.size()"<< str.size()<<endl;
    while (std::string::npos != pos || std::string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        cout << str.substr(lastPos, pos-lastPos) << " ";
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
        cout << "pos="<<pos << " lastPos=" << lastPos <<endl;
    }
  cout <<"leaving Tokenize()"<<endl;
}


void set_shortfile_name( string & longname, string & short_file_name  ) {
 int debug=1; 
 // char * delimiters = "/"; 
 vector<string> vs;
 if (debug) {  cout <<"enter util::set_shortfile_name()" <<endl;}
 Tokenize( longname, vs, "/" );
 short_file_name.assign( vs[vs.size() -1 ] );  
 short_file_name = vs[ vs.size()-1 ];
 cout << "set()::vs.size()=" << vs.size() <<endl;
/*
// stringtok( vs, longname, delimiters );
// short_file_name.assign( vs[vs.size()] ); //??? i am here 102803 tue
// short_file_name =  vs[vs.size()-1] ;  
*/

 cout << "set_shortfile_name()::tokens are:";
 for( unsigned i=0; i< vs.size(); ++i) {
  cout << "[" <<vs[i] << "]";
 }
 
}
