/* v 0.00 January 2006
 Return all possible shortest-paths of a list of input nodes
 Return distance matrix for the input list of node
 Use the single source dijkstra shortest path algorithm.

 Jan 30, 2006 Add edge weights to undirected grapth
 (c) Hogn Qin Dec 11, 2005 hong_man@yahoo.com
*/
#include <string>
#include <iostream>
#include <map>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>
#include "mapdictionary.h"

#include <fstream>
#include "dijkstra.h"
#include "node_parser.h"
using namespace std;

// clean up the memory
void _clear_vpvpReturnPaths( std::vector< std::vector<Node*> * > & vpvpReturnPaths ) {
    int debug=0;
    for( unsigned i=0; i< vpvpReturnPaths.size(); ++i) {
       if (debug) { cout<<"I am deleting " << vpvpReturnPaths[i] << " ... ..."; }
       delete vpvpReturnPaths[i];
       if (debug) {cout<<"; It is now " << vpvpReturnPaths[i] << endl;}
    }
    vpvpReturnPaths.clear();
}

typedef struct {
 int 	debug;
 char   input_pairwise_tab[1024];
 char   input_node_tab[1024];
 char   output_path_file[1024];
 char   output_distance_matrix[1024];
 //char   output_numOfPaths_matrix[1024];
} OPTION_PARA;

static OPTION_PARA myoption;

int main(int argc, char *argv[]){
// myoption.verbose=0;
 myoption.debug  =1;

 int c;

 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",       required_argument, 0, 'i'},
          {"node_tab_in",   		required_argument, 0, 'n'},
          {"output_path_file",   	required_argument, 0, 'o'},
          {"output_distance_matrix",required_argument, 0, 'm'},
        //{"output_numOfPaths_matrix",required_argument, 0, 'p'},
          {"debug",  		    	optional_argument, 0, 'd'},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:n:o:m:d", long_options, &option_index);

      if (c == -1) break;

      switch (c)   {
        case 0 :	break;

        case 'd':
          cout<< "option -d :" << optarg << endl;
          //myoption.debug = atoi( optarg ); //runtime parsing error here!
          myoption.debug = 1;
          break;

        case 'i':
	      //cout << "option i, optarg is " << optarg << endl;
	      strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'n':
	      //cout << "case n, optarg is " << optarg << endl;
	      strcpy( myoption.input_node_tab, optarg );
          break;

        case 'o':
          strcpy( myoption.output_path_file, optarg );
          break;

        case 'm':
          strcpy( myoption.output_distance_matrix, optarg );
          break;

/*        case 'p':
          strcpy( myoption.output_numOfPaths_matrix, optarg );
          break;  */

        case '?':
          break;

        default:
         // abort ();
         break;
        }
 } //while loop

 int debug = myoption.debug;

 long tp;
 time (&tp);
 srand (tp);

 Graph g, g2, g1;
 CPairs_Parser parser1;
 Dijkstra dk1;
 CNode_Parser np1;

 string longfile =  myoption.input_pairwise_tab;
 string node_file = myoption.input_node_tab;

 // read the input network
 parser1.generate_weighted_undirected_graph_without_self_pairing(longfile, g1 ); //013006
 if (debug ) {  cout<<"The w-graph is ";    g1.print(); }

 std::vector<Node*> vpNodes;  //the input Nodes
 std::vector<Node*> vpReturnPath;

 if ( node_file != (string) "ALL" ) {
   np1.set_vsIds_frm_fl( node_file );  // read the input list of nodes

   //pick nodes for shortest_path return
   for ( unsigned i=0; i<np1.vsIds.size(); ++i ) {
   //cout<<"Looking for "<< np1.vsIds[i] << " among ";
     for ( unsigned j=0; j<g1.vNodes.size(); ++j ) {
       //cout << g1.vNodes[j].pId << " ";
       if ( np1.vsIds[i] == (string) g1.vNodes[j].pId ) {
         vpNodes.push_back( & g1.vNodes[j] );
       }
     }
   //cout<<endl;
  }
} else { //all nodes
     for ( unsigned j=0; j<g1.vNodes.size(); ++j ) {
       //cout << g1.vNodes[j].pId << " ";
         vpNodes.push_back( & g1.vNodes[j] );
     }
}

string sTmp = myoption.output_path_file;
string matrix_file     = myoption.output_distance_matrix;
//string numOfPaths_file = myoption.output_numOfPaths_matrix;

float** dd = new float*[ vpNodes.size() ] ; //  distance matrix
//float** mm = new float*[ vpNodes.size() ] ; //  number of SPs
for( unsigned i=0; i<vpNodes.size(); ++i ) {
  dd[i] = new float[ vpNodes.size() ];
  //mm[i] = new float[ vpNodes.size() ];
}


ofstream outfile( sTmp.c_str() );

//enumerate through a list of nodes
for( unsigned k=0; k < vpNodes.size(); ++k) {  // k is the source
  //g1.print();
  if (debug) { cout <<"\n>(main)source is "<< vpNodes[k]->pId <<"\n"; }
  outfile <<">source is "<< vpNodes[k]->pId <<"\n";
  dk1.dijkstra_weight( & g1, vpNodes[k] );

  for( unsigned i= k; i<vpNodes.size(); ++i) {  //i is the target node
	if(debug) { cout    << "(main)target is " << vpNodes[i]->pId << endl; }
    // vpvpReturnPaths.clear();                //need to clear memory instead
    //_clear_vpvpReturnPaths( vpvpReturnPaths ); // does this clear memory? 020806 runtime error?
    //dk1.find_all_shortest_paths_w( vpNodes[i], vpvpReturnPaths, 0);   //will this work for weighted graph?
    dk1.trace_back( vpNodes[i], vpReturnPath );
    outfile << "target is " << vpNodes[i]->pId ;
    outfile << " nD=" << vpNodes[i]->nD;
    dd[k][i] = vpNodes[i]->nD;
//    mm[k][i] = vpvpReturnPaths.size();
    outfile << " vpReturnPath.size()=" << vpReturnPath.size() << endl;
      for( unsigned m=0; m< (vpReturnPath.size()-1); ++m ) { //print out all the nodes in the path
		    outfile<< vpReturnPath[m]->pId<<"<-";
			}//m
      outfile << vpReturnPath[ vpReturnPath.size()-1 ]->pId <<endl;

  }//i
  outfile<<"\n";
}//k

//output distance matrix and number of paths
ofstream outmatrix( matrix_file.c_str() );
//ofstream outnumOfPaths( numOfPaths_file.c_str() );

if (debug) {
 for( unsigned i=0; i<= (vpNodes.size()-1); ++i) {
     cout << "\t" << vpNodes[i]->pId ;
 }
 cout << endl;
 for( unsigned i=0; i<= (vpNodes.size()-1); ++i) {
    cout << vpNodes[i]->pId << "\t";
    for( unsigned j=0; j<=(vpNodes.size()-1); ++j) {
        cout << dd[i][j] << "\t";
    }
    cout << endl;
 }
}

for( unsigned i=0; i<vpNodes.size(); ++i) {
    outmatrix     << "\t" << vpNodes[ vpNodes.size()- i - 1]->pId ; //column labels
    //outnumOfPaths << "\t" << vpNodes[ vpNodes.size()- i - 1]->pId ; //column labels
}
outmatrix     <<endl;
//outnumOfPaths <<endl;

for( unsigned i=0; i<= (vpNodes.size()-1); ++i) {
    unsigned row = vpNodes.size() - i - 1;
    outmatrix     << vpNodes[ row ]->pId <<"\t"; // row labels
    //outnumOfPaths << vpNodes[ row ]->pId <<"\t"; // row labels
    //for( unsigned j=0; j<i; ++j ) { outmatrix<< "\t"; }
    for( unsigned j=0; j< (i+1); ++j) {
        //print by column
        unsigned column = vpNodes.size() - j -1;
        outmatrix << dd[row][column]<<"\t";
        //outnumOfPaths << mm[row][column]<<"\t";
    }
    outmatrix     <<endl;
    //outnumOfPaths <<endl;
}
outmatrix.close();
//outnumOfPaths.close();


for( unsigned i=0; i<vpNodes.size(); ++i ) {
  delete [] dd[i];
//  delete [] mm[i];
}
delete [] dd;
//delete [] mm;


return 0;
}
