<?php

class Person
{
   var $message;
   var $db;
   function Person($_dbLink) 
   {
      $this->message = "";
      $this->db = $_dbLink;
   }
   ////////////////////////////////////////////////////////////
   //Add function adds a person into database                //
   //inputs: $_pInfo - an array with the fields of the table //
   //        $_pTable - name of the person's table in db     //
   //        $_prefix - attribute prefix e.g. 'juv'_fName    //
   //return: $personID                                       //
   ////////////////////////////////////////////////////////////
   function add( $_pInfo, $_pTable, $_prefix )
   {
        if(isset($_pInfo[$_prefix.'registrationDate']))
          $reg_pieces = explode('--', $_pInfo[$_prefix.'registrationDate']); //Should not be able to parse it if it's set correctly
        if(isset($_pInfo[$_prefix.'dob']))
          $dob_pieces = explode('--', $_pInfo[$_prefix.'dob']);
        if( (isset($_pInfo[$_prefix.'fName']) && trim($_pInfo[$_prefix.'fName']) == '') || 
            (isset($_pInfo[$_prefix.'lName']) && trim($_pInfo[$_prefix.'lName']) == '') ||
            (isset($_pInfo[$_prefix.'registrationDate']) && count($reg_pieces) != 1 )||
            (isset($_pInfo[$_prefix.'dob']) && count($dob_pieces) != 1 ) ) 
                  $this->message= "Please enter the required fields.";
        else
        {
                //Check for existing person
                $query = "SELECT * FROM $_pTable WHERE ";
                $query .= implode_with_keys(" AND ", $_pInfo, "\"");
                $result = mysql_query($query, $this->db) or die('Coud not search for duplicates in '.$_pTable.mysql_error());
                if( mysql_num_rows($result) > 0 )
                {
                    $person = mysql_fetch_row($result);
                    $personID = $person[0];
                }
                else
                {
                    $query = "INSERT INTO $_pTable VALUES(NULL,\"";
                    $query .= implode("\",\"", $_pInfo )."\")";
                    $result = mysql_query($query, $this->db) or die('Coud not insert into '.$_pTable.mysql_error());
                    //echo $_pInfo[$_prefix.'fName'] . " " . $_pInfo[$_prefix.'mName'] . " " . $_pInfo[$_prefix.'lName'] . " " . " Added"; 
                    $personID = mysql_insert_id($this->db);
                }
              return $personID;
      
        }
   }
   
   ////////////////////////////////////////////////////////////
   //Update function updates a person in database            //
   //inputs: $_personID - ID of the person being updated     //
   //        $_pInfo - an array with the fields of the table //
   //        $_pTable - name of the person's table in db     //
   //        $_prefix - attribute prefix e.g. 'juv'_fName    //
   //        $_pKey - primary key of the table               //
   //return: n\a                                             //
   ////////////////////////////////////////////////////////////
   function update( $_personID, $_pInfo, $_pTable, $_prefix, $_pKey="" )
   {
    $_pKey= ($_pKey == '') ? strtolower($_pTable).'ID' : $_pKey;
    if(isset($_pInfo[$_prefix.'registrationDate']))
      $reg_pieces = explode('--', $_pInfo[$_prefix.'registrationDate']); //Should not be able to parse it if it's set correctly
    if(isset($_pInfo[$_prefix.'dob']))
      $dob_pieces = explode('--', $_pInfo[$_prefix.'dob']);
    if( (isset($_pInfo[$_prefix.'fName']) && trim($_pInfo[$_prefix.'fName']) == '') || 
       (isset($_pInfo[$_prefix.'lName']) && trim($_pInfo[$_prefix.'lName']) == '') ||
       (isset($_pInfo[$_prefix.'registrationDate']) && count($reg_pieces) != 1  )||
       (isset($_pInfo[$_prefix.'dob']) && count($dob_pieces) != 1  ) ) 
          $this->message= "Please enter the required fields.";
    else
    {
      foreach( $_pInfo as $key=>$val )
      {
          $str = "$key = \"$val\"";
          $parts[] = $str;
      }
      $query = "UPDATE $_pTable SET ";
//       print_r($this->db);
      echo $query .= implode(", ", $parts )." WHERE $_pKey = $_personID";
      $result = mysql_query($query, $this->db) or die('Coud not update '.$_pTable."! ".mysql_error());
      //echo $_pInfo[$_prefix.'fName'] . " " . $_pInfo[$_prefix.'mName'] . " " . $_pInfo[$_prefix.'lName'] . " " . " Updated"; 
    }
   }

    ///////////////////////////////////////////////////////////////////////////
    //Add address                                                            //
    //inputs: $_personID - an ID of the person whose address is being added  //
    //        $_addInfo - attributes of address                              //
    //        $_personType - person type  whose address is being added       //
    //        $_addTable - table name for addresses                          //
    //return: bool                                                           //
    ///////////////////////////////////////////////////////////////////////////
    function addAddress( $_personID, $_addInfo, $_personType, $_addTable='Addresses' )
    {
        $rval = false;
        $query = "SELECT COUNT(*) FROM $_addTable";
        $result = mysql_query($query,$this->db) or die('Coud not count addresses!'.mysql_error());
        $row = mysql_fetch_row($result);
        $addID = $row[0] + 1;
    
        $query = "insert into $_addTable 
                    (addressID,personType, addType, addLine1, addLine2, addLine3, addCity, addState, addZip, addCountry,".$_personType."ID) 
                    values 
                    ($addID,'$_personType', '$_addInfo[addType]', '$_addInfo[addLine1]', '$_add[addLine2]', '$_addInfo[addLine3]',
                    '$_addInfo[addCity]', '$_addInfo[addState]', '$_addInfo[addZip]', '$_addInfo[addCountry]', '$_personID')"; 
        $result = mysql_query($query, $this->db) or die('Could not insert a new address!'.mysql_error());
        if($result)
           $rval = true;
        return $rval;
    } 
     
    ///////////////////////////////////////////////////////////////////////////
    //Update address                                                         //
    //inputs: $_addressID - ID of the address                                //
    //        $_addInfo - attributes of address                              //
    //        $_addTable - table name for addresses                          //
    //return: n/a                                                            //
    ///////////////////////////////////////////////////////////////////////////
    function updateAddress( $_addressID, $_addInfo, $_addTable='Addresses'  )
    {
        $rval = false;
        foreach( $_addInfo as $key=>$val )
        {
                  $str = "$key = \"$val\"";
                  $parts[] = $str;
        }
        $query = "UPDATE Addresses SET ";
        $query .= implode(", ", $parts )." WHERE addressID = $_addressID";
        $result = mysql_query($query, $this->db) or die('Coud not update address!'.mysql_error());
        if($result)
           $rval = true;
        return $rval;
    }

    ///////////////////////////////////////////////////////////////////////////
    //Connect People                                                         //
    //inputs: $_person1ID - ID of the first person                           //
    //        $_person1ID - ID of the second person                          //
    //        $_table - table name                                           //
    //return: n/a                                                            //
    ///////////////////////////////////////////////////////////////////////////
    function connectPeople( $_person1ID, $_person2ID, $_table )
    {
        $rval = false;
        $query = "INSERT INTO $_table VALUES($_person1ID,$_person2ID)";
        $result = mysql_query($query) or die('Coud not insert create connection in '.$_table.mysql_error());
        if($result)
           $rval = true;
        return $rval;
    }
    
    ///////////////////////////////////////////////////////////////////////////
    //Search                                                                 //
    //inputs: $_searchKeys - array of fields to search                       //
    //        $_prefix - preifix of table attributes                         //
    //        $_table - table name                                           //
    //        $_pKey  - primary key attribute in the table                   //
    //return: n/a                                                            //
    ///////////////////////////////////////////////////////////////////////////
    function search( $_searchKeys, $_table, $_prefix, $_pKey="" )
    {
        if( count($_searchKeys) == 0 )
        {      
            $this->message = "Please enter at least one search field!";
        }
        else
        {
          $_pKey= ($_pKey == '') ? strtolower($_table).'ID' : $_pKey;
          $searchResult = array();
          $parts = array();
          $query = "SELECT * FROM $_table WHERE ";
          foreach( $_searchKeys as $arr )
          {
            foreach( $arr as $key=>$val )
            {
              $str = "$key=\"$val\"";
              $parts[] = $str;
            }
          }
          $query .= implode(" AND ", $parts );
          $result = mysql_query($query) or die('Coud not look in '.$_table.mysql_error());
          while( $row = mysql_fetch_assoc($result) )
          {
            $fName = $row[$_prefix.'fName'];
            $lName = $row[$_prefix.'lName'];
            $personID = $row["$_pKey"];
            $dob = $row[$_prefix.'dob'];
            $searchResult[] = array("$_pKey" => $personID,
                                  $_prefix.'fName' => $fName,
                                  $_prefix.'lName' => $lName,
                                  $_prefix.'dob' => $dob );
          }
          if( count($searchResult) == 0 )
            $this->message = "No person found!";
        }
        return $searchResult;
    }
    
      ////////////////////////////////////////
      //getMsg                              //
      //inputs:  n/a                        //  
      //returns: formated message           //
      ////////////////////////////////////////
      function getMsg()
    {
        return $this->message;
    }
      
      ////////////////////////////////////////
      //setMsg                              //
      //inputs:  $_msg - message            //  
      //returns: n/a                        //
      ////////////////////////////////////////
      function setMsg( $_msg )
    {
          $this->message = $_msg;
    }
      
      ////////////////////////////////////////
      //isSetMsg                            //
      //inputs:  n/a                        //  
      //returns: bool                       //
      ////////////////////////////////////////
      function isSetMsg( )
    {
        $rval = ($this->message == '') ? false : true;
        return $rval;
    }
}//End Class Person

?>