/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.ResultFormatter;
import com.syntek_usa.util.ExtensionFileFilter;
import com.syntek_usa.util.ObjectFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GeneCiteResultsFrame
extends JFrame
implements ActionListener {
    private JTable table;
    private JButton saveButton;
    private GeneCiteFrame parent;
    private ResultFormatter[] formatters;
    private int defaultFormatter;

    public GeneCiteResultsFrame(GeneCiteFrame parent) {
        super("GeneCite Search Results");
        this.setDefaultCloseOperation(2);
        this.setSize(500, 300);
        this.parent = parent;
        this.table = new JTable(new DatabaseSearchTableModel(parent.getApp().search.getResult()));
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonPanel = new JPanel();
        this.saveButton = new JButton("Save");
        buttonPanel.add(this.saveButton);
        this.saveButton.addActionListener(this);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.show();
        ObjectFactory factory = parent.getApp().getFormatterFactory();
        String[] formatternames = factory.getObjectList();
        this.formatters = new ResultFormatter[formatternames.length];
        for (int i = 0; i < formatternames.length; ++i) {
            this.formatters[i] = (ResultFormatter)factory.create(formatternames[i]);
            if (!formatternames[i].equals(factory.getDefaultObject())) continue;
            this.defaultFormatter = i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.saveButton) {
            GeneCite app = this.parent.getApp();
            JFileChooser chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            for (int i = 0; i < this.formatters.length; ++i) {
                chooser.addChoosableFileFilter(this.formatters[i].getFileFilter());
            }
            chooser.setFileFilter(this.formatters[this.defaultFormatter].getFileFilter());
            String baseFileName = app.outputFile;
            if (baseFileName.equals("")) {
                baseFileName = this.formatters[this.defaultFormatter].getBaseFileName();
            }
            chooser.setCurrentDirectory(new File(baseFileName).getParentFile());
            chooser.setSelectedFile(new File(baseFileName + "_" + GeneCite.formatDate(app.search.getStartTime()) + "." + ((ExtensionFileFilter)chooser.getFileFilter()).getExtension()));
            if (chooser.showSaveDialog(this) == 0) {
                int i;
                ExtensionFileFilter filter = (ExtensionFileFilter)chooser.getFileFilter();
                for (i = 0; i < this.formatters.length && this.formatters[i].getFileFilter() != filter; ++i) {
                }
                this.saveFile(chooser.getSelectedFile().getAbsolutePath(), this.formatters[i]);
            }
        }
    }

    private boolean saveFile(String filename, ResultFormatter formatter) {
        if (!this.parent.checkOutputFile(filename)) {
            return false;
        }
        try {
            this.parent.getApp().saveResultsFile(filename, formatter);
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, e, "Error Writing File", 0);
            return false;
        }
    }
}

