/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Result;
import com.syntek_usa.dbsearch.ResultFormatter;
import com.syntek_usa.dbsearch.ResultSet;
import com.syntek_usa.dbsearch.Search;
import com.syntek_usa.util.ExtensionFileFilter;
import com.syntek_usa.util.GenericApplication;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.filechooser.FileFilter;

public class HTMLFormatter
implements ResultFormatter {
    private static final String EXT = "html";
    private static final String DESC = "HTML Files";
    private static final String BASE = "results";
    private static final FileFilter filter = new ExtensionFileFilter("html", "HTML Files");
    private static final String HTMLENCODING = "ISO-8859-1";
    private static final String QUOTE = "\"";
    private static final String HEAD1 = "<html>\n<head>\n";
    private static final String HEAD2 = "   <meta http-equiv=\"content-type\" content=\"text/html;charset=ISO-8859-1\">\n   <meta name=\"author\" content=\"";
    private static final String HEAD3 = "\">\n   <title>";
    private static final String HEAD4 = " Citation Results</title>\n</head>\n";
    private static final String BASE1 = "   <base href=\"";
    private static final String BASE2 = "\">\n";
    private static final String FOOT = "</html>\n";
    private static final String BODYHEAD1 = "<body>\n<b> ";
    private static final String BODYHEAD2 = "</b> by <a href=\"";
    private static final String BODYHEAD3 = "\" target=\"_blank\">";
    private static final String BODYHEAD4 = "</a>:<b> Citation Results.</b>&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String BODYHEAD5 = "<br>\n<br>\n";
    private int numberOfOpts = 1;
    private static final String BODYFOOT = "</body>\n";
    private static final int LEFTMARGIN = 67;
    private static final int ROWNUMBERWIDTH = 30;
    private static final int ROWHEADERWIDTH = 300;
    private static final int DATACOLUMNWIDTH = 100;
    private static final int COLSPACING = 2;
    private static final int BORDER = 1;
    private int tableWidth;
    private static final String TABLECELL1 = "      <td valign=\"Top\"";
    private static final String TABLECELL2 = ">";
    private static final String TABLECELL3 = "<br>\n      </td>\n";
    private static final String TABLEHEAD1 = "<table cellpadding=\"2\" cellspacing=\"2\" border=\"1\" width=\"";
    private static final String TABLEHEAD2 = "\">\n  <thead>\n    <tr>\n";
    private static final String TABLEHEAD3 = "    </tr>\n  </thead>\n  <tbody>\n    <tr>\n";
    private static final String TABLEHEAD4 = "    </tr>\n";
    private static final String TABLEFOOT = "  </tbody>\n</table>\n";
    private static final String TABLEROW1 = "    <tr>\n";
    private static final String TABLEROW2 = "    </tr>\n";
    private static final String TABLEROW3 = "<a href=\"";
    private static final String TABLEROW4 = "\">";
    private static final String TABLEROW5 = "</a>\n";
    private GenericApplication app;
    private Search s;
    private PrintWriter w;
    private ResultSet rs;
    private int numberOfColumns;

    public FileFilter getFileFilter() {
        return filter;
    }

    public String getBaseFileName() {
        return BASE;
    }

    public void setApp(GenericApplication app) {
        this.app = app;
    }

    public void setSearch(Search s) {
        this.s = s;
    }

    public void format(OutputStream os) throws IOException {
        if (this.app == null || this.s == null) {
            throw new IllegalStateException();
        }
        this.w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, HTMLENCODING)));
        this.rs = this.s.getResult();
        this.outputHead();
        this.outputBody();
        this.outputFoot();
        this.w.close();
    }

    private void outputHead() {
        this.w.print(HEAD1 + this.formatBase(this.s.getBaseURL()) + HEAD2 + this.app.getCompany() + HEAD3 + this.app.getTitle() + HEAD4);
    }

    private String formatBase(String url) {
        return BASE1 + url + BASE2;
    }

    private void outputFoot() {
        this.w.print(FOOT);
    }

    private void outputBody() {
        this.outputBodyHead();
        this.outputTable();
        this.outputBodyFoot();
    }

    private void outputBodyHead() {
        this.w.print(BODYHEAD1 + this.app.getTitle() + BODYHEAD2 + this.app.getCompanyURL() + BODYHEAD3 + this.app.getCompany() + BODYHEAD4);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = format.format(new Date(this.s.getStartTime()));
        this.w.print(startTime + BODYHEAD5 + this.s.getDescription() + BODYHEAD5);
    }

    private void outputBodyFoot() {
        this.w.print(BODYFOOT);
    }

    private void outputTable() {
        this.numberOfColumns = this.rs.numberOfDimensions() == 1 ? 1 : this.rs.getDimension(1);
        this.tableWidth = 404 + 102 * this.numberOfColumns;
        this.outputTableHead();
        this.outputTableBody();
        this.outputTableFoot();
    }

    private String formatTableCell(int width, String content) {
        return TABLECELL1 + width + TABLECELL2 + content + TABLECELL3;
    }

    private void outputTableHead() {
        int col;
        this.w.print(TABLEHEAD1 + this.tableWidth + TABLEHEAD2 + this.formatTableCell(30, "GeneCite") + this.formatTableCell(300, ""));
        if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
            this.w.print(this.formatTableCell(100, ""));
        } else {
            for (col = 0; col < this.numberOfColumns; ++col) {
                this.w.print(this.formatTableCell(100, "#" + (col + 1)));
            }
        }
        this.w.print(TABLEHEAD3 + this.formatTableCell(30, "") + this.formatTableCell(300, "Terms:"));
        if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
            this.w.print(this.formatTableCell(100, ""));
        } else {
            for (col = 0; col < this.numberOfColumns; ++col) {
                this.w.print(this.formatTableCell(100, this.rs.getHeader(1, col)));
            }
        }
        this.w.print("    </tr>\n");
    }

    private void outputTableFoot() {
        this.w.print(TABLEFOOT);
    }

    private void outputTableBody() {
        for (int row = 0; row < this.rs.getDimension(0); ++row) {
            this.w.print(TABLEROW1 + this.formatTableCell(30, "#" + (row + 1)) + this.formatTableCell(300, this.rs.getHeader(0, row)));
            if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
                this.w.print(this.formatTableCell(100, TABLEROW3 + this.s.getQueryURL(((Result)this.rs.getValueAt(row)).getQuery()) + TABLEROW4 + this.rs.getValueAt(row) + TABLEROW5));
            } else {
                for (int col = 0; col < this.numberOfColumns; ++col) {
                    this.w.print(this.formatTableCell(100, TABLEROW3 + this.s.getQueryURL(((Result)this.rs.getValueAt(row, col)).getQuery()) + TABLEROW4 + this.rs.getValueAt(row, col) + TABLEROW5));
                }
            }
            this.w.print("    </tr>\n");
        }
    }
}

