/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.util.PropertyListWithDefault;
import com.syntek_usa.util.SelfReadingPropertiesFile;
import java.net.MalformedURLException;
import java.net.URL;

public class PubMedDatabasePropertiesFile
extends SelfReadingPropertiesFile {
    private String urlName = new String();
    private int lockPeriod;
    private String[] keywordList = null;
    private int defaultKeyword;
    private boolean sendQuery;
    private String[] queryOptionList = null;
    private String[] hiddenQueryOptionList = null;
    private String noCitationsPattern = new String();
    private String noCitationsOutput = new String();
    private String citationCountPattern = new String();
    private String citationDefault = new String();
    private static final String PROPFILE = "PubMedDatabase.properties";
    private static final String URLPROP = "url";
    private static final String DEFAULTURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi";
    private static final String LOCKPERIODPROP = "lock_period";
    private static final int DEFAULTLOCKPERIOD = 2000;
    private static final String KEYWORDLISTPROP = "keywords";
    private static final String DEFAULTKEYWORDLIST = "term";
    private static final String DEFKEYWORDPROP = "default_keyword";
    private static final int DEFAULTKEYWORD = 1;
    private static final String SENDQUERYPROP = "send_query";
    private static final boolean DEFAULTSENDQUERY = true;
    private static final String QUERYOPTIONSPROP = "query_options";
    private static final String DEFAULTQUERYOPTIONS = "db=PubMed,cmd=search";
    private static final String HIDDENQUERYOPTIONSPROP = "hidden_query_options";
    private static final String DEFAULTHIDDENQUERYOPTIONS = "dispmax=1";
    private static final String NOCITATIONSPATTERNPROP = "no_citations_pattern";
    private static final String DEFAULTNOCITATIONSPATTERN = "No items found";
    private static final String NOCITATIONSOUTPUTPROP = "no_citations_output";
    private static final String DEFAULTNOCITATIONSOUTPUT = "0";
    private static final String CITATIONCOUNTPATTERNPROP = "citation_count_pattern";
    private static final String DEFAULTCITATIONCOUNTPATTERN = ".*Item.* of (\\d+).*";
    private static final String CITATIONDEFAULTPROP = "citation_default";
    private static final String DEFAULTCITATIONDEFAULT = "1";
    private static final String DEFAULTTEXT = "#\n#                        PubMedDatabase.properties\n#\n# This is the PubMedDatabase.properties file.  It contains options specific\n# to the PubMed database support provided for the GeneCite program.\n# Each entry in the properties file consists of a keyword, an equals sign,\n# and a value.  In order for the keyword to be recognized, it must match\n# the expected keyword exactly, including underscore characters '_' .  Each\n# keyword has a default that will be used if that keyword is not given in the\n# properties file, or if the properties file does not exist.  As a result, a\n# properties file is really necessary only if the defaults need to be changed.\n\n# Database URL - url - This is the Internet URL to which PubMed queries are\n# submitted.  You may want to change this if you use a reflection site instead\n# of the standard site, for instance.  The default value is:\n# url = http://www.ncbi.nlm.nih.gov/entrez/query.fcgi\n# Example:\n# url=http://www.ncbi.nlm.nih.gov/entrez/query.fcgi\n\n# Inter-Query Lock Period - lock_period - The minimum interval in milliseconds\n# that will be enforced between queries.  The U.S. National Library of\n# Medicine's NCBI organization, which administers PubMed, requests that a two-\n# second minimum interval be maintained between queries submitted in bulk.\n# The default for this value is therefore 2000, or two seconds.\n# Example:\n# lock_period = 2000\n\n# Keyword List - keywords - The list of keywords for which queries can be\n# submitted to this database.  For instance, PubMed supports queries of the\n# form:\n#    term=(term1 OR term2) AND (term3 OR term4 OR term5)\n# Other keywords are not currently supported by GeneCite for PubMed, therefore\n# the only valid value for this keyword is currently \"term\".  More keywords\n# may someday be added to GeneCite for use with PubMed, and other database\n# types may be added which use other keywords.\n# Example:\n# keywords = term\n\n# Default Keyword - default_keyword - This is the index of the keyword in the\n# Keyword List (see above) which you want to use as the default.  Any number\n# outside of the range from 1 to the number of entries in the Keyword List\n# will be ignored, and the default substituted.  Since there is currently\n# only one keyword in the list, the default is 1.\n# Example:\n# default_keyword = 1\n\n# Send Query Flag - send_query - This flag is used primarily in debugging,\n# and indicates whether to send the query to the database, or simply display\n# it in place of the citation count.  The default is true, causing queries\n# to be sent normally.\n# Example:\n# send_query = true\n\n# Query Options - query_options - This is a list of option strings which will\n# be inserted in all queries, including the ones in output file hyperlinks.\n# For PubMed, the default value is \"db=PubMed,cmd=search\", which specifically\n# selects PubMed from among several databases offered by NCBI, and requests\n# a citation search.  Further options may be added to this comma-delimited\n# list;  in actual queries, they are combined with ampersand '&' as part of\n# the HTTP POST command.  No spaces or other whitespace are allowed in the\n# value of this keyword.\n# Example:\n# query_options = db=PubMed,cmd=search\n\n# Hidden Query Options - hidden_query_options - This is a list of option\n# strings, just like the Query Options (see above), except that these are\n# used only in the initial query to create the citation counts, not in the\n# hyperlinks stored in the output files.  The options are generally ones used\n# to limit the database output as much as possible during the original search.\n# The default contains a single item, \"dispmax=1\", which, for PubMed, limits\n# the database response to one citation, while still returning the citation\n# count, which is all the program needs from the query.\n# Example:\n# hidden_query_options = dispmax=1\n\n# Pattern When No Citations Exist - no_citations_pattern - This value is a\n# regular expression used to diagnose when the database output contains no\n# citations (citation count will equal zero.)  For PubMed, the literal\n# \"No items found\" is present in all forms of database response when no\n# citations are found, whether because of an input error or simply lack of\n# citations.  It is possible that PubMed's output format may change in the\n# future, invalidating the current test for 'no citations'.  This pattern\n# would then need to be updated.\n# Example:\n# no_citations_pattern = No items found\n\n# Output When No Citations Exist - no_citations_output - This is the data\n# that you want to be placed in each citation count that would otherwise be\n# zero.  For instance, you could suppress the display of zeros by setting\n# this string to nothing:\n# no_citations_output=\n# Or, you could put in some other string, such as 'None', that you would\n# rather see.  For numeric manipulation of data, it is recommended that you\n# use:\n# no_citations_output=0\n# The default is to output a zero.\n# Example:\n#no_citations_output=0\n\n# Pattern For Citation Counts - citation_count_pattern - This is a regular\n# expression used to parse out the citation count from the database output.\n# For the current version of PubMed, the default is:\n# \" .*Item.* of (\\\\d+).* \".  This represents any number of any\n# type of characters - .* - followed by the word Item and another set of \n# any number of any type of characters - .* - then a space, \n# 'of', and a space, finally followed by a sequence of numbers\n# which is the citation count (therefore in parentheses), followed by any\n# number of other characters representing the rest of the document.  This\n# discussion is meant for those who have experience with regular expressions.\n# The only reason to change this value is if the PubMed output format were\n# to change in the future.  It should only be changed by an expert in\n# regular expressions, as an invalid value will prevent the recovery of the\n# citation counts.\n# Example:\n# citation_count_pattern = .*Item.* of (\\\\d+).*\n\n# Citation Default - citation_default - When there is only one matching\n# citation, unfortunately, the output returned by PubMed does not contain any\n# diagnostic phrase.  As a result, the Pattern For Citation Counts and the\n# Pattern When No Citations Exist both fail.  This value allows you to\n# specify what to do when that happens.  The default is to output a '1' (one).\n# Example:\n#citation_default = 1\n";

    public PubMedDatabasePropertiesFile() {
        super(PROPFILE, DEFAULTTEXT);
        this.getProperties();
    }

    private void getProperties() {
        this.urlName = this.getProperty(URLPROP, DEFAULTURL);
        try {
            URL url = new URL(this.urlName);
        }
        catch (MalformedURLException e) {
            this.urlName = DEFAULTURL;
        }
        String userLockPeriod = this.getProperty(LOCKPERIODPROP, "");
        try {
            this.lockPeriod = Integer.parseInt(userLockPeriod);
        }
        catch (NumberFormatException e) {
            this.lockPeriod = 2000;
        }
        PropertyListWithDefault userKeywordList = new PropertyListWithDefault(this, KEYWORDLISTPROP, DEFAULTKEYWORDLIST, DEFKEYWORDPROP, 1, ","){

            public boolean verifyListElement(String element) {
                return true;
            }
        };
        this.keywordList = userKeywordList.getObjectList();
        this.defaultKeyword = userKeywordList.getDefaultIndex();
        String userSendQuery = this.getProperty(SENDQUERYPROP, "");
        this.sendQuery = userSendQuery.equals("false") ? false : (userSendQuery.equals("true") ? true : true);
        PropertyListWithDefault userQueryOptionList = new PropertyListWithDefault(this, QUERYOPTIONSPROP, DEFAULTQUERYOPTIONS, "", 1, ","){

            public boolean verifyListElement(String element) {
                return true;
            }
        };
        this.queryOptionList = userQueryOptionList.getObjectList();
        PropertyListWithDefault userHiddenOptionList = new PropertyListWithDefault(this, HIDDENQUERYOPTIONSPROP, DEFAULTHIDDENQUERYOPTIONS, "", 1, ","){

            public boolean verifyListElement(String element) {
                return true;
            }
        };
        this.hiddenQueryOptionList = userHiddenOptionList.getObjectList();
        this.noCitationsPattern = this.getProperty(NOCITATIONSPATTERNPROP, DEFAULTNOCITATIONSPATTERN);
        this.noCitationsOutput = this.getProperty(NOCITATIONSOUTPUTPROP, DEFAULTNOCITATIONSOUTPUT);
        this.citationCountPattern = this.getProperty(CITATIONCOUNTPATTERNPROP, DEFAULTCITATIONCOUNTPATTERN);
        this.citationDefault = this.getProperty(CITATIONDEFAULTPROP, DEFAULTCITATIONDEFAULT);
    }

    public String getURLName() {
        return this.urlName;
    }

    public int getLockPeriod() {
        return this.lockPeriod;
    }

    public String[] getKeywordList() {
        return this.keywordList;
    }

    public int getDefaultKeyword() {
        return this.defaultKeyword;
    }

    public boolean getSendQuery() {
        return this.sendQuery;
    }

    public String[] getQueryOptionList() {
        return this.queryOptionList;
    }

    public String[] getHiddenQueryOptionList() {
        return this.hiddenQueryOptionList;
    }

    public String getNoCitationsPattern() {
        return this.noCitationsPattern;
    }

    public String getNoCitationsOutput() {
        return this.noCitationsOutput;
    }

    public String getCitationCountPattern() {
        return this.citationCountPattern;
    }

    public String getCitationDefault() {
        return this.citationDefault;
    }
}

