/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.BasicQueryGenerator;
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.QueryGenerator;
import com.syntek_usa.dbsearch.Result;
import com.syntek_usa.dbsearch.ResultSet;
import com.syntek_usa.dbsearch.ResultSetImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SelfCrossQueryGenerator
extends BasicQueryGenerator {
    public static final int NUMDIMS = 2;
    private Query[] storage;
    private ResultSet rs;

    public SelfCrossQueryGenerator(Query[] list) {
        super(new int[2], new String[2][]);
        this.dimensions[0] = this.dimensions[1] = list.length;
        this.headers[0] = new String[this.dimensions[0]];
        this.headers[1] = new String[this.dimensions[1]];
        for (int dim = 0; dim <= 1; ++dim) {
            for (int i = 0; i < list.length; ++i) {
                this.headers[dim][i] = ((Object)list[i]).toString();
            }
        }
        this.storage = list;
    }

    public Iterator iterator() {
        return new SelfCrossQueryIterator();
    }

    public Query generateQuery(int row, int col) {
        if (row == col) {
            return this.storage[row];
        }
        if (row > col) {
            return this.storage[row].group().and(this.storage[col].group());
        }
        if (this.rs == null) {
            throw new IllegalStateException();
        }
        return ((Result)this.rs.getValueAt(col, row)).getQuery();
    }

    public int totalElements() {
        int size = this.dimensions[0];
        return (size * size + size) / 2;
    }

    public ResultSet createResultSet() {
        this.rs = new SelfCrossResultSet(this);
        return this.rs;
    }

    protected class SelfCrossQueryIterator
    implements Iterator {
        private int row = 0;
        private int col = 0;

        public boolean hasNext() {
            return this.col < SelfCrossQueryGenerator.this.getDimension(1);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Query q = SelfCrossQueryGenerator.this.generateQuery(this.row, this.col);
            ++this.row;
            if (this.row >= SelfCrossQueryGenerator.this.getDimension(0)) {
                ++this.col;
                this.row = this.col;
            }
            return q;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class SelfCrossResultSet
    extends ResultSetImpl {
        public SelfCrossResultSet(QueryGenerator qg) {
            super(qg);
        }

        public void setValueAsVector(int index, Object newValue) {
            int rowwidth = super.getDimension(0);
            int col = 0;
            int sum = 0;
            int inc = rowwidth;
            while (index >= sum + inc) {
                sum += inc--;
                ++col;
            }
            int row = rowwidth - inc + (index - sum);
            super.setValueAsVector(col * rowwidth + row, newValue);
            super.setValueAsVector(row * rowwidth + col, newValue);
        }
    }
}

