/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.dbsearch;

import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.QueryGenerator;
import com.syntek_usa.dbsearch.ResultSet;
import com.syntek_usa.dbsearch.ResultSetImpl;
import com.syntek_usa.narray.BasicNArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BasicQueryGenerator
extends BasicNArray
implements QueryGenerator {
    public BasicQueryGenerator(int[] dimensions, String[][] headers) {
        super(dimensions, headers);
    }

    public Iterator iterator() {
        switch (this.numberOfDimensions()) {
            case 1: {
                return new OneDimQueryIterator();
            }
            case 2: {
                return new TwoDimQueryIterator();
            }
            case 3: {
                return new ThreeDimQueryIterator();
            }
        }
        return new MultiDimQueryIterator();
    }

    public Query generateQuery(int row) {
        throw new UnsupportedOperationException();
    }

    public Query generateQuery(int row, int col) {
        throw new UnsupportedOperationException();
    }

    public Query generateQuery(int row, int col, int o) {
        throw new UnsupportedOperationException();
    }

    public Query generateQuery(int[] indexes) {
        throw new UnsupportedOperationException();
    }

    public ResultSet createResultSet() {
        return new ResultSetImpl(this);
    }

    private class MultiDimQueryIterator
    implements Iterator {
        private int[] indexes;

        public MultiDimQueryIterator() {
            this.indexes = new int[BasicQueryGenerator.this.numberOfDimensions()];
        }

        public boolean hasNext() {
            return this.indexes[BasicQueryGenerator.this.numberOfDimensions() - 1] < BasicQueryGenerator.this.getDimension(BasicQueryGenerator.this.numberOfDimensions() - 1);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Query q = BasicQueryGenerator.this.generateQuery(this.indexes);
            this.indexes[0] = this.indexes[0] + 1;
            for (int i = 0; i < BasicQueryGenerator.this.numberOfDimensions() - 1 && this.indexes[i] == BasicQueryGenerator.this.getDimension(i); ++i) {
                this.indexes[i] = 0;
                int n = i + 1;
                this.indexes[n] = this.indexes[n] + 1;
            }
            return q;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ThreeDimQueryIterator
    implements Iterator {
        private int row = 0;
        private int col = 0;
        private int o;

        public boolean hasNext() {
            return this.col < BasicQueryGenerator.this.getDimension(1);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Query q = BasicQueryGenerator.this.generateQuery(this.row, this.col, this.o);
            ++this.row;
            if (this.row >= BasicQueryGenerator.this.getDimension(0)) {
                this.row = 0;
                ++this.col;
            }
            return q;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TwoDimQueryIterator
    implements Iterator {
        private int row = 0;
        private int col = 0;

        public boolean hasNext() {
            return this.col < BasicQueryGenerator.this.getDimension(1);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Query q = BasicQueryGenerator.this.generateQuery(this.row, this.col);
            ++this.row;
            if (this.row >= BasicQueryGenerator.this.getDimension(0)) {
                this.row = 0;
                ++this.col;
            }
            return q;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class OneDimQueryIterator
    implements Iterator {
        private int current = 0;

        public boolean hasNext() {
            return this.current < BasicQueryGenerator.this.getDimension(0);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return BasicQueryGenerator.this.generateQuery(this.current++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

