/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.dbsearch;

import com.syntek_usa.dbsearch.Database;
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.QueryGenerator;
import com.syntek_usa.dbsearch.Result;
import com.syntek_usa.dbsearch.ResultImpl;
import com.syntek_usa.dbsearch.ResultSet;
import com.syntek_usa.dbsearch.SearchEvent;
import com.syntek_usa.dbsearch.SearchListener;
import com.syntek_usa.dbsearch.SearchListenerList;
import com.syntek_usa.util.TimeOut;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Iterator;

public class Search
implements Runnable {
    private boolean running;
    private boolean completed;
    private boolean cancelled;
    private int timeoutMillis;
    private String invalidValue;
    private int queryNumber;
    private Query query;
    private Database db;
    private QueryGenerator qg;
    private ResultSet rs;
    private Thread myThread;
    private long startTime;
    private long elapsedTime;
    private SearchListenerList listeners = new SearchListenerList();

    public Search(int timeoutMillis, String invalidValue) {
        this.timeoutMillis = timeoutMillis;
        this.invalidValue = invalidValue;
        this.setRunning(false);
        this.setCompleted(false);
        this.setCancelled(false);
    }

    public void run() {
        if (this.db == null || this.qg == null || this.isRunning()) {
            throw new IllegalStateException();
        }
        this.setRunning(true);
        this.setCompleted(false);
        this.setCancelled(false);
        this.myThread = Thread.currentThread();
        this.startTime = System.currentTimeMillis();
        this.queryNumber = 0;
        this.rs = this.qg.createResultSet();
        Iterator q = this.qg.iterator();
        while (q.hasNext()) {
            if (this.isCancelled()) {
                return;
            }
            this.query = (Query)q.next();
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            this.fireSearchProgress();
            TimeOut timeout = new TimeOut(this.myThread, this.timeoutMillis);
            Result r = null;
            try {
                r = this.db.runQuery(this.query);
            }
            catch (InterruptedIOException iioe) {
            }
            catch (IOException ioe) {
                timeout.cancel();
                if (timeout != null && timeout.timedOut()) {
                    this.fireQueryTimedOut();
                } else {
                    this.fireQueryFailed("Query failed: " + ioe);
                }
                r = new ResultImpl(this.query, this.invalidValue);
            }
            timeout.cancel();
            this.rs.setValueAsVector(this.queryNumber, r);
            ++this.queryNumber;
        }
        this.rs.setLocked(true);
        this.setCompleted(true);
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        this.fireSearchCompleted();
        this.setRunning(false);
    }

    public ResultSet getResult() {
        if (!this.isCompleted()) {
            throw new IllegalStateException();
        }
        return this.rs;
    }

    public void cancel() {
        if (!this.isRunning()) {
            return;
        }
        this.setRunning(false);
        this.setCancelled(true);
        this.myThread.interrupt();
        this.fireSearchCancelled();
    }

    public int getQueryNumber() {
        return this.queryNumber + 1;
    }

    public int getTotalQueries() {
        if (this.qg == null) {
            throw new IllegalStateException();
        }
        return this.qg.totalElements();
    }

    public void setDB(Database db) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this.db = db;
    }

    public Database getDB() {
        return this.db;
    }

    public void setQG(QueryGenerator qg) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this.qg = qg;
    }

    public QueryGenerator getQG() {
        return this.qg;
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setCompleted(boolean completed) {
        this.completed = completed;
    }

    private synchronized boolean isCompleted() {
        return this.completed;
    }

    private synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getDescription() {
        return this.db.getDescription();
    }

    public String getBaseURL() {
        return this.db.getBaseURL();
    }

    public String getQueryURL(Query q) {
        return this.db.getQueryURL(q);
    }

    public void addSearchListener(SearchListener sl) {
        this.listeners.addSearchListener(sl);
    }

    public void removeSearchListener(SearchListener sl) {
        this.listeners.removeSearchListener(sl);
    }

    protected void fireQueryTimedOut() {
        this.listeners.fireQueryTimedOut(new SearchEvent(this, "Query timed out", this.getQueryNumber(), this.getTotalQueries()));
    }

    protected void fireQueryFailed(String message) {
        this.listeners.fireQueryFailed(new SearchEvent(this, message, this.getQueryNumber(), this.getTotalQueries()));
    }

    protected void fireSearchProgress() {
        this.listeners.fireSearchProgress(new SearchEvent(this, this.getQueryNumber(), this.getTotalQueries(), ((Object)this.query).toString()));
    }

    protected void fireSearchCompleted() {
        this.listeners.fireSearchCompleted(new SearchEvent(this, this.getQueryNumber(), this.getTotalQueries()));
    }

    protected void fireSearchCancelled() {
        this.listeners.fireSearchCancelled(new SearchEvent(this, "Search Cancelled", this.getQueryNumber(), this.getTotalQueries()));
    }
}

