/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.narray;

import com.syntek_usa.narray.NArray;

public class BasicNArray
implements NArray {
    protected int[] dimensions;
    protected String[][] headers;
    private int totalElements = -1;

    public BasicNArray(int[] dimensions, String[][] headers) {
        if (dimensions == null) {
            throw new IllegalArgumentException();
        }
        if (headers != null) {
            if (headers.length != dimensions.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < dimensions.length; ++i) {
                if (headers[i] == null || headers[i].length == dimensions[i]) continue;
                throw new IllegalArgumentException();
            }
        }
        this.dimensions = dimensions;
        this.headers = headers;
    }

    public int numberOfDimensions() {
        return this.dimensions.length;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getDimension(int dimension) {
        return this.dimensions[dimension];
    }

    public String[][] getAllHeaders() {
        return this.headers;
    }

    public String[] getHeaders(int dimension) {
        if (this.headers == null) {
            return null;
        }
        return this.headers[dimension];
    }

    public String getHeader(int dimension, int index) {
        if (this.headers == null) {
            return null;
        }
        return this.headers[dimension][index];
    }

    public int totalElements() {
        if (this.totalElements == -1) {
            this.totalElements = 1;
            for (int i = 0; i < this.numberOfDimensions(); ++i) {
                this.totalElements *= this.getDimension(i);
            }
        }
        return this.totalElements;
    }
}

