/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.util;

import com.syntek_usa.util.ObjectFactory;

public class BasicObjectFactory
implements ObjectFactory {
    private String[] objectNames;
    private int defaultIndex;

    public BasicObjectFactory(String[] objectNames, int defaultIndex) {
        if (objectNames == null || defaultIndex < 0 || defaultIndex >= objectNames.length) {
            throw new IllegalArgumentException();
        }
        this.objectNames = objectNames;
        this.defaultIndex = defaultIndex;
    }

    public static boolean verifyObjectName(String objectName) {
        try {
            Class.forName(objectName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object create(String objectName) throws IllegalArgumentException {
        int objectIndex = -1;
        for (int i = 0; i < this.objectNames.length; ++i) {
            if (!objectName.equals(this.objectNames[i])) continue;
            objectIndex = i;
            break;
        }
        if (objectIndex == -1) {
            throw new IllegalArgumentException();
        }
        if (BasicObjectFactory.verifyObjectName(objectName)) {
            try {
                Class<?> objClass = Class.forName(objectName);
                return objClass.newInstance();
            }
            catch (Exception e) {
                System.out.println("Internal error: BasicObjectFactory create ( " + objectName + ") threw exception " + e);
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public String[] getObjectList() {
        return this.objectNames;
    }

    public String getDefaultObject() {
        return this.objectNames[this.defaultIndex];
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }
}

