/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Database;
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.Result;
import com.syntek_usa.dbsearch.ResultImpl;
import com.syntek_usa.util.TimeLock;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class uniSTSDatabase
implements Database {
    private String urlName;
    private int lockPeriod;
    private String[] keywordList;
    private int defaultKeyword;
    private boolean sendQuery;
    private String[] queryOptionList;
    private String[] hiddenQueryOptionList;
    private String noCitationsPattern;
    private String noCitationsOutput;
    private String citationCountPattern;
    private String citationDefault;
    private TimeLock timeLock;
    private URL url;

    public uniSTSDatabase() {
        uniSTSDatabasePropertiesFile p = new uniSTSDatabasePropertiesFile();
        this.urlName = p.getURLName();
        this.lockPeriod = p.getLockPeriod();
        this.keywordList = p.getKeywordList();
        this.defaultKeyword = p.getDefaultKeyword();
        this.sendQuery = p.getSendQuery();
        this.queryOptionList = p.getQueryOptionList();
        this.hiddenQueryOptionList = p.getHiddenQueryOptionList();
        this.noCitationsPattern = p.getNoCitationsPattern();
        this.noCitationsOutput = p.getNoCitationsOutput();
        this.citationCountPattern = p.getCitationCountPattern();
        this.citationDefault = p.getCitationDefault();
        try {
            this.url = new URL(this.urlName);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.timeLock = new TimeLock(0);
    }

    public Object[] getKeywords() {
        return this.keywordList;
    }

    public Object getDefaultKeyword() {
        return this.keywordList[this.defaultKeyword];
    }

    public int getDefaultKeywordIndex() {
        return this.defaultKeyword;
    }

    public Result runQuery(Query q) throws IOException {
        ResultImpl r;
        try {
            this.timeLock.waitForLock();
        }
        catch (InterruptedException ie) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.bytesTransferred = 0;
            throw ioe;
        }
        String rawQuery = this.getQueryParams(q, this.hiddenQueryOptionList);
        if (this.sendQuery) {
            String line;
            URLConnection connection = this.url.openConnection();
            connection.setDoOutput(true);
            PrintWriter out = new PrintWriter(connection.getOutputStream());
            out.println(rawQuery);
            out.flush();
            out.close();
            String result = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
            br.close();
            r = new ResultImpl(q, this.getCitationCount(result));
        } else {
            r = new ResultImpl(q, rawQuery);
        }
        this.timeLock = new TimeLock(this.lockPeriod);
        return r;
    }

    private String getQueryParams(Query q, String[] hiddenOptionList) {
        String qstr = ((Object)q).toString();
        String params = "";
        try {
            int i;
            for (i = 0; i < this.queryOptionList.length; ++i) {
                params = params + this.queryOptionList[i] + "&";
            }
            for (i = 0; i < hiddenOptionList.length; ++i) {
                params = params + hiddenOptionList[i] + "&";
            }
            params = params + URLEncoder.encode(qstr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return params.replaceAll("%3D", "=");
    }

    public String getBaseURL() {
        return this.urlName;
    }

    public String getQueryURL(Query q) {
        return "?" + this.getQueryParams(q, new String[0]);
    }

    public String getDescription() {
        return "Search performed by the U.S. National Library of Medicine's uniSTS database.  See their <a href=\"http://www.ncbi.nlm.nih.gov/About/disclaimer.html.\">disclaimer and copyright notice.</a>";
    }

    private String getCitationCount(String page) {
        if (page.indexOf(this.noCitationsPattern) >= 0) {
            return this.noCitationsOutput;
        }
        Pattern p = Pattern.compile(this.citationCountPattern);
        Matcher m = p.matcher(page);
        if (m.matches()) {
            return m.group(1);
        }
        return this.citationDefault;
    }
}

