/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Result;
import com.syntek_usa.dbsearch.ResultFormatter;
import com.syntek_usa.dbsearch.ResultSet;
import com.syntek_usa.dbsearch.Search;
import com.syntek_usa.util.ExtensionFileFilter;
import com.syntek_usa.util.GenericApplication;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.filechooser.FileFilter;

public class CSVCountFormatter
implements ResultFormatter {
    private static final String EXT = "csv";
    private static final String DESC = "CSV Files with Counts";
    private static final String BASE = "counts";
    private static final FileFilter filter = new ExtensionFileFilter("csv", "CSV Files with Counts");
    private static String QUOTE = "\"";
    private GenericApplication app;
    private Search s;
    private PrintWriter w;
    private ResultSet rs;
    private int numberOfColumns;

    public FileFilter getFileFilter() {
        return filter;
    }

    public String getBaseFileName() {
        return BASE;
    }

    public void setApp(GenericApplication app) {
        this.app = app;
    }

    public void setSearch(Search s) {
        this.s = s;
    }

    public void format(OutputStream os) throws IOException {
        if (this.app == null || this.s == null) {
            throw new IllegalStateException();
        }
        this.w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.rs = this.s.getResult();
        this.outputHead();
        this.outputBody();
        this.w.close();
    }

    private void outputHead() {
        int col;
        this.numberOfColumns = this.rs.numberOfDimensions() == 1 ? 1 : this.rs.getDimension(1);
        this.w.print(this.app.getTitle() + " by " + this.app.getCompany() + ": Citation Results (counts only).  ");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = format.format(new Date(this.s.getStartTime()));
        this.w.print(startTime + "," + QUOTE + this.s.getBaseURL() + QUOTE + ",");
        if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
            this.w.print("#1,");
        } else {
            for (col = 0; col < this.numberOfColumns; ++col) {
                this.w.print("#" + (col + 1) + ",");
            }
        }
        this.w.println();
        this.w.print(" ,Terms:,");
        if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
            this.w.print("Counts,");
        } else {
            for (col = 0; col < this.numberOfColumns; ++col) {
                this.w.print(QUOTE + "(" + this.rs.getHeader(1, col) + QUOTE + "),");
            }
        }
        this.w.println();
    }

    private void outputBody() {
        for (int row = 0; row < this.rs.getDimension(0); ++row) {
            this.outputRowHeader(row);
            if (this.numberOfColumns == 1 && this.rs.numberOfDimensions() == 1) {
                this.outputDataItem((Result)this.rs.getValueAt(row));
            } else {
                for (int col = 0; col < this.numberOfColumns; ++col) {
                    this.outputDataItem((Result)this.rs.getValueAt(row, col));
                }
            }
            this.w.println();
        }
    }

    private void outputRowHeader(int row) {
        this.w.print("#" + (row + 1) + "," + QUOTE + "(" + this.rs.getHeader(0, row) + ")" + QUOTE + ",");
    }

    private void outputDataItem(Result value) {
        String str = ((Object)value).toString();
        this.w.print((str.equals("") ? "0" : str) + ",");
    }
}

