/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.QueryImpl;
import com.syntek_usa.dbsearch.ResultFormatter;
import com.syntek_usa.dbsearch.Search;
import com.syntek_usa.util.ExtensionFileFilter;
import com.syntek_usa.util.GenericApplication;
import com.syntek_usa.util.ObjectFactory;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class GeneCite
extends GenericApplication {
    private static final String TITLE = "GeneCite";
    private static final String VERSION = "3.0";
    private static final String COPYRIGHT = "";
    public static final int ONEDIMSEARCHFILE1 = 0;
    public static final int ONEDIMSEARCHFILE2 = 1;
    public static final int SELFCROSSSEARCH = 2;
    public static final int ANDSEARCH = 3;
    public static final int ORSEARCH = 4;
    public static final int NOTSEARCH = 5;
    public static final int ONEDIMSEARCHFILE1_OPTS = 6;
    public static final int ONEDIMSEARCHFILE2_OPTS = 7;
    public static final int SELFCROSSSEARCH_OPTS = 8;
    public static final int ANDSEARCH_OPTS = 9;
    public static final int ORSEARCH_OPTS = 10;
    public static final int NOTSEARCH_OPTS = 11;
    public static final int ONEDIMSEARCHOPTS = 12;
    public static final int MAXSEARCH = 13;
    public static final int DEFAULTSEARCHTYPE = 3;
    public static final String ONEDIMSEARCHSTR = "ONEDIM";
    public static final String SELFSEARCHSTR = "SELF";
    public static final String ANDSEARCHSTR = "AND";
    public static final String ORSEARCHSTR = "OR";
    public static final String NOTSEARCHSTR = "NOT";
    public static final String ONEDIMSEARCHSTR_OPTS = "ONEDIM_OPTS";
    public static final String SELFSEARCHSTR_OPTS = "SELF_OPTS";
    public static final String ANDSEARCHSTR_OPTS = "AND_OPTS";
    public static final String ORSEARCHSTR_OPTS = "OR_OPTS";
    public static final String NOTSEARCHSTR_OPTS = "NOT_OPTS";
    public String baseDir;
    public String inputFile1;
    public String inputFile2;
    public String outputFile;
    public int searchType;
    protected int queryTimeout;
    protected String invalidValue;
    public boolean autoFormat;
    public String[] autoFormatList;
    protected ObjectFactory databaseFactory;
    protected ObjectFactory formatterFactory;
    public Search search;
    private static JMenuItem item;
    private GeneCiteFilePanel_opts opts;

    public static void main(String[] args) {
        String s = null;
        String f1 = null;
        String f2 = null;
        String iconfilename = "icon.img";
        try {
            s = args[0];
            f1 = args[1];
            f2 = args[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        GeneCite app = new GeneCite(s, f1, f2);
        GeneCiteFrame gui = new GeneCiteFrame(app);
        gui.setDefaultCloseOperation(3);
        gui.setTitle("GeneCite 3.0");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(TITLE);
        menuBar.add(menu);
        item = new JMenuItem("About");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object e = evt.getSource();
                if (e == item) {
                    GeneCite.about();
                }
            }
        });
        menu.add(item);
        gui.setJMenuBar(menuBar);
        File iconfile = new File(iconfilename);
        if (iconfile.exists()) {
            gui.setIconImage(Toolkit.getDefaultToolkit().createImage(iconfilename));
        }
        gui.pack();
        gui.show();
    }

    private GeneCite(String searchType, String file1, String file2) {
        super(TITLE, VERSION, COPYRIGHT);
        GeneCitePropertiesFile p = new GeneCitePropertiesFile();
        this.baseDir = p.getBaseDir();
        this.inputFile1 = p.getInputFile1();
        this.inputFile2 = p.getInputFile2();
        this.outputFile = p.getOutputFile();
        this.searchType = p.getSearchType();
        this.queryTimeout = p.getQueryTimeout();
        this.invalidValue = p.getInvalidValue();
        this.autoFormat = p.getAutoFormat();
        this.autoFormatList = p.getAutoFormatList();
        this.search = new Search(this.queryTimeout, this.invalidValue);
        this.databaseFactory = new DatabaseFactory(p.getDatabaseList(), p.getDefaultDatabase());
        this.formatterFactory = new FormatterFactory(p.getFormatterList(), p.getDefaultFormatter(), this, this.search);
        if (searchType != null) {
            this.searchType = GeneCite.interpretSearchStr(searchType);
        }
        if (file1 != null) {
            this.inputFile1 = GeneCite.checkFile(file1, this.baseDir, this.inputFile1);
        }
        if (file2 != null) {
            this.inputFile2 = GeneCite.checkFile(file2, this.baseDir, this.inputFile2);
        }
        File f1 = new File(this.inputFile1);
        File f2 = new File(this.inputFile2);
        File f1parent = f1.getParentFile();
        File f2parent = f2.getParentFile();
        if (f1parent != null && f2parent != null && f1parent.equals(f2parent)) {
            this.baseDir = f1parent.getAbsolutePath();
        }
    }

    public static String checkDirectory(String dirName, String defaultBase, String defaultDir) {
        String errorReturn;
        String string = errorReturn = defaultDir != null ? defaultDir : defaultBase;
        if (dirName == null) {
            return errorReturn;
        }
        File dir = new File(dirName);
        if (!dir.isAbsolute() && defaultBase != null) {
            dir = new File(defaultBase, dirName);
        }
        if (!dir.isDirectory()) {
            return errorReturn;
        }
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException e) {
            return errorReturn;
        }
    }

    public static String checkFile(String fileName, String defaultBase, String defaultFile) {
        File parentDir;
        File file;
        String errorReturn;
        String string = errorReturn = defaultFile != null ? defaultFile : defaultBase;
        if (fileName == null) {
            fileName = errorReturn;
        }
        if (!(file = new File(fileName)).isAbsolute() && defaultBase != null) {
            file = new File(defaultBase, fileName);
        }
        if (file.isDirectory()) {
            return errorReturn;
        }
        if (!(file.isFile() || (parentDir = file.getParentFile()) != null && parentDir.isDirectory())) {
            return errorReturn;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return errorReturn;
        }
    }

    public String loadQueryFile(String fileName) throws IOException {
        String line;
        File file = new File(fileName);
        String text = new String();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            text = text + line + "\n";
        }
        return text;
    }

    public void saveQueryFile(String fileName, String text) throws IOException {
        File file = new File(fileName);
        PrintWriter printer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        StringTokenizer linest = new StringTokenizer(text, "\n");
        while (linest.hasMoreTokens()) {
            printer.println(linest.nextToken());
        }
        printer.close();
    }

    public Query[] getQueries(Object keyword, String text) {
        Vector<QueryImpl> qs = new Vector<QueryImpl>();
        StringTokenizer linest = new StringTokenizer(text, "\n");
        while (linest.hasMoreTokens()) {
            String line = linest.nextToken();
            if (line.indexOf("(") != -1 || line.indexOf(")") != -1) {
                throw new IllegalArgumentException();
            }
            line = line.trim();
            Query q = null;
            StringTokenizer st = new StringTokenizer(line, ";\t\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (q == null) {
                    q = new QueryImpl(keyword, token);
                    continue;
                }
                q = q.or(new QueryImpl(keyword, token));
            }
            if (q == null) continue;
            qs.add((QueryImpl)q);
        }
        return qs.toArray(new Query[0]);
    }

    public void saveResultsFile(String fileName, ResultFormatter formatter) throws IOException {
        File file = new File(fileName);
        FileOutputStream is = new FileOutputStream(fileName);
        formatter.format(is);
        ((OutputStream)is).close();
    }

    public void doAutoFormat() throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.autoFormatList.length; ++i) {
            ResultFormatter formatter = (ResultFormatter)this.formatterFactory.create(this.autoFormatList[i]);
            String filename = this.baseDir + File.separator + formatter.getBaseFileName() + "_" + GeneCite.formatDate(this.search.getStartTime()) + "." + ((ExtensionFileFilter)formatter.getFileFilter()).getExtension();
            filename = GeneCite.checkFile(filename, this.baseDir, this.outputFile);
            try {
                this.saveResultsFile(filename, formatter);
                continue;
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static String formatDate(long dateMillis) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        return format.format(new Date(dateMillis));
    }

    public static int interpretSearchStr(String str) {
        if ((str = str.toUpperCase()).equals(ONEDIMSEARCHSTR)) {
            return 0;
        }
        if (str.equals(SELFSEARCHSTR)) {
            return 2;
        }
        if (str.equals(ANDSEARCHSTR)) {
            return 3;
        }
        if (str.equals(ORSEARCHSTR)) {
            return 4;
        }
        if (str.equals(NOTSEARCHSTR)) {
            return 5;
        }
        if (str.equals(ONEDIMSEARCHSTR_OPTS)) {
            return 6;
        }
        if (str.equals(SELFSEARCHSTR_OPTS)) {
            return 8;
        }
        if (str.equals(ANDSEARCHSTR_OPTS)) {
            return 9;
        }
        if (str.equals(ORSEARCHSTR_OPTS)) {
            return 10;
        }
        if (str.equals(NOTSEARCHSTR_OPTS)) {
            return 11;
        }
        return 3;
    }

    public void changeQueries(Query[] queries1, Query[] queries2, Query[] queries3) {
        switch (this.searchType) {
            case 0: {
                this.search.setQG(new ListQueryGenerator(queries1));
                break;
            }
            case 1: {
                this.search.setQG(new ListQueryGenerator(queries2));
                break;
            }
            case 2: {
                this.search.setQG(new SelfCrossQueryGenerator(queries1));
                break;
            }
            case 3: {
                this.search.setQG(new PairwiseQueryGenerator_and(queries1, queries2));
                break;
            }
            case 4: {
                this.search.setQG(new PairwiseQueryGenerator_or(queries1, queries2));
                break;
            }
            case 5: {
                this.search.setQG(new PairwiseQueryGenerator_not(queries1, queries2));
                break;
            }
            case 6: {
                this.search.setQG(new ListQueryGenerator_opts(queries1, queries3));
                break;
            }
            case 7: {
                this.search.setQG(new ListQueryGenerator_opts(queries2, queries3));
                break;
            }
            case 9: {
                this.search.setQG(new PairwiseQueryGenerator_and_opts(queries1, queries2, queries3));
                break;
            }
            case 10: {
                this.search.setQG(new PairwiseQueryGenerator_or_opts(queries1, queries2, queries3));
                break;
            }
            case 11: {
                this.search.setQG(new PairwiseQueryGenerator_not_opts(queries1, queries2, queries3));
                break;
            }
            case 12: {
                this.search.setQG(new ListQueryGenerator(queries3));
            }
        }
    }

    public String toString() {
        String s = "GeneCite:\n";
        s = s + "baseDir " + this.baseDir + "\n";
        s = s + "inputFile1 " + this.inputFile1 + "\n";
        s = s + "inputFile2 " + this.inputFile2 + "\n";
        s = s + "outputFile " + this.outputFile + "\n";
        s = s + "searchType " + this.searchType + "\n";
        s = s + "queryTimeout " + this.queryTimeout + "\n";
        s = s + "invalidValue " + this.invalidValue + "\n";
        s = s + "autoFormat " + this.autoFormat + "\n";
        s = s + "autoFormatList:\n";
        for (int i = 0; i < this.autoFormatList.length; ++i) {
            s = s + "[" + i + "] " + this.autoFormatList[i] + "\n";
        }
        return s;
    }

    public ObjectFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public ObjectFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    private static Action about() {
        JFrame frame = new JFrame();
        JOptionPane.showMessageDialog(frame, "GeneCite 3.0\nCreated by Walter Reed Army Institute of Research\nCopywrite is released as Open Sourse to BioSPICE.org", "GeneCite 3.0", -1);
        return null;
    }
}

