/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.util.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GeneCiteFilePanel
extends JPanel
implements ActionListener,
DocumentListener {
    public String pathwayData;
    private GeneCiteFrame parent;
    private JLabel titleLabel;
    private JTextField nameLabel;
    private JButton browseButton;
    private JButton saveButton;
    public JTextArea editor;
    private JLabel itemsLabel;
    private String currentDir;
    private boolean editorModified;
    private JFileChooser chooser;
    private File currentFile;

    public GeneCiteFilePanel() {
    }

    public GeneCiteFilePanel(GeneCiteFrame parent, String title) {
        this.parent = parent;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.titleLabel = new JLabel(title);
        this.add(this.titleLabel);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BorderLayout());
        editPanel.setAlignmentX(0.0f);
        this.add(editPanel);
        JPanel namePanel = new JPanel();
        editPanel.add((Component)namePanel, "North");
        namePanel.setLayout(new BorderLayout());
        this.nameLabel = new JTextField();
        this.nameLabel.setEditable(false);
        JScrollPane sp = new JScrollPane(this.nameLabel);
        sp.setHorizontalScrollBarPolicy(32);
        namePanel.add((Component)sp, "Center");
        JPanel buttonPanel = new JPanel();
        namePanel.add((Component)buttonPanel, "East");
        buttonPanel.setLayout(new GridLayout(0, 1));
        this.browseButton = new JButton("Browse");
        buttonPanel.add(this.browseButton);
        this.saveButton = new JButton("Save");
        buttonPanel.add(this.saveButton);
        this.editor = new JTextArea();
        this.editor.setColumns(15);
        editPanel.add((Component)new JScrollPane(this.editor), "Center");
        this.itemsLabel = new JLabel();
        this.add(this.itemsLabel);
        this.browseButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.editor.getDocument().addDocumentListener(this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.titleLabel.setEnabled(enabled);
        this.nameLabel.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.saveButton.setEnabled(enabled && this.isEditorModified());
        this.editor.setEnabled(enabled);
        this.itemsLabel.setEnabled(enabled);
    }

    public boolean loadFile(String filename) {
        String nameText;
        if (!this.parent.checkQueryFile(filename)) {
            return false;
        }
        File queryFile = new File(filename);
        try {
            nameText = queryFile.getCanonicalPath();
            this.editor.setText(this.parent.getApp().loadQueryFile(filename));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, e, "Error Reading File", 0);
            return false;
        }
        this.currentFile = queryFile;
        this.currentDir = queryFile.getParent();
        this.nameLabel.setText(nameText);
        this.editorModified = false;
        this.setEnabled(this.isEnabled());
        this.updateNumberOfItems();
        return true;
    }

    private boolean saveFile(String filename) {
        String nameText;
        if (!this.parent.checkOutputFile(filename)) {
            return false;
        }
        File queryFile = new File(filename);
        try {
            nameText = queryFile.getCanonicalPath();
            this.parent.getApp().saveQueryFile(filename, this.editor.getText());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, e, "Error Writing File", 0);
            return false;
        }
        this.currentFile = queryFile;
        this.currentDir = queryFile.getParent();
        this.nameLabel.setText(nameText);
        this.editorModified = false;
        this.setEnabled(this.isEnabled());
        return true;
    }

    public int getNumberOfItems() {
        return this.editor.getLineCount() - 1;
    }

    private void updateNumberOfItems() {
        this.itemsLabel.setText("Number of items: " + this.getNumberOfItems());
        this.parent.changeQueries();
    }

    private void browse() {
        if (this.currentDir == null) {
            this.currentDir = this.parent.getApp().baseDir;
        }
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileFilter(new ExtensionFileFilter("txt", "Text files for GeneCite"));
        }
        this.chooser.setCurrentDirectory(new File(this.currentDir));
        if (this.currentFile != null) {
            this.chooser.setSelectedFile(this.currentFile);
        }
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            this.loadFile(this.chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void save() {
        if (this.currentDir == null) {
            this.currentDir = this.parent.getApp().baseDir;
        }
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileFilter(new ExtensionFileFilter("txt", "Text files for GeneCite"));
        }
        this.chooser.setCurrentDirectory(new File(this.currentDir));
        if (this.currentFile != null) {
            this.chooser.setSelectedFile(this.currentFile);
        }
        if (this.chooser.showSaveDialog(this.parent) == 0) {
            this.saveFile(this.chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.browseButton) {
            this.browse();
        } else if (s == this.saveButton) {
            this.save();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    private void editorChanged() {
        this.editorModified = true;
        this.setEnabled(this.isEnabled());
        this.updateNumberOfItems();
    }

    public boolean isEditorModified() {
        return this.editorModified;
    }

    public Query[] getQueries(Object keyword) {
        try {
            return this.parent.getApp().getQueries(keyword, this.editor.getText());
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this.parent, "Input files may not contain parentheses ( " + this.titleLabel.getText() + ").\n" + "Please correct and try again.", "Error in Input File Format", 0);
            throw e;
        }
    }

    public void havePathwayData() {
    }
}

