/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Query;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GeneCiteFilePanel_opts
extends JPanel
implements ActionListener,
DocumentListener {
    private GeneCiteFrame parent;
    private JLabel titleLabel;
    private JTextField nameLabel;
    private JButton dpButton;
    private JButton auButton;
    private JButton jourButton;
    private JButton organismButton;
    private JButton moreButton;
    private JButton tipButton;
    public JTextField editor;
    private JLabel itemsLabel;
    private boolean editorModified;

    public GeneCiteFilePanel_opts(GeneCiteFrame parent, String title) {
        this.parent = parent;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.titleLabel = new JLabel(title);
        this.add(this.titleLabel);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BorderLayout());
        editPanel.setAlignmentX(0.0f);
        this.add(editPanel);
        JPanel namePanel = new JPanel();
        editPanel.add((Component)namePanel, "North");
        namePanel.setLayout(new BorderLayout());
        this.nameLabel = new JTextField();
        this.nameLabel.setEditable(false);
        JScrollPane sp = new JScrollPane(this.nameLabel);
        sp.setHorizontalScrollBarPolicy(32);
        namePanel.add((Component)sp, "Center");
        JPanel OptsPanel = new JPanel();
        editPanel.add((Component)OptsPanel, "North");
        OptsPanel.setLayout(new BorderLayout());
        JPanel optsbtnPanel = new JPanel();
        OptsPanel.add((Component)optsbtnPanel, "South");
        this.dpButton = new JButton("Date of Publish");
        optsbtnPanel.add(this.dpButton);
        this.auButton = new JButton("Author");
        optsbtnPanel.add(this.auButton);
        this.jourButton = new JButton("Journal");
        optsbtnPanel.add(this.jourButton);
        this.organismButton = new JButton("Model");
        optsbtnPanel.add(this.organismButton);
        this.moreButton = new JButton("More");
        optsbtnPanel.add(this.moreButton);
        this.tipButton = new JButton("Search Tip");
        optsbtnPanel.add(this.tipButton);
        OptsPanel.add((Component)optsbtnPanel, "South");
        this.editor = new JTextField();
        this.editor.setColumns(15);
        editPanel.add((Component)new JScrollPane(this.editor), "Center");
        this.itemsLabel = new JLabel();
        this.add(this.itemsLabel);
        this.dpButton.addActionListener(this);
        this.auButton.addActionListener(this);
        this.jourButton.addActionListener(this);
        this.moreButton.addActionListener(this);
        this.organismButton.addActionListener(this);
        this.tipButton.addActionListener(this);
        this.editor.getDocument().addDocumentListener(this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.titleLabel.setEnabled(enabled);
        this.nameLabel.setEnabled(enabled);
        this.dpButton.setEnabled(enabled);
        this.auButton.setEnabled(enabled);
        this.jourButton.setEnabled(enabled);
        this.moreButton.setEnabled(enabled);
        this.organismButton.setEnabled(enabled);
        this.tipButton.setEnabled(enabled);
        this.editor.setEnabled(enabled);
    }

    public boolean loadFile(String filename) {
        String nameText;
        if (!this.parent.checkQueryFile(filename)) {
            return false;
        }
        File queryFile = new File(filename);
        try {
            nameText = queryFile.getCanonicalPath();
            this.editor.setText(this.parent.getApp().loadQueryFile(filename));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, e, "Error Reading File", 0);
            return false;
        }
        this.nameLabel.setText(nameText);
        this.editorModified = false;
        this.setEnabled(this.isEnabled());
        this.updateNumberOfItems();
        return true;
    }

    public int getNumberOfItems() {
        return 1;
    }

    private void updateNumberOfItems() {
    }

    private void dp() {
        this.editor.setText(this.editor.getText() + " [dp]");
    }

    private void au() {
        this.editor.setText(this.editor.getText() + " [au]");
    }

    private void jour() {
        this.editor.setText(this.editor.getText() + " [jour]");
    }

    private void organism() {
        this.editor.setText(this.editor.getText() + " [organism]");
    }

    private void more() {
        this.editor.setText(this.editor.getText() + " AND ");
    }

    public void clear() {
        this.editor.setText("");
    }

    public void populate() {
        this.editor.setText("2001:2005[dp]");
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.dpButton) {
            this.dp();
        } else if (s == this.jourButton) {
            this.jour();
        } else if (s == this.auButton) {
            this.au();
        } else if (s == this.organismButton) {
            this.organism();
        } else if (s == this.moreButton) {
            this.more();
        } else if (s == this.tipButton) {
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, "Searching by date:\n Example 2000:2005 [dp]\n\nSearch by data and author:\nExample 2000:2005 [dp]Joshua Lederberg[au]\n\nSearch by data, author and journal:\n2000:2005 [dp]Joshua Lederberg[au]Science[jour]\n\nMore detailed search tips at: \nhttp://www.ncbi.nlm.nih.gov/books/bv.fcgi?rid=helppubmed.section.pubmedhelp.Searching_PubMed");
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.editorChanged();
    }

    private void editorChanged() {
        this.editorModified = true;
        this.setEnabled(this.isEnabled());
        this.updateNumberOfItems();
    }

    public boolean isEditorModified() {
        return this.editorModified;
    }

    public Query[] getQueries(Object keyword) {
        try {
            return this.parent.getApp().getQueries(keyword, this.editor.getText());
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this.parent, "Input files may not contain parentheses ( " + this.titleLabel.getText() + ").\n" + "Please correct and try again.", "Error in Input File Format", 0);
            throw e;
        }
    }
}

