/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.dbsearch.Database;
import com.syntek_usa.dbsearch.Query;
import com.syntek_usa.dbsearch.SearchEvent;
import com.syntek_usa.dbsearch.SearchListener;
import com.syntek_usa.util.ObjectFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneCiteFrame
extends JFrame
implements ActionListener,
ItemListener,
SearchListener {
    public static final long MILLISPERSECOND = 1000L;
    public static final long SECONDSPERMINUTE = 60L;
    private static final long DEFAULTQUERYTIME = 7000L;
    private GeneCite app;
    private JLabel databaseLabel;
    private JComboBox databaseListBox;
    private JLabel keywordLabel;
    private JComboBox keywordListBox;
    private JLabel optstext;
    private JLabel oneDLabel;
    private JRadioButton oneDimFile1;
    private JRadioButton oneDimFile2;
    private JLabel twoDLabel;
    private JRadioButton selfCross;
    private JRadioButton and;
    private JRadioButton or;
    private JRadioButton not;
    private JRadioButton oneDimFile1_opts;
    private JRadioButton oneDimFile2_opts;
    private JRadioButton and_opts;
    private JRadioButton or_opts;
    private JRadioButton not_opts;
    private JRadioButton opts;
    public JButton PS_search;
    private JLabel searchSize;
    private JRadioButton LID;
    private JRadioButton GID;
    private JButton startButton;
    private JButton cancelButton;
    private GeneCiteFilePanel leftPanel;
    private GeneCiteFilePanel rightPanel;
    private GeneCiteFilePanel_opts optsPanel;
    private JTabbedPane tabbedPane;
    private JProgressBar progressBar;
    private JLabel timeRemainingLabel;
    private JLabel statusLabel;
    private GeneCiteResultsFrame results;
    private Thread s;

    public GeneCiteFrame(GeneCite app) {
        this.app = app;
        Container cp = this.getContentPane();
        ((JComponent)cp).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel topPanel = app.getIdPanel(null);
        cp.add((Component)topPanel, "North");
        JPanel triplePanel = new JPanel();
        cp.add((Component)triplePanel, "Center");
        Box progressPanel = Box.createVerticalBox();
        cp.add((Component)progressPanel, "South");
        progressPanel.add(Box.createVerticalGlue());
        Box optionsBox = Box.createVerticalBox();
        optionsBox.setAlignmentX(0.0f);
        Dimension max_opt = topPanel.getMaximumSize();
        Dimension min_opt = topPanel.getMinimumSize();
        Dimension desired_opt = new Dimension(max_opt.width, 75);
        optionsBox.setMaximumSize(desired_opt);
        progressPanel.add(optionsBox);
        this.optsPanel = new GeneCiteFilePanel_opts(this, "Additonal Options");
        this.optsPanel.setEnabled(false);
        optionsBox.add(this.optsPanel);
        this.timeRemainingLabel = new JLabel(" ");
        progressPanel.add(this.timeRemainingLabel);
        this.progressBar = new JProgressBar();
        progressPanel.add(this.progressBar);
        JPanel statusPanel = new JPanel();
        progressPanel.add(statusPanel);
        this.statusLabel = new JLabel(" ");
        statusPanel.add(this.statusLabel);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(0));
        ((FlowLayout)statusPanel.getLayout()).setAlignment(0);
        statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        statusPanel.setAlignmentX(0.0f);
        this.progressBar.setAlignmentX(0.0f);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorderPainted(true);
        progressPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        triplePanel.setLayout(new BoxLayout(triplePanel, 0));
        this.leftPanel = new GeneCiteFilePanel(this, "File 1:");
        triplePanel.add(this.leftPanel);
        JPanel centerPanel = new JPanel();
        triplePanel.add(centerPanel);
        this.rightPanel = new GeneCiteFilePanel(this, "File 2:");
        triplePanel.add(this.rightPanel);
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        centerPanel.add(Box.createVerticalGlue());
        this.databaseLabel = new JLabel("Database");
        centerPanel.add(this.databaseLabel);
        ObjectFactory dbfactory = app.getDatabaseFactory();
        this.databaseListBox = new JComboBox<String>(dbfactory.getObjectList());
        this.databaseListBox.setAlignmentX(0.0f);
        Dimension max = this.databaseListBox.getMaximumSize();
        Dimension min = this.databaseListBox.getMinimumSize();
        Dimension desired = new Dimension(max.width, min.height);
        this.databaseListBox.setMaximumSize(desired);
        centerPanel.add(this.databaseListBox);
        centerPanel.add(Box.createVerticalStrut(8));
        this.keywordLabel = new JLabel("Keyword");
        this.keywordLabel.setVisible(false);
        centerPanel.add(this.keywordLabel);
        this.keywordListBox = new JComboBox();
        this.keywordListBox.setAlignmentX(0.0f);
        this.keywordListBox.setMaximumSize(this.databaseListBox.getMaximumSize());
        this.keywordListBox.setVisible(false);
        centerPanel.add(this.keywordListBox);
        this.optstext = new JLabel("Database Options Panel");
        this.optstext.setAlignmentX(0.0f);
        centerPanel.add(this.optstext);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setAlignmentX(0.0f);
        JComponent panel1 = this.options_E();
        this.tabbedPane.addTab("Enabled", null, panel1, "Additional Options Enabled");
        this.tabbedPane.setMnemonicAt(0, 69);
        JComponent panel2 = this.options_D();
        this.tabbedPane.addTab("Disabled", null, panel2, "Additional Options Disabled");
        this.tabbedPane.setMnemonicAt(1, 68);
        JComponent panel3 = this.options_D_PS();
        this.tabbedPane.addTab("Pathway Screen", null, panel3, "PathwayScreen");
        this.tabbedPane.setMnemonicAt(2, 80);
        this.tabbedPane.setEnabledAt(2, false);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                if (sel == 0) {
                    GeneCiteFrame.this.enabled();
                } else if (sel == 1) {
                    GeneCiteFrame.this.disabled();
                } else if (sel == 2) {
                    GeneCiteFrame.this.disabled();
                }
            }
        });
        centerPanel.add(this.tabbedPane);
        centerPanel.add(Box.createVerticalGlue());
        this.searchSize = new JLabel();
        centerPanel.add(this.searchSize);
        centerPanel.add(Box.createVerticalStrut(this.oneDimFile1.getMinimumSize().height));
        final JPanel buttonPanel = new JPanel();
        buttonPanel.setAlignmentX(0.0f);
        centerPanel.add(buttonPanel);
        this.startButton = new JButton("Start");
        buttonPanel.add(this.startButton);
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.databaseListBox.addItemListener(this);
        this.keywordListBox.addItemListener(this);
        this.oneDimFile1.addItemListener(this);
        this.oneDimFile2.addItemListener(this);
        this.selfCross.addItemListener(this);
        this.and.addItemListener(this);
        this.or.addItemListener(this);
        this.not.addItemListener(this);
        this.oneDimFile1_opts.addItemListener(this);
        this.oneDimFile2_opts.addItemListener(this);
        this.and_opts.addItemListener(this);
        this.or_opts.addItemListener(this);
        this.not_opts.addItemListener(this);
        this.opts.addItemListener(this);
        this.GID.addItemListener(this);
        this.LID.addItemListener(this);
        this.startButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        app.search.addSearchListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.oneDimFile1);
        bg.add(this.oneDimFile2);
        bg.add(this.selfCross);
        bg.add(this.and);
        bg.add(this.or);
        bg.add(this.not);
        bg.add(this.oneDimFile1_opts);
        bg.add(this.oneDimFile2_opts);
        bg.add(this.and_opts);
        bg.add(this.or_opts);
        bg.add(this.not_opts);
        bg.add(this.opts);
        bg.add(this.LID);
        bg.add(this.GID);
        this.setGUIForSearching(false);
        this.databaseListBox.setSelectedIndex(-1);
        this.databaseListBox.setSelectedItem(dbfactory.getDefaultObject());
        this.databaseListBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JComboBox pane = (JComboBox)evt.getSource();
                int sel = pane.getSelectedIndex();
                if (sel == 1) {
                    GeneCiteFrame.this.tabbedPane.setSelectedIndex(1);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(0, false);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(1, true);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(2, false);
                    buttonPanel.setVisible(true);
                    GeneCiteFrame.this.rightPanel.setVisible(true);
                    GeneCiteFrame.this.disabled();
                } else if (sel == 0) {
                    GeneCiteFrame.this.tabbedPane.setSelectedIndex(0);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(0, true);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(1, true);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(2, false);
                    buttonPanel.setVisible(true);
                    GeneCiteFrame.this.rightPanel.setVisible(true);
                    GeneCiteFrame.this.enabled();
                } else if (sel == 2) {
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(0, false);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(1, false);
                    GeneCiteFrame.this.tabbedPane.setEnabledAt(2, true);
                    GeneCiteFrame.this.tabbedPane.setSelectedIndex(2);
                    buttonPanel.setVisible(false);
                    GeneCiteFrame.this.rightPanel.setVisible(false);
                    GeneCiteFrame.this.disabled();
                }
            }
        });
        switch (app.searchType) {
            case 0: {
                this.oneDimFile1.doClick();
                break;
            }
            case 1: {
                this.oneDimFile2.doClick();
                break;
            }
            case 2: {
                this.selfCross.doClick();
                break;
            }
            case 3: {
                this.and.doClick();
                break;
            }
            case 4: {
                this.or.doClick();
                break;
            }
            case 5: {
                this.not.doClick();
            }
        }
        this.leftPanel.loadFile(app.inputFile1);
        this.rightPanel.loadFile(app.inputFile2);
        this.optsPanel.populate();
    }

    private void disabled() {
        this.optsPanel.setVisible(false);
        this.optsPanel.clear();
    }

    private void enabled() {
        this.optsPanel.setVisible(true);
        this.optsPanel.populate();
    }

    protected JComponent options_D() {
        JPanel btnPanel = new JPanel(false);
        btnPanel.setAlignmentX(0.0f);
        Box radioBox = Box.createHorizontalBox();
        Box oneDBox = Box.createVerticalBox();
        Box twoDBox = Box.createVerticalBox();
        radioBox.add(oneDBox);
        radioBox.add(Box.createHorizontalStrut(16));
        radioBox.add(twoDBox);
        radioBox.setAlignmentX(0.0f);
        btnPanel.add(radioBox);
        this.oneDLabel = new JLabel("One Dimension");
        oneDBox.add(this.oneDLabel);
        this.selfCross = new JRadioButton("File 1 AND File 1");
        oneDBox.add(this.selfCross);
        this.oneDimFile1 = new JRadioButton("File 1");
        oneDBox.add(this.oneDimFile1);
        this.oneDimFile2 = new JRadioButton("File 2");
        oneDBox.add(this.oneDimFile2);
        this.twoDLabel = new JLabel("Two Dimensions");
        twoDBox.add(this.twoDLabel);
        this.and = new JRadioButton("File 1 AND File 2");
        twoDBox.add(this.and);
        this.or = new JRadioButton("File 1 OR File 2");
        twoDBox.add(this.or);
        this.not = new JRadioButton("File 1 NOT File 2");
        twoDBox.add(this.not);
        return btnPanel;
    }

    public JComponent options_D_PS() {
        JPanel btnPanel = new JPanel(false);
        btnPanel.setAlignmentX(0.0f);
        Box radioBox = Box.createHorizontalBox();
        Box oneDBox = Box.createVerticalBox();
        radioBox.add(oneDBox);
        radioBox.setAlignmentX(0.0f);
        btnPanel.add(radioBox);
        this.LID = new JRadioButton("Search by Locus Link ID");
        oneDBox.add(this.LID);
        this.LID.setVisible(false);
        this.GID = new JRadioButton("Search by Gene Symbol");
        this.GID.setVisible(false);
        oneDBox.add(this.GID);
        this.PS_search = new JButton("Search");
        this.PS_search.setSize(100, 50);
        this.PS_search.setAlignmentX(0.5f);
        JRadioButton[] radioButtons = new JRadioButton[2];
        final ButtonGroup group = new ButtonGroup();
        String defaultMessageCommand = "default";
        String gs = "genesymbol";
        radioButtons[0] = new JRadioButton("Search by Locus Link ID");
        oneDBox.add(radioButtons[0]);
        radioButtons[0].setActionCommand("default");
        radioButtons[1] = new JRadioButton("Search by Gene Symbol");
        oneDBox.add(radioButtons[1]);
        radioButtons[1].setActionCommand("genesymbol");
        for (int i = 0; i < 2; ++i) {
            group.add(radioButtons[i]);
        }
        radioButtons[0].setSelected(true);
        this.PS_search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent PSevt) {
                JButton PS_search = (JButton)PSevt.getSource();
                Object PS = PSevt.getSource();
                String command = group.getSelection().getActionCommand();
                if (PS == PS_search) {
                    String s = ((GeneCiteFrame)GeneCiteFrame.this).leftPanel.editor.getText();
                    String[] s0 = s.split("\n");
                    int slengh = s.length();
                    if (s.equals("")) {
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, "No input data.");
                    } else if (command == "default") {
                        ConnectLocalDB cl = new ConnectLocalDB();
                        Vector v = ConnectLocalDB.retrievedb(s0);
                        cl.write(v);
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, "Search finished, please check results in Pathway.xls in the current directory. ");
                    } else if (command == "genesymbol") {
                        ConnectLocalDB cl = new ConnectLocalDB();
                        Vector v = ConnectLocalDB.retrievedbsymbol(s0);
                        cl.write(v);
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, "Search finished, please check results in Pathway.xls in the current directory. ");
                    }
                }
            }
        });
        oneDBox.add(this.PS_search);
        return btnPanel;
    }

    protected JComponent options_E() {
        JPanel opts_btnPanel = new JPanel(false);
        opts_btnPanel.setAlignmentX(0.0f);
        Box optsBox = Box.createHorizontalBox();
        Box oneDBoxopts = Box.createVerticalBox();
        oneDBoxopts.setAlignmentX(0.0f);
        Box twoDBoxopts = Box.createVerticalBox();
        optsBox.add(oneDBoxopts);
        optsBox.add(Box.createHorizontalStrut(16));
        optsBox.add(twoDBoxopts);
        optsBox.setAlignmentX(0.0f);
        opts_btnPanel.add(optsBox);
        this.oneDLabel = new JLabel("One Dimension");
        oneDBoxopts.add(this.oneDLabel);
        this.oneDimFile1_opts = new JRadioButton("File 1");
        oneDBoxopts.add(this.oneDimFile1_opts);
        this.oneDimFile2_opts = new JRadioButton("File 2");
        oneDBoxopts.add(this.oneDimFile2_opts);
        this.opts = new JRadioButton("Options Panel Only");
        oneDBoxopts.add(this.opts);
        this.twoDLabel = new JLabel("Two Dimensions");
        twoDBoxopts.add(this.twoDLabel);
        this.and_opts = new JRadioButton("File 1 AND File 2");
        twoDBoxopts.add(this.and_opts);
        this.or_opts = new JRadioButton("File 1 OR File 2");
        twoDBoxopts.add(this.or_opts);
        this.not_opts = new JRadioButton("File 1 NOT File 2");
        twoDBoxopts.add(this.not_opts);
        return opts_btnPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.startButton) {
            this.doStart();
        } else if (s == this.cancelButton) {
            if (this.app.search != null && this.app.search.isRunning()) {
                if (JOptionPane.showConfirmDialog(this, "Are you sure you want to cancel the current search?", "Cancel search", 0) == 0) {
                    this.app.search.cancel();
                }
            } else {
                System.exit(0);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object s = e.getSource();
        if (s == this.oneDimFile1) {
            this.app.searchType = 0;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(false);
        } else if (s == this.oneDimFile2) {
            this.app.searchType = 1;
            this.leftPanel.setEnabled(false);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(false);
        } else if (s == this.selfCross) {
            this.app.searchType = 2;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(false);
        } else if (s == this.and) {
            this.app.searchType = 3;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(false);
        } else if (s == this.or) {
            this.app.searchType = 4;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(false);
        } else if (s == this.not) {
            this.app.searchType = 5;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(false);
        } else if (s == this.oneDimFile1_opts) {
            this.app.searchType = 6;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(true);
        } else if (s == this.oneDimFile2_opts) {
            this.app.searchType = 7;
            this.leftPanel.setEnabled(false);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(true);
        } else if (s == this.and_opts) {
            this.app.searchType = 9;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(true);
        } else if (s == this.or_opts) {
            this.app.searchType = 10;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(true);
        } else if (s == this.not_opts) {
            this.app.searchType = 11;
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(true);
            this.optsPanel.setEnabled(true);
        } else if (s == this.opts) {
            this.app.searchType = 12;
            this.leftPanel.setEnabled(false);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(true);
        } else if (s == this.LID) {
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(false);
        } else if (s == this.GID) {
            this.leftPanel.setEnabled(true);
            this.rightPanel.setEnabled(false);
            this.optsPanel.setEnabled(false);
        } else if (s == this.databaseListBox) {
            String dbname = (String)e.getItem();
            try {
                this.app.search.setDB((Database)this.app.getDatabaseFactory().create(dbname));
                this.keywordListBox.setModel(new DefaultComboBoxModel<Object>(this.app.search.getDB().getKeywords()));
                this.keywordListBox.setSelectedItem(this.app.search.getDB().getDefaultKeyword());
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        this.changeQueries();
    }

    public void queryTimedOut(SearchEvent se) {
        System.out.println(se.getMessage());
    }

    public void queryFailed(SearchEvent se) {
        System.out.println(se.getMessage());
    }

    public void searchProgress(SearchEvent se) {
        int queryNumber = se.getQueryNumber() - 1;
        this.progressBar.setValue(queryNumber);
        long secondsRemaining = queryNumber > 0 ? this.app.search.getElapsedTime() * (long)(this.app.search.getTotalQueries() - queryNumber) / (long)queryNumber / 1000L : 7000L * (long)this.app.search.getTotalQueries() / 1000L;
        long minutesRemaining = secondsRemaining / 60L;
        String text = "";
        if (queryNumber == 0) {
            text = text + "Estimated ";
        } else {
            text = text + queryNumber;
            text = queryNumber == 1 ? text + " query completed, estimated " : text + " queries completed, estimated ";
        }
        if (minutesRemaining < 1L) {
            text = text + secondsRemaining + " secs";
        } else {
            text = text + String.valueOf(minutesRemaining);
            text = minutesRemaining == 1L ? text + " min" : text + " mins";
        }
        text = text + " remaining.";
        this.timeRemainingLabel.setText(text);
        this.statusLabel.setText(se.getQuery());
    }

    public void searchCompleted(SearchEvent se) {
        this.progressBar.setValue(se.getQueryNumber());
        this.timeRemainingLabel.setText("");
        this.statusLabel.setText("Search completed.");
        if (this.app.autoFormat) {
            try {
                this.app.doAutoFormat();
                JOptionPane.showMessageDialog(this, "Search completed.\nSee output files for results.", "Search Complete", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "An error occurred during output of results.\nThe error was:\n" + e, "Output File Error", 0);
            }
        } else {
            this.results = new GeneCiteResultsFrame(this);
        }
        this.setGUIForSearching(false);
    }

    public void searchCancelled(SearchEvent se) {
        this.progressBar.setValue(0);
        this.timeRemainingLabel.setText("");
        this.statusLabel.setText("Search cancelled.");
        this.setGUIForSearching(false);
    }

    private void doStart() {
        this.setGUIForSearching(true);
        this.progressBar.setMaximum(this.app.search.getTotalQueries());
        this.progressBar.setValue(0);
        this.s = new Thread(this.app.search);
        this.s.start();
    }

    public void changeQueries() {
        String keyword = (String)this.keywordListBox.getSelectedItem();
        if (keyword == null) {
            throw new IllegalStateException();
        }
        try {
            Query[] file1Queries = this.leftPanel.getQueries(keyword);
            Query[] file2Queries = this.rightPanel.getQueries(keyword);
            Query[] file3Queries = this.optsPanel.getQueries(keyword);
            this.app.changeQueries(file1Queries, file2Queries, file3Queries);
        }
        catch (Exception e) {
            return;
        }
        if (this.searchSize != null) {
            this.searchSize.setText("Total number of queries: " + this.app.search.getTotalQueries());
        }
        this.startButton.setEnabled(this.app.search.getTotalQueries() > 0);
    }

    public boolean checkQueryFile(String fileName) {
        File queryFile = new File(fileName);
        String testName = GeneCite.checkFile(fileName, null, null);
        if (testName == null) {
            JOptionPane.showMessageDialog(this, "Invalid Input File name " + queryFile.getAbsolutePath(), "Invalid File Name", 0);
            return false;
        }
        queryFile = new File(testName);
        if (!queryFile.isFile()) {
            if (JOptionPane.showConfirmDialog(this, "Input File " + queryFile.getAbsolutePath() + " does not exist.\n" + "Would you like to create it?", "Create File?", 0) != 0) {
                return false;
            }
            try {
                return queryFile.createNewFile();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean checkOutputFile(String fileName) {
        File file = new File(fileName);
        String testName = GeneCite.checkFile(fileName, null, null);
        if (testName == null) {
            JOptionPane.showMessageDialog(this, "Invalid Output File name " + file.getAbsolutePath(), "Invalid File Name", 0);
            return false;
        }
        file = new File(testName);
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Output File name " + file.getAbsolutePath() + " refers to an existing directory.", "Invalid File Name", 0);
            return false;
        }
        if (file.exists()) {
            if (!file.isFile()) {
                JOptionPane.showMessageDialog(this, "The file " + file.getAbsolutePath() + " cannot be an Output File.", "Invalid File Name", 0);
                return false;
            }
            if (JOptionPane.showConfirmDialog(this, "The file " + file.getAbsolutePath() + " exists.\n" + "Do you want to overwrite it?", "File Save - File exists", 0) == 1) {
                return false;
            }
        }
        return true;
    }

    private void setGUIForSearching(boolean searching) {
        this.databaseLabel.setEnabled(!searching);
        this.databaseListBox.setEnabled(!searching);
        this.keywordLabel.setEnabled(!searching);
        this.keywordListBox.setEnabled(!searching);
        this.oneDLabel.setEnabled(!searching);
        this.oneDimFile1.setEnabled(!searching);
        this.oneDimFile2.setEnabled(!searching);
        this.selfCross.setEnabled(!searching);
        this.twoDLabel.setEnabled(!searching);
        this.and.setEnabled(!searching);
        this.or.setEnabled(!searching);
        this.not.setEnabled(!searching);
        this.oneDimFile1_opts.setEnabled(!searching);
        this.oneDimFile2_opts.setEnabled(!searching);
        this.and_opts.setEnabled(!searching);
        this.or_opts.setEnabled(!searching);
        this.not_opts.setEnabled(!searching);
        this.opts.setEnabled(!searching);
        this.optsPanel.setEnabled(!searching);
        this.startButton.setEnabled(!searching);
        this.searchSize.setEnabled(!searching);
        this.leftPanel.setEnabled(!searching);
        this.rightPanel.setEnabled(!searching);
        this.tabbedPane.setEnabled(!searching);
        this.optstext.setEnabled(!searching);
        this.PS_search.setEnabled(!searching);
        this.LID.setEnabled(!searching);
        this.GID.setEnabled(!searching);
        this.optsPanel.setEnabled(!searching);
    }

    public GeneCite getApp() {
        return this.app;
    }
}

