/*
 * Decompiled with CFR 0.152.
 */
import com.syntek_usa.util.BasicObjectFactory;
import com.syntek_usa.util.PropertyListWithDefault;
import com.syntek_usa.util.SelfReadingPropertiesFile;
import java.util.Properties;

public class GeneCitePropertiesFile
extends SelfReadingPropertiesFile {
    private String baseDir = new String();
    private String inputFile1 = new String();
    private String inputFile2 = new String();
    private String outputFile = new String();
    private int searchType;
    private int queryTimeout;
    private String invalidValue;
    private String[] databaseList;
    private int defaultDatabase;
    private String[] formatterList;
    private int defaultFormatter;
    private boolean autoFormat;
    private String[] autoFormatList;
    private static final String GENECITEPROPFILE = "GeneCite.properties";
    private static final String DBLISTPROP = "db_list";
    private static final String DEFAULTDBLIST = "PubMedDatabase,uniSTSDatabase,PathwayScreen";
    private static final String DEFAULTDBPROP = "default_db";
    private static final int DEFAULTDB = 1;
    private static final String FORMATTERLISTPROP = "formatters";
    private static final String DEFAULTFMTLIST = "HTMLFormatter, CSVLinkFormatter, CSVCountFormatter";
    private static final String DEFAULTFMTPROP = "default_formatter";
    private static final int DEFAULTFMT = 1;
    private static final String BASEDIRPROP = "base_dir";
    private static final String DEFAULTBASEDIR = System.getProperty("user.dir");
    private static final String FILE1PROP = "input_file1";
    private static final String DEFAULTFILE1 = "genes.txt";
    private static final String FILE2PROP = "input_file2";
    private static final String DEFAULTFILE2 = "terms.txt";
    private static final String OUTPUTFILEPROP = "output_file";
    private static final String DEFAULTOUTPUTFILE = "";
    private static final String SEARCHPROP = "search_type";
    private static final String DEFAULTSEARCHTYPESTR = "AND";
    private static final int DEFAULTSEARCHTYPE = 3;
    private static final String QUERYTIMEOUTPROP = "query_timeout";
    private static final String DEFAULTQUERYTIMEOUT = "10000";
    private static final String INVALIDVALUEPROP = "invalid_value";
    private static final String DEFAULTINVALIDVALUE = "-1";
    private static final String AUTOFORMATPROP = "auto_format";
    private static final String DEFAULTAUTOFORMAT = "true";
    private static final String AUTOFORMATLISTPROP = "auto_format_list";
    private static final String AUTOFORMATLISTALL = "all";
    private static final String DEFAULTAUTOFORMATLIST = "all";
    private static final String DEFAULTTEXT = "#\n#                             GeneCite.properties\n#\n# This is the GeneCite.properties file.  It is an example file to show\n# you some of the options you can use to alter GeneCite's default\n# behavior.  The lines you are reading, that begin with the '#'\n# character, are comments that are ignored when the file is processed.\n# You can use them to explain your changes or for any other notes you\n# would like to make.  Each entry in the properties file consists of a\n# keyword, an equals sign, and a value.  In order for the keyword to be\n# recognized, it must match the expected keyword exactly, including\n# underscore characters '_' .  Each keyword has a default that will be\n# used if that keyword is not given in the properties file, or if the\n# properties file does not exist.  As a result, a properties file is\n# really necessary only if the defaults need to be changed.\n\n# Database List - db_list - This is a list of all database classes that\n# the program should use.  Currently, the only valid value is\n# PubMedDatabase, so that there is little need to use this keyword.\n# Database names are case-sensitive, and names that do not match known\n# databases will simply be ignored.  Should GeneCite be upgraded to\n# include multiple types of databases, there will be more values\n# possible for this keyword.  Then, you can use this keyword to select\n# only those databases that you want to use. The default, of course, is\n# PubMedDatabase.\n# Example:\n# db_list = PubMedDatabase\n\n# Default Database - default_db - This is the index of the database in\n# the Database List which you want to have as the default database.  Any\n# number outside of the range from 1 to the number of databases in the\n# list will be ignored, and the default substituted.  Since there is\n# currently only one database in the list, the default is 1.\n# Example:\n# default_db = 1\n\n# Formatter List - formatters - This is a list of all output file\n# formatter classes that the program should use.  Currently, the valid\n# values are: CSVLinkFormatter, CSVCountFormatter, and HTMLFormatter.\n#  Formatter names are case-sensitive, and names that do not match known\n# formatters will simply be ignored.  Should GeneCite be upgraded to\n# include more formatters, there will be more values possible for this\n# keyword.  You can use this keyword to select only those formatters you\n# want to use.  The default is a list of all valid values:\n# formatters = HTMLFormatter, CSVLinkFormatter, CSVCountFormatter\n# Example:\n# formatters = CSVLinkFormatter,HTMLFormatter\n\n# Default Formatter - default_formatter - This is the index of the\n# formatter in the Formatter List that the program should use as a\n# default.  The default format is the one that is initially selected in\n# the Save output dialog that appears when Auto Format (see below) is\n# turned off.  Any number outside of the range from 1 to the number of\n# formatters in the list will be ignored, and the default substituted.\n# The default is 1, indicating that the default formatter is the first\n# one in the list.\n# Example:\n# default_formatter = 1\n\n# Auto Format - auto_format - Controls whether output files are\n# automatically generated.  If the value is 'true' (upper or lower\n# case), output files aregenerated automatically in each of the formats\n# listed in the auto_format_list (see below).  If Auto Format is off,\n# the user will be shown a Results window with a Save button.  Clicking\n# on the Save button presents a dialog allowing the user to choose the\n# format and file name in which to save the file.  The default value of\n# Auto Format is true;  that is, all formats are generated.\n# Example:\n# auto_format = false\n\n# Auto Format List - auto_format_list - This is the list of formatters\n# for which files should be generated automatically.  The list of\n# formatters for the current version is given in Formatter List above.\n# Names that do not match known formatters will simply be ignored,\n# except that the word 'all' is also allowed.  When 'all' appears as the\n# only name, all known formatters (see 'formatters' keyword above) are\n# used.  The default value is 'all'.\n# Examples:\n# auto_format_list = CSVLinkFormatter,HTMLFormatter\n# auto_format_list = all\n\n# Query Timeout - query_timeout - This is the maximum amount of time\n# that will be allowed for each query to execute.  Normal execution is\n# expected to be much faster.  The value is in milliseconds, and\n# defaults to 10000 (ten thousand, or 10 seconds.)\n# Example:\n# query_timeout = 5000\n\n# Invalid Value - invalid_value - This is the value that will be used\n# in place of the citation count when an error in encountered while\n# executing the query.  For numerical analysis of the data, a negative\n# number, which cannot be a valid value but is still numeric, might be\n# used.  Otherwise, a more explanatory 'Invalid' could be used.  The\n# default is '-1'.\n# Example:\n# invalid_value = Invalid\n\n# Search Type - search_type - This is the default search type.  The\n# allowed values are 'ONEDIM', 'SELF', or 'CROSS' (case is not important\n# for these.) The ONEDIM value implies that File 1 will be used (there\n# is no need for a default of ONEDIM using File 2.)  SELF represents a\n# two-dimensional File 1 X File 1 search, while CROSS represents File 1\n# X File 2.  The value given here in the properties file will be over-\n# ridden if a search type is given on the command line.  The default is\n# SELF.\n# Example:\n# search_type = cross\n\n# Base Directory - base_dir - The base directory used in locating input\n# files and for storing output files.  This directory is only used if no\n# directory is specified in the file names given (see below).  This\n# allows a variety of file storage policies.  For instance, the base\n# directory could be set to a user-specific directory (i.e.\n# /users/<username> on a Unix system), and the input and output file\n# names would not need to duplicate this path.  Or, the file names could\n# include a relative path, such as inputfiles/input1.txt and\n# outputfiles/output.txt.  This value will be overridden by any\n# directory specified in an input file name, if only one input file name\n# is given, or by the directory in both input file names, if the\n# directories are the same.  The default value is the directory from\n# which GeneCite was started.\n# Example:\n# base_dir = /mlaing/java/GeneCite/v2.0a\n\n# Input File Name - input_file1 and input_file2 - Default file names for\n# File 1 and File 2.  If a relative path is given in the file name, it\n# is combined with the Base Directory, if any.  The file name is checked\n# to ensure that it either exists, or that at least its parent directory\n# exists, so that the file can be created.  The file names given will be\n# overridden by file names that may be given on the command line.  The\n# file names can be absolute, containing a complete file path from the\n# root, or relative, with or without any directory specified.  For\n# instance, on some system, \"C:\\genecite\\input\\datainput.txt\" might\n# be an absolute file name, \"input\\datainput.txt\" would be a relative\n# name with a directory, and \"datainput.txt\" would be a relative name\n# with no directory.  By changing the Base Directory value as well, all\n# three names could refer to the same file.  For historical reasons, the\n# default value for input_file1 is \"genes.txt\", and the default for\n# input_file2 is \"terms.txt\".  The names no longer imply anything\n# about the contents of the files;  both follow the format given for\n# input files, and can contain any set of queries.\n# Example:\n# input_file1 = code/genes.txt\n# input_file2 = C:\\mlaing\\java\\GeneCite\\v2.0a/code\\terms.txt\n\n# Output File Name - output_file - Default file name base for output\n# files.  This name is combined with the date and time that the search\n# began, and is given the extension of the output format that it\n# contains, to form the suggested file name.  If Auto Format is off (see\n# above), the suggested name will be the one given in the Save dialog.\n# If a relative path is given in the file name, it is combined with the\n# Base Directory, if any.  The file name is checked to ensure that it\n# either exists, or that at least its parent directory exists, so that\n# the file can be created.  This name overrides the default file name\n# base that is provided by the formatter (for HTML- and CSV-\n# LinkFormatters, this is \"results\";  for CSVCountFormatter,\n# \"counts\".  The default is empty, which causes the formatter's file\n# name to be used.\n# Example:\n# output_file = output\n";

    public GeneCitePropertiesFile() {
        super(GENECITEPROPFILE, DEFAULTTEXT);
        this.getProperties();
    }

    private void getProperties() {
        this.baseDir = this.getProperty(BASEDIRPROP, null);
        this.baseDir = GeneCite.checkDirectory(this.baseDir, null, DEFAULTBASEDIR);
        this.inputFile1 = this.getProperty(FILE1PROP, null);
        this.inputFile1 = GeneCite.checkFile(this.inputFile1, this.baseDir, DEFAULTFILE1);
        this.inputFile2 = this.getProperty(FILE2PROP, null);
        this.inputFile2 = GeneCite.checkFile(this.inputFile2, this.baseDir, DEFAULTFILE2);
        this.outputFile = this.getProperty(OUTPUTFILEPROP, null);
        this.outputFile = GeneCite.checkFile(this.outputFile, this.baseDir, DEFAULTOUTPUTFILE);
        String userSearch = this.getProperty(SEARCHPROP, DEFAULTSEARCHTYPESTR);
        try {
            this.searchType = Integer.parseInt(userSearch);
            if (this.searchType < 0 || this.searchType > 13) {
                this.searchType = 3;
            }
        }
        catch (NumberFormatException e) {
            this.searchType = GeneCite.interpretSearchStr(userSearch);
        }
        String userQueryTimeout = this.getProperty(QUERYTIMEOUTPROP, DEFAULTQUERYTIMEOUT);
        try {
            this.queryTimeout = Integer.parseInt(userQueryTimeout);
            if (this.queryTimeout < 0) {
                this.queryTimeout = Integer.parseInt(DEFAULTQUERYTIMEOUT);
            }
        }
        catch (NumberFormatException e) {
            try {
                this.queryTimeout = Integer.parseInt(DEFAULTQUERYTIMEOUT);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        PropertyListWithDefault userDatabaseList = new PropertyListWithDefault(this, DBLISTPROP, DEFAULTDBLIST, DEFAULTDBPROP, 1, ","){

            public boolean verifyListElement(String element) {
                return BasicObjectFactory.verifyObjectName(element);
            }
        };
        this.databaseList = userDatabaseList.getObjectList();
        this.defaultDatabase = userDatabaseList.getDefaultIndex();
        PropertyListWithDefault userFormatterList = new PropertyListWithDefault(this, FORMATTERLISTPROP, DEFAULTFMTLIST, DEFAULTFMTPROP, 1, ","){

            public boolean verifyListElement(String element) {
                return BasicObjectFactory.verifyObjectName(element);
            }
        };
        this.formatterList = userFormatterList.getObjectList();
        this.defaultFormatter = userFormatterList.getDefaultIndex();
        String userAutoFormat = this.getProperty(AUTOFORMATPROP, DEFAULTAUTOFORMAT);
        this.autoFormat = Boolean.valueOf(userAutoFormat);
        String userAutoFormatList = this.getProperty(AUTOFORMATLISTPROP, "all");
        if (userAutoFormatList.toLowerCase().equals("all")) {
            this.autoFormatList = this.formatterList;
        } else {
            PropertyListVerifiedAgainstList userList = new PropertyListVerifiedAgainstList(this, AUTOFORMATLISTPROP, "all", this.formatterList);
            this.autoFormatList = userList.getObjectList();
        }
        this.invalidValue = this.getProperty(INVALIDVALUEPROP, DEFAULTINVALIDVALUE);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getInputFile1() {
        return this.inputFile1;
    }

    public String getInputFile2() {
        return this.inputFile2;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public String getInvalidValue() {
        return this.invalidValue;
    }

    public String[] getDatabaseList() {
        return this.databaseList;
    }

    public int getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public String[] getFormatterList() {
        return this.formatterList;
    }

    public int getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public boolean getAutoFormat() {
        return this.autoFormat;
    }

    public String[] getAutoFormatList() {
        return this.autoFormatList;
    }

    class PropertyListVerifiedAgainstList
    extends PropertyListWithDefault {
        private String[] validValues;

        public PropertyListVerifiedAgainstList(Properties p, String propertyName, String propertyDefault, String[] validValues) {
            super(p, propertyName, propertyDefault, GeneCitePropertiesFile.DEFAULTOUTPUTFILE, 1, ",");
            this.validValues = validValues;
        }

        public boolean verifyListElement(String element) {
            for (int i = 0; i < this.validValues.length; ++i) {
                if (!this.validValues[i].equals(element)) continue;
                return true;
            }
            return false;
        }
    }
}

