/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.dbsearch;

import com.syntek_usa.dbsearch.Query;

public class QueryImpl
implements Query {
    protected QuerySpec qs;

    public QueryImpl(Object key, Object value) {
        this(new QuerySpec(new KeywordSpec(key, new ValueSpec(value))));
    }

    protected QueryImpl(QuerySpec qs) {
        this.qs = qs;
    }

    public Query and(Query other) {
        if (!(other instanceof QueryImpl)) {
            throw new IllegalArgumentException();
        }
        QueryImpl o = (QueryImpl)other;
        return new QueryImpl(this.qs.and(o.qs));
    }

    public Query or(Query other) {
        if (!(other instanceof QueryImpl)) {
            throw new IllegalArgumentException();
        }
        QueryImpl o = (QueryImpl)other;
        return new QueryImpl(this.qs.or(o.qs));
    }

    public Query not(Query other) {
        if (!(other instanceof QueryImpl)) {
            throw new IllegalArgumentException();
        }
        QueryImpl o = (QueryImpl)other;
        return new QueryImpl(this.qs.not(o.qs));
    }

    public Query group() {
        return new QueryImpl((QuerySpec)this.qs.group());
    }

    public boolean equals(Object other) {
        if (!(other instanceof QueryImpl)) {
            return false;
        }
        return this.qs.equals(((QueryImpl)other).qs);
    }

    public Object[] toTokens() {
        return this.qs.toTokens();
    }

    public String toString() {
        return this.toString(symbolTable);
    }

    public String toString(String[] symbolTable) {
        if (symbolTable.length != Query.symbolTable.length) {
            throw new IllegalArgumentException();
        }
        String s = "";
        Object[] tokens = this.toTokens();
        for (int i = 0; i < tokens.length; ++i) {
            s = tokens[i] == AND ? s + symbolTable[0] : (tokens[i] == OR ? s + symbolTable[1] : (tokens[i] == NOT ? s + symbolTable[2] : (tokens[i] == BEGIN ? s + symbolTable[3] : (tokens[i] == END ? s + symbolTable[4] : (tokens[i] == KEY ? s + symbolTable[5] : s + tokens[i].toString())))));
        }
        return s;
    }

    private static class QuerySpec
    extends Expression
    implements Tokenizable {
        public QuerySpec(KeywordSpec ks) {
            super(KeywordSpec.class, ks);
        }

        public QuerySpec(QuerySpec left, Query.Symbol op, QuerySpec right) {
            super(KeywordSpec.class, left, op, right);
        }

        public QuerySpec(QuerySpec left, Query.Symbol op, QuerySpec right, boolean grouped) {
            super(KeywordSpec.class, left, op, right, grouped);
        }

        protected Expression create(Object value) {
            if (!(value instanceof KeywordSpec)) {
                throw new IllegalArgumentException();
            }
            return new QuerySpec((KeywordSpec)value);
        }

        protected Expression create(Expression left, Query.Symbol op, Expression right) {
            if (!(left instanceof QuerySpec) || !(right instanceof QuerySpec)) {
                throw new IllegalArgumentException();
            }
            return new QuerySpec((QuerySpec)left, op, (QuerySpec)right);
        }

        public QuerySpec and(QuerySpec other) {
            if (!this.isTerminal() || !other.isTerminal()) {
                return (QuerySpec)super.and(other);
            }
            KeywordSpec myks = (KeywordSpec)this.value;
            KeywordSpec otks = (KeywordSpec)other.value;
            if (myks.getKey() != otks.getKey()) {
                return (QuerySpec)super.and(other);
            }
            ValueSpec leftval = myks.getValue();
            if (this.grouped) {
                leftval = (ValueSpec)leftval.group();
            }
            ValueSpec rightval = otks.getValue();
            if (other.grouped) {
                rightval = (ValueSpec)rightval.group();
            }
            return new QuerySpec(new KeywordSpec(myks.getKey(), new ValueSpec(leftval, Query.AND, rightval)));
        }

        public QuerySpec or(QuerySpec other) {
            if (!this.isTerminal() || !other.isTerminal()) {
                return (QuerySpec)super.or(other);
            }
            KeywordSpec myks = (KeywordSpec)this.value;
            KeywordSpec otks = (KeywordSpec)other.value;
            if (myks.getKey() != otks.getKey()) {
                return (QuerySpec)super.or(other);
            }
            ValueSpec leftval = myks.getValue();
            if (this.grouped) {
                leftval = (ValueSpec)leftval.group();
            }
            ValueSpec rightval = otks.getValue();
            if (other.grouped) {
                rightval = (ValueSpec)rightval.group();
            }
            return new QuerySpec(new KeywordSpec(myks.getKey(), new ValueSpec(leftval, Query.OR, rightval)));
        }

        public QuerySpec not(QuerySpec other) {
            if (!this.isTerminal() || !other.isTerminal()) {
                return (QuerySpec)super.not(other);
            }
            KeywordSpec myks = (KeywordSpec)this.value;
            KeywordSpec otks = (KeywordSpec)other.value;
            if (myks.getKey() != otks.getKey()) {
                return (QuerySpec)super.not(other);
            }
            ValueSpec leftval = myks.getValue();
            if (this.grouped) {
                leftval = (ValueSpec)leftval.group();
            }
            ValueSpec rightval = otks.getValue();
            if (other.grouped) {
                rightval = (ValueSpec)rightval.group();
            }
            return new QuerySpec(new KeywordSpec(myks.getKey(), new ValueSpec(leftval, Query.NOT, rightval)));
        }
    }

    private static class KeywordSpec
    implements Tokenizable {
        private Object key;
        private ValueSpec value;

        public KeywordSpec(Object key, ValueSpec value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public ValueSpec getValue() {
            return this.value;
        }

        public Object[] toTokens() {
            Object[] valtok = this.value.toTokens();
            Object[] tokens = new Object[valtok.length + 2];
            tokens[0] = this.key;
            tokens[1] = Query.KEY;
            System.arraycopy(valtok, 0, tokens, 2, valtok.length);
            return tokens;
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeywordSpec)) {
                return false;
            }
            KeywordSpec o = (KeywordSpec)other;
            return this.key.equals(o.key) && this.value.equals(o.value);
        }
    }

    private static class ValueSpec
    extends Expression
    implements Tokenizable {
        public ValueSpec(Object value) {
            super(Object.class, value);
        }

        public ValueSpec(ValueSpec left, Query.Symbol op, ValueSpec right) {
            super(Object.class, left, op, right);
        }

        public ValueSpec(ValueSpec left, Query.Symbol op, ValueSpec right, boolean grouped) {
            super(Object.class, left, op, right, grouped);
        }

        protected Expression create(Object value) {
            return new ValueSpec(value);
        }

        protected Expression create(Expression left, Query.Symbol op, Expression right) {
            if (!(left instanceof ValueSpec) || !(right instanceof ValueSpec)) {
                throw new IllegalArgumentException();
            }
            return new ValueSpec((ValueSpec)left, op, (ValueSpec)right);
        }
    }

    private static abstract class Expression
    implements Tokenizable {
        public static final boolean GROUPED = true;
        public static final boolean NOTGROUPED = false;
        protected Class valueClass;
        protected Object value;
        protected Expression left;
        protected Query.Symbol op;
        protected Expression right;
        protected boolean grouped;

        protected Expression(Class valueClass, Object value) {
            if (!valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException();
            }
            this.valueClass = valueClass;
            this.value = value;
        }

        protected Expression(Class valueClass, Expression left, Query.Symbol op, Expression right) {
            this(valueClass, left, op, right, false);
        }

        protected Expression(Class valueClass, Expression left, Query.Symbol op, Expression right, boolean grouped) {
            if (!valueClass.isAssignableFrom(left.valueClass) || !valueClass.isAssignableFrom(right.valueClass)) {
                throw new IllegalArgumentException();
            }
            if (op != Query.AND && op != Query.OR && op != Query.NOT) {
                throw new IllegalArgumentException();
            }
            this.valueClass = valueClass;
            this.left = left;
            this.op = op;
            this.right = right;
            this.grouped = grouped;
        }

        public Expression and(Expression other) {
            if (!this.valueClass.isAssignableFrom(other.valueClass)) {
                throw new IllegalArgumentException();
            }
            return this.create(this, Query.AND, other);
        }

        public Expression or(Expression other) {
            if (!this.valueClass.isAssignableFrom(other.valueClass)) {
                throw new IllegalArgumentException();
            }
            return this.create(this, Query.OR, other);
        }

        public Expression not(Expression other) {
            if (!this.valueClass.isAssignableFrom(other.valueClass)) {
                throw new IllegalArgumentException();
            }
            return this.create(this, Query.NOT, other);
        }

        public Expression group() {
            Expression e = this.isTerminal() ? this.create(this.value) : this.create(this.left, this.op, this.right);
            e.grouped = true;
            return e;
        }

        protected abstract Expression create(Object var1);

        protected abstract Expression create(Expression var1, Query.Symbol var2, Expression var3);

        public Object[] toTokens() {
            int toklen;
            if (this.isTerminal() && !(this.value instanceof Tokenizable)) {
                return new Object[]{this.value};
            }
            Object[] v = null;
            Object[] l = null;
            Object[] r = null;
            if (this.isTerminal()) {
                v = ((Tokenizable)this.value).toTokens();
                toklen = v.length;
            } else {
                l = this.left.toTokens();
                r = this.right.toTokens();
                toklen = l.length + r.length + 1;
            }
            if (this.grouped) {
                toklen += 2;
            }
            Object[] tokens = new Object[toklen];
            int offset = 0;
            if (this.grouped) {
                tokens[offset++] = Query.BEGIN;
            }
            if (this.isTerminal()) {
                System.arraycopy(v, 0, tokens, offset, v.length);
                offset += v.length;
            } else {
                System.arraycopy(l, 0, tokens, offset, l.length);
                offset += l.length;
                tokens[offset++] = this.op;
                System.arraycopy(r, 0, tokens, offset, r.length);
                offset += r.length;
            }
            if (this.grouped) {
                tokens[offset] = Query.END;
            }
            return tokens;
        }

        public boolean isTerminal() {
            return this.value != null;
        }

        public boolean equals(Object other) {
            if (!this.getClass().isAssignableFrom(other.getClass())) {
                return false;
            }
            Expression o = (Expression)other;
            if (this.isTerminal()) {
                return o.isTerminal() && this.value.equals(o.value);
            }
            return !o.isTerminal() && this.left.equals(o.left) && this.op == o.op && this.right.equals(o.right) && this.grouped == o.grouped;
        }
    }

    private static interface Tokenizable {
        public Object[] toTokens();
    }
}

