/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.narray;

import com.syntek_usa.narray.BasicNArray;
import com.syntek_usa.narray.ReadableNArray;

public class BasicReadableNArray
extends BasicNArray
implements ReadableNArray {
    protected Object[] storage = new Object[this.totalElements()];

    public BasicReadableNArray(int[] dimensions, String[][] headers) {
        super(dimensions, headers);
    }

    public Object getValueAt(int row) {
        return this.storage[this.getIndex(row)];
    }

    public Object getValueAt(int row, int col) {
        return this.storage[this.getIndex(row, col)];
    }

    public Object getValueAt(int[] indexes) {
        return this.storage[this.getIndex(indexes)];
    }

    protected int getIndex(int row) {
        if (this.numberOfDimensions() != 1) {
            throw new UnsupportedOperationException();
        }
        if (row < 0 || row > this.getDimension(0)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return row;
    }

    protected int getIndex(int row, int col) {
        if (row < 0 || row > this.getDimension(0) || col < 0 || col > this.getDimension(1)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return col * this.getDimension(0) + row;
    }

    protected int getIndex(int row, int col, int o) {
        if (this.numberOfDimensions() != 3) {
            throw new UnsupportedOperationException();
        }
        if (row < 0 || row > this.getDimension(0) || col < 0 || col > this.getDimension(1)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return col * this.getDimension(0) + row;
    }

    protected int getIndex(int[] indexes) {
        if (this.numberOfDimensions() != indexes.length) {
            throw new UnsupportedOperationException();
        }
        int lastindex = this.numberOfDimensions() - 1;
        if (indexes[lastindex] > this.getDimension(lastindex)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = indexes[lastindex];
        for (int i = lastindex - 1; i >= 0; --i) {
            if (indexes[i] > this.getDimension(i)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            index = index * this.getDimension(i) + indexes[i];
        }
        return index;
    }
}

