/*
 * Decompiled with CFR 0.152.
 */
package com.syntek_usa.util;

import java.awt.Color;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class GenericApplication {
    private static final String COMPANY = "Walter Reed Army Institute of Research";
    private static final String COMPANYADDR = "Released as Open Source to BioSPICE.org ";
    private static final String COMPANYPHONE = " ";
    private static final String COMPANYURL = "http://www.BioSPICE.org";
    private String title;
    private String version;
    private String copyright;

    protected GenericApplication(String title, String version, String copyright) {
        this.title = title;
        this.version = version;
        this.copyright = copyright;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getCompany() {
        return COMPANY;
    }

    public String getCompanyAddr() {
        return COMPANYADDR;
    }

    public String getCompanyPhone() {
        return COMPANYPHONE;
    }

    public String getCompanyURL() {
        return COMPANYURL;
    }

    public String getAppId() {
        return this.title + ", Version " + this.version;
    }

    public String[] getIdStrings() {
        return new String[]{this.getAppId(), COMPANYADDR, COMPANYPHONE, COMPANYURL};
    }

    public JPanel getIdPanel(MouseListener urlListener) {
        JPanel id = new JPanel();
        Box logoBox = Box.createHorizontalBox();
        logoBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        id.add(logoBox);
        JLabel iconLabel = new JLabel(new ImageIcon(this.getClass().getResource("SmallLogo.gif")));
        iconLabel.setAlignmentY(0.0f);
        logoBox.add(iconLabel);
        logoBox.add(Box.createHorizontalStrut(8));
        Box addressBox = Box.createVerticalBox();
        addressBox.setAlignmentY(0.5f);
        logoBox.add(addressBox);
        JLabel titleLine = new JLabel(this.getTitle() + COMPANYPHONE + this.getVersion() + ", Copyright " + this.getCopyright());
        titleLine.setAlignmentX(0.5f);
        addressBox.add(titleLine);
        JLabel idLine1 = new JLabel(COMPANY);
        idLine1.setAlignmentX(0.5f);
        addressBox.add(idLine1);
        JLabel idLine2 = new JLabel(COMPANYADDR);
        idLine2.setAlignmentX(0.5f);
        addressBox.add(idLine2);
        JPanel idPanel = new JPanel();
        addressBox.add(idPanel);
        JLabel idPhone = new JLabel(COMPANYPHONE);
        idPanel.add(idPhone);
        idPanel.add(Box.createHorizontalGlue());
        JLabel idURL = new JLabel(COMPANYURL);
        idPanel.add(idURL);
        if (urlListener != null) {
            idURL.setForeground(Color.blue);
            idURL.addMouseListener(urlListener);
        }
        id.setVisible(false);
        return id;
    }
}

