{***************************************************************************
 *
 * Author:     Alberto Pascual Montano (pascual@fis.ucm.es)
 *             http://www.dacya.ucm.es/apascual

 * Complutense University of Madrid (UCM). Madrid, Spain
 * The KEY Institute for Brain-Mind Research, Zurich, Switzerland
 * National Center for Biotechnology (CNB). Madrid, Spain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  All comments concerning this program package may be sent to the
 *  e-mail address 'pascual@fis.ucm.es'
 ***************************************************************************}

unit factors;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, uMatToolsDyn, Grids, ExtCtrls, microarray;
type
  Tfactorsform = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    UpLabel: TLabel;
    DownLabel: TLabel;
    evlabel: TLabel;
    StringGrid1: TStringGrid;
    DrawGrid1: TDrawGrid;
    CheckBox1: TCheckBox;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    ComboBox1: TComboBox;
    CheckBox2: TCheckBox;
    maxcollabel: TLabel;
    maxrowlabel: TLabel;
    Image1: TImage;
    CheckBox3: TCheckBox;
    Button2: TButton;
    SaveDialog1: TSaveDialog;
    Label3: TLabel;
    minColorLabel: TLabel;
    maxcolorlabel: TLabel;
    Label4: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    collabel: TLabel;
    rowlabel: TLabel;
    minneglabel: TLabel;
    minposlabel: TLabel;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    SaveDialog2: TSaveDialog;
    Button3: TButton;
    StatusBar1: TStatusBar;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure CheckBox3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    Up, Down: extended;
    maxUp, maxDown: extended;
    slopeUp, slopeDown: extended;
    gridselflag, stringselflag: boolean;
    maxColTh, maxRowTh : extended;
    oldMatrixIndex: integer;
    procedure DrawStringGrid;
    function fromComboToIndex(combo: integer): integer;
    function fromIndexToCombo(index: integer): integer;
    function fromComboToSubIndex(combo: integer): integer;
    procedure repaintbitmap;
    procedure MouseToCells(yc, xc: integer; var X, Y: Integer);
  public
    { Public declarations }
    factvec: ^factvector;
    p, n, q: ^integer;
    rowlabels, varlabels: ^stringvector;
    numberofrowheaders: ^integer;
    microselflag, factorselflag: boolean;
    itemmask : boolvector;
    varmask : boolvector;
    internalMatrixIndex, internalMatrixSubIndex: integer;
    showdelcells: boolean;
    showfirsttime : bool;
    mat: matrix;
    function fromMComboToFCombo(combo: integer): integer;
    function fromFComboToMCombo(combo: integer): integer;
end;
var
  factorsform: Tfactorsform;

implementation

//uses microarray;

{$R *.dfm}
const
   min = 0;

procedure Tfactorsform.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:= false;
  visible:= false;
end;

procedure Tfactorsform.FormShow(Sender: TObject);
var
  i,j, he, wi: integer;
begin
  if (showfirsttime) then begin
      showfirsttime := false;
      StringGrid1.ColCount := p^+1;
      StringGrid1.RowCount := n^+1;
      DrawGrid1.ColCount := p^+1;
      DrawGrid1.RowCount := n^+1;
      DrawGrid1.RowHeights[0] := 0;
      DrawGrid1.colwidths[0] := 0;
      wi := 10;
      he := 10;
      showdelcells:= true;
      checkbox1.checked := true;
      checkbox3.checked := true;
      DrawGrid1.scrollBars := ssBoth;
      TrackBar1.Position := 90;
      TrackBar2.Position := 10;
      Image1.Height := DrawGrid1.Height;
      Image1.Width := DrawGrid1.Width;
      Image1.top := DrawGrid1.top;
      Image1.left := DrawGrid1.left;
      for i:=1 to n^ do
         itemmask[i]:= true;
      for j:=1 to p^ do
         varmask[j]:= true;

      for i:= 1 to microform.dimfactvec do begin
        ComboBox1.AddItem('Reconstructed matrix by ' + factvec^[i].name, Sender);
        ComboBox1.AddItem(factvec^[i].name + ' by rows', Sender);
        ComboBox1.AddItem(factvec^[i].name + ' by columns', Sender);
      end;
      ComboBox1.ItemIndex := fromMComboToFCombo(microform.ComboBox1.ItemIndex);
      Label1.Caption := ComboBox1.Items[ComboBox1.ItemIndex];
      internalMatrixIndex := fromComboToIndex(ComboBox1.ItemIndex);
      internalMatrixSubIndex := fromComboToSubIndex(ComboBox1.ItemIndex);
      oldMatrixIndex := internalMatrixIndex;

      StringGrid1.Cells[0, 0] := '';
      for i:=1 to numberofrowheaders^-1 do
          StringGrid1.Cells[0, 0] := StringGrid1.Cells[0, 0] + varlabels^[i] + #9;
      if (numberofrowheaders^ >0) then
          StringGrid1.Cells[0, 0] := StringGrid1.Cells[0, 0] + varlabels^[numberofrowheaders^];

      for i:=1 to n^ do begin
         StringGrid1.Cells[0, i] := rowlabels^[factvec^[internalMatrixIndex].Aindex.v[i]];
         DrawGrid1.RowHeights[i] := he;
      end;
      for j:=1 to p^ do begin
         StringGrid1.Cells[j, 0] := varlabels^[factvec^[internalMatrixIndex].Bindex.v[j] + numberofrowheaders^];
         DrawGrid1.colwidths[j] := wi;
      end;

      factvec^[internalMatrixIndex].min:= 656000; factvec^[internalMatrixIndex].max := -656000;
      for i:=1 to n^ do begin
          for j:=1 to p^ do begin
                mat.m[i,j] := factvec^[internalMatrixIndex].Avec.v[i]*factvec^[internalMatrixIndex].weight*factvec^[internalMatrixIndex].Bvec.v[j];
                if (factvec^[internalMatrixIndex].min > mat.m[i,j]) then factvec^[internalMatrixIndex].min := mat.m[i,j];
                if (factvec^[internalMatrixIndex].max < mat.m[i,j]) then factvec^[internalMatrixIndex].max := mat.m[i,j];
          end;
      end;

      for i:=1 to n^ do begin
        for j:=1 to p^ do begin
         StringGrid1.Cells[j, i] := floattostr(mat.m[i,j]);
        end;
      end;
      evLabel.Caption := microform.importancemodelstr + FloatToStrF(factvec^[internalMatrixIndex].evar, ffFixed, 4, 2) +'%';

      if (abs(factvec^[internalMatrixIndex].amin) > abs(factvec^[internalMatrixIndex].amax)) then begin
          maxRowTh := abs(factvec^[internalMatrixIndex].amin);
          maxrowLabel.Caption :=  '+/- ' + FloatToStrF(maxRowTh, ffFixed, 4, 2);
      end else begin
          maxRowTh := abs(factvec^[internalMatrixIndex].amax);
          maxrowLabel.Caption :=  '+/- ' + FloatToStrF(maxRowTh, ffFixed, 4, 2);
      end;
      if (abs(factvec^[internalMatrixIndex].bmin) > abs(factvec^[internalMatrixIndex].bmax)) then begin
          maxColTh := abs(factvec^[internalMatrixIndex].bmin);
          maxcolLabel.Caption :=  '+/- ' + FloatToStrF(maxColTh, ffFixed, 4, 2)
      end else begin
          maxColTh := abs(factvec^[internalMatrixIndex].bmax);
          maxcolLabel.Caption :=  '+/- ' + FloatToStrF(maxColTh, ffFixed, 4, 2);
      end;
      trackbar3.position := trackbar3.max;
      trackbar4.position := trackbar3.min;

      StringGrid1.Hint := 'Item label: ' + StringGrid1.Cells[0, 1] + #13 + 'Var Label: ' +  StringGrid1.Cells[1, 0];
      DrawGrid1.Hint := StringGrid1.Hint;

       if (internalMatrixSubIndex = 0) then begin
                maxUp:=factvec^[internalMatrixIndex].max;
                maxDown:=factvec^[internalMatrixIndex].min;
       end else if (internalMatrixSubIndex = 1) then begin
                maxUp:=factvec^[internalMatrixIndex].amax;
                maxDown:=factvec^[internalMatrixIndex].amin;
       end else if (internalMatrixSubIndex = 2) then begin
                maxUp:=factvec^[internalMatrixIndex].bmax;
                maxDown:=factvec^[internalMatrixIndex].bmin;
       end;

       if (MaxUp <= 0) then begin
          maxUp:= 0;
          trackbar2.position := 0;
          trackbar2.Enabled := false;
          maxcolorLabel.Caption :=  '0.0';
       end else begin
          trackbar2.Enabled := true;
          maxcolorLabel.Caption :=  FloatToStrF(MaxUp, ffFixed, 4, 2);
          Up := MaxUp/2;
          if (MaxUp <> 0) then
              trackbar2.position := round(Up*trackbar2.Max/MaxUp)
          else
              trackbar2.position := trackbar2.min;
       end;
       if (MaxDown >= 0) then begin
          maxDown := 0;
          trackbar1.position := trackbar1.max;
          trackbar1.Enabled := false;
          mincolorLabel.Caption :=  '0.0';
       end else begin
          trackbar1.Enabled := true;
          mincolorLabel.Caption :=  FloatToStrF(MaxDown, ffFixed, 4, 2);
          MaxDown := abs(MaxDown);
          Down := MaxDown/2;
          if (MaxDown <> 0) then
              trackbar1.position := trackbar1.Max - round(Down*trackbar1.Max/MaxDown)
          else
              trackbar1.position := trackbar1.Max;
       end;

       if (Up <> min) then
          slopeUp := (255)/(Up-min)
       else slopeUp := 0;
       if (Down <> min) then
          slopeDown := (255)/(Down-min)
       else slopeDown := 0;

       CheckBox2.enabled := true;
       checkbox2.checked := false;
       microform.CheckBox2.enabled := true;
   end;
end;

procedure Tfactorsform.DrawGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
   // Focus the cell in String grid
   if (not stringselflag) then begin
        gridselflag := true;
        StringGrid1.col := ACol;
        StringGrid1.row := ARow;
   end else
        stringselflag := false;
end;

procedure Tfactorsform.DrawGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var
  c: TColor;
  auxE: extended;
  auxUp, auxDown : integer;
begin
   // Paint the color of the cell, if visible
    if ((DrawGrid1.RowHeights[Arow] = 0) or (DrawGrid1.colwidths[Acol] = 0)) then begin
       exit;
    end;
    if ((ACol >0) and (ARow >0)) then begin
        if (itemmask[Arow] and varmask[Acol]) then begin
            if (internalMatrixSubIndex = 0) then begin
                auxE := mat.m[ARow,Acol];
            end else if (internalMatrixSubIndex = 1) then begin
                auxE := factvec^[internalMatrixIndex].Avec.v[ARow];
            end else if (internalMatrixSubIndex = 2) then begin
                auxE := factvec^[internalMatrixIndex].Bvec.v[ACol];
            end;
            if (auxE > 0) then begin
                if (auxE > Up) then auxE := Up;
                auxUp:= round(slopeUp*(auxE-min));
                c:=rgb(auxUp, 0, 0);
                DrawGrid1.Canvas.Brush.Color := c
            end else begin
                auxE := abs(auxE);
                if (auxE > Down) then auxE := Down;
                auxDown:= round(slopeDown*(auxE-min));
                c:=rgb(0, auxDown, 0);
                DrawGrid1.Canvas.Brush.Color := c
            end;
        end else begin
            c:=rgb(100, 100, 100);
            DrawGrid1.Canvas.Brush.Color := c
        end;
        DrawGrid1.Canvas.FillRect(Rect);
    end;
end;

procedure Tfactorsform.TrackBar1Change(Sender: TObject);
begin
  // Negative (down regulation)
   Down := (trackbar1.Max+1 - trackbar1.position)*MaxDown/(trackbar1.Max+1);
   DownLabel.caption := '-' + FloatToStrF(Down, ffFixed, 4, 2);
   if (not microform.mousedown) then begin
     if (Down <> min) then
        slopeDown := (255)/(Down-min)
     else slopeDown := 0;
     if CheckBox2.Checked then
       repaintbitmap;
     DrawGrid1.repaint;
   end;
end;

procedure Tfactorsform.TrackBar2Change(Sender: TObject);
begin
   // Positive (up regulation)
   Up := trackbar2.position*MaxUp/trackbar2.Max;
   UpLabel.caption := FloatToStrF(Up, ffFixed, 4, 2);
   if (not microform.mousedown) then begin
     if (Up <> min) then
        slopeUp := (255)/(Up-min)
     else slopeUp := 0;
     if CheckBox2.Checked then
       repaintbitmap;
     DrawGrid1.repaint;
   end;
end;

procedure Tfactorsform.CheckBox1Click(Sender: TObject);
begin
   if (checkbox1.checked) then begin
      DrawGrid1.GridLineWidth := 1;
   end else begin
      DrawGrid1.GridLineWidth := 0;
   end;
   DrawGrid1.LeftCol := 0;
   DrawGrid1.TopRow := 0;
end;


procedure Tfactorsform.repaintbitmap;
type
     TpIntArray=array[1..maxword] of tcolor;
var
  wi, he, i, j, restwi, resthe, nn, pp, ap, an, counter, ir, jr: integer;
  auxup, auxdown: integer;
  ah, bh, aw, bw, auxe: extended;
  c: TColor;
  ttt:^TpIntArray;
  ii, jj, counteri, counterj:integer;
  MyBitmap: TBitmap;
  iv, jv : intvector;
  passed: boolean;
begin
    an := 0;
    ap := 0;
    create1(n^,iv);
    create1(p^,jv);
    counter := 0;
    for i:=1 to n^ do
      if ((not showdelcells) and (internalMatrixSubIndex <> 2)) then begin
        if not itemmask[i] then an := an + 1
        else begin
           counter := counter + 1;
           iv.v[counter] := i;
        end;
      end else iv.v[i] := i;
    counter := 0;
    for j:=1 to p^ do
      if ((not showdelcells) and (internalMatrixSubIndex <> 1)) then begin
        if not varmask[j] then ap := ap + 1
        else begin
           counter := counter + 1;
           jv.v[counter] := j;
        end;
      end else jv.v[j] := j;

      if (not CheckBox2.Checked) then begin
        an := 0;
        ap := 0;
      end;
      
      if (internalMatrixSubIndex = 0) then begin
          pp := p^ - ap;
          nn := n^ - an;
      end else if (internalMatrixSubIndex = 1) then begin
          pp := 1;
          nn := n^-an;
      end else if (internalMatrixSubIndex = 2) then begin
          pp := p^-ap;
          nn := 1;
      end;

      MyBitmap := TBitmap.Create;
      MyBitmap.Width := DrawGrid1.ClientWidth;
      MyBitmap.Height := DrawGrid1.ClientHeight;
      MyBitmap.PixelFormat:=pf32bit;
      Image1.Picture.Graphic := MyBitmap;
      MyBitmap.Free;

      wi :=  DrawGrid1.ClientWidth div pp;
      restwi := DrawGrid1.ClientWidth mod pp;
      he :=  DrawGrid1.ClientHeight div nn;
      resthe := DrawGrid1.ClientHeight mod nn;

      if (he = 0) then begin
         // Do downsampling by rows
        bh := (nn-1)/(DrawGrid1.ClientHeight-1);
        ah := 1-bh;
      end;
      if (wi = 0) then begin
         // Do downsampling by columns
        bw := (pp-1)/(DrawGrid1.ClientWidth-1);
        aw := 1-bw;
      end;

      // Now paint Bitmap
      counteri:= 0; i:=1;
      for ii:= 1 to DrawGrid1.ClientHeight-1 do begin
        ttt:=image1.Picture.Bitmap.scanline[ii-1];
        if (he = 0) then begin
            i := round(ah + bh*ii);
        end else begin
            counteri := counteri +1;
            if (i <= resthe) then  begin
                if (counteri = (he+1)) then begin
                    i:=i+1;
                    counteri := 0;
                end;
            end else begin
                if (counteri = he) then begin
                    i:=i+1;
                    counteri := 0;
                end;
            end;
        end;
        ir := iv.v[i];
        j := 1; counterj := 0;
        for jj:=1 to DrawGrid1.ClientWidth-1 do begin
            if (wi = 0) then begin
                j := round(aw + bw*jj);
            end else begin
               counterj := counterj +1;
                if (j <= restwi) then  begin
                    if (counterj = (wi+1)) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end else begin
                    if (counterj = wi) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end;
            end;
            jr := jv.v[j];
            if (internalMatrixSubIndex = 0) then
                passed := (itemmask[ir] and varmask[jr])
            else if (internalMatrixSubIndex = 1) then
                passed := (itemmask[ir])
            else if (internalMatrixSubIndex = 2) then
                passed := (varmask[jr]);
            if (passed) then begin
                if (internalMatrixSubIndex = 0) then begin
                    auxE := mat.m[ir,jr];
                end else if (internalMatrixSubIndex = 1) then begin
                    auxE := factvec^[internalMatrixIndex].Avec.v[ir];
                end else if (internalMatrixSubIndex = 2) then begin
                    auxE := factvec^[internalMatrixIndex].Bvec.v[jr];
                end;
                if (auxE > 0) then begin
                    if (auxE > Up) then auxE := Up;
                    auxUp:= round(slopeUp*(auxE-min));
                    c:=rgb(0, 0, auxUp);
                end else begin
                    auxE := abs(auxE);
                    if (auxE > Down) then auxE := Down;
                    auxDown:= round(slopeDown*(auxE-min));
                    c:=rgb(0, auxDown, 0);
                end;
                ttt^[jj]:=c;
            end else begin
                if (showdelcells) then begin
                    c:=rgb(100, 100, 100);
                    ttt^[jj]:=c;
                end;
            end;
        end;
    end;
    destroy1(iv);
    destroy1(jv);
end;

procedure Tfactorsform.CheckBox2Click(Sender: TObject);
type
     TpIntArray=array[1..maxword] of tcolor;
var
  wi, he, i, j, restwi, resthe, nn, pp, ap, an, counter, ir, jr: integer;
  auxup, auxdown: integer;
  ah, bh, aw, bw, auxe: extended;
  MyBitmap : TBitmap;
  c: TColor;
  ttt:^TpIntArray;
  ii, jj, counteri, counterj:integer;
  iv, jv : intvector;
  passed : boolean;
begin

  // Fit array to window. Uses downsampling if necessary

  an := 0;
  ap := 0;
  create1(n^,iv);
  create1(p^,jv);
  counter := 0;
  for i:=1 to n^ do
    if ((not showdelcells) and (internalMatrixSubIndex <> 2)) then begin
      if not itemmask[i] then an := an + 1
      else begin
         counter := counter + 1;
         iv.v[counter] := i;
      end;
    end else iv.v[i] := i;
  counter := 0;

  for j:=1 to p^ do
    if ((not showdelcells) and (internalMatrixSubIndex <> 1)) then begin
      if not varmask[j] then ap := ap + 1
      else begin
         counter := counter + 1;
         jv.v[counter] := j;
      end;
    end else jv.v[j] := j;

  if (not CheckBox2.Checked) then begin
      an := 0;
      ap := 0;
  end;

  if (internalMatrixSubIndex = 0) then begin
      pp := p^ - ap;
      nn := n^ - an;
  end else if (internalMatrixSubIndex = 1) then begin
      pp := 1;
      nn := n^-an;
  end else if (internalMatrixSubIndex = 2) then begin
      pp := p^-ap;
      nn := 1;
  end;

  if (checkbox2.checked) then begin
    DrawGrid1.Visible := false;
    checkbox1.checked := false;
    checkbox1.enabled := false;
    DrawGrid1.scrollBars := ssNone;
  end;
   DrawGrid1.LeftCol := 0;
   DrawGrid1.TopRow := 0;

  if (not checkbox2.checked) then begin
      he := 10; wi := 10;
      for i:=1 to nn do
          DrawGrid1.RowHeights[i] := he;
      for j:=1 to pp do
          DrawGrid1.colwidths[j] := wi;
      // Shows control
      Image1.Visible := false;
      DrawGrid1.Visible := true;
  end else begin
      // Hide control
      MyBitmap := TBitmap.Create;
      MyBitmap.Width := DrawGrid1.ClientWidth;
      MyBitmap.Height := DrawGrid1.ClientHeight;
      MyBitmap.PixelFormat:=pf32bit;
      Image1.Picture.Graphic := MyBitmap;
      MyBitmap.Free;

      wi :=  DrawGrid1.ClientWidth div pp;
      restwi := DrawGrid1.ClientWidth mod pp;
      he :=  DrawGrid1.ClientHeight div nn;
      resthe := DrawGrid1.ClientHeight mod nn;

      if (he = 0) then begin
         // Do downsampling by rows
        bh := (nn-1)/(DrawGrid1.ClientHeight-1);
        ah := 1-bh;
      end else begin
          for i:=1 to nn do begin
              if (i <= resthe) then
                  DrawGrid1.RowHeights[i] := he+1
              else
                  DrawGrid1.RowHeights[i] := he;
          end;
      end;
      if (wi = 0) then begin
         // Do downsampling by columns
        bw := (pp-1)/(DrawGrid1.ClientWidth-1);
        aw := 1-bw;
      end else begin
          for j:=1 to pp do begin
              if (j <= restwi) then
                  DrawGrid1.colwidths[j] := wi + 1
              else
                  DrawGrid1.colwidths[j] := wi;
          end;
      end;

      // Now paint Bitmap
    i := 1; counteri := 0;
    for ii:= 1 to DrawGrid1.ClientHeight-1 do begin
        ttt:=image1.Picture.Bitmap.scanline[ii-1];
        if (he = 0) then begin
            i := round(ah + bh*ii);
        end else begin
            counteri := counteri +1;
            if (i <= resthe) then  begin
                if (counteri = (he+1)) then begin
                    i:=i+1;
                    counteri := 0;
                end;
            end else begin
                if (counteri = he) then begin
                    i:=i+1;
                    counteri := 0;
                end;
            end;
        end;
        ir := iv.v[i];
        j := 1; counterj := 0;
        for jj:=1 to DrawGrid1.ClientWidth-1 do begin
            if (wi = 0) then begin
                j := round(aw + bw*jj);
            end else begin
               counterj := counterj +1;
                if (j <= restwi) then  begin
                    if (counterj = (wi+1)) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end else begin
                    if (counterj = wi) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end;
            end;
            jr := jv.v[j];
            if (internalMatrixSubIndex = 0) then
                passed := (itemmask[ir] and varmask[jr])
            else if (internalMatrixSubIndex = 1) then
                passed := (itemmask[ir])
            else if (internalMatrixSubIndex = 2) then
                passed := (varmask[jr]);
            if (passed) then begin
                if (internalMatrixSubIndex = 0) then begin
                    auxE := mat.m[ir,jr];
                end else if (internalMatrixSubIndex = 1) then begin
                    auxE := factvec^[internalMatrixIndex].Avec.v[ir];
                end else if (internalMatrixSubIndex = 2) then begin
                    auxE := factvec^[internalMatrixIndex].Bvec.v[jr];
                end;
                if (auxE > 0) then begin
                    if (auxE > Up) then auxE := Up;
                    auxUp:= round(slopeUp*(auxE-min));
                    c:=rgb(0, 0, auxUp);
                end else begin
                    auxE := abs(auxE);
                    if (auxE > Down) then auxE := Down;
                    auxDown:= round(slopeDown*(auxE-min));
                    c:=rgb(0, auxDown, 0);
                end;
                ttt^[jj]:=c;
            end else begin
                if (showdelcells) then begin
                    c:=rgb(100, 100, 100);
                    ttt^[jj]:=c;
                end;
            end;
        end;
    end;
      // Hide control and show bitmap
      Image1.Visible := true;

  end;
  destroy1(iv);
  destroy1(jv);

  if (not checkbox2.checked) then begin
    checkbox1.enabled := true;
    checkbox1.checked := true;
    DrawGrid1.scrollBars := ssBoth;
  end;
end;

procedure Tfactorsform.DrawStringGrid;
var
  i, j: integer;
begin
  if (internalMatrixSubIndex = 0) then begin
      StringGrid1.ColCount := p^+1;
      StringGrid1.RowCount := n^+1;
      DrawGrid1.ColCount := p^+1;
      DrawGrid1.RowCount := n^+1;
  end else if (internalMatrixSubIndex = 1) then begin
      StringGrid1.ColCount := 2;
      StringGrid1.RowCount := n^+1;
      DrawGrid1.ColCount := 2;
      DrawGrid1.RowCount := n^+1;
  end else if (internalMatrixSubIndex = 2) then begin
      StringGrid1.ColCount := p^+1;
      StringGrid1.RowCount := 2;
      DrawGrid1.ColCount := p^+1;
      DrawGrid1.RowCount := 2;
  end;

  if (internalMatrixSubIndex <> 2) then begin
      if (internalMatrixSubIndex <> 0) then
          StringGrid1.Cells[1, 0] := 'values';
      for i:=1 to n^ do begin
          StringGrid1.Cells[0, i] := rowlabels^[factvec^[internalMatrixIndex].Aindex.v[i]];
      end;
  end;
  if (internalMatrixSubIndex <> 1) then begin
    if (internalMatrixSubIndex <> 0) then
        StringGrid1.Cells[0, 1] := 'values';
    for j:=1 to p^ do begin
      StringGrid1.Cells[j, 0] := varlabels^[factvec^[internalMatrixIndex].Bindex.v[j] + numberofrowheaders^];
    end;
  end;
  if (internalMatrixSubIndex = 0) then begin
      for i:=1 to n^ do
          for j:=1 to p^ do begin
              StringGrid1.Cells[j, i] := floattostr(mat.m[i,j]);
          end;
  end else if (internalMatrixSubIndex = 1) then begin
      for i:=1 to n^ do
              StringGrid1.Cells[1, i] := floattostr(factvec^[internalMatrixIndex].Avec.v[i]);
  end else if (internalMatrixSubIndex = 2) then begin
      for j:=1 to p^ do
              StringGrid1.Cells[j, 1] := floattostr(factvec^[internalMatrixIndex].Bvec.v[j]);
  end;
end;

function Tfactorsform.fromComboToIndex(combo: integer): integer;
begin
   fromComboToIndex:= (ComboBox1.ItemIndex div 3) + 1;
end;

function Tfactorsform.fromComboToSubIndex(combo: integer): integer;
begin
   fromComboToSubIndex:= (ComboBox1.ItemIndex mod 3);
end;

function Tfactorsform.fromIndexToCombo(index: integer): integer;
begin
   fromIndexToCombo:= (index-1)*3;
end;

function Tfactorsform.fromMComboToFCombo(combo: integer): integer;
begin
   if (combo = 0) then begin
      fromMComboToFCombo := 0;
      exit;
   end;
   fromMComboToFCombo := (combo-1)*3;
end;

function Tfactorsform.fromFComboToMCombo(combo: integer): integer;
begin
   fromFComboToMCombo := (combo div 3) + 1;
end;

procedure Tfactorsform.ComboBox1Change(Sender: TObject);
var
  i,j: integer;
  Save_Cursor:TCursor;
begin
  Save_Cursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;    { Show hourglass cursor }
  // Change in comboBox
  internalMatrixIndex := fromComboToIndex(ComboBox1.ItemIndex);
  internalMatrixSubIndex := fromComboToSubIndex(ComboBox1.ItemIndex);

  // set the matrix
  factvec^[internalMatrixIndex].min:= 656000; factvec^[internalMatrixIndex].max := -656000;
  for i:=1 to n^ do begin
      for j:=1 to p^ do begin
            mat.m[i,j] := factvec^[internalMatrixIndex].Avec.v[i]*factvec^[internalMatrixIndex].weight*factvec^[internalMatrixIndex].Bvec.v[j];
            if (factvec^[internalMatrixIndex].min > mat.m[i,j]) then factvec^[internalMatrixIndex].min := mat.m[i,j];
            if (factvec^[internalMatrixIndex].max < mat.m[i,j]) then factvec^[internalMatrixIndex].max := mat.m[i,j];
      end;
  end;

  Label1.Caption := ComboBox1.Items[ComboBox1.ItemIndex];
  if (internalMatrixSubIndex = 0) then begin
            maxUp:=factvec^[internalMatrixIndex].max;
            maxDown:=factvec^[internalMatrixIndex].min;
  end else if (internalMatrixSubIndex = 1) then begin
            maxUp:=factvec^[internalMatrixIndex].amax;
            maxDown:=factvec^[internalMatrixIndex].amin;
  end else if (internalMatrixSubIndex = 2) then begin
            maxUp:=factvec^[internalMatrixIndex].bmax;
            maxDown:=factvec^[internalMatrixIndex].bmin;
  end;

  if (MaxUp <= 0) then begin
      maxUp:= 0;
      trackbar2.position := 0;
      trackbar2.Enabled := false;
      maxcolorLabel.Caption :=  '0.0';
  end else begin
      trackbar2.Enabled := true;
      maxcolorLabel.Caption :=  FloatToStrF(MaxUp, ffFixed, 4, 2);
      Up := MaxUp/2;
      UpLabel.caption := FloatToStrF(Up, ffFixed, 4, 2);
      if (MaxUp <> 0) then
          trackbar2.position := round(Up*trackbar2.Max/MaxUp)
      else
         trackbar2.position := trackbar2.min;
  end;
  if (MaxDown >= 0) then begin
      maxDown := 0;
      trackbar1.position := trackbar1.max;
      trackbar1.Enabled := false;
      mincolorLabel.Caption :=  '0.0';
  end else begin
      trackbar1.Enabled := true;
      mincolorLabel.Caption :=  FloatToStrF(MaxDown, ffFixed, 4, 2);
      MaxDown := abs(MaxDown);
      Down := MaxDown/2;
      DownLabel.caption := FloatToStrF(Down, ffFixed, 4, 2);
      if (MaxDown <> 0) then
          trackbar1.position := trackbar1.Max - round(Down*trackbar1.Max/MaxDown)
      else
          trackbar1.position := trackbar1.max;
  end;
  if (Up <> min) then
      slopeUp := (255)/(Up-min)
  else slopeUp := 0;
  if (Down <> min) then
      slopeDown := (255)/(Down-min)
  else slopeDown := 0;

  if (oldMatrixIndex <> internalMatrixIndex) then begin
      oldMatrixIndex:= internalMatrixIndex;
      evLabel.Caption := microform.importancemodelstr + FloatToStrF(factvec^[internalMatrixIndex].evar, ffFixed, 4, 2) +'%';

      if (abs(factvec^[internalMatrixIndex].amin) > abs(factvec^[internalMatrixIndex].amax)) then
          maxrowLabel.Caption :=  '+/-' + FloatToStrF(abs(factvec^[internalMatrixIndex].amin), ffFixed, 4, 2)
      else
          maxrowLabel.Caption :=  '+/-' + FloatToStrF(abs(factvec^[internalMatrixIndex].amax), ffFixed, 4, 2);

      if (abs(factvec^[internalMatrixIndex].bmin) > abs(factvec^[internalMatrixIndex].bmax)) then
          maxcolLabel.Caption :=  '+/-' + FloatToStrF(abs(factvec^[internalMatrixIndex].bmin), ffFixed, 4, 2)
      else
          maxcolLabel.Caption :=  '+/-' + FloatToStrF(abs(factvec^[internalMatrixIndex].bmax), ffFixed, 4, 2);

      for i:=1 to n^ do
         itemmask[i]:= true;
      for j:=1 to p^ do
         varmask[j]:= true;


       if (abs(factvec^[internalMatrixIndex].amin) > abs(factvec^[internalMatrixIndex].amax)) then begin
          maxRowTh := abs(factvec^[internalMatrixIndex].amin);
          maxrowLabel.Caption :=  '+/- ' + FloatToStrF(maxRowTh, ffFixed, 4, 2);
       end else begin
          maxRowTh := abs(factvec^[internalMatrixIndex].amax);
          maxrowLabel.Caption :=  '+/- ' + FloatToStrF(maxRowTh, ffFixed, 4, 2);
       end;
       if (abs(factvec^[internalMatrixIndex].bmin) > abs(factvec^[internalMatrixIndex].bmax)) then begin
          maxColTh := abs(factvec^[internalMatrixIndex].bmin);
          maxcolLabel.Caption :=  '+/- ' + FloatToStrF(maxColTh, ffFixed, 4, 2)
       end else begin
          maxColTh := abs(factvec^[internalMatrixIndex].bmax);
          maxcolLabel.Caption :=  '+/- ' + FloatToStrF(maxColTh, ffFixed, 4, 2);
       end;
       trackbar3.position := trackbar3.max;
       trackbar4.position := trackbar3.min;
  end;
  // Change also the combo in the microform visualization form
  // Unless visualization form is showing the original matrix
  if ((Sender <> microform) and (microform.ComboBox1.ItemIndex > 0))then begin
      microform.ComboBox1.ItemIndex := fromFComboToMCombo(ComboBox1.ItemIndex);
      microform.ComboBox1Change(factorsform);
  end else begin
      microform.DrawGrid1.repaint;
      microform.StringGrid1.repaint;
     if CheckBox2.Checked then
        microform.repaintbitmap;
  end;
  DrawStringGrid;
  if (internalMatrixSubIndex >0) then begin
     if CheckBox2.Checked then
        CheckBox2Click(sender)
     else
      CheckBox2.Checked := true;
  end else CheckBox2Click(sender);
  DrawGrid1.repaint;
  Screen.Cursor := Save_Cursor;  { Always restore to normal }
end;


procedure Tfactorsform.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
    // Focus the cell in String grid
   if (not gridselflag) then begin
        stringselflag := true;
        DrawGrid1.col := ACol;
        DrawGrid1.row := ARow;
   end else
        gridselflag := false;

   // Change also the cell in visualization form
   if (not microselflag) then begin
      factorselflag := true;
      if (microform.ComboBox1.ItemIndex > 0) then begin
              if (internalMatrixSubIndex = 0) then begin
                  // One to one correspondence
                  microform.StringGrid1.Col := Acol;
                  microform.StringGrid1.Row := Arow;
              end else if (internalMatrixSubIndex = 1) then begin
                  // row correspondence
                  microform.StringGrid1.Col := 1;
                  microform.StringGrid1.Row := Arow;
              end else begin
                  // column correspondence
                  microform.StringGrid1.Col := Acol;
                  microform.StringGrid1.Row := 1;
              end;
      end else begin
              if (internalMatrixSubIndex = 0) then begin
                  // One to one correspondence
                  microform.StringGrid1.Col := factvec^[internalMatrixIndex].BIndex.v[Acol];
                  microform.StringGrid1.Row := factvec^[internalMatrixIndex].AIndex.v[Arow];
              end else if (factorsform.internalMatrixSubIndex = 1) then begin
                  // row correspondence
                  microform.StringGrid1.Col := 1;
                  microform.StringGrid1.Row := factvec^[internalMatrixIndex].AIndex.v[Arow];
              end else begin
                  // column correspondence
                  microform.StringGrid1.Col := factvec^[internalMatrixIndex].BIndex.v[Acol];
                  microform.StringGrid1.Row := 1;
              end;
      end;
   end else
       microselflag := false;

   // Show column and row name in the hint label
   StringGrid1.Hint := 'Item label: ' + StringGrid1.Cells[0, Arow] + #13 + 'Var Label: ' +  StringGrid1.Cells[Acol, 0];
   DrawGrid1.Hint := StringGrid1.Hint;
end;


procedure Tfactorsform.StringGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var
   c: TColor;
   strtemp: string;
const
  SelectedColor = Clblue;
begin
  StringGrid1.Options := StringGrid1.Options + [goDrawFocusSelected] + [goRowSizing] + [goColSizing];
  // Change the font color according to mask
  if ((Acol = 0) or (Arow = 0)) then exit;
  if ((gdFocused in state) or (gdSelected in state)) then begin
      StringGrid1.Canvas.Brush.Color := SelectedColor;
      StringGrid1.Canvas.FillRect(Rect);
      StringGrid1.Canvas.TextRect(Rect, Rect.Left + 2, Rect.Top + 2, StringGrid1.Cells[aCol, aRow]);
      exit;
  end;
  strTemp := StringGrid1.Cells[ACol,ARow];
  if (internalMatrixSubIndex = 0) then begin
      if ((not itemmask[Arow]) or (not varmask[Acol])) then
          c:=rgb(100, 100, 100)
      else
          c:=rgb(255, 255, 255);
  end else if (internalMatrixSubIndex = 1) then begin
      if (not itemmask[Arow]) then
          c:=rgb(100, 100, 100)
      else
          c:=rgb(255, 255, 255);
  end else if (internalMatrixSubIndex = 2) then begin
      if (not varmask[Acol]) then
          c:=rgb(100, 100, 100)
      else
          c:=rgb(255, 255, 255);
  end;
  StringGrid1.Canvas.Brush.Color := c;
  StringGrid1.Canvas.FillRect(Rect);
  DrawText(StringGrid1.Canvas.Handle,PChar(strTemp),-1,Rect,0);
end;

procedure Tfactorsform.MouseToCells(yc, xc: integer; var X, Y: Integer);
var
  counteri, counterj, ii, jj,counter: integer;
  i, j, wi, he, restwi, resthe, nn, pp, ap, an: integer;
  ah, bh, aw, bw: extended;
  iv, jv : intvector;

begin
    an := 0;
    ap := 0;
    create1(n^,iv);
    create1(p^,jv);
    counter := 0;
    for i:=1 to n^ do
      if (not showdelcells) then begin
        if not itemmask[i] then an := an + 1
        else begin
           counter := counter + 1;
           iv.v[counter] := i;
        end;
      end else iv.v[i] := i;
    counter := 0;
    for j:=1 to p^ do
      if (not showdelcells) then begin
        if not varmask[j] then ap := ap + 1
        else begin
           counter := counter + 1;
           jv.v[counter] := j;
        end;
      end else jv.v[j] := j;

      if (internalMatrixSubIndex = 0) then begin
          pp := p^ - ap;
          nn := n^ - an;
      end else if (internalMatrixSubIndex = 1) then begin
          pp := 1;
          nn := n^-an;
      end else if (internalMatrixSubIndex = 2) then begin
          pp := p^-ap;
          nn := 1;
      end;

      wi :=  DrawGrid1.ClientWidth div pp;
      restwi := DrawGrid1.ClientWidth mod pp;
      he :=  DrawGrid1.ClientHeight div nn;
      resthe := DrawGrid1.ClientHeight mod nn;

      if (he = 0) then begin
         // Do downsampling by rows
        bh := (nn-1)/(DrawGrid1.ClientHeight-1);
        ah := 1-bh;
      end;
      if (wi = 0) then begin
         // Do downsampling by columns
        bw := (pp-1)/(DrawGrid1.ClientWidth-1);
        aw := 1-bw;
      end;

      if (he = 0) then 
          x := round(ah + bh*yc)
      else begin
          counteri:= 0; x:=1;
          for ii:= 1 to yc do begin
                counteri := counteri +1;
                if (x <= resthe) then  begin
                    if (counteri = (he+1)) then begin
                        x:=x+1;
                        counteri := 0;
                    end;
                end else begin
                    if (counteri = he) then begin
                        x:=x+1;
                        counteri := 0;
                    end;
                end;
          end;
      end;
      x := iv.v[x];

      if (wi = 0) then
          y := round(aw + bw*xc)
      else begin
        y := 1; counterj := 0;
        for jj:=1 to xc do begin
            counterj := counterj +1;
            if (y <= restwi) then  begin
                if (counterj = (wi+1)) then begin
                    y:=y+1;
                    counterj := 0;
                end;
            end else begin
                if (counterj = wi) then begin
                    y:=y+1;
                    counterj := 0;
                end;
            end;
        end;
      end;
      y := jv.v[y];
      
      if (x <= 0) then x:=1;
      if (y <= 0) then y:=1;
      if (x > n^) then x:=n^;
      if (y > p^) then y:=p^;
      if (internalMatrixSubIndex = 1) then begin
          y := 1;
      end else if (internalMatrixSubIndex = 2) then begin
          x:=1;
      end;

end;

procedure Tfactorsform.CheckBox3Click(Sender: TObject);
begin
    if CheckBox3.checked then
        showdelcells:= true
    else
        showdelcells:= false;
    if CheckBox2.Checked then
      repaintbitmap;
    if microform.CheckBox2.Checked then
      microform.repaintbitmap;

end;

procedure Tfactorsform.FormCreate(Sender: TObject);
begin
  // Create
  showfirsttime:= true;
end;

procedure Tfactorsform.Button2Click(Sender: TObject);
var
  S: string;
  FileExt :string[4];
  Save_Cursor:TCursor;
begin
  // Save bitmap
  if savedialog1.Execute then begin
    S := savedialog1.FileName;
    FileExt := AnsiUpperCase(ExtractFileExt(S));
    if (FileExt <> '.BMP') then S := S + '.bmp';
    if FileExists(S) then
      if MessageDlg(S+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then exit;
    Save_Cursor := Screen.Cursor;
    Screen.Cursor := crHourGlass;    { Show hourglass cursor }
    repaintbitmap;
    Image1.Picture.Bitmap.SavetoFile(S);
    Screen.Cursor := Save_Cursor;  { Always restore to normal }
  end;
end;

procedure Tfactorsform.TrackBar3Change(Sender: TObject);
var
  rowthreshold: extended;
  i, counter: integer;
  Save_Cursor:TCursor;
begin
   if (trackbar3.Max <> 0) then
      rowthreshold := (trackbar3.Max - trackbar3.position)*maxRowTh/trackbar3.Max
   else
      rowthreshold := 0;
   rowLabel.caption := FloatToStrF(rowthreshold, ffFixed, 4, 2);
   if (not microform.mousedown) then begin
       Save_Cursor := Screen.Cursor;
       Screen.Cursor := crHourGlass;    { Show hourglass cursor }
       counter := 0;
       for i:= 1 to n^ do begin
           if (abs(factvec^[internalMatrixIndex].Avec.v[i]) < rowthreshold) then begin
               itemmask[i]:= false;
               counter := counter +1;
           end else begin
              itemmask[i]:= true;
           end;
       end;
       DrawStringGrid;
       DrawGrid1.repaint;
       microform.DrawStringGrid;
       microform.DrawGrid1.repaint;
       if (counter = n^) then begin
          if CheckBox2.checked then CheckBox2.checked := false;
          if microform.CheckBox2.checked then microform.CheckBox2.checked := false;
          CheckBox2.enabled := false;
          microform.CheckBox2.enabled := false;
       end else begin
          CheckBox2.enabled := true;
          microform.CheckBox2.enabled := true;
          if CheckBox2.Checked then
            repaintbitmap;
          if microform.CheckBox2.Checked then
            microform.repaintbitmap;
       end;
       Screen.Cursor := Save_Cursor;  { Always restore to normal }
   end;

end;

procedure Tfactorsform.TrackBar4Change(Sender: TObject);
var
  colthreshold: extended;
  j, counter: integer;
  Save_Cursor:TCursor;
begin
   if (trackbar4.Max <> 0) then
      colthreshold := trackbar4.position*MaxColTh/trackbar4.Max
   else
      colthreshold := 0;
   ColLabel.caption := FloatToStrF(colthreshold, ffFixed, 4, 2);
   if (not microform.mousedown) then begin
         Save_Cursor := Screen.Cursor;
         Screen.Cursor := crHourGlass;    { Show hourglass cursor }
         counter := 0;
         for j:= 1 to p^ do begin
             if (abs(factvec^[internalMatrixIndex].Bvec.v[j]) < colthreshold) then begin
                 varmask[j]:= false;
                 counter := counter +1;
             end else begin
                varmask[j]:= true;
             end;
         end;
         DrawStringGrid;
         DrawGrid1.repaint;
         microform.DrawStringGrid;
         microform.DrawGrid1.repaint;
         if (counter = n^) then begin
              if microform.CheckBox2.checked then microform.CheckBox2.checked := false;
              if CheckBox2.checked then CheckBox2.checked := false;
              CheckBox2.enabled := false;
              microform.CheckBox2.enabled := false;
         end else begin
              microform.CheckBox2.enabled := true;
              CheckBox2.enabled := true;
              if CheckBox2.Checked then
                repaintbitmap;
              if microform.CheckBox2.Checked then
                microform.repaintbitmap;
         end;
         Screen.Cursor := Save_Cursor;  { Always restore to normal }
   end;
end;

procedure Tfactorsform.Button3Click(Sender: TObject);
var
  S: string;
  FileExt :string[4];
  txt:textfile; i,j, k:integer;
  Save_Cursor:TCursor;
  flag: boolean;

begin
  // Save bitmap
  if savedialog2.Execute then begin
    S := savedialog2.FileName;
    FileExt := AnsiUpperCase(ExtractFileExt(S));
    if (FileExt <> '.TXT') then S := S + '.txt';
    if FileExists(S) then
      if MessageDlg(S+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then exit;

    if (internalMatrixSubIndex <> 2) then begin
        k := 0;
        for i:=1 to StringGrid1.RowCount-1 do
            if factorsform.itemmask[i] then k:= k+1;
        if (k=0) then begin
            showmessage('The matrix has no active items. File can not be saved.');
            exit;
        end;
    end;
    if (internalMatrixSubIndex <> 1) then begin
        k := 0;
        for j:=1 to StringGrid1.ColCount-1 do
          if factorsform.varmask[j] then k:= k+1;
        if (k=0) then begin
            showmessage('The matrix has no active variables. File can not be saved.');
            exit;
        end;
    end;
    // Now save the file
    Save_Cursor := Screen.Cursor;
    Screen.Cursor := crHourGlass;    { Show hourglass cursor }
    assignfile(txt,S);
    filemode:=1;
    rewrite(txt);
    for i:= 0 to StringGrid1.RowCount-1 do begin
        if ((internalMatrixSubIndex <> 2) and (i <> 0) and (not itemmask[i])) then continue;
        flag:= true;
        for j:= 0 to StringGrid1.ColCount-1 do begin
           if ((internalMatrixSubIndex = 2) and (j = 0)) then continue;
           if ((internalMatrixSubIndex <> 1) and (j <> 0) and (not factorsform.varmask[j])) then continue;
            if ((i=0) and (j=0) and (numberofrowheaders^ = 0)) then
              write(txt,'ItemsHeader',#9)
            else begin
              if (not flag) then
                 write(txt,#9, StringGrid1.Cells[j,i])
              else
                 write(txt, StringGrid1.Cells[j,i]);
              flag := false;
            end;
        end;
        writeln(txt);
    end;
    closefile(txt);
    Screen.Cursor := Save_Cursor;  { Always restore to normal }
  end;
end;

end.
