/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.TreeLayoutAlgorithm;

public class TreeLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    protected TreeLayoutAlgorithm layout;
    private JComboBox alignmentCombo = new JComboBox<Object>(new Object[]{"Top", "Center", "Bottom"});
    private JComboBox orientationCombo = new JComboBox<Object>(new Object[]{"North", "East", "South", "West"});
    private JTextField nodeDistanceTextField = new JTextField();
    private JTextField levelDistanceTextField = new JTextField();

    public TreeLayoutSettings(TreeLayoutAlgorithm treeLayoutAlgorithm) {
        this.layout = treeLayoutAlgorithm;
        JPanel jPanel = new JPanel(new GridLayout(4, 2, 4, 4));
        jPanel.add(new JLabel("Alignment"));
        jPanel.add(this.alignmentCombo);
        jPanel.add(new JLabel("Orientation"));
        jPanel.add(this.orientationCombo);
        jPanel.add(new JLabel("Node Distance"));
        jPanel.add(this.nodeDistanceTextField);
        jPanel.add(new JLabel("Level Distance"));
        jPanel.add(this.levelDistanceTextField);
        this.add((Component)jPanel, "Center");
        this.revert();
    }

    public void revert() {
        this.setAlignment(this.layout.getAlignment());
        this.setOrientation(this.layout.getOrientation());
        this.nodeDistanceTextField.setText(String.valueOf(this.layout.getNodeDistance()));
        this.levelDistanceTextField.setText(String.valueOf(this.layout.getLevelDistance()));
    }

    private void check() {
        try {
            Integer.parseInt(this.nodeDistanceTextField.getText());
            Integer.parseInt(this.levelDistanceTextField.getText());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void apply() {
        this.check();
        this.layout.setAlignment(this.getAlignment());
        this.layout.setOrientation(this.getOrientation());
        this.layout.setNodeDistance(Integer.parseInt(this.nodeDistanceTextField.getText()));
        this.layout.setLevelDistance(Integer.parseInt(this.levelDistanceTextField.getText()));
    }

    public int getAlignment() {
        int n = 1;
        switch (this.alignmentCombo.getSelectedIndex()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        return n;
    }

    public void setAlignment(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
            }
        }
        this.alignmentCombo.setSelectedIndex(n2);
    }

    public int getOrientation() {
        int n = 1;
        switch (this.orientationCombo.getSelectedIndex()) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 7;
            }
        }
        return n;
    }

    public void setOrientation(int n) {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
            }
        }
        this.orientationCombo.setSelectedIndex(n2);
    }
}

