/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Rectangle2D;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;

public class JGraphImageMapEncoder {
    public static boolean isURL(Object object) {
        return object != null && (object.toString().startsWith("http:") || object.toString().startsWith("mailto:") || object.toString().startsWith("ftp:") || object.toString().startsWith("telnet:") || object.toString().startsWith("gopher:") || object.toString().startsWith("file:") || object.toString().startsWith("https:") || object.toString().startsWith("webdav:") || object.toString().startsWith("webdavs:"));
    }

    public String getURL(JGraph jGraph, Object object) {
        String string = this.getLabel(jGraph, object);
        if (JGraphImageMapEncoder.isURL(string)) {
            return string.toString();
        }
        return "";
    }

    public String getLabel(JGraph jGraph, Object object) {
        return jGraph.convertValueToString((Object)object.toString());
    }

    public String encode(JGraph jGraph, String string) {
        if (jGraph.getModel().getRootCount() > 0) {
            String string2 = "<map NAME=\"" + string + "\">\n";
            Rectangle2D rectangle2D = jGraph.getCellBounds(jGraph.getRoots());
            Object[] objectArray = DefaultGraphModel.getAll((GraphModel)jGraph.getModel());
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = this.getLabel(jGraph, objectArray[i]);
                String string4 = this.getURL(jGraph, objectArray[i]);
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(objectArray[i], false);
                if (cellView == null || string4 == null || string4.length() <= 0) continue;
                Rectangle2D rectangle2D2 = jGraph.toScreen((Rectangle2D)cellView.getBounds().clone());
                rectangle2D2.setFrame(rectangle2D2.getX() - rectangle2D.getX() + 5.0, rectangle2D2.getY() - rectangle2D.getY() + 5.0, rectangle2D2.getWidth(), rectangle2D2.getHeight());
                String string5 = (int)rectangle2D2.getX() + "," + (int)rectangle2D2.getY() + "," + (int)(rectangle2D2.getX() + rectangle2D2.getWidth()) + "," + (int)(rectangle2D2.getY() + rectangle2D2.getHeight());
                String string6 = "rect";
                String string7 = "<area shape=" + string6 + " coords=\"" + string5 + "\" href=\"" + string4 + "\" alt=\"" + string3 + "\">\n";
                string2 = string2 + string7;
            }
            string2 = string2 + "</map>";
            return string2;
        }
        return null;
    }
}

