/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static transient EdgeRenderer renderer = new EdgeRenderer();
    protected transient List points;
    protected transient CellView source;
    protected transient CellView target;
    protected transient Point labelPosition;
    protected transient Point[] extraLabelPositions;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected transient Rectangle2D cachedLabelBounds = null;
    protected transient Rectangle2D[] cachedExtraLabelBounds = null;
    protected transient Rectangle2D cachedBounds = null;

    public EdgeView() {
    }

    public EdgeView(Object object) {
        super(object);
    }

    public void refresh(GraphModel graphModel, CellMapper cellMapper, boolean bl) {
        super.refresh(graphModel, cellMapper, bl);
        Object object = graphModel.getSource(this.cell);
        Object object2 = graphModel.getTarget(this.cell);
        this.setSource(cellMapper.getMapping(object, bl));
        this.setTarget(cellMapper.getMapping(object2, bl));
    }

    public void update() {
        Edge.Routing routing;
        super.update();
        this.points = GraphConstants.getPoints(this.allAttributes);
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        Point[] pointArray = GraphConstants.getExtraLabelPositions(this.allAttributes);
        if (pointArray != null) {
            this.extraLabelPositions = new Point[pointArray.length];
            for (int i = 0; i < pointArray.length; ++i) {
                this.extraLabelPositions[i] = pointArray[i];
            }
        } else {
            this.extraLabelPositions = null;
        }
        if ((routing = GraphConstants.getRouting(this.allAttributes)) != null) {
            routing.route(this, this.points);
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.invalidate();
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
        this.cachedExtraLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public Rectangle2D getLabelBounds() {
        if (this.cachedLabelBounds != null) {
            return this.cachedLabelBounds;
        }
        this.cachedLabelBounds = this.getEdgeRenderer().getLabelBounds(null, this);
        return this.cachedLabelBounds;
    }

    public Rectangle2D getExtraLabelBounds(int n) {
        if (this.cachedLabelBounds != null && n < this.cachedExtraLabelBounds.length && this.cachedExtraLabelBounds[n] != null) {
            return this.cachedExtraLabelBounds[n];
        }
        this.cachedExtraLabelBounds[n] = this.getEdgeRenderer().getExtraLabelBounds(this, n);
        return this.cachedExtraLabelBounds[n];
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        if (!this.isLeaf()) {
            return super.intersects(jGraph, rectangle2D);
        }
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.getEdgeRenderer().intersects(jGraph, this, rectangle);
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = super.getBounds();
        if (rectangle2D == null) {
            if (this.cachedBounds == null) {
                this.cachedBounds = this.getEdgeRenderer().getBounds(this);
            }
            rectangle2D = this.cachedBounds;
        }
        return rectangle2D;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView cellView) {
        this.source = cellView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point2D getExtraLabelPosition(int n) {
        return this.extraLabelPositions[n];
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D point2D) {
        this.labelPosition.setLocation(point2D);
        this.invalidate();
    }

    public void setExtraLabelPosition(int n, Point2D point2D) {
        this.extraLabelPositions[n].setLocation(point2D);
        this.invalidate();
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int n) {
        Object e = this.points.get(n);
        if (e instanceof PortView) {
            return ((PortView)e).getLocation(this);
        }
        if (e instanceof CellView) {
            Rectangle2D rectangle2D = ((CellView)e).getBounds();
            return this.getAttributes().createPoint(rectangle2D.getX(), rectangle2D.getY());
        }
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        return null;
    }

    public void setPoint(int n, Point2D point2D) {
        this.points.set(n, point2D);
        this.invalidate();
    }

    public void addPoint(int n, Point2D point2D) {
        this.points.add(n, point2D);
        this.invalidate();
    }

    public void removePoint(int n) {
        this.points.remove(n);
        this.invalidate();
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point2D point2D = null;
            Point2D point2D2 = null;
            for (int i = 0; i < edgeView.getPointCount(); ++i) {
                point2D2 = edgeView.getPoint(i);
                if (point2D != null) {
                    d += point2D.distance(point2D2);
                }
                point2D = point2D2;
            }
        }
        return d;
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected int currentLabel = -1;
        protected int currentIndex = -1;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D[] extraLabelLocations;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edgeView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView;
            this.loc = new Rectangle();
            Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
            if (objectArray != null) {
                this.extraLabelLocations = new Rectangle[objectArray.length];
                for (int i = 0; i < this.extraLabelLocations.length; ++i) {
                    this.extraLabelLocations[i] = new Rectangle();
                }
            }
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edgeView.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle();
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            if (!this.edge.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                if (this.isEdgeConnectable) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView cellView = null;
                if (i == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView == null) continue;
                graphics.setColor(this.graph.getLockedHandleColor());
                Point2D point2D = GraphConstants.getOffset(cellView.getAllAttributes());
                if (point2D != null) {
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    continue;
                }
                graphics.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
            }
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall && this.edge.isLeaf()) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground().darker());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
            int n = 3;
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
            this.graph.getUI().paintCell(graphics, cellView, rectangle2D, true);
        }

        protected boolean snap(boolean bl, Point2D point2D) {
            CellView cellView;
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Object object = this.graph.getPortForLocation(point2D.getX(), point2D.getY());
            if (object != null && bl2 && GraphConstants.isConnectable((cellView = this.graph.getGraphLayoutCache().getMapping(object, false)).getParentView().getAllAttributes())) {
                Object object2 = this.edge.getCell();
                if (bl && this.graph.getModel().acceptsSource(object2, object)) {
                    if (this.edge.getSource() != cellView) {
                        this.overlay(this.graph.getGraphics());
                        this.edge.setSource(cellView);
                        this.edge.update();
                        this.overlay(this.graph.getGraphics());
                    }
                    return true;
                }
                if (!bl && this.graph.getModel().acceptsTarget(object2, object)) {
                    if (this.edge.getTarget() != cellView) {
                        this.overlay(this.graph.getGraphics());
                        this.edge.setTarget(cellView);
                        this.edge.update();
                        this.overlay(this.graph.getGraphics());
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent mouseEvent) {
            return SwingUtilities.isRightMouseButton(mouseEvent);
        }

        public boolean isRemovePointEvent(MouseEvent mouseEvent) {
            return SwingUtilities.isRightMouseButton(mouseEvent);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentLabel >= 0 || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            for (n = 0; n < this.r.length; ++n) {
                if (!this.r[n].contains(mouseEvent.getPoint())) continue;
                this.graph.setCursor(new Cursor(1));
                mouseEvent.consume();
                return;
            }
            if (this.loc.contains(mouseEvent.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
            if (this.extraLabelLocations != null && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    if (!this.extraLabelLocations[n].contains(mouseEvent.getPoint())) continue;
                    this.graph.setCursor(new Cursor(12));
                    mouseEvent.consume();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D;
            int n;
            if (!this.edge.isLeaf()) {
                return;
            }
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            boolean bl2 = this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = 0;
            for (n4 = 0; n4 < this.r.length; ++n4) {
                if (!this.r[n4].contains(n2, n3)) continue;
                this.currentPoint = this.edge.getPoint(n4);
                this.currentIndex = n4;
                this.source = n4 == 0 && (this.edge.getSource() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                this.target = n4 == this.r.length - 1 && (this.edge.getTarget() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                break;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n2, n3) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                this.label = true;
            } else if (this.extraLabelLocations != null && !this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    if (this.extraLabelLocations[n] == null || !this.extraLabelLocations[n].contains(n2, n3)) continue;
                    this.currentLabel = n;
                    break;
                }
            }
            if (this.isRemovePointEvent(mouseEvent) && this.currentPoint != null && !this.source && !this.target && bl) {
                this.edge.removePoint(n4);
                this.mouseReleased(mouseEvent);
            } else if (this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl && this.edge.intersects(this.graph, rectangle2D = this.graph.fromScreen(new Rectangle(n2 - (n = this.graph.getHandleSize()), n3 - n, 2 * n, 2 * n)))) {
                Point2D point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                double d = Double.MAX_VALUE;
                double d2 = 0.0;
                for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                    Point2D point2D2;
                    Point2D point2D3 = this.edge.getPoint(i);
                    d2 = new Line2D.Double(point2D3, point2D2 = this.edge.getPoint(i + 1)).ptLineDistSq(point2D);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n4 = i + 1;
                }
                this.edge.addPoint(n4, point2D);
                this.currentPoint = point2D;
                this.reloadPoints(this.edge);
                this.paint(this.graph.getGraphics());
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point2D point2D = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.label || this.currentLabel >= 0) {
                Rectangle2D rectangle2D = this.edge.getBounds();
                if (rectangle2D != null) {
                    Point2D point2D2 = this.edge.getPoint(0);
                    Point2D point2D3 = this.edge.getPoint(this.edge.getPointCount() - 1);
                    double d = point2D.getX() - rectangle2D.getX();
                    if (point2D2.getX() > point2D3.getX()) {
                        d = rectangle2D.getX() + rectangle2D.getWidth() - point2D.getX();
                    }
                    double d2 = point2D.getY() - rectangle2D.getY();
                    if (point2D2.getY() > point2D3.getY()) {
                        d2 = rectangle2D.getY() + rectangle2D.getHeight() - point2D.getY();
                    }
                    double d3 = 1.0;
                    if (rectangle2D.getWidth() != 0.0) {
                        d3 = 1000.0 / rectangle2D.getWidth();
                    }
                    double d4 = 1.0;
                    if (rectangle2D.getHeight() != 0.0) {
                        d4 = 1000.0 / rectangle2D.getHeight();
                    }
                    point2D = new Point2D.Double(d * d3, d2 * d4);
                    this.overlay(this.graph.getGraphics());
                    if (this.label) {
                        this.edge.setLabelPosition(point2D);
                    } else {
                        this.edge.setExtraLabelPosition(this.currentLabel, point2D);
                    }
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (!(!this.isEditing() || this.source && this.snap(true, mouseEvent.getPoint()) || this.target && this.snap(false, mouseEvent.getPoint()))) {
                boolean bl;
                boolean bl2 = this.source && (this.graph.getModel().acceptsSource(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                boolean bl3 = bl = this.target && (this.graph.getModel().acceptsTarget(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                if (bl2 || bl || !this.source && !this.target) {
                    this.overlay(this.graph.getGraphics());
                    point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                    if (this.isConstrainedMoveEvent(mouseEvent) && this.currentIndex >= 0) {
                        EdgeView edgeView = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                        Point2D point2D4 = edgeView.getPoint(this.currentIndex);
                        double d = point2D.getX() - point2D4.getX();
                        double d5 = point2D.getY() - point2D4.getY();
                        if (Math.abs(d) < Math.abs(d5)) {
                            point2D.setLocation(point2D4.getX(), point2D.getY());
                        } else {
                            point2D.setLocation(point2D.getX(), point2D4.getY());
                        }
                    }
                    point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                    this.currentPoint.setLocation(point2D);
                    if (this.source) {
                        this.edge.setPoint(0, point2D);
                        this.edge.setSource(null);
                    } else if (this.target) {
                        this.edge.setPoint(this.edge.getPointCount() - 1, point2D);
                        this.edge.setTarget(null);
                    }
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            boolean bl = mouseEvent.isControlDown() && this.graph.isCloneable();
            GraphModel graphModel = this.graph.getModel();
            Object object2 = this.edge.getSource() != null ? this.edge.getSource().getCell() : null;
            Object object3 = object = this.edge.getTarget() != null ? this.edge.getTarget().getCell() : null;
            if (graphModel.acceptsSource(this.edge.getCell(), object2) && graphModel.acceptsTarget(this.edge.getCell(), object)) {
                ConnectionSet connectionSet = this.createConnectionSet(this.edge, this.edge.getCell(), bl);
                Map map = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
                if (bl) {
                    Map map2 = this.graph.cloneCells(this.graph.getDescendants(new Object[]{this.edge.getCell()}));
                    map = GraphConstants.replaceKeys(map2, map);
                    connectionSet = connectionSet.clone(map2);
                    Object[] objectArray = map2.values().toArray();
                    this.graph.getGraphLayoutCache().insert(objectArray, map, connectionSet, null, null);
                } else {
                    this.graph.getGraphLayoutCache().edit(map, connectionSet, null, null);
                }
            } else {
                this.overlay(this.graph.getGraphics());
            }
            this.currentPoint = null;
            this.label = false;
            this.currentLabel = -1;
            this.currentIndex = -1;
            this.firstOverlayCall = true;
            mouseEvent.consume();
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, Object object, boolean bl) {
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != this.graph.getModel().getSource(object)) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != this.graph.getModel().getTarget(object)) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            Point2D point2D;
            Dimension dimension;
            Point2D point2D2;
            int n;
            EdgeView edgeView = this.relevantEdge;
            int n2 = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = (EdgeRenderer)this.edge.getRenderer();
            for (n = 0; n < this.r.length; ++n) {
                point2D2 = this.graph.toScreen(this.edge.getAttributes().createPoint(edgeView.getPoint(n)));
                this.r[n].setFrame(point2D2.getX() - (double)n2, point2D2.getY() - (double)n2, 2 * n2, 2 * n2);
                point2D2 = this.graph.toScreen((Point2D)edgeRenderer.getLabelPosition(edgeView).clone());
                dimension = edgeRenderer.getLabelSize(this.graph.convertValueToString(edgeView), edgeView);
                if (point2D2 == null || dimension == null) continue;
                point2D = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                this.loc.setFrame(point2D2.getX() - point2D.getX() / 2.0, point2D2.getY() - point2D.getY() / 2.0, point2D.getX(), point2D.getY());
            }
            if (this.extraLabelLocations != null) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    point2D2 = edgeRenderer.getExtraLabelPosition(edgeView, n);
                    if (point2D2 == null) continue;
                    point2D2 = this.graph.toScreen((Point2D)point2D2.clone());
                    dimension = edgeRenderer.getExtraLabelSize(edgeView, n);
                    if (dimension == null) continue;
                    point2D = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                    this.extraLabelLocations[n].setFrame(point2D2.getX() - point2D.getX() / 2.0, point2D2.getY() - point2D.getY() / 2.0, point2D.getX(), point2D.getY());
                }
            }
        }
    }
}

