/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;

public class GraphContext
implements CellMapper {
    protected JGraph graph;
    protected transient GraphLayoutCache graphLayoutCache;
    protected Object[] cells;
    protected Set allCells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph jGraph, Object[] objectArray) {
        GraphModel graphModel = jGraph.getModel();
        this.allCells = new HashSet(DefaultGraphModel.getDescendants(graphModel, objectArray));
        this.graphLayoutCache = jGraph.getGraphLayoutCache();
        this.graph = jGraph;
        this.cells = objectArray;
        this.cellSet = new HashSet();
        Iterator iterator = this.allCells.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.graphLayoutCache.isVisible(e)) continue;
            this.cellSet.add(e);
            if (graphModel.isPort(e)) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object object) {
        return this.cellSet.contains(object);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViewArray = new CellView[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            cellViewArray[i] = this.getMapping(this.cells[i], true);
        }
        return cellViewArray;
    }

    public CellView[] createTemporaryPortViews() {
        Object object;
        GraphModel graphModel = this.graph.getModel();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Iterator iterator = this.allCells.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!graphModel.isPort(object) || !this.graph.getGraphLayoutCache().isVisible(object)) continue;
            arrayList.add(this.getMapping(object, true));
        }
        object = new PortView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set set) {
        Object object;
        Object[] objectArray = set.toArray();
        Set set2 = DefaultGraphModel.getEdges(this.graph.getModel(), objectArray);
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            CellView cellView = this.graphLayoutCache.getMapping(object, false);
            if (set.contains(object) || !this.graphLayoutCache.isVisible(object) || cellView == null || !cellView.isLeaf()) continue;
            arrayList.add(this.createMapping(object));
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object != null) {
            CellView cellView = (CellView)this.views.get(object);
            if (cellView != null) {
                return cellView;
            }
            if (this.contains(object)) {
                return this.createMapping(object);
            }
            return this.graphLayoutCache.getMapping(object, false);
        }
        return null;
    }

    public CellView createMapping(Object object) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        CellView cellView2 = this.graphLayoutCache.getFactory().createView(this.graph.getModel(), object);
        this.putMapping(object, cellView2);
        cellView2.refresh(this.graph.getModel(), this, true);
        cellView2.update();
        if (cellView != null) {
            cellView2.changeAttributes((AttributeMap)cellView.getAllAttributes().clone());
            cellView2.refresh(this.graph.getModel(), this, false);
        }
        return cellView2;
    }

    public ConnectionSet disconnect(CellView[] cellViewArray) {
        ConnectionSet connectionSet = new ConnectionSet();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)cellViewArray[i];
            CellView cellView = edgeView.getSource();
            if (!GraphConstants.isDisconnectable(edgeView.getAllAttributes())) continue;
            if (cellView != null && GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) && !this.contains(cellView.getCell())) {
                edgeView.setSource(null);
                connectionSet.disconnect(edgeView.getCell(), true);
            }
            if ((cellView = edgeView.getTarget()) == null || !GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) || this.contains(cellView.getCell())) continue;
            edgeView.setTarget(null);
            connectionSet.disconnect(edgeView.getCell(), false);
        }
        return connectionSet;
    }

    public void putMapping(Object object, CellView cellView) {
        this.views.put(object, cellView);
    }
}

