/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.VertexView;

public class PortView
extends AbstractCellView {
    public static transient int SIZE = 6;
    public static transient PortRenderer renderer = new PortRenderer();
    protected transient CellView lastParent;

    public PortView() {
    }

    public PortView(Object object) {
        super(object);
    }

    public CellView getParentView() {
        CellView cellView = super.getParentView();
        if (cellView == null) {
            cellView = this.lastParent;
        } else {
            this.lastParent = cellView;
        }
        return cellView;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.getAttributes().createRect(this.getLocation(null));
        if (rectangle2D != null) {
            rectangle2D.setFrame(rectangle2D.getX() - (double)(SIZE / 2), rectangle2D.getY() - (double)(SIZE / 2), rectangle2D.getWidth() + (double)SIZE, rectangle2D.getHeight() + (double)SIZE);
        }
        return rectangle2D;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return null;
    }

    public Point2D getLocation(EdgeView edgeView) {
        Port port = null;
        if (this.cell instanceof Port) {
            port = ((Port)this.cell).getAnchor();
        }
        VertexView vertexView = (VertexView)this.getParentView();
        Point2D point2D = null;
        if (vertexView != null) {
            PortView portView = null;
            Point2D point2D2 = GraphConstants.getOffset(this.allAttributes);
            if (edgeView == null && point2D2 == null) {
                point2D = vertexView.getCenterPoint();
            }
            if (point2D2 != null) {
                double d = point2D2.getX();
                double d2 = point2D2.getY();
                Rectangle2D rectangle2D = vertexView.getBounds();
                boolean bl = GraphConstants.isAbsoluteX(this.allAttributes);
                boolean bl2 = GraphConstants.isAbsoluteY(this.allAttributes);
                if (!bl) {
                    d = d * (rectangle2D.getWidth() - 1.0) / 1000.0;
                }
                if (!bl2) {
                    d2 = d2 * (rectangle2D.getHeight() - 1.0) / 1000.0;
                }
                point2D = portView != null ? portView.getLocation(edgeView) : this.getAttributes().createPoint(rectangle2D.getX(), rectangle2D.getY());
                point2D = this.getAttributes().createPoint(point2D.getX() + d, point2D.getY() + d2);
            } else if (edgeView != null) {
                Point2D point2D3 = this.getNextPoint(edgeView);
                if (point2D3 == null) {
                    return vertexView.getCenterPoint();
                }
                point2D = vertexView.getPerimeterPoint(point2D, point2D3);
                if (this.shouldInvokePortMagic(edgeView) && point2D3 != null) {
                    Rectangle2D rectangle2D = this.getParentView().getBounds();
                    if (point2D3.getX() > rectangle2D.getX() && point2D3.getX() < rectangle2D.getX() + rectangle2D.getWidth()) {
                        point2D.setLocation(point2D3.getX(), point2D.getY());
                    } else if (point2D3.getY() >= rectangle2D.getY() && point2D3.getY() < rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D.setLocation(point2D.getX(), point2D3.getY());
                    }
                    if (point2D3.getY() < rectangle2D.getY()) {
                        point2D.setLocation(point2D.getX(), rectangle2D.getY());
                    } else if (point2D3.getY() > rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D.setLocation(point2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
                    }
                }
            }
        }
        return point2D;
    }

    protected boolean shouldInvokePortMagic(EdgeView edgeView) {
        return edgeView.getPointCount() > 2 && GraphConstants.getRouting(edgeView.getAllAttributes()) == null && GraphConstants.getLineStyle(edgeView.getAllAttributes()) == 11;
    }

    protected Point2D getNextPoint(EdgeView edgeView) {
        int n = edgeView.getPointCount();
        if (n > 1) {
            if (edgeView.points.get(0) == this) {
                return this.getEdgePoint(edgeView, 1);
            }
            if (edgeView.points.get(n - 1) == this) {
                return this.getEdgePoint(edgeView, n - 2);
            }
        }
        return null;
    }

    protected Point2D getEdgePoint(EdgeView edgeView, int n) {
        VertexView vertexView;
        Object e = edgeView.points.get(n);
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        if (e instanceof PortView && (vertexView = (VertexView)((CellView)e).getParentView()) != null) {
            return vertexView.getCenterPoint();
        }
        return null;
    }
}

