/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.GEMLayoutSettings;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class GEMLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final String KEY_CAPTION = "GEM-TEMPORARY-DATA";
    public static final String KEY_TEMPERATURE = "Temperature";
    public static final String KEY_CURRENT_IMPULSE = "Current_Impulse";
    public static final String KEY_LAST_IMPULSE = "Last_Impulse";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_SKEWGAUGE = "Skew_Gauge";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String KEY_MASSINDEX = "Mass_Index";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    private ArrayList cellList;
    private ArrayList applyCellList;
    private ArrayList edgeList;
    private double equalsNull = 1.0E-17;
    protected double initTemperature = 10.0;
    protected double minTemperature = 3.0;
    protected double maxTemperature = 256.0;
    protected double prefEdgeLength = 100.0;
    protected double gravitation = 0.0625;
    protected double randomImpulseRange = 32.0;
    protected double alphaOsc = Math.toRadians(90.0);
    protected double alphaRot = Math.toRadians(60.0);
    protected double sigmaOsc = 0.3333333333333333;
    protected double sigmaRot = 0.5;
    private int maxRounds;
    private int countRounds;
    private int recursionDepth;
    private double overlapDetectWidth;
    private double overlapPrefDistance;
    private boolean avoidOverlapping;
    private String layoutUpdateMethod;
    private boolean shouldEndPerAverage;
    private boolean shouldComputePermutation;
    private boolean isActive = true;
    private boolean isRunning = false;
    private JGraph jgraph;
    protected Properties config;
    protected static final int VALUES_PUR = 0;
    protected static final int VALUES_INC = 1;
    private AnnealingLayoutAlgorithm optimizationAlgorithm;
    private boolean useOptimizeAlgorithm;
    private Properties optimizationAlgorithmConfig;
    private boolean isClusteringEnabled;
    private double clusterInitTemperature;
    private double clusterForceScalingFactor;
    private double clusteringFactor;
    private double perimeterInitSize;
    private double perimeterSizeInc;
    private boolean isDebugging = false;

    public GEMLayoutAlgorithm(AnnealingLayoutAlgorithm annealingLayoutAlgorithm) {
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.optimizationAlgorithm = annealingLayoutAlgorithm;
    }

    public String toString() {
        return "GEM";
    }

    public String getHint() {
        return "Ignores selection";
    }

    public JGraphLayoutSettings createSettings() {
        return new GEMLayoutSettings(this);
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        this.isRunning = true;
        this.jgraph = jGraph;
        this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.getNodes(this.jgraph, objectArray);
        long l = System.currentTimeMillis();
        boolean bl = this.initialize();
        if (!bl) {
            bl = this.calculate();
        }
        if (!bl && this.useOptimizeAlgorithm) {
            this.optimizationAlgorithm.performOptimization(this.applyCellList, this.cellList, this.edgeList, this.optimizationAlgorithmConfig);
        }
        if (!bl) {
            this.correctCoordinates();
        }
        if (!bl) {
            bl = this.setNewCoordinates(this.jgraph);
        }
        this.removeTemporaryLayoutDataFromCells();
        this.isRunning = false;
    }

    protected void loadRuntimeValues(int n) {
        this.maxRounds = this.applyCellList.size() * 4;
        this.countRounds = 0;
        this.isActive = this.isTrue((String)this.config.get("Layout Update enabled"));
        this.recursionDepth = Integer.parseInt((String)this.config.get("Layout Update depth"));
        this.layoutUpdateMethod = (String)this.config.get("Layout Update method");
        if (n == 0) {
            this.initTemperature = Double.parseDouble((String)this.config.get("init temperature"));
            this.minTemperature = Double.parseDouble((String)this.config.get("min temperature"));
            this.maxTemperature = Double.parseDouble((String)this.config.get("max temperature"));
            this.prefEdgeLength = Double.parseDouble((String)this.config.get("preferred Edge length"));
            this.gravitation = Double.parseDouble((String)this.config.get("gravitation to barycenter"));
            this.randomImpulseRange = Double.parseDouble((String)this.config.get("random impulse range"));
            this.overlapDetectWidth = Double.parseDouble((String)this.config.get("overlapping detection width"));
            this.overlapPrefDistance = Double.parseDouble((String)this.config.get("overlapping preferred distance"));
            this.shouldEndPerAverage = this.isTrue((String)this.config.get("compute permutation"));
            this.shouldComputePermutation = this.isTrue((String)this.config.get("end condition average"));
            this.avoidOverlapping = this.isTrue((String)this.config.get("avoid overlapping"));
            this.alphaOsc = Double.parseDouble((String)this.config.get("alpha oscillation"));
            this.alphaRot = Double.parseDouble((String)this.config.get("alpha rotation"));
            this.sigmaOsc = Double.parseDouble((String)this.config.get("sigma oscillation"));
            this.sigmaRot = Double.parseDouble((String)this.config.get("sigma rotation"));
            this.useOptimizeAlgorithm = this.isTrue((String)this.config.get("optimization algorithm enabled"));
            this.optimizationAlgorithmConfig = (Properties)this.config.get("optimization algorithm configuration");
        } else if (n == 1) {
            this.initTemperature = Double.parseDouble((String)this.config.get("Layout Update init temperature"));
            this.minTemperature = Double.parseDouble((String)this.config.get("Layout Update min temperature"));
            this.maxTemperature = Double.parseDouble((String)this.config.get("Layout Update max temperature"));
            this.prefEdgeLength = Double.parseDouble((String)this.config.get("Layout Update preferred Edge length"));
            this.gravitation = Double.parseDouble((String)this.config.get("Layout Update gravitation to barycenter"));
            this.randomImpulseRange = Double.parseDouble((String)this.config.get("Layout Update random impulse range"));
            this.overlapDetectWidth = Double.parseDouble((String)this.config.get("Layout Update overlapping detection width"));
            this.overlapPrefDistance = Double.parseDouble((String)this.config.get("Layout Update overlapping preferred distance"));
            this.shouldEndPerAverage = this.isTrue((String)this.config.get("Layout Update compute permutation"));
            this.shouldComputePermutation = this.isTrue((String)this.config.get("Layout Update end condition average"));
            this.avoidOverlapping = this.isTrue((String)this.config.get("Layout Update avoid overlapping"));
            this.alphaOsc = Double.parseDouble((String)this.config.get("Layout Update alpha rotation"));
            this.alphaRot = Double.parseDouble((String)this.config.get("Layout Update alpha oscillation"));
            this.sigmaOsc = Double.parseDouble((String)this.config.get("Layout Update sigma rotation"));
            this.sigmaRot = Double.parseDouble((String)this.config.get("Layout Update sigma oscillation"));
            this.useOptimizeAlgorithm = this.isTrue((String)this.config.get("Layout Update optimization algorithm enabled"));
            this.optimizationAlgorithmConfig = (Properties)this.config.get("Layout Update optimization algorithm configuration");
            this.perimeterInitSize = Double.parseDouble((String)this.config.get("Layout Update method perimeter initial size"));
            this.perimeterSizeInc = Double.parseDouble((String)this.config.get("Layout Update method perimeter size increase value"));
            this.isClusteringEnabled = this.isTrue((String)this.config.get("clustering enabled"));
            this.clusterInitTemperature = Double.parseDouble((String)this.config.get("cluster init temperature"));
            this.clusterForceScalingFactor = Double.parseDouble((String)this.config.get("clustering force scaling factor"));
            this.clusteringFactor = Double.parseDouble((String)this.config.get("cluster size factor"));
        }
        this.sigmaRot *= 1.0 / (double)(this.applyCellList.size() == 0 ? 1 : this.applyCellList.size());
    }

    protected boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jGraph, Object[] objectArray) {
        int n;
        Object[] objectArray2 = jGraph.getRoots();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray2, false);
        CellView[] cellViewArray2 = jGraph.getGraphLayoutCache().getMapping(objectArray, false);
        for (n = 0; n < cellViewArray.length; ++n) {
            if (cellViewArray[n] instanceof VertexView) {
                this.cellList.add(cellViewArray[n]);
                this.applyCellList.add(cellViewArray[n]);
                continue;
            }
            if (!(cellViewArray[n] instanceof EdgeView)) continue;
            this.edgeList.add(cellViewArray[n]);
        }
        for (n = 0; n < cellViewArray2.length; ++n) {
            if (!(cellViewArray2[n] instanceof VertexView)) continue;
            this.applyCellList.add(cellViewArray2[n]);
        }
    }

    private boolean initialize() {
        int n;
        int n2 = this.cellList.size();
        for (n = 0; n < n2; ++n) {
            CellView cellView = (CellView)this.cellList.get(n);
            this.initializeVertice(cellView);
        }
        for (n = 0; n < this.applyCellList.size(); ++n) {
            this.computeLastImpulse((CellView)this.applyCellList.get(n));
        }
        return false;
    }

    private void initializeVertice(CellView cellView) {
        Object object = cellView.getAttributes();
        if (object == null) {
            object = new Hashtable();
        }
        object.put(KEY_CAPTION, KEY_CAPTION);
        this.initPosition(cellView);
        if (this.isCluster(cellView)) {
            object.put(KEY_TEMPERATURE, new Double(this.clusterInitTemperature));
        } else {
            object.put(KEY_TEMPERATURE, new Double(this.initTemperature));
        }
        object.put(KEY_SKEWGAUGE, new Double(0.0));
        object.put(KEY_CURRENT_IMPULSE, new Point2D.Double());
        object.put(KEY_LAST_IMPULSE, new Point2D.Double());
    }

    private boolean calculate() {
        int n;
        int n2 = this.applyCellList.size();
        int[] nArray = new int[n2];
        boolean bl = false;
        if (!this.shouldComputePermutation) {
            for (n = 0; n < n2; ++n) {
                nArray[n] = n;
            }
        }
        while (!this.isFrozen() && this.countRounds <= this.maxRounds && !bl) {
            if (this.shouldComputePermutation) {
                nArray = this.createPermutation(n2);
            }
            for (n = 0; n < nArray.length; ++n) {
                CellView cellView = (CellView)this.applyCellList.get(nArray[n]);
                this.computeCurrentImpulse(cellView);
                this.updatePosAndTemp(cellView);
            }
            ++this.countRounds;
        }
        return false;
    }

    private void computeCurrentImpulse(CellView cellView) {
        Point2D.Double double_ = this.computeImpulse(cellView);
        cellView.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)double_);
    }

    private void computeLastImpulse(CellView cellView) {
        Point2D.Double double_ = this.computeImpulse(cellView);
        cellView.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)double_);
    }

    private Point2D.Double computeImpulse(CellView cellView) {
        int n;
        Cloneable cloneable;
        double d;
        double d2;
        Cloneable cloneable2;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = this.getPosition(cellView);
        boolean bl = this.isCluster(cellView);
        double d3 = this.getNodeWeight(cellView);
        Point2D.Double double_3 = this.computeBarycenter(this.cellList);
        Point2D.Double double_4 = new Point2D.Double((double_3.getX() - double_2.getX()) * this.gravitation * d3, (double_3.getY() - double_2.getY()) * this.gravitation * d3);
        Point2D.Double double_5 = this.getRandomVector(this.randomImpulseRange);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (int i = 0; i < this.cellList.size(); ++i) {
            if (this.cellList.get(i) == cellView) continue;
            cloneable2 = this.getPosition(i, this.cellList);
            double d4 = double_2.getX() - ((Point2D.Double)cloneable2).getX();
            d = AnnealingLayoutAlgorithm.MathExtensions.abs(d4, d2 = double_2.getY() - ((Point2D.Double)cloneable2).getY());
            if (!(d > this.equalsNull)) continue;
            arrayList.add(new Point2D.Double(d4 * (this.prefEdgeLength * this.prefEdgeLength / (d * d)), d2 * (this.prefEdgeLength * this.prefEdgeLength / (d * d))));
        }
        ArrayList arrayList2 = this.getRelativesFrom(this.cellList, cellView);
        cloneable2 = new ArrayList(arrayList2.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            cloneable = this.getPosition(i, arrayList2);
            d2 = double_2.getX() - ((Point2D.Double)cloneable).getX();
            d = double_2.getY() - ((Point2D.Double)cloneable).getY();
            double d5 = AnnealingLayoutAlgorithm.MathExtensions.abs(d2, d);
            ((ArrayList)cloneable2).add(new Point2D.Double(d2 * (d5 * d5 / (this.prefEdgeLength * this.prefEdgeLength * d3)), d * (d5 * d5 / (this.prefEdgeLength * this.prefEdgeLength * d3))));
        }
        ArrayList<Point2D.Double> arrayList3 = new ArrayList<Point2D.Double>();
        if (this.avoidOverlapping) {
            cloneable = new Rectangle((int)double_2.x, (int)double_2.y, (int)cellView.getBounds().getWidth(), (int)cellView.getBounds().getHeight());
            Rectangle rectangle = new Rectangle((int)(((Rectangle)cloneable).getX() - this.overlapDetectWidth), (int)(((Rectangle)cloneable).getY() - this.overlapDetectWidth), (int)(((Rectangle)cloneable).getWidth() + 2.0 * this.overlapDetectWidth), (int)(((Rectangle)cloneable).getHeight() + 2.0 * this.overlapDetectWidth));
            for (int i = 0; i < this.cellList.size(); ++i) {
                Point2D.Double double_6 = this.getPosition(i, this.cellList);
                Rectangle rectangle2 = new Rectangle((int)double_6.x, (int)double_6.y, (int)((CellView)this.cellList.get(i)).getBounds().getWidth(), (int)((CellView)this.cellList.get(i)).getBounds().getHeight());
                if (cellView == this.cellList.get(i) || !rectangle.intersects(rectangle2)) continue;
                Dimension dimension = ((Rectangle)cloneable).getSize();
                Dimension dimension2 = rectangle2.getSize();
                double d6 = Math.max(dimension.getWidth(), dimension.getHeight()) / 2.0 + Math.max(dimension2.getWidth(), dimension2.getHeight()) / 2.0 + this.overlapPrefDistance;
                double d7 = double_2.x - double_6.x;
                double d8 = double_2.y - double_6.y;
                if (d7 < this.equalsNull && d7 >= 0.0) {
                    d7 = this.equalsNull;
                } else if (d7 > -this.equalsNull && d7 <= 0.0) {
                    d7 = -this.equalsNull;
                }
                if (d8 < this.equalsNull && d8 >= 0.0) {
                    d8 = this.equalsNull;
                } else if (d8 > -this.equalsNull && d8 <= 0.0) {
                    d8 = -this.equalsNull;
                }
                double d9 = AnnealingLayoutAlgorithm.MathExtensions.abs(d7, d8);
                Point2D.Double double_7 = new Point2D.Double(d7 * (d6 * d6) / (d9 * d9), d8 * (d6 * d6) / (d9 * d9));
                arrayList3.add(double_7);
            }
        }
        cloneable = this.getAdditionalForces((VertexView)cellView);
        double_ = this.add(double_, double_4);
        double_ = this.add(double_, double_5);
        for (n = 0; n < arrayList.size(); ++n) {
            double_ = this.add(double_, (Point2D.Double)arrayList.get(n));
        }
        for (n = 0; n < ((ArrayList)cloneable2).size(); ++n) {
            double_ = this.sub(double_, (Point2D.Double)((ArrayList)cloneable2).get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            double_ = this.add(double_, (Point2D.Double)arrayList3.get(n));
        }
        for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
            double_ = this.add(double_, (Point2D.Double)((ArrayList)cloneable).get(n));
        }
        return double_;
    }

    private void updatePosAndTemp(CellView cellView) {
        Point2D.Double double_ = (Point2D.Double)cellView.getAttributes().get((Object)KEY_CURRENT_IMPULSE);
        Point2D.Double double_2 = (Point2D.Double)cellView.getAttributes().get((Object)KEY_LAST_IMPULSE);
        Point2D.Double double_3 = this.getPosition(cellView);
        double d = (Double)cellView.getAttributes().get((Object)KEY_TEMPERATURE);
        double d2 = (Double)cellView.getAttributes().get((Object)KEY_SKEWGAUGE);
        double d3 = AnnealingLayoutAlgorithm.MathExtensions.abs(double_);
        double d4 = AnnealingLayoutAlgorithm.MathExtensions.abs(double_2);
        if (d3 > this.equalsNull) {
            if (this.isCluster(cellView)) {
                double_.setLocation(double_.getX() * d * this.clusterForceScalingFactor / d3, double_.getY() * d * this.clusterForceScalingFactor / d3);
            } else {
                double_.setLocation(double_.getX() * d / d3, double_.getY() * d / d3);
            }
            cellView.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)double_);
            double_3.setLocation(double_3.getX() + double_.getX(), double_3.getY() + double_.getY());
            cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_3);
        }
        if (d4 > this.equalsNull) {
            double d5 = AnnealingLayoutAlgorithm.MathExtensions.angleBetween(double_, double_2);
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            if (Math.abs(d6) >= Math.sin(1.5707963267948966 + this.alphaRot / 2.0)) {
                d2 += this.sigmaRot * AnnealingLayoutAlgorithm.MathExtensions.sgn(d6);
            }
            if (d7 < Math.cos(Math.PI + this.alphaOsc / 2.0)) {
                d *= this.sigmaOsc * Math.abs(d7);
            }
            d *= 1.0 - Math.abs(d2);
            d = Math.min(d, this.maxTemperature);
        }
        cellView.getAttributes().put((Object)KEY_TEMPERATURE, (Object)new Double(d));
        cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_3);
        cellView.getAttributes().put((Object)KEY_SKEWGAUGE, (Object)new Double(d2));
        cellView.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)new Point2D.Double(double_.getX(), double_.getY()));
    }

    private Point2D.Double add(Point2D.Double double_, Point2D.Double double_2) {
        return new Point2D.Double(double_.getX() + double_2.getX(), double_.getY() + double_2.getY());
    }

    private Point2D.Double sub(Point2D.Double double_, Point2D.Double double_2) {
        return new Point2D.Double(double_.getX() - double_2.getX(), double_.getY() - double_2.getY());
    }

    private ArrayList getRelativesFrom(ArrayList arrayList, CellView cellView) {
        ArrayList arrayList2 = this.getRelatives(cellView);
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!arrayList.contains(arrayList2.get(i))) continue;
            arrayList3.add(arrayList2.get(i));
        }
        return arrayList3;
    }

    private ArrayList getRelatives(CellView cellView) {
        if (!(cellView instanceof VertexView)) {
            new Exception("getRelatives 1").printStackTrace();
            return null;
        }
        if (cellView.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)cellView.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        if (this.isCluster(cellView)) {
            ArrayList arrayList2 = (ArrayList)cellView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < arrayList2.size(); ++i) {
                ArrayList arrayList3 = this.getRelatives((CellView)arrayList2.get(i));
                for (int j = 0; j < arrayList3.size(); ++j) {
                    CellView cellView2 = (CellView)arrayList3.get(j);
                    if (arrayList2.contains(cellView2) || arrayList.contains(cellView2)) continue;
                    arrayList.add(cellView2);
                }
            }
        } else {
            Object object;
            int n;
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            VertexView vertexView = (VertexView)cellView;
            GraphModel graphModel = this.jgraph.getModel();
            GraphLayoutCache graphLayoutCache = this.jgraph.getGraphLayoutCache();
            Object object2 = vertexView.getCell();
            for (n = 0; n < graphModel.getChildCount(object2); ++n) {
                object = graphModel.getChild(object2, n);
                arrayList4.add(object);
            }
            for (n = 0; n < arrayList4.size(); ++n) {
                object = arrayList4.get(n);
                Iterator iterator = graphModel.edges(object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object3 = null;
                    object3 = graphModel.getSource(e) != object ? graphModel.getSource(e) : graphModel.getTarget(e);
                    CellView cellView3 = graphLayoutCache.getMapping(graphModel.getParent(object3), true);
                    arrayList.add(cellView3);
                }
            }
        }
        cellView.getAttributes().put((Object)KEY_RELATIVES, arrayList);
        return arrayList;
    }

    private double getNodeWeight(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_MASSINDEX)) {
            return (Double)cellView.getAttributes().get((Object)KEY_MASSINDEX);
        }
        int n = this.getRelatives(cellView).size();
        double d = (double)(n + 1) / 2.0;
        cellView.getAttributes().put((Object)KEY_MASSINDEX, (Object)new Double(d));
        return d;
    }

    private boolean setNewCoordinates(JGraph jGraph) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.cellList.size(); ++i) {
            Point2D.Double double_ = this.getPosition(i, this.cellList);
            Rectangle2D rectangle2D = ((CellView)this.cellList.get(i)).getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = ((CellView)this.cellList.get(i)).getCell();
            Hashtable hashtable2 = new Hashtable();
            GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D);
            hashtable.put(object, hashtable2);
        }
        jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
        return false;
    }

    private void removeTemporaryLayoutDataFromCells() {
        for (int i = 0; i < this.cellList.size(); ++i) {
            ((CellView)this.cellList.get(i)).getAttributes().clear();
        }
    }

    private boolean isFrozen() {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            double d3 = this.getTemperature(i, this.applyCellList);
            d += d3;
            boolean bl2 = bl = bl && d3 <= this.minTemperature;
            if (!bl && !this.shouldEndPerAverage) break;
        }
        if (this.shouldEndPerAverage) {
            d2 = d / (double)this.applyCellList.size();
            return d2 < this.minTemperature;
        }
        return bl;
    }

    private int[] createPermutation(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = (int)(Math.random() * (double)n);
            for (int j = 0; j < i; ++j) {
                if (n2 != nArray[j]) continue;
                n2 = (int)(Math.random() * (double)n);
                j = -1;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    private Point2D.Double getRandomVector(double d) {
        double d2 = Math.random() * Math.PI * 2.0;
        return new Point2D.Double(d * Math.cos(d2), d * Math.sin(d2));
    }

    private Point2D.Double computeBarycenter(ArrayList arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            CellView cellView = (CellView)arrayList.get(i);
            this.initPosition(cellView);
            Point2D.Double double_ = this.getPosition(cellView);
            d += double_.x;
            d2 += double_.y;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private void initPosition(CellView cellView) {
        if (!cellView.getAttributes().containsKey((Object)KEY_POSITION)) {
            cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(cellView.getBounds().getCenterX(), cellView.getBounds().getCenterY()));
        }
    }

    private void correctCoordinates() {
        Rectangle rectangle = this.getBoundingBox();
        if (rectangle != null) {
            for (int i = 0; i < this.cellList.size(); ++i) {
                CellView cellView = (CellView)this.cellList.get(i);
                Point2D.Double double_ = this.getPosition(cellView);
                Point2D.Double double_2 = new Point2D.Double(double_.x + cellView.getBounds().getWidth() / 2.0, double_.y + cellView.getBounds().getHeight() / 2.0);
                Point2D.Double double_3 = new Point2D.Double(double_2.x - rectangle.getX(), double_2.y - rectangle.getY());
                cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_3);
            }
        }
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    private Rectangle getBoundingBox(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Point2D.Double double_ = this.getPosition(0, arrayList);
            Rectangle2D rectangle2D = ((CellView)arrayList.get(0)).getBounds();
            double d = double_.getX();
            double d2 = double_.getY();
            double d3 = double_.getX() + rectangle2D.getWidth();
            double d4 = double_.getY() + rectangle2D.getHeight();
            for (int i = 1; i < arrayList.size(); ++i) {
                double_ = this.getPosition(i, arrayList);
                rectangle2D = ((CellView)arrayList.get(i)).getBounds();
                if (d > double_.getX()) {
                    d = double_.getX();
                }
                if (d2 > double_.getY()) {
                    d2 = double_.getY();
                }
                if (d3 < double_.getX() + rectangle2D.getWidth()) {
                    d3 = double_.getX() + rectangle2D.getWidth();
                }
                if (!(d4 < double_.getY() + rectangle2D.getHeight())) continue;
                d4 = double_.getY() + rectangle2D.getHeight();
            }
            Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
            return rectangle;
        }
        return null;
    }

    private Point2D.Double getPosition(int n, ArrayList arrayList) {
        return (Point2D.Double)this.getAttribute(n, KEY_POSITION, arrayList);
    }

    private double getTemperature(int n, ArrayList arrayList) {
        Double d = (Double)this.getAttribute(n, KEY_TEMPERATURE, arrayList);
        return d;
    }

    private Point2D.Double getPosition(CellView cellView) {
        return (Point2D.Double)cellView.getAttributes().get((Object)KEY_POSITION);
    }

    private Object getAttribute(int n, String string, ArrayList arrayList) {
        CellView cellView = (CellView)arrayList.get(n);
        return cellView.getAttributes().get((Object)string);
    }

    private void arrangePlacement(CellView[] cellViewArray) {
        for (int i = 0; i < this.cellList.size(); ++i) {
            this.initPosition((CellView)this.cellList.get(i));
        }
        if (cellViewArray != null && cellViewArray.length > 0) {
            CellView[] cellViewArray2;
            int n;
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            for (n = 0; n < cellViewArray.length; ++n) {
                if (!(cellViewArray[n] instanceof VertexView) || (cellViewArray2 = this.getRelativesFrom(this.cellList, cellViewArray[n])).size() <= 0) continue;
                if (cellViewArray[n].getAttributes() == null) {
                    cellViewArray[n].changeAttributes((Map)new AttributeMap());
                }
                cellViewArray[n].getAttributes().put((Object)KEY_POSITION, (Object)this.computeBarycenter((ArrayList)cellViewArray2));
                arrayList.add(cellViewArray[n]);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.cellList.add(arrayList.get(n));
            }
            n = 0;
            cellViewArray2 = new CellView[cellViewArray.length - arrayList.size()];
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (arrayList.contains(cellViewArray[i])) continue;
                cellViewArray2[n++] = cellViewArray[i];
            }
            this.arrangePlacement(cellViewArray2);
        }
    }

    public void addApplyableVertices(VertexView[] vertexViewArray) {
        int n;
        for (n = 0; n < vertexViewArray.length; ++n) {
            if (!this.applyCellList.contains(vertexViewArray[n])) {
                this.applyCellList.add(vertexViewArray[n]);
            }
            if (this.cellList.contains(vertexViewArray[n])) continue;
            this.cellList.add(vertexViewArray[n]);
        }
        if ("Perimeter".equals(this.layoutUpdateMethod)) {
            for (n = 0; n < vertexViewArray.length; ++n) {
                Point2D.Double double_;
                int n2;
                double d = this.perimeterInitSize;
                Point2D.Double double_2 = this.getPosition((CellView)vertexViewArray[n]);
                for (n2 = 0; n2 < vertexViewArray.length; ++n2) {
                    if (n == n2 || !(Math.abs(double_2.distance(double_ = this.getPosition((CellView)vertexViewArray[n2]))) < this.perimeterInitSize / 2.0)) continue;
                    d += this.perimeterSizeInc;
                }
                for (n2 = 0; n2 < this.cellList.size(); ++n2) {
                    double_ = this.getPosition(n2, this.cellList);
                    if (!(Math.abs(double_2.distance(double_)) < d / 2.0) || this.applyCellList.contains(this.cellList.get(n2))) continue;
                    this.applyCellList.add(this.cellList.get(n2));
                }
            }
            vertexViewArray = new VertexView[this.applyCellList.size()];
            for (n = 0; n < this.applyCellList.size(); ++n) {
                vertexViewArray[n] = (VertexView)this.applyCellList.get(n);
            }
        }
        if (this.recursionDepth > 0) {
            this.addRelativesToList(vertexViewArray, this.recursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexViewArray, int n) {
        if (vertexViewArray == null) {
            return;
        }
        if (vertexViewArray.length == 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        for (int i = 0; i < vertexViewArray.length; ++i) {
            ArrayList arrayList = this.getRelatives((CellView)vertexViewArray[i]);
            VertexView[] vertexViewArray2 = new VertexView[arrayList.size()];
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!this.applyCellList.contains(arrayList.get(j))) {
                    this.applyCellList.add(arrayList.get(j));
                }
                if (!this.cellList.contains(arrayList.get(j))) {
                    this.cellList.add(arrayList.get(j));
                }
                vertexViewArray2[j] = (VertexView)arrayList.get(j);
            }
            this.addRelativesToList(vertexViewArray2, n - 1);
        }
    }

    protected ArrayList getAdditionalForces(VertexView vertexView) {
        return new ArrayList();
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        if (!this.isRunning && this.isActive) {
            this.isRunning = true;
            GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
            Object[] objectArray = graphModelChange.getRemoved();
            Object[] objectArray2 = graphModelChange.getInserted();
            if (objectArray == null && objectArray2 != null) {
                for (int i = 0; i < this.cellList.size(); ++i) {
                    this.initPosition((CellView)this.cellList.get(i));
                }
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray2, false);
                this.applyCellList = new ArrayList();
                int n = 0;
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (!(cellViewArray[i] instanceof VertexView)) continue;
                    ++n;
                }
                VertexView[] vertexViewArray = new VertexView[n];
                n = 0;
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (!(cellViewArray[i] instanceof VertexView)) continue;
                    vertexViewArray[n++] = (VertexView)cellViewArray[i];
                }
                if (vertexViewArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.loadRuntimeValues(1);
                this.sigmaRot /= 1.0 / (double)this.applyCellList.size();
                this.arrangePlacement((CellView[])vertexViewArray);
                this.addApplyableVertices(vertexViewArray);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.sigmaRot *= 1.0 / (double)this.applyCellList.size();
                this.maxRounds = this.applyCellList.size() * 4;
                this.initialize();
                this.calculate();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                if (this.useOptimizeAlgorithm) {
                    this.optimizationAlgorithm.run(this.jgraph, this.jgraph.getRoots(), null);
                }
                this.correctCoordinates();
                this.setNewCoordinates(this.jgraph);
                this.removeTemporaryLayoutDataFromCells();
            } else if (objectArray != null && objectArray2 == null) {
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (!(cellViewArray[i] instanceof VertexView) || !this.cellList.contains(cellViewArray[i])) continue;
                    this.applyCellList.remove(cellViewArray[i]);
                    this.cellList.remove(cellViewArray[i]);
                }
            }
            this.isRunning = false;
        }
    }

    protected void clusterGraph() {
        int n;
        Point2D.Double double_;
        Point2D.Double double_2;
        VertexView vertexView;
        int n2;
        int n3 = (int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor);
        if (n3 == 0) {
            System.out.println("maxClusters = 0");
            return;
        }
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.cellList.size(); ++i) {
            if (this.applyCellList.contains(this.cellList.get(i))) continue;
            arrayList2.add(this.cellList.get(i));
        }
        VertexView[] vertexViewArray = new VertexView[n3];
        Rectangle rectangle = this.getBoundingBox();
        for (n2 = 0; n2 < vertexViewArray.length; ++n2) {
            vertexViewArray[n2] = new VertexView(null);
            vertexView = vertexViewArray[n2].getAttributes();
            vertexView.put(KEY_IS_CLUSTER, "true");
            vertexView.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)rectangle.width, Math.random() * (double)rectangle.height));
            arrayList.add(vertexViewArray[n2]);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            vertexView = (VertexView)arrayList2.get(n2);
            double_2 = this.getPosition((CellView)vertexView);
            int n4 = 0;
            double_ = this.getPosition((CellView)arrayList.get(0));
            double d = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_2, double_);
            for (int i = 1; i < arrayList.size(); ++i) {
                double_ = this.getPosition(i, arrayList);
                double d2 = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_2, double_);
                if (!(d > d2)) continue;
                d = d2;
                n4 = i;
            }
            VertexView vertexView2 = (VertexView)arrayList.get(n4);
            this.moveVerticeToCluster(vertexView, vertexView2);
        }
        n2 = 0;
        do {
            n2 = 0;
            block5: for (n = 0; n < arrayList2.size(); ++n) {
                double_2 = (VertexView)arrayList2.get(n);
                VertexView vertexView3 = (VertexView)double_2.getAttributes().get((Object)KEY_CLUSTER);
                double_ = this.getPosition((CellView)double_2);
                Point2D.Double double_3 = this.getPosition((CellView)vertexView3);
                double d = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_, double_3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    double d3;
                    VertexView vertexView4 = (VertexView)arrayList.get(i);
                    if (vertexView4 == vertexView3 || !((d3 = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_, double_3 = this.getPosition((CellView)vertexView4))) < d)) continue;
                    this.moveVerticeToCluster((VertexView)double_2, vertexView4);
                    n2 = 1;
                    continue block5;
                }
            }
        } while (n2 != 0);
        for (n = 0; n < arrayList.size(); ++n) {
            if (!((VertexView)arrayList.get(n)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                arrayList.remove(n--);
                continue;
            }
            if (((ArrayList)((VertexView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() != 0) continue;
            arrayList.remove(n--);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.cellList.remove(arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.applyCellList.add(arrayList.get(n));
            this.cellList.add(arrayList.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            double_2 = (VertexView)arrayList.get(n);
            AttributeMap attributeMap = double_2.getAttributes();
            double_ = (Point2D.Double)attributeMap.get(KEY_POSITION);
            attributeMap.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(double_.x, double_.y));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            double_2 = (VertexView)arrayList.get(n);
            double_2.setCachedBounds(this.getBoundingBox((ArrayList)double_2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
        }
        this.colorizeClusters(arrayList);
        this.stop(20);
    }

    protected void moveVerticeToCluster(VertexView vertexView, VertexView vertexView2) {
        if (!vertexView2.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            vertexView2.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList arrayList = (ArrayList)vertexView2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        arrayList.add(vertexView);
        if (vertexView.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView vertexView3 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList arrayList2 = (ArrayList)vertexView3.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            arrayList2.remove(vertexView);
            this.computeClusterPosition(vertexView3);
        }
        vertexView.getAttributes().put((Object)KEY_CLUSTER, (Object)vertexView2);
        this.computeClusterPosition(vertexView2);
    }

    protected void computeClusterPosition(VertexView vertexView) {
        ArrayList arrayList = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double double_ = this.computeBarycenter(arrayList);
        vertexView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
    }

    protected void declusterGraph() {
        VertexView vertexView;
        int n;
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        for (n = 0; n < this.cellList.size(); ++n) {
            vertexView = (VertexView)this.cellList.get(n);
            if (!this.isCluster((CellView)vertexView)) continue;
            arrayList.add(vertexView);
        }
        if (arrayList.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.cellList.remove(arrayList.get(n));
            this.applyCellList.remove(arrayList.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            vertexView = (VertexView)arrayList.get(n);
            AttributeMap attributeMap = vertexView.getAttributes();
            Point2D.Double double_ = this.getPosition((CellView)vertexView);
            Point2D.Double double_2 = (Point2D.Double)attributeMap.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
            ArrayList arrayList2 = (ArrayList)attributeMap.get(KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < arrayList2.size(); ++i) {
                VertexView vertexView2 = (VertexView)arrayList2.get(i);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView2);
                Point2D.Double double_5 = new Point2D.Double(double_4.x + double_3.x, double_4.y + double_3.y);
                vertexView2.getAttributes().put((Object)KEY_POSITION, (Object)double_5);
                this.cellList.add(vertexView2);
            }
        }
    }

    protected boolean isCluster(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cellView.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private void colorizeClusters(ArrayList arrayList) {
        Color[] colorArray = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i >= colorArray.length) continue;
            ArrayList arrayList2 = (ArrayList)((CellView)arrayList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            this.showCellList(arrayList2, colorArray[i]);
        }
    }

    private void showCellList(ArrayList arrayList, Color color) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < arrayList.size(); ++i) {
            CellView cellView = (CellView)arrayList.get(i);
            Point2D.Double double_ = this.getPosition(i, arrayList);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = cellView.getCell();
            Hashtable hashtable2 = new Hashtable();
            GraphConstants.setBackground(hashtable2, (Color)color);
            GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D);
            hashtable.put(object, hashtable2);
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private synchronized void stop(double d) {
        try {
            this.wait((long)(d * 1000.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void stop(int n) {
        this.stop((double)n);
    }

    public AnnealingLayoutAlgorithm getOptimizationAlgorithm() {
        return this.optimizationAlgorithm;
    }

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties properties) {
        this.config = properties;
        this.loadRuntimeValues(0);
    }
}

