/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.AnnealingLayoutSettings;
import org.jgraph.layout.GEMLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class GEMLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    public static final String KEY_TITLE = "GEM";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "init temperature";
    public static final String KEY_MIN_TEMPERATURE = "min temperature";
    public static final String KEY_MAX_TEMPERATURE = "max temperature";
    public static final String KEY_PREF_EDGE_LENGTH = "preferred Edge length";
    public static final String KEY_GRAVITATION = "gravitation to barycenter";
    public static final String KEY_RANDOM_IMPULSE_RANGE = "random impulse range";
    public static final String KEY_COMPUTE_PERMUTATION = "compute permutation";
    public static final String KEY_END_CONDITION_AVERAGE = "end condition average";
    public static final String KEY_AVOID_OVERLAPPING = "avoid overlapping";
    public static final String KEY_OVERLAPPING_DETECTION_WIDTH = "overlapping detection width";
    public static final String KEY_OVERLAPPING_PREF_DISTANCE = "overlapping preferred distance";
    public static final String KEY_ALPHA_OSC = "alpha oscillation";
    public static final String KEY_ALPHA_ROT = "alpha rotation";
    public static final String KEY_SIGMA_OSC = "sigma oscillation";
    public static final String KEY_SIGMA_ROT = "sigma rotation";
    public static final String KEY_OPTIMIZE_ALGORITHM_ENABLED = "optimization algorithm enabled";
    public static final String KEY_OPTIMIZE_ALGORITHM_CONFIG = "optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update init temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min temperature";
    public static final String KEY_LAYOUT_UPDATE_MAX_TEMPERATURE = "Layout Update max temperature";
    public static final String KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH = "Layout Update preferred Edge length";
    public static final String KEY_LAYOUT_UPDATE_GRAVITATION = "Layout Update gravitation to barycenter";
    public static final String KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE = "Layout Update random impulse range";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update compute permutation";
    public static final String KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE = "Layout Update end condition average";
    public static final String KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING = "Layout Update avoid overlapping";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH = "Layout Update overlapping detection width";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE = "Layout Update overlapping preferred distance";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_ROT = "Layout Update alpha oscillation";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_OSC = "Layout Update alpha rotation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_ROT = "Layout Update sigma oscillation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_OSC = "Layout Update sigma rotation";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update method";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED = "Layout Update optimization algorithm enabled";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG = "Layout Update optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETERS = "Perimeter";
    public static final String KEY_LAYOUT_UPDATE_DEPTH = "Layout Update depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE = "Layout Update method perimeter initial size";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC = "Layout Update method perimeter size increase value";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE = "cluster init temperature";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR = "clustering force scaling factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "cluster size factor";
    protected GEMLayoutAlgorithm layout;
    private JTextField tf_initTemperature;
    private JTextField tf_minTemperature;
    private JTextField tf_maxTemperature;
    private JTextField tf_prefEdgeLength;
    private JTextField tf_gravitation;
    private JTextField tf_randomImpulseRange;
    private JTextField tf_overlapDetectWidth;
    private JTextField tf_overlapPrefDistance;
    private JTextField tf_alphaOsc;
    private JTextField tf_alphaRot;
    private JTextField tf_sigmaOsc;
    private JTextField tf_sigmaRot;
    private JTextField tf_lu_initTemperature;
    private JTextField tf_lu_minTemperature;
    private JTextField tf_lu_maxTemperature;
    private JTextField tf_lu_prefEdgeLength;
    private JTextField tf_lu_gravitation;
    private JTextField tf_lu_randomImpulseRange;
    private JTextField tf_lu_overlapDetectWidth;
    private JTextField tf_lu_overlapPrefDistance;
    private JTextField tf_lu_alphaOsc;
    private JTextField tf_lu_alphaRot;
    private JTextField tf_lu_sigmaOsc;
    private JTextField tf_lu_sigmaRot;
    private JTextField tf_lu_depth;
    private JTextField tf_lu_cluster_initTemperature;
    private JTextField tf_lu_cluster_forceScalingFactor;
    private JTextField tf_lu_cluster_factor;
    private JTextField tf_lu_perimeter_initSize;
    private JTextField tf_lu_perimeter_sizeInc;
    private JCheckBox cb_computePermutation;
    private JCheckBox cb_endPerAverage;
    private JCheckBox cb_avoidOverlapping;
    private JCheckBox cb_useOptimizationAlg;
    private JCheckBox cb_lu_enableLayoutUpdate;
    private JCheckBox cb_lu_computePermutation;
    private JCheckBox cb_lu_endPerAverage;
    private JCheckBox cb_lu_avoidOverlapping;
    private JCheckBox cb_lu_useOptimizationAlg;
    private JCheckBox cb_lu_cluster_enable;
    private JComboBox comb_lu_method;
    private JComboBox comb_loadPreSets;
    private JButton button_ConfigOptimizeAlg;
    private JButton button_lu_ConfigOptimizeAlg;
    private JPanel panelLayoutUpdate;
    private JScrollPane panelLayoutRunWrapper;
    private JScrollPane panelLayoutUpdateWrapper;
    private Properties[] presetConfigs;
    private AnnealingLayoutSettings optimizeAlgController;
    private AnnealingLayoutSettings lu_optimizeAlgController;
    private JTabbedPane tp_main;
    private static final String CAPTION = "GEM Layout Configuration";

    public GEMLayoutSettings(GEMLayoutAlgorithm gEMLayoutAlgorithm) {
        this.layout = gEMLayoutAlgorithm;
        this.optimizeAlgController = new AnnealingLayoutSettings(new AnnealingLayoutAlgorithm(true), true);
        this.lu_optimizeAlgController = new AnnealingLayoutSettings(new AnnealingLayoutAlgorithm(true), true);
        Properties[] propertiesArray = new Properties[2];
        for (int i = 0; i < propertiesArray.length; ++i) {
            propertiesArray[i] = new Properties();
        }
        Properties properties = this.optimizeAlgController.getConfiguration();
        properties.put(KEY_CONFIG_NAME, "GEM optimization values");
        properties.put("Costfunction Config", "110111");
        properties.put("Start Temperature", "40.0");
        properties.put("min. Distance", "100.0");
        properties.put("Temperature Scalefactor", "0.85");
        this.optimizeAlgController.setConfiguration(properties);
        Properties properties2 = this.lu_optimizeAlgController.getConfiguration();
        properties2.put(KEY_CONFIG_NAME, "GEM optimization values");
        properties2.put("Costfunction Config", "110111");
        properties2.put(KEY_INIT_TEMPERATURE, "40.0");
        properties2.put("min. Distance", "100.0");
        properties2.put("Temperature Scalefactor", "0.85");
        this.lu_optimizeAlgController.setConfiguration(properties2);
        propertiesArray[0].put(KEY_CONFIG_NAME, "Default Values");
        propertiesArray[0].put(KEY_INIT_TEMPERATURE, "50.0");
        propertiesArray[0].put(KEY_MIN_TEMPERATURE, "3.0");
        propertiesArray[0].put(KEY_MAX_TEMPERATURE, "256.0");
        propertiesArray[0].put(KEY_PREF_EDGE_LENGTH, "100.0");
        propertiesArray[0].put(KEY_GRAVITATION, "0.0625");
        propertiesArray[0].put(KEY_RANDOM_IMPULSE_RANGE, "32.0");
        propertiesArray[0].put(KEY_COMPUTE_PERMUTATION, "true");
        propertiesArray[0].put(KEY_END_CONDITION_AVERAGE, "true");
        propertiesArray[0].put(KEY_AVOID_OVERLAPPING, "false");
        propertiesArray[0].put(KEY_OVERLAPPING_DETECTION_WIDTH, "40.0");
        propertiesArray[0].put(KEY_OVERLAPPING_PREF_DISTANCE, "40.0");
        propertiesArray[0].put(KEY_ALPHA_OSC, String.valueOf(1.5707963267948966));
        propertiesArray[0].put(KEY_ALPHA_ROT, String.valueOf(1.0471975511965976));
        propertiesArray[0].put(KEY_SIGMA_OSC, String.valueOf(0.3333333333333333));
        propertiesArray[0].put(KEY_SIGMA_ROT, String.valueOf(0.5));
        propertiesArray[0].put(KEY_OPTIMIZE_ALGORITHM_ENABLED, "false");
        propertiesArray[0].put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties.clone());
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "10.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "3.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, "256.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, "100.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_GRAVITATION, "0.0625");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, "32.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, "true");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, "false");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, "40.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, "40.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(0.3333333333333333));
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(0.5));
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_ENABLED, "false");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_DEPTH, "1");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY);
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, "false");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties2.clone());
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "false");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, "15.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, "0.1");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "8.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, "100.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, "20.0");
        propertiesArray[1].put(KEY_CONFIG_NAME, "Long running Values");
        propertiesArray[1].put(KEY_INIT_TEMPERATURE, "250.0");
        propertiesArray[1].put(KEY_MIN_TEMPERATURE, "0.5");
        propertiesArray[1].put(KEY_MAX_TEMPERATURE, "256.0");
        propertiesArray[1].put(KEY_PREF_EDGE_LENGTH, "100.0");
        propertiesArray[1].put(KEY_GRAVITATION, "0.0625");
        propertiesArray[1].put(KEY_RANDOM_IMPULSE_RANGE, "32.0");
        propertiesArray[1].put(KEY_COMPUTE_PERMUTATION, "true");
        propertiesArray[1].put(KEY_END_CONDITION_AVERAGE, "false");
        propertiesArray[1].put(KEY_AVOID_OVERLAPPING, "false");
        propertiesArray[1].put(KEY_OVERLAPPING_DETECTION_WIDTH, "40.0");
        propertiesArray[1].put(KEY_OVERLAPPING_PREF_DISTANCE, "40.0");
        propertiesArray[1].put(KEY_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        propertiesArray[1].put(KEY_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        propertiesArray[1].put(KEY_SIGMA_OSC, String.valueOf(0.875));
        propertiesArray[1].put(KEY_SIGMA_ROT, String.valueOf(0.2));
        propertiesArray[1].put(KEY_OPTIMIZE_ALGORITHM_ENABLED, "false");
        propertiesArray[1].put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties.clone());
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "100.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, "256.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, "100.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_GRAVITATION, "0.0625");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, "32.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, "false");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, "false");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, "40.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, "40.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(0.875));
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(0.2));
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_ENABLED, "false");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_DEPTH, "1");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETERS);
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, "false");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties2.clone());
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, "20.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, "0.1");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "12.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, "150.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, "30.0");
        this.presetConfigs = propertiesArray;
        this.initComponents();
        this.setConfiguration(this.presetConfigs[0]);
    }

    public void revert() {
    }

    public void apply() {
        this.layout.setConfig(this.getConfiguration());
    }

    public void setConfiguration(Properties properties) {
        double d = Double.parseDouble((String)properties.get(KEY_INIT_TEMPERATURE));
        double d2 = Double.parseDouble((String)properties.get(KEY_MIN_TEMPERATURE));
        double d3 = Double.parseDouble((String)properties.get(KEY_MAX_TEMPERATURE));
        double d4 = Double.parseDouble((String)properties.get(KEY_PREF_EDGE_LENGTH));
        double d5 = Double.parseDouble((String)properties.get(KEY_GRAVITATION));
        double d6 = Double.parseDouble((String)properties.get(KEY_RANDOM_IMPULSE_RANGE));
        double d7 = Double.parseDouble((String)properties.get(KEY_OVERLAPPING_DETECTION_WIDTH));
        double d8 = Double.parseDouble((String)properties.get(KEY_OVERLAPPING_PREF_DISTANCE));
        double d9 = Double.parseDouble((String)properties.get(KEY_ALPHA_OSC));
        double d10 = Double.parseDouble((String)properties.get(KEY_ALPHA_ROT));
        double d11 = Double.parseDouble((String)properties.get(KEY_SIGMA_OSC));
        double d12 = Double.parseDouble((String)properties.get(KEY_SIGMA_ROT));
        boolean bl = this.isTrue((String)properties.get(KEY_COMPUTE_PERMUTATION));
        boolean bl2 = this.isTrue((String)properties.get(KEY_END_CONDITION_AVERAGE));
        boolean bl3 = this.isTrue((String)properties.get(KEY_AVOID_OVERLAPPING));
        boolean bl4 = this.isTrue((String)properties.get(KEY_OPTIMIZE_ALGORITHM_ENABLED));
        Properties properties2 = (Properties)properties.get(KEY_OPTIMIZE_ALGORITHM_CONFIG);
        double d13 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE));
        double d14 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE));
        double d15 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE));
        double d16 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH));
        double d17 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_GRAVITATION));
        double d18 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE));
        double d19 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH));
        double d20 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE));
        double d21 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_ALPHA_OSC));
        double d22 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_ALPHA_ROT));
        double d23 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_SIGMA_OSC));
        double d24 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_SIGMA_ROT));
        double d25 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE));
        double d26 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR));
        double d27 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR));
        int n = Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_DEPTH));
        double d28 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE));
        double d29 = Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC));
        boolean bl5 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_ENABLED));
        boolean bl6 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED));
        boolean bl7 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION));
        boolean bl8 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE));
        boolean bl9 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING));
        boolean bl10 = this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED));
        Properties properties3 = (Properties)properties.get(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG);
        String string = (String)properties.get(KEY_LAYOUT_UPDATE_METHOD);
        this.setInitTemperature(d);
        this.setMinTemperature(d2);
        this.setMaxTemperature(d3);
        this.setPreferredEdgeLength(d4);
        this.setGravitation(d5);
        this.setRandomImpulseRange(d6);
        this.setOverlapDetectionWidth(d7);
        this.setOverlapPreferredDistance(d8);
        this.setAlphaOsc(d9);
        this.setAlphaRot(d10);
        this.setSigmaOsc(d11);
        this.setSigmaRot(d12);
        this.setComputePermutation(bl);
        this.setEndPerAverage(bl2);
        this.setAvoidOverlapping(bl3);
        this.setOptimizationAlgorithmEnabled(bl4);
        this.setOptimizationConfiguration(properties2);
        this.setLayoutUpdateInitTemperature(d13);
        this.setLayoutUpdateMinTemperature(d14);
        this.setLayoutUpdateMaxTemperature(d15);
        this.setLayoutUpdatePreferredEdgeLength(d16);
        this.setLayoutUpdateGravitation(d17);
        this.setLayoutUpdateRandomImpulseRange(d18);
        this.setLayoutUpdateOverlapDetectionWidth(d19);
        this.setLayoutUpdateOverlapPreferredDistance(d20);
        this.setLayoutUpdateAlphaOsc(d21);
        this.setLayoutUpdateAlphaRot(d22);
        this.setLayoutUpdateSigmaOsc(d23);
        this.setLayoutUpdateSigmaRot(d24);
        this.setLayoutUpdateComputePermutation(bl7);
        this.setLayoutUpdateEndPerAverage(bl8);
        this.setLayoutUpdateAvoidOverlapping(bl9);
        this.setLayoutUpdateOptimizationAlgorithmEnabled(bl10);
        this.setLayoutUpdateOptimizationConfiguration(properties3);
        this.setLayoutUpdateEnabled(bl5);
        this.setLayoutUpdateDepth(n);
        this.setLayoutUpdateMethodPerimeterInitSize(d28);
        this.setLayoutUpdateMethodPerimeterSizeInc(d29);
        this.setLayoutUpdateClusteringEnabled(bl6);
        this.setLayoutUpdateClusteringInitTemperature(d25);
        this.setLayoutUpdateClusteringForceScalingFactor(d26);
        this.setLayoutUpdateClusteringFactor(d27);
        this.setLayoutUpdateMethod(string);
    }

    public Properties getConfiguration() {
        Properties properties = new Properties();
        double d = this.getInitTemperature();
        double d2 = this.getMinTemperature();
        double d3 = this.getMaxTemperature();
        double d4 = this.getPreferredEdgeLength();
        double d5 = this.getGravitation();
        double d6 = this.getRandomImpulseRange();
        double d7 = this.getOverlapDetectionWidth();
        double d8 = this.getOverlapPreferredDistance();
        double d9 = this.getAlphaOsc();
        double d10 = this.getAlphaRot();
        double d11 = this.getSigmaOsc();
        double d12 = this.getSigmaRot();
        boolean bl = this.getComputePermutation();
        boolean bl2 = this.getEndPerAverage();
        boolean bl3 = this.getAvoidOverlapping();
        boolean bl4 = this.getOptimizationAlgorithmEnabled();
        Properties properties2 = this.getOptimizationConfiguration();
        double d13 = this.getLayoutUpdateInitTemperature();
        double d14 = this.getLayoutUpdateMinTemperature();
        double d15 = this.getLayoutUpdateMaxTemperature();
        double d16 = this.getLayoutUpdatePreferredEdgeLength();
        double d17 = this.getLayoutUpdateGravitation();
        double d18 = this.getLayoutUpdateRandomImpulseRange();
        double d19 = this.getLayoutUpdateOverlapDetectionWidth();
        double d20 = this.getLayoutUpdateOverlapPreferredDistance();
        double d21 = this.getLayoutUpdateAlphaOsc();
        double d22 = this.getLayoutUpdateAlphaRot();
        double d23 = this.getLayoutUpdateSigmaOsc();
        double d24 = this.getLayoutUpdateSigmaRot();
        boolean bl5 = this.getLayoutUpdateComputePermutation();
        boolean bl6 = this.getLayoutUpdateEndPerAverage();
        boolean bl7 = this.getLayoutUpdateAvoidOverlapping();
        boolean bl8 = this.getLayoutUpdateOptimizationAlgorithmEnabled();
        boolean bl9 = this.getLayoutUpdateEnabled();
        String string = this.getLayoutUpdateMethod();
        int n = this.getLayoutUpdateDepth();
        double d25 = this.getLayoutUpdateMethodPerimeterInitSize();
        double d26 = this.getLayoutUpdateMethodPerimeterSizeInc();
        boolean bl10 = this.getLayoutUpdateClusteringEnabled();
        double d27 = this.getLayoutUpdateClusteringInitTemperature();
        double d28 = this.getLayoutUpdateClusteringForceScalingFactor();
        double d29 = this.getLayoutUpdateClusteringFactor();
        Properties properties3 = this.getLayoutUpdateOptimizationConfiguration();
        properties.put(KEY_INIT_TEMPERATURE, String.valueOf(d));
        properties.put(KEY_MIN_TEMPERATURE, String.valueOf(d2));
        properties.put(KEY_MAX_TEMPERATURE, String.valueOf(d3));
        properties.put(KEY_PREF_EDGE_LENGTH, String.valueOf(d4));
        properties.put(KEY_GRAVITATION, String.valueOf(d5));
        properties.put(KEY_RANDOM_IMPULSE_RANGE, String.valueOf(d6));
        properties.put(KEY_OVERLAPPING_DETECTION_WIDTH, String.valueOf(d7));
        properties.put(KEY_OVERLAPPING_PREF_DISTANCE, String.valueOf(d8));
        properties.put(KEY_COMPUTE_PERMUTATION, String.valueOf(bl));
        properties.put(KEY_END_CONDITION_AVERAGE, String.valueOf(bl2));
        properties.put(KEY_AVOID_OVERLAPPING, String.valueOf(bl3));
        properties.put(KEY_ALPHA_OSC, String.valueOf(d9));
        properties.put(KEY_ALPHA_ROT, String.valueOf(d10));
        properties.put(KEY_SIGMA_OSC, String.valueOf(d11));
        properties.put(KEY_SIGMA_ROT, String.valueOf(d12));
        properties.put(KEY_OPTIMIZE_ALGORITHM_ENABLED, String.valueOf(bl4));
        properties.put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties2);
        properties.put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, String.valueOf(d13));
        properties.put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, String.valueOf(d14));
        properties.put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, String.valueOf(d15));
        properties.put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, String.valueOf(d16));
        properties.put(KEY_LAYOUT_UPDATE_GRAVITATION, String.valueOf(d17));
        properties.put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, String.valueOf(d18));
        properties.put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, String.valueOf(d19));
        properties.put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, String.valueOf(d20));
        properties.put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, String.valueOf(bl5));
        properties.put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, String.valueOf(bl6));
        properties.put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, String.valueOf(bl7));
        properties.put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(d21));
        properties.put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(d22));
        properties.put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(d23));
        properties.put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(d24));
        properties.put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, String.valueOf(bl8));
        properties.put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties3);
        properties.put(KEY_LAYOUT_UPDATE_ENABLED, String.valueOf(bl9));
        properties.put(KEY_LAYOUT_UPDATE_METHOD, string);
        properties.put(KEY_LAYOUT_UPDATE_DEPTH, String.valueOf(n));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, String.valueOf(d25));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, String.valueOf(d26));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, String.valueOf(bl10));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, String.valueOf(d27));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, String.valueOf(d28));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, String.valueOf(d29));
        return properties;
    }

    protected Properties[] getPresetConfigs() {
        return this.presetConfigs;
    }

    protected Properties getPresetConfig(int n) {
        return this.presetConfigs[n];
    }

    protected void setPresetConfigs(Properties[] propertiesArray) {
        this.presetConfigs = propertiesArray;
    }

    protected void switchPreferences(int n) {
        Properties properties = this.presetConfigs[n];
        double d = Math.toDegrees(Double.parseDouble((String)properties.get(KEY_ALPHA_OSC)));
        double d2 = Math.toDegrees(Double.parseDouble((String)properties.get(KEY_ALPHA_ROT)));
        double d3 = Math.toDegrees(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_ALPHA_OSC)));
        double d4 = Math.toDegrees(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_ALPHA_ROT)));
        this.tf_initTemperature.setText((String)properties.get(KEY_INIT_TEMPERATURE));
        this.tf_minTemperature.setText((String)properties.get(KEY_MIN_TEMPERATURE));
        this.tf_maxTemperature.setText((String)properties.get(KEY_MAX_TEMPERATURE));
        this.tf_prefEdgeLength.setText((String)properties.get(KEY_PREF_EDGE_LENGTH));
        this.tf_gravitation.setText((String)properties.get(KEY_GRAVITATION));
        this.tf_randomImpulseRange.setText((String)properties.get(KEY_RANDOM_IMPULSE_RANGE));
        this.tf_overlapDetectWidth.setText((String)properties.get(KEY_OVERLAPPING_DETECTION_WIDTH));
        this.tf_overlapPrefDistance.setText((String)properties.get(KEY_OVERLAPPING_PREF_DISTANCE));
        this.tf_lu_initTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE));
        this.tf_lu_minTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE));
        this.tf_lu_maxTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE));
        this.tf_lu_prefEdgeLength.setText((String)properties.get(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH));
        this.tf_lu_gravitation.setText((String)properties.get(KEY_LAYOUT_UPDATE_GRAVITATION));
        this.tf_lu_randomImpulseRange.setText((String)properties.get(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE));
        this.tf_lu_overlapDetectWidth.setText((String)properties.get(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH));
        this.tf_lu_overlapPrefDistance.setText((String)properties.get(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE));
        this.tf_lu_cluster_initTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE));
        this.tf_lu_cluster_forceScalingFactor.setText((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR));
        this.tf_lu_cluster_factor.setText((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR));
        this.tf_alphaOsc.setText(String.valueOf(d));
        this.tf_alphaRot.setText(String.valueOf(d2));
        this.tf_sigmaOsc.setText((String)properties.get(KEY_SIGMA_OSC));
        this.tf_sigmaRot.setText((String)properties.get(KEY_SIGMA_ROT));
        this.tf_lu_alphaOsc.setText(String.valueOf(d3));
        this.tf_lu_alphaRot.setText(String.valueOf(d4));
        this.tf_lu_sigmaOsc.setText((String)properties.get(KEY_LAYOUT_UPDATE_SIGMA_OSC));
        this.tf_lu_sigmaRot.setText((String)properties.get(KEY_LAYOUT_UPDATE_SIGMA_ROT));
        this.tf_lu_depth.setText((String)properties.get(KEY_LAYOUT_UPDATE_DEPTH));
        this.tf_lu_perimeter_initSize.setText((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE));
        this.tf_lu_perimeter_sizeInc.setText((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC));
        this.cb_computePermutation.setSelected(this.isTrue((String)properties.get(KEY_COMPUTE_PERMUTATION)));
        this.cb_endPerAverage.setSelected(this.isTrue((String)properties.get(KEY_END_CONDITION_AVERAGE)));
        this.cb_avoidOverlapping.setSelected(this.isTrue((String)properties.get(KEY_AVOID_OVERLAPPING)));
        this.cb_useOptimizationAlg.setSelected(this.isTrue((String)properties.get(KEY_OPTIMIZE_ALGORITHM_ENABLED)));
        this.cb_lu_enableLayoutUpdate.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_ENABLED)));
        this.cb_lu_computePermutation.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION)));
        this.cb_lu_endPerAverage.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE)));
        this.cb_lu_avoidOverlapping.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING)));
        this.cb_lu_useOptimizationAlg.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED)));
        this.cb_lu_cluster_enable.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED)));
        this.comb_lu_method.setSelectedItem((String)properties.get(KEY_LAYOUT_UPDATE_METHOD));
    }

    protected boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    protected void check(ArrayList arrayList) {
        boolean bl = true;
        bl &= this.assertDouble(this.tf_initTemperature.getText(), KEY_INIT_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_minTemperature.getText(), KEY_MIN_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_maxTemperature.getText(), KEY_MIN_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_prefEdgeLength.getText(), KEY_PREF_EDGE_LENGTH, arrayList);
        bl &= this.assertDouble(this.tf_gravitation.getText(), KEY_GRAVITATION, arrayList);
        bl &= this.assertDouble(this.tf_randomImpulseRange.getText(), KEY_RANDOM_IMPULSE_RANGE, arrayList);
        bl &= this.assertDouble(this.tf_overlapDetectWidth.getText(), KEY_OVERLAPPING_DETECTION_WIDTH, arrayList);
        bl &= this.assertDouble(this.tf_overlapPrefDistance.getText(), KEY_OVERLAPPING_PREF_DISTANCE, arrayList);
        bl &= this.assertDouble(this.tf_alphaOsc.getText(), KEY_ALPHA_OSC, arrayList);
        bl &= this.assertDouble(this.tf_alphaRot.getText(), KEY_ALPHA_ROT, arrayList);
        bl &= this.assertDouble(this.tf_sigmaOsc.getText(), KEY_SIGMA_OSC, arrayList);
        bl &= this.assertDouble(this.tf_sigmaRot.getText(), KEY_SIGMA_ROT, arrayList);
        bl &= this.assertDouble(this.tf_lu_initTemperature.getText(), KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_minTemperature.getText(), KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_maxTemperature.getText(), KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_prefEdgeLength.getText(), KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, arrayList);
        bl &= this.assertDouble(this.tf_lu_gravitation.getText(), KEY_LAYOUT_UPDATE_GRAVITATION, arrayList);
        bl &= this.assertDouble(this.tf_lu_randomImpulseRange.getText(), KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, arrayList);
        bl &= this.assertDouble(this.tf_lu_overlapDetectWidth.getText(), KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, arrayList);
        bl &= this.assertDouble(this.tf_lu_overlapPrefDistance.getText(), KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, arrayList);
        bl &= this.assertDouble(this.tf_lu_alphaOsc.getText(), KEY_LAYOUT_UPDATE_ALPHA_OSC, arrayList);
        bl &= this.assertDouble(this.tf_lu_alphaRot.getText(), KEY_LAYOUT_UPDATE_ALPHA_ROT, arrayList);
        bl &= this.assertDouble(this.tf_lu_sigmaOsc.getText(), KEY_LAYOUT_UPDATE_SIGMA_OSC, arrayList);
        bl &= this.assertDouble(this.tf_lu_sigmaRot.getText(), KEY_LAYOUT_UPDATE_SIGMA_ROT, arrayList);
        bl &= this.assertInteger(this.tf_lu_depth.getText(), KEY_LAYOUT_UPDATE_DEPTH, arrayList);
        bl &= this.assertDouble(this.tf_lu_perimeter_initSize.getText(), KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, arrayList);
        bl &= this.assertDouble(this.tf_lu_perimeter_sizeInc.getText(), KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, arrayList);
        bl &= this.assertDouble(this.tf_lu_cluster_initTemperature.getText(), KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_cluster_forceScalingFactor.getText(), KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, arrayList);
        if (bl &= this.assertDouble(this.tf_lu_cluster_factor.getText(), KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, arrayList)) {
            bl &= this.assertMinimum(this.tf_initTemperature.getText(), 0.0, false, KEY_INIT_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_minTemperature.getText(), 0.0, false, KEY_MIN_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_maxTemperature.getText(), 0.0, false, KEY_MAX_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_prefEdgeLength.getText(), 0.0, false, KEY_PREF_EDGE_LENGTH, arrayList);
            bl &= this.assertRange(this.tf_gravitation.getText(), 0.0, 1.0, true, true, KEY_GRAVITATION, arrayList);
            bl &= this.assertMinimum(this.tf_randomImpulseRange.getText(), 0.0, false, KEY_RANDOM_IMPULSE_RANGE, arrayList);
            bl &= this.assertMinimum(this.tf_overlapDetectWidth.getText(), 0.0, false, KEY_OVERLAPPING_DETECTION_WIDTH, arrayList);
            bl &= this.assertMinimum(this.tf_overlapPrefDistance.getText(), 0.0, false, KEY_OVERLAPPING_PREF_DISTANCE, arrayList);
            bl &= this.assertRange(this.tf_alphaOsc.getText(), 0.0, 360.0, true, false, KEY_ALPHA_OSC, arrayList);
            bl &= this.assertRange(this.tf_alphaRot.getText(), 0.0, 360.0, true, false, KEY_ALPHA_ROT, arrayList);
            bl &= this.assertRange(this.tf_sigmaOsc.getText(), 0.0, 360.0, true, false, KEY_SIGMA_OSC, arrayList);
            bl &= this.assertRange(this.tf_sigmaRot.getText(), 0.0, 360.0, true, false, KEY_SIGMA_ROT, arrayList);
            bl &= this.assertMinimum(this.tf_lu_initTemperature.getText(), 0.0, false, KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_lu_minTemperature.getText(), 0.0, false, KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_lu_maxTemperature.getText(), 0.0, false, KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, arrayList);
            bl &= this.assertMinimum(this.tf_lu_prefEdgeLength.getText(), 0.0, false, KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, arrayList);
            bl &= this.assertRange(this.tf_lu_gravitation.getText(), 0.0, 1.0, true, true, KEY_LAYOUT_UPDATE_GRAVITATION, arrayList);
            bl &= this.assertMinimum(this.tf_lu_randomImpulseRange.getText(), 0.0, false, KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, arrayList);
            bl &= this.assertMinimum(this.tf_lu_overlapDetectWidth.getText(), 0.0, false, KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, arrayList);
            bl &= this.assertMinimum(this.tf_lu_overlapPrefDistance.getText(), 0.0, false, KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, arrayList);
            bl &= this.assertRange(this.tf_lu_alphaOsc.getText(), 0.0, 360.0, true, false, KEY_LAYOUT_UPDATE_ALPHA_OSC, arrayList);
            bl &= this.assertRange(this.tf_lu_alphaRot.getText(), 0.0, 360.0, true, false, KEY_LAYOUT_UPDATE_ALPHA_ROT, arrayList);
            bl &= this.assertRange(this.tf_lu_sigmaOsc.getText(), 0.0, 360.0, true, false, KEY_LAYOUT_UPDATE_SIGMA_OSC, arrayList);
            bl &= this.assertRange(this.tf_lu_sigmaRot.getText(), 0.0, 360.0, true, false, KEY_LAYOUT_UPDATE_SIGMA_ROT, arrayList);
            bl &= this.assertMinimum(this.tf_lu_depth.getText(), 0, true, KEY_LAYOUT_UPDATE_DEPTH, arrayList);
            bl &= this.assertMinimum(this.tf_lu_perimeter_initSize.getText(), 0.0, false, KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, arrayList);
            bl &= this.assertMinimum(this.tf_lu_perimeter_sizeInc.getText(), 0.0, false, KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, arrayList);
            bl &= this.assertMinimum(this.tf_lu_cluster_initTemperature.getText(), 0.0, false, KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, arrayList);
            bl &= this.assertRange(this.tf_lu_cluster_forceScalingFactor.getText(), 0.0, 1.0, false, true, KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, arrayList);
            bl &= this.assertMinimum(this.tf_lu_cluster_factor.getText(), 1.0, true, KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, arrayList);
        }
        if (!bl) {
            String string = new String();
            for (int i = 0; i < arrayList.size(); ++i) {
                string = string + (String)arrayList.get(i);
                if (i == arrayList.size() - 1) continue;
                string = string + "\n";
            }
            throw new IllegalArgumentException(string);
        }
    }

    protected void action_LoadPreSets(int n) {
        this.switchPreferences(n);
        this.switchLayoutUpdatePanel();
        this.switchVisibility();
    }

    private void switchVisibility() {
        this.tf_overlapDetectWidth.setEnabled(this.cb_avoidOverlapping.isSelected());
        this.tf_overlapPrefDistance.setEnabled(this.cb_avoidOverlapping.isSelected());
        this.tf_lu_overlapDetectWidth.setEnabled(this.cb_lu_avoidOverlapping.isSelected());
        this.tf_lu_overlapPrefDistance.setEnabled(this.cb_lu_avoidOverlapping.isSelected());
        this.button_ConfigOptimizeAlg.setEnabled(this.cb_useOptimizationAlg.isSelected());
        this.button_lu_ConfigOptimizeAlg.setEnabled(this.cb_lu_useOptimizationAlg.isSelected());
        this.tf_lu_cluster_initTemperature.setEnabled(this.cb_lu_cluster_enable.isSelected());
        this.tf_lu_cluster_forceScalingFactor.setEnabled(this.cb_lu_cluster_enable.isSelected());
        this.tf_lu_cluster_factor.setEnabled(this.cb_lu_cluster_enable.isSelected());
        if (this.comb_lu_method.getSelectedItem() == KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY) {
            this.tf_lu_perimeter_initSize.setEnabled(false);
            this.tf_lu_perimeter_sizeInc.setEnabled(false);
        } else if (this.comb_lu_method.getSelectedItem() == KEY_LAYOUT_UPDATE_METHOD_PERIMETERS) {
            this.tf_lu_perimeter_initSize.setEnabled(true);
            this.tf_lu_perimeter_sizeInc.setEnabled(true);
        }
    }

    private void switchLayoutUpdatePanel() {
        if (this.cb_lu_enableLayoutUpdate.isSelected()) {
            this.tp_main.addTab("Update Values", this.panelLayoutUpdateWrapper);
        } else {
            this.tp_main.remove(this.panelLayoutUpdateWrapper);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(12, 1, 0, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(12, 1, 0, 5));
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 3, 10, 0));
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 10, 4));
        JPanel jPanel7 = new JPanel(new GridLayout(3, 2, 10, 4));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new GridLayout(2, 2));
        this.tp_main = new JTabbedPane();
        this.panelLayoutUpdate = new JPanel(new BorderLayout(5, 10));
        this.panelLayoutUpdate.setBackground(new Color(205, 215, 215));
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel4.add((Component)jPanel6, "North");
        jPanel4.add((Component)jPanel8, "Center");
        jPanel4.add((Component)this.getAdditionalForceConfig(), "South");
        jPanel4.setBackground(new Color(215, 215, 205));
        jPanel8.add((Component)jPanel9, "North");
        jPanel8.add((Component)jPanel7, "Center");
        jPanel8.setOpaque(false);
        jPanel6.setOpaque(false);
        jPanel7.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        this.setLayout(new BorderLayout(5, 10));
        this.add((Component)jPanel, "North");
        this.add((Component)this.tp_main, "Center");
        this.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Global Settings"));
        jPanel.add((Component)new JLabel("run permanent :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 30), 0, 0));
        this.cb_lu_enableLayoutUpdate = new JCheckBox();
        jPanel.add((Component)this.cb_lu_enableLayoutUpdate, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(new JLabel("start temperature :"));
        jPanel2.add(new JLabel("min. temperature :"));
        jPanel2.add(new JLabel("max. temperature :"));
        jPanel2.add(new JLabel("preferred Edge length :"));
        jPanel2.add(new JLabel("gravitation :"));
        jPanel2.add(new JLabel("range of random impulse :"));
        jPanel2.add(new JLabel("compute permutations :"));
        jPanel2.add(new JLabel("end condition is average :"));
        jPanel2.add(new JLabel("alpha oscillation :"));
        jPanel2.add(new JLabel("alpha rotation :"));
        jPanel2.add(new JLabel("sigma oscillation :"));
        jPanel2.add(new JLabel("sigma rotation :"));
        this.tf_initTemperature = new JTextField();
        this.tf_minTemperature = new JTextField();
        this.tf_maxTemperature = new JTextField();
        this.tf_prefEdgeLength = new JTextField();
        this.tf_gravitation = new JTextField();
        this.tf_randomImpulseRange = new JTextField();
        this.cb_computePermutation = new JCheckBox();
        this.cb_endPerAverage = new JCheckBox();
        this.cb_computePermutation.setOpaque(false);
        this.cb_endPerAverage.setOpaque(false);
        this.tf_alphaOsc = new JTextField();
        this.tf_alphaRot = new JTextField();
        this.tf_sigmaOsc = new JTextField();
        this.tf_sigmaRot = new JTextField();
        jPanel3.add(this.tf_initTemperature);
        jPanel3.add(this.tf_minTemperature);
        jPanel3.add(this.tf_maxTemperature);
        jPanel3.add(this.tf_prefEdgeLength);
        jPanel3.add(this.tf_gravitation);
        jPanel3.add(this.tf_randomImpulseRange);
        jPanel3.add(this.cb_computePermutation);
        jPanel3.add(this.cb_endPerAverage);
        jPanel3.add(this.tf_alphaOsc);
        jPanel3.add(this.tf_alphaRot);
        jPanel3.add(this.tf_sigmaOsc);
        jPanel3.add(this.tf_sigmaRot);
        this.cb_avoidOverlapping = new JCheckBox();
        this.cb_avoidOverlapping.setOpaque(false);
        this.tf_overlapDetectWidth = new JTextField();
        this.tf_overlapPrefDistance = new JTextField();
        JPanel jPanel10 = new JPanel(new GridLayout(1, 2, 10, 4));
        jPanel10.setOpaque(false);
        jPanel10.add(new JLabel("on/off"));
        jPanel10.add(this.cb_avoidOverlapping);
        JPanel jPanel11 = new JPanel();
        jPanel11.setOpaque(false);
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Force for overlapping Cells", 4, 1));
        jPanel7.add(jPanel10);
        jPanel7.add(jPanel11);
        jPanel7.add(new JLabel("detection width :"));
        jPanel7.add(this.tf_overlapDetectWidth);
        jPanel7.add(new JLabel("pref. distance :"));
        jPanel7.add(this.tf_overlapPrefDistance);
        this.cb_useOptimizationAlg = new JCheckBox();
        this.cb_useOptimizationAlg.setOpaque(false);
        this.cb_useOptimizationAlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchVisibility();
            }
        });
        this.button_ConfigOptimizeAlg = new JButton("Configure");
        this.button_ConfigOptimizeAlg.setBackground(jPanel4.getBackground());
        JPanel jPanel12 = new JPanel();
        jPanel12.setOpaque(false);
        jPanel9.add(new JLabel("Use optimization Algorithm:"));
        jPanel9.add(this.cb_useOptimizationAlg);
        jPanel9.add(jPanel12);
        jPanel9.add(this.button_ConfigOptimizeAlg);
        jPanel9.setOpaque(false);
        this.button_ConfigOptimizeAlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.cb_avoidOverlapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchVisibility();
            }
        });
        this.cb_lu_enableLayoutUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchLayoutUpdatePanel();
            }
        });
        this.comb_loadPreSets = new JComboBox();
        for (int i = 0; i < this.presetConfigs.length; ++i) {
            this.comb_loadPreSets.addItem(this.presetConfigs[i].get(KEY_CONFIG_NAME));
        }
        jPanel5.add(this.comb_loadPreSets);
        this.comb_loadPreSets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.action_LoadPreSets(((JComboBox)actionEvent.getSource()).getSelectedIndex());
            }
        });
        JPanel jPanel13 = new JPanel(new GridLayout(16, 1, 0, 5));
        JPanel jPanel14 = new JPanel(new GridLayout(16, 1, 0, 5));
        JPanel jPanel15 = new JPanel(new BorderLayout(10, 5));
        JPanel jPanel16 = new JPanel(new GridLayout(3, 2, 10, 4));
        JPanel jPanel17 = new JPanel(new BorderLayout());
        JPanel jPanel18 = new JPanel(new GridLayout(2, 2, 10, 4));
        JPanel jPanel19 = new JPanel(new GridLayout(4, 2, 10, 4));
        jPanel15.setOpaque(false);
        jPanel13.setOpaque(false);
        jPanel14.setOpaque(false);
        jPanel16.setOpaque(false);
        jPanel17.setOpaque(false);
        jPanel18.setOpaque(false);
        jPanel19.setOpaque(false);
        jPanel15.add((Component)jPanel13, "West");
        jPanel15.add((Component)jPanel14, "East");
        jPanel15.add((Component)jPanel19, "South");
        jPanel17.add((Component)jPanel18, "North");
        jPanel17.add((Component)jPanel16, "Center");
        this.panelLayoutUpdate.add((Component)jPanel15, "North");
        this.panelLayoutUpdate.add((Component)jPanel17, "Center");
        this.panelLayoutUpdate.add((Component)this.getAdditionalForceLUConfig(), "South");
        jPanel13.add(new JLabel("start temperature :"));
        jPanel13.add(new JLabel("min. temperature :"));
        jPanel13.add(new JLabel("max. temperature :"));
        jPanel13.add(new JLabel("preferred Edge length :"));
        jPanel13.add(new JLabel("gravitation :"));
        jPanel13.add(new JLabel("range of random impulse :"));
        jPanel13.add(new JLabel("compute permutations :"));
        jPanel13.add(new JLabel("end condition is average :"));
        jPanel13.add(new JLabel("alpha oscillation :"));
        jPanel13.add(new JLabel("alpha rotation :"));
        jPanel13.add(new JLabel("sigma oscillation :"));
        jPanel13.add(new JLabel("sigma rotation :"));
        jPanel13.add(new JLabel("layout update method :"));
        jPanel13.add(new JLabel("layout update depth :"));
        jPanel13.add(new JLabel("layout update perimeter init size :"));
        jPanel13.add(new JLabel("layout update perimeter increase value :"));
        this.tf_lu_initTemperature = new JTextField();
        this.tf_lu_minTemperature = new JTextField();
        this.tf_lu_maxTemperature = new JTextField();
        this.tf_lu_prefEdgeLength = new JTextField();
        this.tf_lu_gravitation = new JTextField();
        this.tf_lu_randomImpulseRange = new JTextField();
        this.cb_lu_computePermutation = new JCheckBox();
        this.cb_lu_endPerAverage = new JCheckBox();
        this.cb_lu_computePermutation.setOpaque(false);
        this.cb_lu_endPerAverage.setOpaque(false);
        this.tf_lu_alphaOsc = new JTextField();
        this.tf_lu_alphaRot = new JTextField();
        this.tf_lu_sigmaOsc = new JTextField();
        this.tf_lu_sigmaRot = new JTextField();
        this.tf_lu_depth = new JTextField();
        this.comb_lu_method = new JComboBox();
        this.comb_lu_method.addItem(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY);
        this.comb_lu_method.addItem(KEY_LAYOUT_UPDATE_METHOD_PERIMETERS);
        this.comb_lu_method.setBackground(this.panelLayoutUpdate.getBackground());
        this.tf_lu_perimeter_initSize = new JTextField();
        this.tf_lu_perimeter_sizeInc = new JTextField();
        jPanel14.add(this.tf_lu_initTemperature);
        jPanel14.add(this.tf_lu_minTemperature);
        jPanel14.add(this.tf_lu_maxTemperature);
        jPanel14.add(this.tf_lu_prefEdgeLength);
        jPanel14.add(this.tf_lu_gravitation);
        jPanel14.add(this.tf_lu_randomImpulseRange);
        jPanel14.add(this.cb_lu_computePermutation);
        jPanel14.add(this.cb_lu_endPerAverage);
        jPanel14.add(this.tf_lu_alphaOsc);
        jPanel14.add(this.tf_lu_alphaRot);
        jPanel14.add(this.tf_lu_sigmaOsc);
        jPanel14.add(this.tf_lu_sigmaRot);
        jPanel14.add(this.comb_lu_method);
        jPanel14.add(this.tf_lu_depth);
        jPanel14.add(this.tf_lu_perimeter_initSize);
        jPanel14.add(this.tf_lu_perimeter_sizeInc);
        this.tf_lu_cluster_initTemperature = new JTextField();
        this.tf_lu_cluster_forceScalingFactor = new JTextField();
        this.tf_lu_cluster_factor = new JTextField();
        this.cb_lu_cluster_enable = new JCheckBox();
        this.cb_lu_cluster_enable.setOpaque(false);
        this.cb_lu_cluster_enable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchVisibility();
            }
        });
        JPanel jPanel20 = new JPanel(new GridLayout(1, 2, 10, 4));
        jPanel20.setOpaque(false);
        jPanel20.add(new JLabel("on/off"));
        jPanel20.add(this.cb_lu_cluster_enable);
        JPanel jPanel21 = new JPanel();
        jPanel21.setOpaque(false);
        jPanel19.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Clustering", 4, 1));
        jPanel19.add(jPanel20);
        jPanel19.add(jPanel21);
        jPanel19.add(new JLabel("clustering factor :"));
        jPanel19.add(this.tf_lu_cluster_factor);
        jPanel19.add(new JLabel("init temperature :"));
        jPanel19.add(this.tf_lu_cluster_initTemperature);
        jPanel19.add(new JLabel("force scaling factor :"));
        jPanel19.add(this.tf_lu_cluster_forceScalingFactor);
        this.cb_lu_avoidOverlapping = new JCheckBox();
        this.cb_lu_avoidOverlapping.setOpaque(false);
        this.tf_lu_overlapDetectWidth = new JTextField();
        this.tf_lu_overlapPrefDistance = new JTextField();
        JPanel jPanel22 = new JPanel(new GridLayout(1, 2, 10, 4));
        jPanel22.setOpaque(false);
        jPanel22.add(new JLabel("on/off"));
        jPanel22.add(this.cb_lu_avoidOverlapping);
        JPanel jPanel23 = new JPanel();
        jPanel23.setOpaque(false);
        jPanel16.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Force for overlapping Cells", 4, 1));
        jPanel16.add(jPanel22);
        jPanel16.add(jPanel23);
        jPanel16.add(new JLabel("detection width :"));
        jPanel16.add(this.tf_lu_overlapDetectWidth);
        jPanel16.add(new JLabel("pref. distance :"));
        jPanel16.add(this.tf_lu_overlapPrefDistance);
        this.cb_lu_avoidOverlapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchVisibility();
            }
        });
        this.cb_lu_useOptimizationAlg = new JCheckBox();
        this.cb_lu_useOptimizationAlg.setOpaque(false);
        this.cb_lu_useOptimizationAlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GEMLayoutSettings.this.switchVisibility();
            }
        });
        this.button_lu_ConfigOptimizeAlg = new JButton(this.button_ConfigOptimizeAlg.getText());
        this.button_lu_ConfigOptimizeAlg.setBackground(this.panelLayoutUpdate.getBackground());
        this.button_lu_ConfigOptimizeAlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JPanel jPanel24 = new JPanel();
        jPanel24.setOpaque(false);
        jPanel18.add(new JLabel("Use optimization Algorithm:"));
        jPanel18.add(this.cb_lu_useOptimizationAlg);
        jPanel18.add(jPanel24);
        jPanel18.add(this.button_lu_ConfigOptimizeAlg);
        this.panelLayoutRunWrapper = new JScrollPane(jPanel4);
        Dimension dimension = new Dimension(500, 350);
        this.panelLayoutRunWrapper.setPreferredSize(dimension);
        this.panelLayoutUpdateWrapper = new JScrollPane(this.panelLayoutUpdate);
        this.panelLayoutUpdateWrapper.setPreferredSize(dimension);
        this.tp_main.addTab("Apply Values", this.panelLayoutRunWrapper);
        this.setToolTipText();
    }

    protected JPanel getAdditionalForceConfig() {
        return new JPanel();
    }

    protected JPanel getAdditionalForceLUConfig() {
        return new JPanel();
    }

    protected void setToolTipText() {
        this.tf_initTemperature.setToolTipText("Temperature Cells will be initialised with");
        this.tf_minTemperature.setToolTipText("Algorithm stops when all Temperatures/the average of all Temperatures is below this value");
        this.tf_maxTemperature.setToolTipText("Value, no temperature will surmount");
        this.tf_prefEdgeLength.setToolTipText("preferred Length of Edges");
        this.tf_gravitation.setToolTipText("attracting Force to the Barycenter of the Graph");
        this.tf_randomImpulseRange.setToolTipText("Power of disturbing Forces");
        this.tf_overlapDetectWidth.setToolTipText("Distance around a cell that will be searched for overlapping of other cells");
        this.tf_overlapPrefDistance.setToolTipText("Distance the Algorithm try's to keep as mimimum between overlapped cells");
        this.tf_alphaOsc.setToolTipText("Angle in witch Oscillations are detected");
        this.tf_alphaRot.setToolTipText("Angle in witch Rotations are detected");
        this.tf_sigmaOsc.setToolTipText("Penaltyvalue for Oscillations (with a higher Value Temperature decreases more slowly)");
        this.tf_sigmaRot.setToolTipText("Penaltyvalue for Rotations (with a small Value Temperature decreases more slowly)");
        this.tf_lu_initTemperature.setToolTipText(this.tf_initTemperature.getToolTipText());
        this.tf_lu_minTemperature.setToolTipText(this.tf_minTemperature.getToolTipText());
        this.tf_lu_maxTemperature.setToolTipText(this.tf_maxTemperature.getToolTipText());
        this.tf_lu_prefEdgeLength.setToolTipText(this.tf_prefEdgeLength.getToolTipText());
        this.tf_lu_gravitation.setToolTipText(this.tf_gravitation.getToolTipText());
        this.tf_lu_randomImpulseRange.setToolTipText(this.tf_randomImpulseRange.getToolTipText());
        this.tf_lu_overlapDetectWidth.setToolTipText(this.tf_overlapDetectWidth.getToolTipText());
        this.tf_lu_overlapPrefDistance.setToolTipText(this.tf_overlapPrefDistance.getToolTipText());
        this.tf_lu_alphaOsc.setToolTipText(this.tf_alphaOsc.getToolTipText());
        this.tf_lu_alphaRot.setToolTipText(this.tf_alphaRot.getToolTipText());
        this.tf_lu_sigmaOsc.setToolTipText(this.tf_sigmaOsc.getToolTipText());
        this.tf_lu_sigmaRot.setToolTipText(this.tf_sigmaRot.getToolTipText());
        this.tf_lu_depth.setToolTipText("Cells depth Edges away from the inserted Cells will also be updated");
        this.tf_lu_cluster_initTemperature.setToolTipText("Initial temperature for clusters. It is recommended, that this value is below the initial temperature for normal vertices.");
        this.tf_lu_cluster_forceScalingFactor.setToolTipText("Scales the forces, affecting clusters. Possible values are between 0.0 and 1.0. A small value ensures, that clusters move slow and over short distances.");
        this.tf_lu_cluster_factor.setToolTipText("Factor the creation of clusters. A lower value leads to more clusters, with smaller size, a higher value to fewer, bigger clusters");
        this.cb_computePermutation.setToolTipText("Algorithms will be calculated with the same/permutating order of Cells");
        this.cb_endPerAverage.setToolTipText("Should the Algorithm stop when all Temperatures/the average of all Temperatures is below the min. Temperature");
        this.cb_avoidOverlapping.setToolTipText("Switches the calculation of a Force, that appears when two Cells are overlapping");
        this.cb_useOptimizationAlg.setToolTipText("Enables finetuning after the GEM-TEMPORARY-DATA-Algorithm with a short run of the GEM-Algorithm");
        this.cb_lu_enableLayoutUpdate.setToolTipText("Should the Algorithm be performed, when Cells collapses/expand");
        this.cb_lu_computePermutation.setToolTipText(this.cb_computePermutation.getToolTipText());
        this.cb_lu_endPerAverage.setToolTipText(this.cb_endPerAverage.getToolTipText());
        this.cb_lu_avoidOverlapping.setToolTipText(this.cb_avoidOverlapping.getToolTipText());
        this.cb_lu_useOptimizationAlg.setToolTipText(this.cb_useOptimizationAlg.getToolTipText());
        this.cb_lu_cluster_enable.setToolTipText("Switches clustering for the layout update process on/off");
        this.comb_lu_method.setToolTipText("Method of organizing place for inserted Cells");
        this.button_ConfigOptimizeAlg.setToolTipText("Configures the GEM-Algorithm for finetuning purpose");
        this.button_lu_ConfigOptimizeAlg.setToolTipText(this.button_ConfigOptimizeAlg.getToolTipText());
    }

    protected boolean assertDouble(String string, String string2, ArrayList arrayList) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = string2 + " is NOT a double value";
            arrayList.add(string3);
            return false;
        }
        return true;
    }

    protected boolean assertInteger(String string, String string2, ArrayList arrayList) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = string2 + " is NOT a integer value";
            arrayList.add(string3);
            return false;
        }
        return true;
    }

    protected boolean assertRange(String string, double d, double d2, boolean bl, boolean bl2, String string2, ArrayList arrayList) {
        double d3 = Double.parseDouble(string);
        boolean bl3 = true;
        if (bl) {
            bl3 = d <= d3;
        } else {
            boolean bl4 = bl3 = d < d3;
        }
        if (bl3) {
            if (bl2) {
                bl3 = d2 >= d3;
            } else {
                boolean bl5 = bl3 = d2 > d3;
            }
            if (bl3) {
                return true;
            }
        }
        String string3 = string2 + " is out of the interval ";
        string3 = bl ? string3 + "[" : string3 + "]";
        string3 = string3 + d + ";" + d2;
        string3 = bl2 ? string3 + "]" : string3 + "[";
        arrayList.add(string3);
        return false;
    }

    protected boolean assertRange(String string, int n, int n2, boolean bl, boolean bl2, String string2, ArrayList arrayList) {
        int n3 = Integer.parseInt(string);
        boolean bl3 = true;
        if (bl) {
            bl3 = n <= n3;
        } else {
            boolean bl4 = bl3 = n < n3;
        }
        if (bl3) {
            if (bl2) {
                bl3 = n2 >= n3;
            } else {
                boolean bl5 = bl3 = n2 > n3;
            }
            if (bl3) {
                return true;
            }
        }
        String string3 = string2 + " is out of the interval ";
        string3 = bl ? string3 + "[" : string3 + "]";
        string3 = string3 + n + ";" + n2;
        string3 = bl2 ? string3 + "]" : string3 + "[";
        arrayList.add(string3);
        return false;
    }

    protected boolean assertMinimum(String string, double d, boolean bl, String string2, ArrayList arrayList) {
        double d2 = Double.parseDouble(string);
        boolean bl2 = true;
        if (bl) {
            bl2 = d <= d2;
        } else {
            boolean bl3 = bl2 = d < d2;
        }
        if (bl2) {
            return true;
        }
        String string3 = string2 + " has to be bigger";
        string3 = bl ? string3 + " or equal to " : string3 + " then ";
        string3 = string3 + String.valueOf(d);
        arrayList.add(string3);
        return false;
    }

    protected boolean assertMinimum(String string, int n, boolean bl, String string2, ArrayList arrayList) {
        int n2 = Integer.parseInt(string);
        boolean bl2 = true;
        if (bl) {
            bl2 = n <= n2;
        } else {
            boolean bl3 = bl2 = n < n2;
        }
        if (bl2) {
            return true;
        }
        String string3 = string2 + " has to be bigger";
        string3 = bl ? string3 + " or equal to " : string3 + " then ";
        string3 = string3 + String.valueOf(n);
        arrayList.add(string3);
        return false;
    }

    public double getInitTemperature() {
        return Double.parseDouble(this.tf_initTemperature.getText());
    }

    public void setInitTemperature(double d) {
        this.tf_initTemperature.setText(String.valueOf(d));
    }

    public double getMinTemperature() {
        return Double.parseDouble(this.tf_minTemperature.getText());
    }

    public void setMinTemperature(double d) {
        this.tf_minTemperature.setText(String.valueOf(d));
    }

    public double getMaxTemperature() {
        return Double.parseDouble(this.tf_maxTemperature.getText());
    }

    public void setMaxTemperature(double d) {
        this.tf_maxTemperature.setText(String.valueOf(d));
    }

    public double getPreferredEdgeLength() {
        return Double.parseDouble(this.tf_prefEdgeLength.getText());
    }

    public void setPreferredEdgeLength(double d) {
        this.tf_prefEdgeLength.setText(String.valueOf(d));
    }

    public double getGravitation() {
        return Double.parseDouble(this.tf_gravitation.getText());
    }

    public void setGravitation(double d) {
        this.tf_gravitation.setText(String.valueOf(d));
    }

    public double getRandomImpulseRange() {
        return Double.parseDouble(this.tf_randomImpulseRange.getText());
    }

    public void setRandomImpulseRange(double d) {
        this.tf_randomImpulseRange.setText(String.valueOf(d));
    }

    public double getOverlapDetectionWidth() {
        return Double.parseDouble(this.tf_overlapDetectWidth.getText());
    }

    public void setOverlapDetectionWidth(double d) {
        this.tf_overlapDetectWidth.setText(String.valueOf(d));
    }

    public double getOverlapPreferredDistance() {
        return Double.parseDouble(this.tf_overlapPrefDistance.getText());
    }

    public void setOverlapPreferredDistance(double d) {
        this.tf_overlapPrefDistance.setText(String.valueOf(d));
    }

    public void setAvoidOverlapping(boolean bl) {
        this.cb_avoidOverlapping.setSelected(bl);
        this.switchVisibility();
    }

    public boolean getAvoidOverlapping() {
        return this.cb_avoidOverlapping.isSelected();
    }

    public double getAlphaOsc() {
        return Math.toRadians(Double.parseDouble(this.tf_alphaOsc.getText()));
    }

    public void setAlphaOsc(double d) {
        this.tf_alphaOsc.setText(String.valueOf(Math.toDegrees(d)));
    }

    public double getAlphaRot() {
        return Math.toRadians(Double.parseDouble(this.tf_alphaRot.getText()));
    }

    public void setAlphaRot(double d) {
        this.tf_alphaRot.setText(String.valueOf(Math.toDegrees(d)));
    }

    public double getSigmaOsc() {
        return Double.parseDouble(this.tf_sigmaOsc.getText());
    }

    public void setSigmaOsc(double d) {
        this.tf_sigmaOsc.setText(String.valueOf(d));
    }

    public double getSigmaRot() {
        return Double.parseDouble(this.tf_sigmaRot.getText());
    }

    public void setSigmaRot(double d) {
        this.tf_sigmaRot.setText(String.valueOf(d));
    }

    public boolean getComputePermutation() {
        return this.cb_computePermutation.isSelected();
    }

    public void setComputePermutation(boolean bl) {
        this.cb_computePermutation.setSelected(bl);
    }

    public boolean getEndPerAverage() {
        return this.cb_endPerAverage.isSelected();
    }

    public void setEndPerAverage(boolean bl) {
        this.cb_computePermutation.setSelected(bl);
    }

    public double getLayoutUpdateInitTemperature() {
        return Double.parseDouble(this.tf_lu_initTemperature.getText());
    }

    public void setLayoutUpdateInitTemperature(double d) {
        this.tf_lu_initTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMinTemperature() {
        return Double.parseDouble(this.tf_lu_minTemperature.getText());
    }

    public void setLayoutUpdateMinTemperature(double d) {
        this.tf_lu_minTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMaxTemperature() {
        return Double.parseDouble(this.tf_lu_maxTemperature.getText());
    }

    public void setLayoutUpdateMaxTemperature(double d) {
        this.tf_lu_maxTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdatePreferredEdgeLength() {
        return Double.parseDouble(this.tf_lu_prefEdgeLength.getText());
    }

    public void setLayoutUpdatePreferredEdgeLength(double d) {
        this.tf_lu_prefEdgeLength.setText(String.valueOf(d));
    }

    public double getLayoutUpdateGravitation() {
        return Double.parseDouble(this.tf_lu_gravitation.getText());
    }

    public void setLayoutUpdateGravitation(double d) {
        this.tf_lu_gravitation.setText(String.valueOf(d));
    }

    public double getLayoutUpdateRandomImpulseRange() {
        return Double.parseDouble(this.tf_lu_randomImpulseRange.getText());
    }

    public void setLayoutUpdateRandomImpulseRange(double d) {
        this.tf_lu_randomImpulseRange.setText(String.valueOf(d));
    }

    public double getLayoutUpdateOverlapDetectionWidth() {
        return Double.parseDouble(this.tf_lu_overlapDetectWidth.getText());
    }

    public void setLayoutUpdateOverlapDetectionWidth(double d) {
        this.tf_lu_overlapDetectWidth.setText(String.valueOf(d));
    }

    public double getLayoutUpdateOverlapPreferredDistance() {
        return Double.parseDouble(this.tf_lu_overlapPrefDistance.getText());
    }

    public void setLayoutUpdateOverlapPreferredDistance(double d) {
        this.tf_lu_overlapPrefDistance.setText(String.valueOf(d));
    }

    public void setLayoutUpdateAvoidOverlapping(boolean bl) {
        this.cb_lu_avoidOverlapping.setSelected(bl);
        this.switchVisibility();
    }

    public boolean getLayoutUpdateAvoidOverlapping() {
        return this.cb_lu_avoidOverlapping.isSelected();
    }

    public double getLayoutUpdateAlphaOsc() {
        return Math.toRadians(Double.parseDouble(this.tf_lu_alphaOsc.getText()));
    }

    public void setLayoutUpdateAlphaOsc(double d) {
        this.tf_lu_alphaOsc.setText(String.valueOf(Math.toDegrees(d)));
    }

    public double getLayoutUpdateAlphaRot() {
        return Math.toRadians(Double.parseDouble(this.tf_lu_alphaRot.getText()));
    }

    public void setLayoutUpdateAlphaRot(double d) {
        this.tf_lu_alphaRot.setText(String.valueOf(Math.toDegrees(d)));
    }

    public double getLayoutUpdateSigmaOsc() {
        return Double.parseDouble(this.tf_lu_sigmaOsc.getText());
    }

    public void setLayoutUpdateSigmaOsc(double d) {
        this.tf_lu_sigmaOsc.setText(String.valueOf(d));
    }

    public double getLayoutUpdateSigmaRot() {
        return Double.parseDouble(this.tf_lu_sigmaRot.getText());
    }

    public void setLayoutUpdateSigmaRot(double d) {
        this.tf_lu_sigmaRot.setText(String.valueOf(d));
    }

    public boolean getLayoutUpdateComputePermutation() {
        return this.cb_lu_computePermutation.isSelected();
    }

    public void setLayoutUpdateComputePermutation(boolean bl) {
        this.cb_lu_computePermutation.setSelected(bl);
    }

    public void setLayoutUpdateEndPerAverage(boolean bl) {
        this.cb_lu_endPerAverage.setSelected(bl);
    }

    public boolean getLayoutUpdateEndPerAverage() {
        return this.cb_lu_endPerAverage.isSelected();
    }

    public void setLayoutUpdateEnabled(boolean bl) {
        this.cb_lu_enableLayoutUpdate.setSelected(bl);
        this.switchLayoutUpdatePanel();
    }

    public boolean getLayoutUpdateEnabled() {
        return this.cb_lu_enableLayoutUpdate.isSelected();
    }

    public void setLayoutUpdateMethod(String string) {
        this.comb_lu_method.setSelectedItem(string);
        this.switchVisibility();
    }

    public String getLayoutUpdateMethod() {
        return (String)this.comb_lu_method.getSelectedItem();
    }

    public void setLayoutUpdateDepth(int n) {
        this.tf_lu_depth.setText(String.valueOf(n));
    }

    public int getLayoutUpdateDepth() {
        return Integer.parseInt(this.tf_lu_depth.getText());
    }

    public void setOptimizationAlgorithmEnabled(boolean bl) {
        this.cb_useOptimizationAlg.setSelected(bl);
        this.switchVisibility();
    }

    public boolean getOptimizationAlgorithmEnabled() {
        return this.cb_useOptimizationAlg.isSelected();
    }

    public Properties getOptimizationConfiguration() {
        return this.optimizeAlgController.getConfiguration();
    }

    public void setOptimizationConfiguration(Properties properties) {
        this.optimizeAlgController.setConfiguration(properties);
    }

    public void setLayoutUpdateOptimizationAlgorithmEnabled(boolean bl) {
        this.cb_lu_useOptimizationAlg.setSelected(bl);
        this.switchVisibility();
    }

    public boolean getLayoutUpdateOptimizationAlgorithmEnabled() {
        return this.cb_lu_useOptimizationAlg.isSelected();
    }

    public void setLayoutUpdateOptimizationConfiguration(Properties properties) {
        this.lu_optimizeAlgController.setConfiguration(properties);
    }

    public Properties getLayoutUpdateOptimizationConfiguration() {
        return this.lu_optimizeAlgController.getConfiguration();
    }

    public void setLayoutUpdateMethodPerimeterInitSize(double d) {
        this.tf_lu_perimeter_initSize.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMethodPerimeterInitSize() {
        return Double.parseDouble(this.tf_lu_perimeter_initSize.getText());
    }

    public void setLayoutUpdateMethodPerimeterSizeInc(double d) {
        this.tf_lu_perimeter_sizeInc.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMethodPerimeterSizeInc() {
        return Double.parseDouble(this.tf_lu_perimeter_sizeInc.getText());
    }

    public void setLayoutUpdateClusteringEnabled(boolean bl) {
        this.cb_lu_cluster_enable.setSelected(bl);
        this.switchVisibility();
    }

    public boolean getLayoutUpdateClusteringEnabled() {
        return this.cb_lu_cluster_enable.isSelected();
    }

    public void setLayoutUpdateClusteringInitTemperature(double d) {
        this.tf_lu_cluster_initTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdateClusteringInitTemperature() {
        return Double.parseDouble(this.tf_lu_cluster_initTemperature.getText());
    }

    public void setLayoutUpdateClusteringForceScalingFactor(double d) {
        this.tf_lu_cluster_forceScalingFactor.setText(String.valueOf(d));
    }

    public double getLayoutUpdateClusteringForceScalingFactor() {
        return Double.parseDouble(this.tf_lu_cluster_forceScalingFactor.getText());
    }

    public void setLayoutUpdateClusteringFactor(double d) {
        this.tf_lu_cluster_factor.setText(String.valueOf(d));
    }

    public double getLayoutUpdateClusteringFactor() {
        return Double.parseDouble(this.tf_lu_cluster_factor.getText());
    }
}

