/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.RadialTreeLayoutSettings;

public class RadialTreeLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final String KEY_WIDTH = "Width";
    public static final String KEY_HEIGHT = "Height";
    public static final String KEY_CENTRE_X = "CentreX";
    public static final String KEY_CENTRE_Y = "CentreY";
    public static final String KEY_RADIUS_X = "RadiusX";
    public static final String KEY_RADIUS_Y = "RadiusY";
    private static final String RADIAL_TREE_VISITED = "RadialTreeVisited";
    private static final double TWO_PI = Math.PI * 2;
    protected double RADIUSX;
    protected double RADIUSY;
    protected double ROOTX;
    protected double ROOTY;
    protected double WIDTH;
    protected double HEIGHT;
    private JGraph jgraph;

    public String toString() {
        return "Radial Tree";
    }

    public String getHint() {
        return "Select a tree";
    }

    public JGraphLayoutSettings createSettings() {
        return new RadialTreeLayoutSettings(this);
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        List list;
        this.jgraph = jGraph;
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray);
        TreeNode treeNode = this.getSpanningTree(cellViewArray, list = this.getRoots(this.jgraph, cellViewArray));
        if (null == treeNode) {
            return;
        }
        double d = treeNode.getDepth();
        Rectangle2D rectangle2D = this.jgraph.getCellBounds(objectArray);
        double d2 = this.WIDTH;
        if (this.WIDTH == this.ROOTX && this.ROOTX == this.RADIUSX && this.ROOTX == 0.0) {
            d2 = rectangle2D.getWidth();
        }
        if (d2 != 0.0) {
            this.ROOTX = d2 / 2.0;
            this.RADIUSX = this.ROOTX / d;
        }
        double d3 = this.HEIGHT;
        if (this.HEIGHT == this.ROOTY && this.ROOTY == this.RADIUSY && this.ROOTY == 0.0) {
            d3 = rectangle2D.getHeight();
        }
        if (d3 != 0.0) {
            this.ROOTY = d3 / 2.0;
            this.RADIUSY = this.ROOTY / d;
        }
        HashMap hashMap = new HashMap();
        this.layoutTree0(hashMap, treeNode);
        this.jgraph.getGraphLayoutCache().edit(hashMap, null, null, null);
    }

    public void setConfiguration(Properties properties) {
        if (properties.containsKey(KEY_WIDTH)) {
            this.WIDTH = Double.parseDouble(properties.getProperty(KEY_WIDTH));
        } else {
            if (!properties.containsKey(KEY_CENTRE_X)) {
                throw new IllegalArgumentException("Must specify one of KEY_WIDTH or KEY_CENTRE_X");
            }
            this.ROOTX = Double.parseDouble(properties.getProperty(KEY_CENTRE_X));
            if (properties.containsKey(KEY_RADIUS_X)) {
                this.RADIUSX = Double.parseDouble(properties.getProperty(KEY_RADIUS_X));
            } else {
                throw new IllegalArgumentException("Must specify one of KEY_WIDTH or KEY_RADIUS_X");
            }
        }
        if (properties.containsKey(KEY_HEIGHT)) {
            this.HEIGHT = Double.parseDouble(properties.getProperty(KEY_HEIGHT));
        } else {
            if (!properties.containsKey(KEY_CENTRE_Y)) {
                throw new IllegalArgumentException("Must specify one of KEY_HEIGHT or KEY_CENTRE_Y");
            }
            this.ROOTY = Double.parseDouble(properties.getProperty(KEY_CENTRE_Y));
            if (properties.containsKey(KEY_RADIUS_Y)) {
                this.RADIUSY = Double.parseDouble(properties.getProperty(KEY_RADIUS_Y));
            } else {
                throw new IllegalArgumentException("Must specify one of KEY_WIDTH or KEY_RADIUS_X");
            }
        }
    }

    private void layoutTree0(Map map, TreeNode treeNode) {
        treeNode.angle = 0.0;
        treeNode.x = this.ROOTX;
        treeNode.y = this.ROOTY;
        treeNode.rightBisector = 0.0;
        treeNode.rightTangent = 0.0;
        treeNode.leftBisector = Math.PI * 2;
        treeNode.leftTangent = Math.PI * 2;
        VertexView vertexView = treeNode.getView();
        if (null != vertexView) {
            this.placeView(map, vertexView, this.ROOTX, this.ROOTY);
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(1);
        arrayList.add(treeNode);
        this.layoutTreeN(map, 1, arrayList);
    }

    private void layoutTreeN(Map map, int n, List list) {
        double d = 0.0;
        TreeNode treeNode = null;
        TreeNode treeNode2 = null;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            List list2 = treeNode3.getChildren();
            double d2 = treeNode3.rightLimit();
            double d3 = (treeNode3.leftLimit() - d2) / (double)list2.size();
            Iterator iterator2 = list2.iterator();
            double d4 = 0.5;
            while (iterator2.hasNext()) {
                TreeNode treeNode4 = (TreeNode)iterator2.next();
                VertexView vertexView = treeNode4.getView();
                treeNode4.angle = d2 + d4 * d3;
                treeNode4.x = this.ROOTX + (double)n * this.RADIUSX * Math.cos(treeNode4.angle);
                treeNode4.y = this.ROOTY + (double)n * this.RADIUSY * Math.sin(treeNode4.angle);
                this.placeView(map, vertexView, treeNode4.x, treeNode4.y);
                if (treeNode4.hasChildren()) {
                    arrayList.add(treeNode4);
                    if (null == treeNode) {
                        treeNode = treeNode4;
                    }
                    double d5 = treeNode4.angle - d;
                    treeNode4.rightBisector = treeNode4.angle - d5 / 2.0;
                    if (null != treeNode2) {
                        treeNode2.leftBisector = treeNode4.rightBisector;
                    }
                    double d6 = (double)n / ((double)n + 1.0);
                    double d7 = 2.0 * Math.asin(d6);
                    treeNode4.leftTangent = treeNode4.angle + d7;
                    treeNode4.rightTangent = treeNode4.angle - d7;
                    d = treeNode4.angle;
                    treeNode2 = treeNode4;
                }
                d4 += 1.0;
            }
        }
        if (null != treeNode) {
            double d8 = Math.PI * 2 - treeNode2.angle;
            treeNode.rightBisector = (treeNode.angle - d8) / 2.0;
            treeNode2.leftBisector = treeNode.rightBisector < 0.0 ? treeNode.rightBisector + Math.PI * 2 + Math.PI * 2 : treeNode.rightBisector + Math.PI * 2;
        }
        if (arrayList.size() > 0) {
            this.layoutTreeN(map, n + 1, arrayList);
        }
    }

    private void placeView(Map map, VertexView vertexView, double d, double d2) {
        Rectangle2D rectangle2D = vertexView.getBounds();
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        rectangle.x = (int)Math.round(d);
        rectangle.y = (int)Math.round(d2);
        Object object = vertexView.getCell();
        Hashtable hashtable = new Hashtable();
        GraphConstants.setBounds(hashtable, (Rectangle2D)rectangle);
        map.put(object, hashtable);
    }

    private List getChildren(VertexView vertexView, List list) {
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        Object object = vertexView.getCell();
        GraphModel graphModel = this.jgraph.getModel();
        int n = graphModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = graphModel.getChild(object, i);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (object2 != graphModel.getSource(e)) continue;
                Object object3 = graphModel.getTarget(e);
                Object object4 = graphModel.getParent(object3);
                VertexView vertexView2 = (VertexView)this.jgraph.getGraphLayoutCache().getMapping(object4, false);
                if (!list.contains(vertexView2)) continue;
                arrayList.add(vertexView2);
            }
        }
        return arrayList;
    }

    private List getRoots(JGraph jGraph, CellView[] cellViewArray) {
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        GraphModel graphModel = jGraph.getModel();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof VertexView)) continue;
            VertexView vertexView = (VertexView)cellViewArray[i];
            boolean bl = true;
            Object object = vertexView.getCell();
            int n = graphModel.getChildCount(object);
            for (int j = 0; bl && j < n; ++j) {
                Object object2 = graphModel.getChild(object, j);
                Iterator iterator = graphModel.edges(object2);
                while (bl && iterator.hasNext()) {
                    Object e = iterator.next();
                    if (graphModel.getTarget(e) != object2) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            arrayList.add(vertexView);
        }
        return arrayList;
    }

    private TreeNode getSpanningTree(CellView[] cellViewArray, List list) {
        TreeNode treeNode;
        VertexView vertexView;
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>(cellViewArray.length);
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof VertexView)) continue;
            vertexView = (VertexView)cellViewArray[i];
            vertexView.getAttributes().remove((Object)RADIAL_TREE_VISITED);
            arrayList.add(vertexView);
        }
        if (list.size() == 0) {
            if (arrayList.size() == 0) {
                return null;
            }
            list.add(arrayList.get(0));
        }
        if (list.size() > 1) {
            treeNode = new TreeNode(null);
            this.buildSpanningTree(arrayList, treeNode, list);
        } else {
            vertexView = (VertexView)list.get(0);
            treeNode = new TreeNode(vertexView);
            vertexView.getAttributes().put((Object)RADIAL_TREE_VISITED, (Object)Boolean.TRUE);
            this.buildSpanningTree(arrayList, treeNode, this.getChildren(vertexView, arrayList));
        }
        return treeNode;
    }

    private void buildSpanningTree(List list, TreeNode treeNode, List list2) {
        Object object;
        Object object2;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (VertexView)iterator.next();
            if (null != object2.getAttributes().get((Object)RADIAL_TREE_VISITED)) continue;
            object2.getAttributes().put((Object)RADIAL_TREE_VISITED, (Object)Boolean.TRUE);
            object = new TreeNode((VertexView)object2);
            treeNode.addChild((TreeNode)object);
        }
        iterator = treeNode.getChildren().iterator();
        while (iterator.hasNext()) {
            object2 = (TreeNode)iterator.next();
            object = ((TreeNode)object2).getView();
            this.buildSpanningTree(list, (TreeNode)object2, this.getChildren((VertexView)object, list));
        }
    }

    private static class TreeNode {
        private VertexView view;
        private List children = new ArrayList();
        public double angle;
        public double x;
        public double y;
        public double rightBisector;
        public double leftBisector;
        public double rightTangent;
        public double leftTangent;

        TreeNode(VertexView vertexView) {
            this.view = vertexView;
        }

        public int getDepth() {
            int n = 1;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TreeNode treeNode = (TreeNode)iterator.next();
                int n2 = treeNode.getDepth();
                if (n2 < n) continue;
                n = n2 + 1;
            }
            return n;
        }

        public VertexView getView() {
            return this.view;
        }

        public void addChild(TreeNode treeNode) {
            this.children.add(treeNode);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public double leftLimit() {
            return Math.min(this.normalize(this.leftBisector), this.leftTangent);
        }

        public double rightLimit() {
            return Math.max(this.normalize(this.rightBisector), this.rightTangent);
        }

        private double normalize(double d) {
            return d;
        }
    }
}

