/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.SugiyamaLayoutAlgorithm;

public class SugiyamaLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    protected SugiyamaLayoutAlgorithm layout;
    private JTextField verticalSpacingTextField = new JTextField();
    private JTextField horizontalSpacingTextField = new JTextField();

    public SugiyamaLayoutSettings(SugiyamaLayoutAlgorithm sugiyamaLayoutAlgorithm) {
        this.layout = sugiyamaLayoutAlgorithm;
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.add(new JLabel("Horizontal Spacing"));
        jPanel.add(this.horizontalSpacingTextField);
        jPanel.add(new JLabel("Vertical Spacing"));
        jPanel.add(this.verticalSpacingTextField);
        this.add((Component)jPanel, "Center");
        this.revert();
    }

    public void revert() {
        this.horizontalSpacingTextField.setText(String.valueOf(this.layout.spacing.x));
        this.verticalSpacingTextField.setText(String.valueOf(this.layout.spacing.y));
    }

    public void apply() {
        this.check();
        this.layout.spacing.x = Integer.parseInt(this.getIndention());
        this.layout.spacing.y = Integer.parseInt(this.getVerticalSpacing());
    }

    private void check() {
        try {
            Integer.parseInt(this.horizontalSpacingTextField.getText());
            Integer.parseInt(this.verticalSpacingTextField.getText());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public String getIndention() {
        return this.horizontalSpacingTextField.getText().trim();
    }

    public void setIndention(String string) {
        this.horizontalSpacingTextField.setText(string);
    }

    public String getVerticalSpacing() {
        return this.verticalSpacingTextField.getText().trim();
    }

    public void setVerticalSpacing(String string) {
        this.verticalSpacingTextField.setText(string);
    }
}

