package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.HashSet;
import java.util.HashMap;
import java.util.Vector;

import org._3pq.jgrapht.graph.SimpleDirectedGraph;

/**
 *
 */
public class Similarity {
	public static final byte ZZL = 0;

	public static final byte RESNIK = 1;

	public static final byte JIANG = 2;

	public static final byte LIN = 3;

	public static final byte CAO = 4;

	/**
	 * evaluate the similarity of two nodes in directed acylic graph
	 * 
	 * @param graphModel
	 *            the graph that contains the two nodes
	 * @param obj1
	 *            one of the two nodes
	 * @param obj2
	 *            one of the two nodes
	 * @param type
	 *            Similarity.CAO: basen on information content <br>
	 *            Similarity.LIN: basen on information content, see <a
	 *            href="http://citeseer.ist.psu.edu/cache/papers/cs/1049/ftp:zSzzSzftp.cs.umanitoba.cazSzpubzSzlindekzSzpaperszSzsim.pdf/an-information-theoretic-definition.pdf">
	 *            Lin D. An information-theoretic definition of similarity. In: Proceedings of 15th International
	 *            Conference on Machine Learning, San Francisco US, 1998, 296-304</a> <br>
	 *            Similarity.RESNIK: based on information content, see <a
	 *            href="http://citeseer.ist.psu.edu/cache/papers/cs/2124/http:zSzzSzwww.cs.umbc.eduzSz891zSzresnik.pdf/resnik95using.pdf">
	 *            Resnik P. Using information content to evaluate semantic similarity in a taxonomy. In: Proceedings of
	 *            the 14th International Joint Conference on Artificial Intelligence, Montreal Canada, 1995, 448-453</a>
	 *            <br>
	 *            Similarity.JIANG: based on information content, see <a
	 *            href="http://arxiv.org/PS_cache/cmp-lg/pdf/9709/9709008.pdf"> Jay J. Jiang and David W. Conrath,
	 *            Semantic Similarity Based on Corpus Statistics and Lexical Taxonomy, In In Proceedings of
	 *            International Conference Research on Computational Linguistics (ROCLING X), 1997, Taiwan.</a> <br>
	 *            Similarity.ZZL: based on distance, see Zhong <a href="http://apex.sjtu.edu.cn/docs/iccs2002.pdf">JW,
	 *            Zhu HP, Li JM, Yu Y. Conceptual Graph Matching for Semantic Search. In: Proceedings of the 10th
	 *            International Conference on Conceptual Structures: Integration and Interfaces, 2002, 92-196</a>
	 * @return the semanic similarity value
	 */
	public static double evaluate(OntologyGraphModel graphModel, Object obj1, Object obj2, byte type) {
		SimpleDirectedGraph subGraph = graphModel.getGraph();
		HashMap nodeChildNumberMap = graphModel.getNodeChildNumberMap();
		Object[][] aPath = GraphPath.getPath2Root(subGraph, obj1);
		Object[][] bPath = GraphPath.getPath2Root(subGraph, obj2);
		Object root1 = aPath[0][aPath[0].length - 1];
		Object root2 = bPath[0][bPath[0].length - 1];
		if (!root1.equals(root2)) {
			System.out.println(obj1 + "\t" + obj2);
			return 0;
		}
		double graphNodeNumber = ((Integer) nodeChildNumberMap.get(root1)).floatValue() + 1;
		int[] lcaIndexes = findLatestCommonAncestor(aPath, bPath, subGraph, nodeChildNumberMap);
		switch (type) {
		case RESNIK:
			return -Math.log((((Integer) nodeChildNumberMap.get(bPath[lcaIndexes[0]][lcaIndexes[1]])).floatValue() + 1)
					/ graphNodeNumber);
		case LIN:
			return lin(subGraph, nodeChildNumberMap, bPath[lcaIndexes[0]][lcaIndexes[1]], obj1, obj2, graphNodeNumber);
		case JIANG:
			return jiang(subGraph, nodeChildNumberMap, bPath[lcaIndexes[0]][lcaIndexes[1]], obj1, obj2, graphNodeNumber);
		case CAO:
			return cao(nodeChildNumberMap, aPath, bPath, obj1, obj2, graphNodeNumber);
		case ZZL:
			return zzl(aPath, bPath, lcaIndexes[0], lcaIndexes[1]);
		default:
			return 0;
		}
	}

	/*
	 * private static float oldZZL(Object[][] aPath, Object[][] bPath) { Vector aVector = new Vector(); int max = 0; for
	 * (int i = 0; i < aPath.length; i++) { if (max < aPath[i].length) { aVector.clear(); aVector.add(new Integer(i));
	 * max = aPath[i].length; } else if (max == aPath[i].length) { aVector.add(new Integer(i)); } } Vector bVector = new
	 * Vector(); max = 0; for (int i = 0; i < bPath.length; i++) { if (max < bPath[i].length) { bVector.clear();
	 * bVector.add(new Integer(i)); max = bPath[i].length; } else if (max == bPath[i].length) { bVector.add(new
	 * Integer(i)); } } max = 0; for (int i = 0; i < aVector.size(); i++) { int M = ((Integer)
	 * aVector.get(i)).intValue(); for (int j = 0; j < bVector.size(); j++) { int N = ((Integer)
	 * bVector.get(j)).intValue(); int commonNum = 0; for (int m = aPath[M].length - 1, n = bPath[N].length - 1; m > -1 &&
	 * n > -1; m--, n--) { if (aPath[M][m].equals(bPath[N][n])) { commonNum++; } else { break; } } max = (max <
	 * commonNum) ? commonNum : max; } } float d1 = (float) (0.5 / Math.pow(2, aPath[((Integer)
	 * aVector.get(0)).intValue()].length - 1)); float d2 = (float) (0.5 / Math.pow(2, bPath[((Integer)
	 * bVector.get(0)).intValue()].length - 1)); float d0 = (float) (0.5 / Math.pow(2, max - 1)); return 2 * d0 - d1 -
	 * d2; }
	 */

	private static float zzl(Object[][] aPath, Object[][] bPath, int dim1, int dim2) {
		int size = bPath[dim1].length - dim2;
		HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
		for (int i = 0; i < aPath.length; i++) {
			int swap = aPath[i].length - size;
			if (swap > -1 && aPath[i][swap].equals(bPath[dim1][dim2])) {
				map.put(new Integer(i), new Integer(swap));
			}
		}
		Object[] keys = map.keySet().toArray();
		int[] indexes = new int[keys.length];
		for (int i = 0; i < keys.length; i++) {
			indexes[i] = ((Integer) keys[i]).intValue();
			boolean hit = true;
			for (int m = map.get(keys[i]).intValue(), n = dim2; m < aPath[indexes[i]].length && n < bPath[dim1].length; m++, n++) {
				if (!aPath[indexes[i]][m].equals(bPath[dim1][n])) {
					hit = false;
					break;
				}
			}
			if (!hit) {
				indexes[i] = -1;
			}
		}
		int index = -1;
		int maxPathNumber = 0;
		for (int i = 0; i < indexes.length; i++) {
			if (indexes[i] > -1) {
				if (maxPathNumber < aPath[indexes[i]].length) {
					maxPathNumber = aPath[indexes[i]].length;
					index = indexes[i];
				}
			}
		}
		if (index < 0) {
			System.out.println("Error!");
			return 0;
		} else {
			float d1 = (float) (0.5 / Math.pow(2, aPath[index].length - 1));
			float d2 = (float) (0.5 / Math.pow(2, bPath[dim1].length - 1));
			float d0 = (float) (0.5 / Math.pow(2, size - 1));
			return 2 * d0 - d1 - d2;
		}
	}

	private static double lin(SimpleDirectedGraph graph, HashMap nodeChildNumberMap, Object latestCommonAncestor,
			Object obj1, Object obj2, double rootChildrenNum) {
		double pc = (((Integer) nodeChildNumberMap.get(latestCommonAncestor)).floatValue() + 1) / rootChildrenNum;
		double pc1 = (((Integer) nodeChildNumberMap.get(obj1)).floatValue() + 1) / rootChildrenNum;
		double pc2 = (((Integer) nodeChildNumberMap.get(obj2)).floatValue() + 1) / rootChildrenNum;
		return 2 * Math.log(pc) / (Math.log(pc1) + Math.log(pc2));
	}

	private static double jiang(SimpleDirectedGraph graph, HashMap nodeChildNumberMap, Object latestCommonAncestor,
			Object obj1, Object obj2, double rootChildrenNum) {
		double pc = (((Integer) nodeChildNumberMap.get(latestCommonAncestor)).floatValue() + 1) / rootChildrenNum;
		double pc1 = (((Integer) nodeChildNumberMap.get(obj1)).floatValue() + 1) / rootChildrenNum;
		double pc2 = (((Integer) nodeChildNumberMap.get(obj2)).floatValue() + 1) / rootChildrenNum;
		return 2 * Math.log(pc) - ((Math.log(pc1) + Math.log(pc2)));
	}

	private static double cao(HashMap nodeChildNumberMap, Object[][] aPath, Object[][] bPath, Object obj1, Object obj2,
			double rootChildrenNum) {
		HashSet<Object> aSet = new HashSet<Object>();
		HashSet<Object> bSet = new HashSet<Object>();
		for (int i = 0; i < aPath.length; i++) {
			for (int j = 0; j < aPath[i].length; j++) {
				aSet.add(aPath[i][j]);
			}
		}
		for (int i = 0; i < bPath.length; i++) {
			for (int j = 0; j < bPath[i].length; j++) {
				bSet.add(bPath[i][j]);
			}
		}

		Object[] values = aSet.toArray();
		HashSet<Object> commonParentSet = new HashSet<Object>();
		for (int i = 0; i < values.length; i++) {
			if (bSet.contains(values[i])) {
				commonParentSet.add(values[i]);
			}
		}
		HashSet<Object> allSet = new HashSet<Object>();
		allSet.addAll(aSet);
		allSet.addAll(bSet);
		double commonInfo = 0;
		values = commonParentSet.toArray();
		for (int j = 0; j < values.length; j++) {
			double swap = (((Integer) nodeChildNumberMap.get(values[j])).floatValue() + 1) / rootChildrenNum;
			commonInfo += -Math.log(swap);
		}
		double allInfo = 0;
		values = allSet.toArray();
		for (int j = 0; j < values.length; j++) {
			double swap = (((Integer) nodeChildNumberMap.get(values[j])).floatValue() + 1) / rootChildrenNum;
			allInfo += -Math.log(swap);
		}
		return commonInfo / allInfo;
	}

	// the path begin from bottom to up
	private static int[] findLatestCommonAncestor(Object[][] aPath, Object[][] bPath, SimpleDirectedGraph graph,
			HashMap nodeChildNumberMap) {
		HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
		HashSet<Object> set = new HashSet<Object>();
		for (int i = 0; i < aPath.length; i++) {
			for (int j = 0; j < aPath[i].length; j++) {
				set.add(aPath[i][j]);
			}
		}
		for (int i = 0; i < bPath.length; i++) {
			for (int j = bPath[i].length - 1; j > -1; j--) {
				if (set.contains(bPath[i][j])) {
					map.put(new Integer(i), new Integer(j));
				}
			}
		}
		Object[] values = map.keySet().toArray();
		int maxCommonPathLength = 0;
		Vector<Object> vector = new Vector<Object>();
		for (int i = 0; i < values.length; i++) {
			int swapCommonPathLength = bPath[((Integer) values[i]).intValue()].length - map.get(values[i]).intValue();
			if (maxCommonPathLength < swapCommonPathLength) {
				vector.clear();
				vector.add(values[i]);
				maxCommonPathLength = swapCommonPathLength;
			} else if (maxCommonPathLength == swapCommonPathLength) {
				vector.add(values[i]);
			}
		}
		int[] array = new int[vector.size() * 2];
		values = vector.toArray();
		for (int i = 0; i < array.length; i += 2) {
			array[i] = ((Integer) values[i / 2]).intValue();
			array[i + 1] = map.get(values[i / 2]).intValue();
		}
		return getMaxInformationIndexes(bPath, array, nodeChildNumberMap);
	}

	private static int[] getMaxInformationIndexes(Object[][] path, int[] indexes, HashMap nodeChildNumberMap) {
		float max = 0;
		int[] dim = { -1, -1 };
		for (int i = 0; i < indexes.length; i += 2) {
			int swap = ((Integer) nodeChildNumberMap.get(path[indexes[i]][indexes[i + 1]])).intValue() + 1;
			if (max < swap) {
				dim[0] = indexes[i];
				dim[1] = indexes[i + 1];
				max = swap;
			} else if (max == swap) {
				if (path[dim[0]].length < path[indexes[i]].length) {
					dim[0] = indexes[i];
					dim[1] = indexes[i + 1];
				}
			}
		}
		return dim;
	}
}
