package edu.hust.go.gui;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import javax.swing.ToolTipManager;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.awt.Component;
import java.util.Enumeration;

public class GoTreeView
    extends JTree {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public GoTreeView(TreeModel model) {
        super(model);
        ToolTipManager.sharedInstance().registerComponent(this);
        setCellRenderer(new TipTreeCellRenderer());
        TreeNode root = (TreeNode) model.getRoot();
        expandAll(this, new TreePath(root), true);
    }

    class TipTreeCellRenderer
        extends DefaultTreeCellRenderer {
        /**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded,
            boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String toolTip = "";
            if (value instanceof GoCell) {
                toolTip = ( (GoCell) value).getToolTipString();
            }
            setToolTipText(toolTip);
            return this;
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode) parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e = node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode) e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        }
        else {
            tree.collapsePath(parent);
        }
    }

}
