package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.List;
import java.util.Vector;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Arrays;

import org._3pq.jgrapht.graph.SimpleDirectedGraph;
import org._3pq.jgrapht.edge.DirectedEdge;

public class GraphPath {
    /*public static HashSet getNodeAllParents(SimpleDirectedGraph graph, Object node) {
        return getAviableNodes(graph, node, true);
    }

    public static HashSet getNodeAllChildren(SimpleDirectedGraph graph, Object node) {
        return getAviableNodes(graph, node, false);
    }*/

    public static Vector<Object> getNodeParents(SimpleDirectedGraph graph, Object node) {
        return getDirectNodes(graph, node, true);
    }

    public static Vector<Object> getNodeChildren(SimpleDirectedGraph graph, Object node) {
        return getDirectNodes(graph, node, false);
    }

    private static Vector<Object> getDirectNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        Vector<Object> list = new Vector<Object>();
        List edgeList;
        if (parent) {
            edgeList = graph.incomingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ((DirectedEdge) edgeList.get(i)).getSource();
                list.add(obj);
            }
        } else {
            edgeList = graph.outgoingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ((DirectedEdge) edgeList.get(i)).getTarget();
                list.add(obj);
            }
        }
        return list;
    }

    public static HashSet<Object> getLowerSubNodes(SimpleDirectedGraph graph, Object node) {
        HashSet<Object> set = new HashSet<Object>();
        List edgeList;
        edgeList = graph.outgoingEdgesOf(node);
        for (int i = 0; i < edgeList.size(); i++) {
            Object obj = ((DirectedEdge) edgeList.get(i)).getTarget();
            set.add(obj);
            set.addAll(getLowerSubNodes(graph, obj));
        }
        return set;
    }

    public static HashSet<Object> getUpperSubNodes(SimpleDirectedGraph graph, Object node) {
        HashSet<Object> set = new HashSet<Object>();
        List edgeList;
        edgeList = graph.incomingEdgesOf(node);
        for (int i = 0; i < edgeList.size(); i++) {
            Object obj = ((DirectedEdge) edgeList.get(i)).getSource();
            set.add(obj);
            set.addAll(getUpperSubNodes(graph, obj));
        }
        return set;
    }

    /*private static HashSet getAviableNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        HashSet set = new HashSet();
        List edgeList;
        if (parent) {
            edgeList = graph.incomingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ((DirectedEdge) edgeList.get(i)).getSource();
                set.add(obj);
                set.addAll(getAviableNodes(graph, obj, parent));
            }
        } else {
            edgeList = graph.outgoingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ((DirectedEdge) edgeList.get(i)).getTarget();
                set.add(obj);
                set.addAll(getAviableNodes(graph, obj, parent));
            }
        }
        return set;
    }*/

    public static HashMap getPath2Node(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        Vector<Object> pathVector = new Vector<Object>();
        HashSet<Object> p1Set = getUpperSubNodes(graph, obj1);
        HashSet<Object> p2Set = getUpperSubNodes(graph, obj2);
        HashSet<Object> commonSet = getCommonElements(p1Set.toArray(), p2Set.toArray());
        Object[][] path = getPath2Root(graph, obj1);
        for (int i = 0; i < path.length; i++) {
            for (int j = 0; j < path[i].length; j++) {
                if (commonSet.contains(path[i][j])) {
                    pathVector.add(path[i]);
                    break;
                }
            }
        }
        path = getPath2Root(graph, obj2);
        for (int i = 0; i < path.length; i++) {
            for (int j = 0; j < path[i].length; j++) {
                if (commonSet.contains(path[i][j])) {
                    pathVector.add(path[i]);
                    break;
                }
            }
        }
        HashMap<HashSet<Object>,Object[]> pathMap = new HashMap<HashSet<Object>,Object[]>();
        pathMap.put(commonSet, pathVector.toArray());
        return pathMap;
    }

    public static boolean related(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        boolean related;
        if (obj1.equals(obj2)) {
            related = true;
        } else {
            HashSet<Object> children = getLowerSubNodes(graph, obj1);
            HashSet<Object> parents = getUpperSubNodes(graph, obj1);
            related = children.contains(obj2) || parents.contains(obj2);
        }
        return related;
    }

    public static Object[][] getPath2Root(SimpleDirectedGraph graph, Object node) {
        Vector<Object> path = getPathVector(graph, node);
        return convertPahtVector2Array(path);
    }

    private static Vector<Object> getPathVector(SimpleDirectedGraph graph, Object obj) {
        Vector<Object> pathVector = new Vector<Object>();
        pathVector.add(obj);

        int pNumber = graph.inDegreeOf(obj);
        boolean finish = false;

        Object curObj = obj;
        while (pNumber < 2) {
            if (pNumber == 0) {
                finish = true;
                break;
            }
            curObj = ((DirectedEdge) graph.incomingEdgesOf(curObj).get(0)).getSource();
            pathVector.add(curObj);
            pNumber = graph.inDegreeOf(curObj);
        }
        if (!finish) {
            Object[] edges = graph.incomingEdgesOf(curObj).toArray();
            Vector<Vector<Object>> _path = new Vector<Vector<Object>>(pNumber);
            for (int i = 0; i < edges.length; i++) {
                Object source = ((DirectedEdge) edges[i]).getSource();
                _path.add(getPathVector(graph, source));
            }
            pathVector.add(_path);
        }
        return pathVector;
    }

    private static Object[][] convertPahtVector2Array(Vector<Object> fullPath) {
        int size = fullPath.size();
        Object obj = fullPath.get(size - 1);
        Object[][] pathArray;
        if (obj instanceof Vector) {
            Object[] prefixPath = new Object[size - 1];
            for (int i = 0; i < size - 1; i++) {
                prefixPath[i] = fullPath.get(i);
            }
            Vector<Vector<Object>> curPath = (Vector<Vector<Object>>) obj;
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            Vector<Object[]> temp = new Vector<Object[]>();
            for (int i = 0; i < curPath.size(); i++) {
                Object[][] tempPath = convertPahtVector2Array(curPath.get(i));
                for (int j = 0; j < tempPath.length; j++) {
                    Object[] swapPath = new Object[size - 1 + tempPath[j].length];
                    System.arraycopy(prefixPath, 0, swapPath, 0, size - 1);
                    System.arraycopy(tempPath[j], 0, swapPath, size - 1, tempPath[j].length);
                    temp.add(swapPath);

                    Integer pathLength = new Integer(swapPath.length);
                    String indexStr = (map.get(pathLength) == null) ? String.valueOf(temp.size() - 1) :
                                      (map.get(pathLength) + " " + (temp.size() - 1));
                    map.put(pathLength, indexStr);
                }
            }

            pathArray = new Object[temp.size()][];
            Integer[] pathSize = new Integer[map.size()];
            map.keySet().toArray(pathSize);
            Arrays.sort(pathSize);
            int flag = 0;
            for (int i = 0; i < pathSize.length; i++) {
                String[] str = map.get(pathSize[pathSize.length - 1 - i]).split(" ");
                for (int j = 0; j < str.length; j++) {
                    pathArray[flag++] = temp.get(Integer.parseInt(str[j]));
                }
            }
        } else {
            pathArray = new Object[1][size];
            fullPath.toArray(pathArray[0]);
        }
        return pathArray;
    }

    public static void getCommonElements(Object[][] path, HashMap<Object, Integer> map) {
        HashSet<Object> nodeSet = new HashSet<Object>();
        for (int i = 0; i < path.length; i++) {
            for (int j = 0; j < path[i].length; j++) {
                nodeSet.add(path[i][j]);
            }
        }
        Object[] nodes = nodeSet.toArray();
        for (int i = 0; i < nodes.length; i++) {
            int value = (map.get(nodes[i]) == null) ? 0 : map.get(nodes[i]).intValue();
            map.put(nodes[i], new Integer(++value));
        }
    }

    public static HashSet<Object> getCommonElements(Object[] apath, Object[] bpath) {
        HashSet<Object> set = new HashSet<Object>();
        HashSet<Object> commonSet = new HashSet<Object>();
        for (int i = 0; i < apath.length; i++) {
            set.add(apath[i]);
        }
        for (int i = 0; i < bpath.length; i++) {
            if (set.contains(bpath[i])) {
                commonSet.add(bpath[i]);
            }
        }
        return commonSet;
    }

    /*public static HashSet getCommonElements(Object[][][] paths) {
        HashSet commonSet = new HashSet();
        int pathNumber = paths.length;
        HashSet[] commonSets = new HashSet[pathNumber];
        for (int i = 0; i < pathNumber; i++) {
            commonSets[i] = getCommonElements(paths[i]);
        }
        if (pathNumber > 0) {
            commonSet = commonSets[0];
            for (int i = 1; i < pathNumber; i++) {
                commonSet = getCommonElements(commonSet.toArray(), commonSets[i].toArray());
            }
        }
        return commonSet;
         }
         public static HashSet getCommonElements(Object[][] path) {
        HashSet commonSet = new HashSet();
        if (path.length == 0) {
            return commonSet;
        }
        for (int i = 0; i < path[0].length; i++) {
            commonSet.add(path[0]);
        }
        for (int i = 1; i < path.length; i++) {
            commonSet = getCommonElements(commonSet.toArray(), path[i]);
        }
        return commonSet;
         }*/
}
