package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.io.File;
import org.xml.sax.helpers.XMLReaderFactory;
import edu.hust.go.term.GO_term;
import edu.hust.go.term.OwlGo_term;

public class OwlGoParser
    extends XmlGoParser {
    public OwlGoParser(String idPatternStr, String idPrefixStr,String connectStr,File _target) {
        this(idPatternStr, idPrefixStr, connectStr,_target, GoParser.defaultThreadNumber, GoParser.defaultPoolSize);
    }

    public OwlGoParser(String idPatternStr, String idPrefixStr,String connectStr,File _target, int _maxThreadNumber) {
        this(idPatternStr, idPrefixStr, connectStr,_target, _maxThreadNumber, GoParser.defaultPoolSize);
    }

    public OwlGoParser(String idPatternStr, String idPrefixStr,String connectStr,File _target, int _maxThreadNumber, int _maxPoolSize) {
        super(_target, _maxThreadNumber, _maxPoolSize);
        setTargetElementName("Class");
        try {
            parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            init();
        }
        catch (Exception e) {
            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
        }
        parse(idPatternStr, idPrefixStr, connectStr,GoParser.OntologyDefineType.OWL);
    }

    public GO_term getGoTermById(int id) {
        return (OwlGo_term) termMap.get(id);
    }
}