package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */

import java.io.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.ext.*;

public abstract class XmlGoParser
    extends GoParser
    implements ContentHandler, DTDHandler, ErrorHandler, DeclHandler, LexicalHandler {
    XMLReader parser;
    Document curDocument;
    Element curElement;

    String targetElementName ;

    public String getTargetElementName() {
        return targetElementName;
    }

    public void setTargetElementName(String _targetElementName) {
        targetElementName=_targetElementName;
    }

    public XmlGoParser(File _target) {
        super(_target, GoParser.defaultThreadNumber, GoParser.defaultPoolSize);
    }

    public XmlGoParser(File _target, int _maxThreadNumber) {
        super(_target, _maxThreadNumber, GoParser.defaultPoolSize);
    }

    /**
     * @param _target GO definition file
     * @param _termType SIMPLE_TERM or COMPLETE_TERM
     * @param _maxThreadNumber thread number
     * @param _maxPoolSize GO term parse speed may slower than read thread, if
     *  the number of unparsed terms greater than maxPoolSize, new term has to
     *  wait until old terms have been parsed.
     */
    public XmlGoParser(File _target, int _maxThreadNumber, int _maxPoolSize) {
        super(_target, _maxThreadNumber, _maxPoolSize);
    }

    void init() {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.setFeature("http://apache.org/xml/features/validation/schema", false);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        }
        catch (SAXException e) {}

        parser.setDTDHandler(this);
        parser.setErrorHandler(this);
        parser.setContentHandler(this);
        try {
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
    }

    protected void parseTarget() {
        try {
            parser.parse(target.getPath());
        }
        catch (IOException e) {
            System.err.println("error: Parse error occurred - " + e.getMessage());
        }
        catch (SAXException e) {
        }
    }

//
// ContentHandler and DocumentHandler methods
//

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int offset, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int offset, int length) throws SAXException {
        if (getCurElement() != null) {
            StringWriter sw = new StringWriter();
            sw.write(ch, offset, length);

            String value = sw.toString();
            Node textNode = getCurElement().getOwnerDocument().createTextNode(value);
            getCurElement().appendChild(textNode);
        }
    }

    public void startElement(String uri, String localName, String qname,
                             Attributes attributes) throws SAXException {
        if (qname.equals(targetElementName)) {
            createNewDocument(localName, qname, attributes);
        }
        else {
            if (getCurElement() != null) {
                addElement(getCurElement(), localName, qname, attributes);
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (qname.equals(getTargetElementName())) {
            Document doc = (Document) getCurElement().getOwnerDocument();
            addDataToPool(doc);
            setCurElement(null);
        }
        else {
            if (getCurElement() != null) {
                setCurElement( (Element) getCurElement().getParentNode());
            }
        }

    }

//
// DTDHandler methods
//

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {

    }

    public void unparsedEntityDecl(String name,
                                   String publicId, String systemId,
                                   String notationName) throws SAXException {
    }

//
// ContentHandler methods
//

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

//
// LexicalHandler methods
//

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int offset, int length) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

//
// DeclHandler methods
//

    public void elementDecl(String name, String contentModel) throws SAXException {
    }

    public void attributeDecl(String elementName, String attributeName,
                              String type, String valueDefault,
                              String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String text) throws SAXException {
    }

    public void externalEntityDecl(String name,
                                   String publicId, String systemId) throws SAXException {
    }

//
// ErrorHandler methods
//

    public void warning(SAXParseException ex) throws SAXException {
        printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        printError("Fatal Error", ex);
        throw ex;
    }

    protected void printError(String type, SAXParseException ex) {

        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf('/');
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }

//
//
//

    private Element getCurElement() {
        return curElement;
    }

    private void setCurElement(Element curElement) {
        this.curElement = curElement;
    }

    private Element createNewDocument(String localName, String qname, Attributes attrs) {
        try {
            curDocument = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Element root = curDocument.createElement(qname);
        int length = attrs.getLength();
        for (int i = 0; i < length; i++) {
            root.setAttribute(attrs.getQName(i), attrs.getValue(i));
        }
        curDocument.appendChild(root);
        setCurElement(root);
        return root;
    }

    private void addElement(Element parent, String localName,
                            String qname, Attributes attrs) {
        Element child = parent.getOwnerDocument().createElement(qname);

        int length = attrs.getLength();
        for (int i = 0; i < length; i++) {
            String Qname = attrs.getQName(i);
            String value = attrs.getValue(i);
            child.setAttribute(Qname, value);
        }
        parent.appendChild(child);
        setCurElement(child);
    }
}
