<?php

// UniGene DLST: Dynamic Local Storage Tool
// R. Hart (c) 2005-6 Rutgers, The State University
// rhart@rci.rutgers.edu

// index.php - web page interface, requires unigene.class.inc

// DLST is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// DLST is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//set passed variables

$working_dir = "/Library/WebServer/Documents/unigene/";
include($working_dir."include/unigene.class.inc");

$ug = new UniGene();

$ug->error_format=true; // set to true for text error messages

$update=$ug->admin; // sets switch for admin access.  this will be replaced on future versions.

$ug->refresh_genome_table($update, true);

$update_list = $ug->update_requested();

$num_genomes_updated = 0;

if($update_list){
	$ug->diagnostic("Updates requested....",0);
	foreach ($update_list as $genome) {
		if($num_genomes_updated>($ug->nightly_limit-1)){
			$ug->diagnostic("Reached nightly limit of $ug->nightly_limit genome updates.",1);
			break;
		}
		$ug->diagnostic("Downloading NCBI file for genome: $genome ",1);
		$ug->get_data_file($genome);
		$ug->diagnostic("Begin parsing data...",1);
		$ug->parser($genome,true);
		echo "Clear update flag for genome: $genome ".$ug->crlf;
		if($ug->clear_queue($genome)) echo "Update flag cleared successfully.".$ug->crlf;
		else "Error clearing update flag.".$ug->crlf;
		$num_genomes_updated++;
		
	}
		
} else {
	echo "No updates requested.".$ug->crlf;
}

//next steps, add or clear gendex data on refresh
if($ug->update_gendex()) echo "-----Gendex data refreshed successfully. ".date("Y-m-d h:m:s").$ug->crlf;
else "Error updating gendex data.".$ug->crlf;

?>