<?php

// UniGene DLST: Dynamic Local Storage Tool
// R. Hart (c) 2005-6 Rutgers, The State University
// rhart@rci.rutgers.edu

// index.php - web page interface, requires unigene.class.inc

// DLST is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// DLST is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//set passed command whether get or post
$go=(isset($_REQUEST['go'])?$_REQUEST['go']:"Search");

$working_dir = "/Library/WebServer/Documents/unigene/";
include($working_dir."include/unigene.class.inc");

$ug = new UniGene();


$update=$ug->admin; // sets switch for admin access.  this will be replaced on future versions.


// go command found
echo "<!--Go is $go -->";  //debug output hidden in html comment

switch ($go){

	case "status":
	// send unigene status page
	$ug->page_head("UniGene Table Status","status",$update);

	// Display genome table
	$ug->genome_table($update);

	$ug->page_tail();
	break;

	case "update":
	// User has selected a genome to download and parse
	$ug->page_head("Update/Load Stored UniGene Table","update",$update);

	// Determine if user authorized to update
	if($update){

		//retrieve passed data selected for action
		$genome = (isset($_REQUEST['genome'])?$_REQUEST['genome']:false);
		$queue = (isset($_REQUEST['queue'])?$_REQUEST['queue']:array());

		if($genome){
			echo "<h2>Loading Genome: $genome </h2>".$ug->crlf;

			if($ug->get_data_file($genome)) {
				echo "<p>File downloaded from NCBI...</p>".$ug->crlf;
			} else {
				echo "<p>Error: No file downloaded from NCBI</p>".$ug->crlf;
			}

			echo "<p>Beginning to parse file into database...</p>".$ug->crlf;

			if($ug->parser($genome)) {
				echo "<p>Database loaded and local file deleted.</p>".$ug->crlf;
			} else {
				echo "<p>There was an error during parsing.</p>".$ug->crlf;
			}

		} else {
			echo "<!--No genome selected.-->".$ug->crlf;
		}
		
		//if($queue){
			//update queue record in unigene table here
			$ug->add_to_queue($queue);
			echo "<p>Selected genomes added to queue for update: ".implode(",",$queue)."</p>".$ug->crlf;
			
		//}
		
	} else {
		echo "<p>You are not authorized to update/load genomes.</p>".$ug->crlf;
	}
	$ug->genome_table($update);
	$ug->page_tail();
	break;

	case "refresh":
	// Refresh local table of UniGene genome builds
	$ug->page_head("UniGene Table Update from NCBI","refresh",$update);

	$ug->refresh_genome_table($update);

	$ug->page_tail();
	break;

	
	case "Search":
	$limit = 10;
	
	//careful here, this is static but must be editted when adding more genomes to gendex
	$species = array(1,2,3,4);
	$keywords = '';

	$keywords = (isset($_POST['keywords']) ? $_POST['keywords'] : $keywords);
	$limit = (isset($_POST['limit']) ? $_POST['limit'] : $limit);
	$species = (isset($_POST['species']) ? $_POST['species'] : $species);


	$ug->page_head("Search Page","search");

	if(!($keywords=='')){
		$ug->keyword_search($keywords,$species,$limit);
	}

	$ug->search_form($keywords,$species,$limit);

	$ug->page_tail();
	break;

	
}

?>