/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef FF2XML_XML_ATTRIBUTE_INCLUDED
#define FF2XML_XML_ATTRIBUTE_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include <string>

namespace OpenEMBL
{
namespace ff2xml
{

    //
    // An xml attribute is nothing more than a name-value pair.
    //
    // No translation of the attribute string is performed at this stage
    // (meaning, special characters like quotes, angle brackets, etc, are
    // not translated into their equivalent character entities)
    //
    class XmlAttribute
    {
    public:
        XmlAttribute(std::string const & name, std::string const & value)
            : m_Name(name)
            , m_Value(value)
        {
        }

        XmlAttribute(std::string const & name, char const * value);
        XmlAttribute(std::string const & name, char value);
        XmlAttribute(std::string const & name, int value);
        XmlAttribute(std::string const & name, long value);
        XmlAttribute(std::string const & name, bool value);

        std::string const & getName() const  { return m_Name; }
        std::string const & getValue() const { return m_Value; }

    private:
        std::string m_Name;
        std::string m_Value;
    };

}
}

#endif // FF2XML_XML_ATTRIBUTE_INCLUDED
