/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#include "EMBLFeatureTableTextSourceAdapter.hpp"

#include <cstring>
#include <cassert>

namespace OpenEMBL
{
namespace Phoenix
{

    EMBLFeatureTableTextSourceAdapter::EMBLFeatureTableTextSourceAdapter(
                        ITextSource* theTextSource)
        : m_pTextSource(theTextSource)
    {
        m_EOF = (NULL == m_pTextSource);
        scanLine();        
    }

    void EMBLFeatureTableTextSourceAdapter::scanLine()
    {
        if (m_EOF)
            return;

        LPCSTR theLine = m_pTextSource->currentLine();

        m_EOF = (theLine == NULL || 0 != strncmp(theLine, "FT   ", 5));
    }

    METHODIMP_(LPCSTR) 
    EMBLFeatureTableTextSourceAdapter::currentLine() const NO_THROW
    {
        if (m_EOF)
            return NULL;

        return m_pTextSource->currentLine();
    }

    METHODIMP_(long)   
    EMBLFeatureTableTextSourceAdapter::currentLineNumber() const NO_THROW
    {
        if (NULL == m_pTextSource)
            return TEXTSOURCE_INVALID_LINE_NUMBER;

        return m_pTextSource->currentLineNumber();
    }

    METHODIMP_(bool)   
    EMBLFeatureTableTextSourceAdapter::nextLine()
    {
        if (NULL != m_pTextSource)
            m_pTextSource->nextLine();

        scanLine();

        return !m_EOF;        
    }

    METHODIMP        
    EMBLFeatureTableTextSourceAdapter::resynch()
    {
        scanLine();
    }

}
}
