/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#include "EntryParser.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    METHODIMP EntryParser::broadcastError(long theLineNumber, int theErrorCode, char const* theMessage)
    {
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastError(theLineNumber, theErrorCode, theMessage);
    }

    METHODIMP EntryParser::broadcastWarning(long theLineNumber, int theWarningNumber, char const* theMessage)
    {
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastWarning(theLineNumber, theWarningNumber, theMessage);
    }

    METHODIMP EntryParser::broadcastBeginEntry(long theLineNumber) 
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginEntry(theLineNumber);
    }

    METHODIMP EntryParser::broadcastEndEntry()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndEntry();
    }

    METHODIMP EntryParser::broadcastID(long theLineNumber, IDLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastID(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastAC(long theLineNumber, ACLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastAC(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastSV(long theLineNumber, SVLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastSV(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastDT(long theLineNumber, DTLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastDT(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastDE(long theLineNumber, DELine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastDE(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastKW(long theLineNumber, KWLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastKW(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastDR(long theLineNumber, DRLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastDR(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastCC(long theLineNumber, CCLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastCC(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastSQ(long theLineNumber, SQLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastSQ(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastXX(long theLineNumber, XXLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastXX(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastBeginTaxonomyLines(long theLineNumber)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginTaxonomyLines(theLineNumber);
    }

    METHODIMP EntryParser::broadcastOS(long theLineNumber, OSLine const & theField)    
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastOS(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastOC(long theLineNumber, OCLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastOC(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastOG(long theLineNumber, OGLine const & theField)        
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastOG(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastEndTaxonomyLines()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndTaxonomyLines();
    }

    METHODIMP EntryParser::broadcastBeginFeatureTable(long theLineNumber)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginFeatureTable(theLineNumber);
    }

    METHODIMP EntryParser::broadcastEndFeatureTable()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndFeatureTable();
    }

    METHODIMP EntryParser::broadcastBeginFeatureKey(long theLineNumber, FeatureKey const & theKey)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginFeatureKey(theLineNumber, theKey);
    }

    METHODIMP EntryParser::broadcastFeatureQualifier(long theLineNumber, FeatureQualifier const & theQualifier)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastFeatureQualifier(theLineNumber, theQualifier);
    }

    METHODIMP EntryParser::broadcastEndFeatureKey()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndFeatureKey();
    }

    METHODIMP EntryParser::broadcastBeginSequenceData(long theLineNumber)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginSequenceData(theLineNumber);
    }

    METHODIMP EntryParser::broadcastSequenceLine(long theLineNumber, SequenceLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastSequenceLine(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastEndSequenceData()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndSequenceData();
    }

    METHODIMP EntryParser::broadcastBeginTPALines(long theLineNumber)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginTPALines(theLineNumber);
    }

    METHODIMP EntryParser::broadcastAS(long theLineNumber, ASLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastAS(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastEndTPALines()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndTPALines();
    }

    METHODIMP EntryParser::broadcastBeginCOLines(long theLineNumber, bool isComplement)        
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginCOLines(theLineNumber, isComplement);
    }

    METHODIMP EntryParser::broadcastCOSegmentInfo (long theLineNumber, COSegmentInfo const & theSegmentInfo)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastCOSegmentInfo(theLineNumber, theSegmentInfo);
    }

    METHODIMP EntryParser::broadcastCOGapInfo (long theLineNumber, COGapInfo const & theGapInfo)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastCOGapInfo(theLineNumber, theGapInfo);
    }

    METHODIMP EntryParser::broadcastEndCOLines()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndCOLines();
    }

    METHODIMP EntryParser::broadcastACStar(long theLineNumber, ACStarLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastACStar(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastBeginPublication(long theLineNumber)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBeginPublication(theLineNumber);
    }

    METHODIMP EntryParser::broadcastRN(long theLineNumber, RNLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRN(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRC(long theLineNumber, RCLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRC(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRP(long theLineNumber, RPLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRP(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRX(long theLineNumber, RXLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRX(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRG(long theLineNumber, RGLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRG(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRA(long theLineNumber, RALine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRA(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastRT(long theLineNumber, RTLine const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastRT(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastSubmission        (long theLineNumber, SubmissionInfo         const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastSubmission(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastUnpublished       (long theLineNumber, UnpublishedInfo        const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastUnpublished(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastBook              (long theLineNumber, BookInfo               const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastBook(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastThesis            (long theLineNumber, ThesisInfo             const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastThesis(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastPatent            (long theLineNumber, PatentInfo             const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastPatent(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastOnlineJournal     (long theLineNumber, OnlineJournalInfo      const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastOnlineJournal(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastElectronicResource(long theLineNumber, ElectronicResourceInfo const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastElectronicResource(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastMiscResource(long theLineNumber, MiscResourceInfo const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastMiscResource(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastJournalArticle    (long theLineNumber, JournalArticleInfo     const & theField)
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastJournalArticle(theLineNumber, theField);
    }

    METHODIMP EntryParser::broadcastEndPublication()
    { 
        if (NULL != m_ParserEventsSource)
            m_ParserEventsSource->broadcastEndPublication();
    }

}
}
