/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#include "FeatureTableTextSourceAdapter.hpp"
#include "EMBLFeatureTableTextSourceAdapter.hpp"
#include "GenBankFeatureTableTextSourceAdapter.hpp"


namespace OpenEMBL
{
namespace Phoenix
{

    FeatureTableTextSourceAdapter::FeatureTableTextSourceAdapter(
                        ITextSource* theTextSource,
                        FormatType   theFormat /* = EMBL */ )
        : m_pImpl( 0 )
    {
        if (EMBL == theFormat)
            m_pImpl = new EMBLFeatureTableTextSourceAdapter(theTextSource);
        else
            m_pImpl = new GenBankFeatureTableTextSourceAdapter(theTextSource);
    }

    FeatureTableTextSourceAdapter::~FeatureTableTextSourceAdapter() throw()
    {
        delete m_pImpl;
    }

    METHODIMP_(LPCSTR) FeatureTableTextSourceAdapter::currentLine() const NO_THROW
    {
        return m_pImpl->currentLine();
    }

    METHODIMP_(long)   FeatureTableTextSourceAdapter::currentLineNumber() const NO_THROW
    {
        return m_pImpl->currentLineNumber();
    }

    METHODIMP_(bool)   FeatureTableTextSourceAdapter::nextLine()
    {
        return m_pImpl->nextLine();
    }

    METHODIMP FeatureTableTextSourceAdapter::resynch()
    {
        m_pImpl->resynch();
    }

}
}
