/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_LOCATION_LEXER_INCLUDED
#define OPEN_EMBL_LOCATION_LEXER_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#  pragma once
#endif

#include <string>

#include "NonCopyable.hpp"
#include "TextSource.hpp"
#include "ErrorLog.hpp"
#include "Lexer.hpp"
#include "TextSourceCharIterator.hpp"
#include "Token.hpp"

namespace OpenEMBL
{
namespace Phoenix
{
    
    class LocationLexer 
        : public virtual ILexer
        , NonCopyable
    {
    public:
        // Numerical codes of tokens (EOF is returned for end of file)
        enum
        {
            BAD_TOKEN               = 0,    
            ACCESSION_NUMBER        = 1,    
            NUMBER                  = 2,    
            DOUBLE_DOT              = 3,    
            JOIN                    = 4,
            ORDER                   = 5,
            COMPLEMENT              = 6,
            GAP                     = 7,
            COMMA                   = ',',
            DOT                     = '.', 
            COLON                   = ':',
            CARET                   = '^', 
            OPENING_PARENTHESIS     = '(',
            CLOSING_PARENTHESIS     = ')',
            OPENING_ANGLE_BRACKET   = '<',
            CLOSING_ANGLE_BRACKET   = '>'
        };

        LocationLexer();

        void setErrorLog(IErrorLog* theErrorLog);
        void setTextSource(ITextSource* theTextSource);

        // Lexer interface
        METHOD_(int)    peekToken() const NO_THROW;
        METHOD_(int)    getToken();
        METHOD_(bool)   getTokenValue(std::string & theValue) const;

    private:
        void readToken();
        void skipBlanks();
        int  currentChar();
        void nextChar();

        void readPunct();
        void readIdent();
        void readNumber();

        void badToken(std::string const & theMessage);

    private:
        IErrorLog*              m_ErrorLog;
        TextSourceCharIterator  m_CharIterator;
        Token                   m_CurrentToken;
        Token                   m_NextToken;
    };

}
}

#endif // OPEN_EMBL_LOCATION_LEXER_INCLUDED
