/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_OBJ_MACROS_INCLUDED
#define OPEN_EMBL_OBJ_MACROS_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#if defined(_WIN32) || defined(__WIN32__)
#   include <ObjBase.h>
#endif

#if !defined(interface) 
#   define interface struct
#endif

#if !defined(DECLARE_INTERFACE)
#   define DECLARE_INTERFACE(iface) interface iface
#endif /* !defined(DECLARE_INTERFACE)*/

#if !defined(DECLARE_INTERFACE_)
#   define DECLARE_INTERFACE_(iface, baseiface) interface iface : public baseiface
#endif /* !defined(DECLARE_INTERFACE_)*/

#if !defined(PURE)
#   define PURE = 0
#endif /* !defined(PURE)*/

#if !defined(NO_THROW)
#   define NO_THROW throw()
#endif /* !defined(NO_THROW)*/

#if !defined(METHOD_)
#   define METHOD_(ret) virtual ret
#endif /* !defined(METHOD_)*/

#if !defined(METHOD)
#   define METHOD METHOD_(void)
#endif /* !defined(METHOD)*/

#if !defined(METHODIMP_)
#   define METHODIMP_(ret) ret
#endif /* !defined(METHODIMP_)*/

#if !defined(METHODIMP)
#   define METHODIMP METHODIMP_(void)
#endif /* !defined(METHODIMP)*/

#if !defined(LPCSTR)
#   define LPCSTR char const*
#endif /* !defined(LPCSTR)*/

#endif // OPEN_EMBL_OBJ_MACROS_INCLUDED
