/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_PARSER_CTX_ON_ERROR_LOG_ADAPTER_INCLUDED
#define OPEN_EMBL_PARSER_CTX_ON_ERROR_LOG_ADAPTER_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include "NonCopyable.hpp"
#include "ParserCtx.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    class ParserCtxOnErrorLogAdapter
        : public virtual IParserCtx
        , NonCopyable
    {
    public:
        ParserCtxOnErrorLogAdapter(
                    IErrorLog*      theErrorLog,
                    ITextSource*    theTextSource);

        METHOD_(LPCSTR) currentLine() const NO_THROW;
        METHOD_(long)   currentLineNumber() const NO_THROW;
        METHOD_(bool)   nextLine();
        METHOD logError(long theLineNumber, int theErrorCode, LPCSTR theMessage);
        METHOD logWarning(long theLineNumber, int theWarning, LPCSTR theMessage);

    private:
        IErrorLog*      m_pErrorLog;
        ITextSource*    m_pTextSource;
    };

}
}

#endif // OPEN_EMBL_PARSER_CTX_ON_ERROR_LOG_ADAPTER_INCLUDED
