/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


//
//  This file defines the parser error codes
//
//  Format is: error code, symbolic name, description string
//
//  Error codes above 30000 are reserved for INTERNAL ERRORS
//


//===================================================================
//							INTERNAL ERRORS
//===================================================================

PARSER_ERROR( 30001, 
              ERROR_INTERNAL_ERROR_INFINITE_LOOP, 
              "INTERNAL_ERROR")            

PARSER_ERROR( 30002, 
              ERROR_INTERNAL_ERROR_STDLIB_EXCEPTION, 
              "INTERNAL_ERROR")            


//===================================================================
//							TEXT FILE 
//===================================================================
               
PARSER_ERROR( 29001, 
              ERROR_OS_ERROR, 
              "I/O error")               

PARSER_ERROR( 29002, 
              ERROR_LINE_TOO_LONG, 
              "line exceeds 4 KB")

//===================================================================
//							ERRORS
//===================================================================

PARSER_ERROR( 1, 
              ERROR_EOF_FOUND, 
              "unexpected end of file")

PARSER_ERROR( 2, 
              ERROR_INVALID_START_OF_RECORD, 
              "invalid start of record")

PARSER_ERROR( 3, 
              ERROR_DUPLICATE_LINE, 
              "duplicate line")

PARSER_ERROR( 4, 
              ERROR_UNKNOWN_LINE_TYPE,
              "unknown line type")

PARSER_ERROR( 5, 
              ERROR_INVALID_CC_LINE,
              "invalid CC line")

PARSER_ERROR( 6, 
              ERROR_INVALID_CC_STAR_LINE,
              "invalid 'CC * ' line")
              
PARSER_ERROR( 7,
              ERROR_INVALID_NUCLEOTIDE_CODE,
              "invalid nucleotide code found in sequence line")

PARSER_ERROR( 8,
              ERROR_INVALID_SQ_LINE,
              "invalid SQ line")
              
PARSER_ERROR( 9,
              ERROR_INVALID_DR_LINE,
              "invalid DR line")

PARSER_ERROR(10,
              ERROR_INVALID_DE_LINE,
              "invalid DE line")

PARSER_ERROR(11,
              ERROR_INVALID_SV_LINE,
              "invalid SV line")

PARSER_ERROR(12,
              ERROR_INVALID_ID_LINE,
              "invalid ID line")

PARSER_ERROR(13,
             ERROR_INVALID_DT_LINE,
             "invalid DT line")

PARSER_ERROR(14,
             ERROR_INVALID_AC_LINE,
             "invalid AC line")
             
PARSER_ERROR(15,
             ERROR_INVALID_KW_LINE,
             "invalid KW line")
             
PARSER_ERROR(16,
             ERROR_MISSING_OS_LINE,
             "missing OS line")
             
PARSER_ERROR(17,
             ERROR_INVALID_OS_LINE,
             "invalid OS line")

PARSER_ERROR(18,
             ERROR_INVALID_OC_LINE,
             "invalid OC line")

PARSER_ERROR(19,
             ERROR_INVALID_OG_LINE,
             "invalid OG line")

PARSER_ERROR(20,
             ERROR_INVALID_RN_LINE,
             "invalid RN line")

PARSER_ERROR(21,
             ERROR_INVALID_RP_LINE,
             "invalid RP line")             
             
PARSER_ERROR(22,
             ERROR_INVALID_RP_LINE_RANGE,
             "invalid base span")
             
PARSER_ERROR(23,
             ERROR_INVALID_RC_LINE,
             "invalid RC line")
             
PARSER_ERROR(24,
             ERROR_INVALID_RX_LINE,
             "invalid RX line")

PARSER_ERROR(25,
             ERROR_MISSING_RN_LINE,
             "missing RN line")

PARSER_ERROR(26,
             ERROR_MISSING_RA_LINE,
             "expected RA line")

PARSER_ERROR(27,
             ERROR_INVALID_RA_LINE,
             "invalid RA line")

PARSER_ERROR(28,
             ERROR_INVALID_RG_LINE,
             "invalid RG line")

PARSER_ERROR(29,
             ERROR_MISSING_RT_LINE,
             "expected RT line")
             
PARSER_ERROR(30,
             ERROR_INVALID_RT_LINE,
             "invalid RT line")             

PARSER_ERROR(31,
             ERROR_MISSING_RL_LINE,
             "expected RL line")
             
PARSER_ERROR(32,
             ERROR_INVALID_RL_LINE,
             "invalid RL line")             
             
PARSER_ERROR(33, 
              ERROR_OUT_OF_MEMORY, 
              "out of memory")
         
PARSER_ERROR(34,
             ERROR_MISSING_DATE_IN_SUBMISSION_INFO,
             "missing submission date")             
             
PARSER_ERROR(35,
             ERROR_INVALID_RL_THESIS_LINE,
             "invalid thesis info format")             

PARSER_ERROR(36,
             ERROR_INVALID_RL_SUBMITTED_LINE,
             "invalid submission information format")             

PARSER_ERROR(37,
             ERROR_INVALID_RL_UNPUBLISHED_LINE,
             "invalid unpublished info format")             

PARSER_ERROR(38,
             ERROR_INVALID_RL_ELECTRONIC_RESOURCE_LINE,
             "invalid electronic resource line")             
             
PARSER_ERROR(39,
             ERROR_INVALID_RL_BOOK_LINE,
             "invalid book format")             

PARSER_ERROR(40,
             ERROR_MISSING_BOOK_EDITOR_INFO,
             "missing editor list")        
             
PARSER_ERROR(41,
             ERROR_RL_LINE_EMPTY_EDITOR_LIST,
             "editor list is empty")        
             
PARSER_ERROR(42,
             ERROR_RL_LINE_EDITOR_LIST_MISSING_TERMINATOR,
             "editor list is not terminated by ;")        
             
PARSER_ERROR(43,
             ERROR_MISSING_BOOK_TITLE_INFO,
             "missing book title")        
            
PARSER_ERROR(44,
             ERROR_INVALID_BOOK_TITLE_FORMAT,
             "invalid book title format")        
             
PARSER_ERROR(45,
             ERROR_MISSING_BOOK_PUBLISHER_INFO,
             "missing book publisher info")        
             
PARSER_ERROR(46,
             ERROR_INVALID_RL_PATENT_LINE,
             "invalid patent info format")
             
PARSER_ERROR(47,
             ERROR_MISSING_PATENT_INFO,
             "missing patent info")           
            
PARSER_ERROR(48,
             ERROR_MISSING_PATENT_APPLICANT_INFO,
             "missing patent applicants info")           
             
PARSER_ERROR(49,
             ERROR_MISSING_PUBLICATION_DATE,
             "missing publication date")           

PARSER_ERROR(50,
             ERROR_RL_JOURNAL_MISSING_PAGE_INFO,
             "missing page info")           

PARSER_ERROR(51,
             ERROR_RL_JOURNAL_MISSING_VOLUME_INFO,
             "missing volume info")           

PARSER_ERROR(52,
             ERROR_RL_JOURNAL_MISSING_JOURNAL_NAME,
             "missing journal name")           

PARSER_ERROR(53,
             ERROR_MISSING_FEATURE_KEY,
             "expected feature key")
             
PARSER_ERROR(54,
             ERROR_FT_LINE_MISSING_COLUMN_SEPARATOR,
             "blank not found at position 21")

PARSER_ERROR(55,
             ERROR_FT_LINE_TOO_SHORT,
             "feature table lines must be at least 22 character long")
             
PARSER_ERROR(56,
             ERROR_FT_LINE_EMPTY_DATA_COLUMN,
             "no character found past column 22 in feature table line")

PARSER_ERROR(57,
             ERROR_INVALID_FEATURE_QUALIFIER_LINE,
             "expected feature qualifier line")
             
PARSER_ERROR(58,
             ERROR_QUALIFIER_NOT_FOUND,
             "no qualifier found after the /")
             
PARSER_ERROR(59,
             ERROR_MISSING_QUALIFIER_VALUE,
             "no value found for qualifier after the = character")

PARSER_ERROR(60,
             ERROR_QUALIFIER_VALUE_MISSING_TERMINAL_QUOTES,
             "missing terminal double quotes in qualifier value")

PARSER_ERROR(61,
             ERROR_BAD_TOKEN_IN_LOCATION,
             "invalid token in location")

PARSER_ERROR(62,
             ERROR_GAP_IN_LOCATION_STRING,
             "gap() operator is not valid inside feature locations")

PARSER_ERROR(63,
             ERROR_UNEXPECTED_LOCATION_END,
             "unexpected end of location")

PARSER_ERROR(64,
             ERROR_INVALID_AS_LINE,
             "invalid AS line")

PARSER_ERROR(65,
             ERROR_AS_LINE_MISSING_TPA_SPAN,
             "missing TPA span")
             
PARSER_ERROR(66,
             ERROR_AS_LINE_BAD_TPA_SPAN_FORMAT,
             "invalid TPA span format")
             
PARSER_ERROR(67,
             ERROR_AS_LINE_MISSING_PRIMARY_IDENTIFIER,
             "missing primary identifier")

PARSER_ERROR(68,
             ERROR_AS_LINE_MISSING_PRIMARY_SPAN,
             "missing primary primary span information")

PARSER_ERROR(69,
             ERROR_AS_LINE_BAD_PRIMARY_SPAN_FORMAT,
             "invalid primary span format")
             
PARSER_ERROR(70,
             ERROR_AS_LINE_INVALID_COMPLEMENT_FORMAT,
             "invalid format for complement flag")
             
PARSER_ERROR(71,
             ERROR_AS_LINE_INVALID_CHARACTERS_AT_END_OF_LINE,
             "invalid characters at end of line")

PARSER_ERROR(72,
             ERROR_INVALID_HD_LINE,
             "invalid HD line")

PARSER_ERROR(73,
             ERROR_HD_LINE_MISSING_CONFIDENTIAL,
             "missing token 'confidential'")

PARSER_ERROR(74,
             ERROR_HD_LINE_EXTRA_CHARACTERS_AT_END,
             "extra characters found at end of HD* line")
             
PARSER_ERROR(75,
             ERROR_HD_LINE_MISSING_HOLD_DATE,
             "missing or invalid hold date")
             
PARSER_ERROR(76,
             ERROR_INVALID_AC_STAR_LINE,
             "invalid AC* line")

PARSER_ERROR(77,
             ERROR_INVALID_CO_LINE,
             "invalid CO line")

PARSER_ERROR(78,
             ERROR_INVALID_RL_MISC_RESOURCE_LINE,
             "invalid misc resource line")             

